/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IAutomatonStatePartition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IBlock;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class ShrinkNwaAsDfa<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private IDoubleDeckerAutomaton<LETTER, STATE> mDoubleDecker;
    private Partition mPartition;
    private int mIds;
    private WorkList mWorkList;

    public ShrinkNwaAsDfa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, null, false, false);
    }

    public ShrinkNwaAsDfa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, boolean bl2) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        this.mDoubleDecker = bl2 ? (IDoubleDeckerAutomaton)this.mOperand : null;
        this.mPartition = new Partition();
        this.mIds = 0;
        this.mWorkList = new WorkList();
        this.minimize(partitionBackedSetOfPairs, bl);
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private void minimize(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) throws AutomataOperationCanceledException {
        this.initialize(partitionBackedSetOfPairs);
        InternalTransitionIterator internalTransitionIterator = new InternalTransitionIterator();
        CallTransitionIterator callTransitionIterator = new CallTransitionIterator();
        ReturnTransitionIterator returnTransitionIterator = new ReturnTransitionIterator();
        while (this.mWorkList.hasNext()) {
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            EquivalenceClass equivalenceClass = this.mWorkList.next();
            if (equivalenceClass.mIncomingInt == IncomingStatus.IN_WL) {
                equivalenceClass.mIncomingInt = IncomingStatus.UNKNOWN;
                this.splitPredecessors(equivalenceClass, internalTransitionIterator, TransitionType.INTERNAL);
            }
            if (equivalenceClass.mIncomingCall == IncomingStatus.IN_WL) {
                equivalenceClass.mIncomingCall = IncomingStatus.UNKNOWN;
                this.splitPredecessors(equivalenceClass, callTransitionIterator, TransitionType.CALL);
            }
            if (equivalenceClass.mIncomingRet != IncomingStatus.IN_WL) continue;
            equivalenceClass.mIncomingRet = IncomingStatus.UNKNOWN;
            this.splitPredecessors(equivalenceClass, returnTransitionIterator, TransitionType.RETURN);
        }
        this.mLogger.info((Object)("Finished analysis, constructing result of size " + this.mPartition.mEquivalenceClasses.size()));
        this.constructAutomaton(bl);
    }

    private void initialize(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs) {
        if (partitionBackedSetOfPairs == null) {
            HashSet<STATE> hashSet = new HashSet<STATE>();
            HashSet<STATE> hashSet2 = new HashSet<STATE>();
            for (STATE STATE : this.mOperand.getStates()) {
                if (this.mOperand.isFinal(STATE)) {
                    hashSet.add(STATE);
                    continue;
                }
                hashSet2.add(STATE);
            }
            if (!hashSet.isEmpty()) {
                this.mPartition.addEcInitialization(hashSet);
            }
            if (!hashSet2.isEmpty()) {
                this.mPartition.addEcInitialization(hashSet2);
            }
        } else {
            Object object = partitionBackedSetOfPairs.getRelation();
            assert (this.assertStatesSeparation((Iterable<Set<STATE>>)object)) : "The states in the initial modules are not separated with respect to their final status.";
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Set set = (Set)iterator.next();
                this.mPartition.addEcInitialization(set);
            }
        }
    }

    private void splitPredecessors(EquivalenceClass equivalenceClass, ITransitionIterator<LETTER, STATE> iTransitionIterator, TransitionType transitionType) {
        block18: {
            HashSet hashSet;
            Pair pair;
            HashMap hashMap;
            block17: {
                assert (transitionType == TransitionType.INTERNAL && iTransitionIterator instanceof InternalTransitionIterator && equivalenceClass.mIncomingInt != IncomingStatus.IN_WL || transitionType == TransitionType.CALL && iTransitionIterator instanceof CallTransitionIterator && equivalenceClass.mIncomingCall != IncomingStatus.IN_WL || transitionType == TransitionType.RETURN && iTransitionIterator instanceof ReturnTransitionIterator && equivalenceClass.mIncomingRet != IncomingStatus.IN_WL);
                hashMap = new HashMap();
                for (Object object : equivalenceClass.mStates) {
                    iTransitionIterator.nextState(object);
                    while (iTransitionIterator.hasNext()) {
                        pair = iTransitionIterator.nextAndLetter();
                        hashSet = (HashSet)hashMap.get(pair);
                        if (hashSet == null) {
                            hashSet = new HashSet();
                            hashMap.put(pair, hashSet);
                        }
                        hashSet.add(iTransitionIterator.getPred());
                    }
                }
                if (!hashMap.isEmpty()) break block17;
                switch (transitionType) {
                    case INTERNAL: {
                        equivalenceClass.mIncomingInt = IncomingStatus.NONE;
                        break block18;
                    }
                    case CALL: {
                        equivalenceClass.mIncomingCall = IncomingStatus.NONE;
                        break block18;
                    }
                    case RETURN: {
                        equivalenceClass.mIncomingRet = IncomingStatus.NONE;
                        break block18;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (this.mDoubleDecker == null) {
                    pair = null;
                } else {
                    switch (transitionType) {
                        case INTERNAL: 
                        case CALL: {
                            pair = null;
                            break;
                        }
                        case RETURN: {
                            pair = (Pair)entry.getKey();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal type.");
                        }
                    }
                }
                hashSet = (HashSet)entry.getValue();
                assert (!hashSet.isEmpty());
                this.mPartition.splitEquivalenceClasses(hashSet, pair);
            }
        }
    }

    private void constructAutomaton(boolean bl) throws AutomataOperationCanceledException {
        for (Object e : this.mOperand.getInitialStates()) {
            EquivalenceClass equivalenceClass = this.mPartition.mState2EquivalenceClass.get(e);
            equivalenceClass.markAsInitial();
        }
        this.constructResultFromPartition(this.mPartition, bl);
        this.mPartition = null;
        this.mWorkList = null;
    }

    private boolean assertStatesSeparation(Iterable<Set<STATE>> iterable) {
        for (Set<STATE> set : iterable) {
            Iterator<STATE> iterator = set.iterator();
            assert (iterator.hasNext()) : "Empty equivalence classes should be avoided.";
            boolean bl = this.mOperand.isFinal(iterator.next());
            while (iterator.hasNext()) {
                if (bl == this.mOperand.isFinal(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    private abstract class AWorkList
    implements Iterator<EquivalenceClass> {
        protected final PriorityQueue<EquivalenceClass> mQueue;

        public AWorkList() {
            this.mQueue = new PriorityQueue(Math.max(ShrinkNwaAsDfa.this.mOperand.size(), 1), (equivalenceClass, equivalenceClass2) -> equivalenceClass.mStates.size() - equivalenceClass2.mStates.size());
        }

        public void add(EquivalenceClass equivalenceClass) {
            assert (!this.mQueue.contains(equivalenceClass));
            this.mQueue.add(equivalenceClass);
        }

        @Override
        public boolean hasNext() {
            return !this.mQueue.isEmpty();
        }

        @Override
        public abstract EquivalenceClass next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported.");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toStringHelper(stringBuilder);
            stringBuilder.append(">>");
            return stringBuilder.toString();
        }

        protected void toStringHelper(StringBuilder stringBuilder) {
            stringBuilder.append("<<");
            String string = "";
            for (EquivalenceClass equivalenceClass : this.mQueue) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(equivalenceClass);
            }
        }
    }

    private class CallTransitionIterator
    implements ITransitionIterator<LETTER, STATE> {
        private Iterator<IncomingCallTransition<LETTER, STATE>> mIterator;
        private IncomingCallTransition<LETTER, STATE> mTransition;

        private CallTransitionIterator() {
        }

        @Override
        public void nextState(STATE STATE) {
            this.mIterator = ShrinkNwaAsDfa.this.mOperand.callPredecessors(STATE).iterator();
        }

        @Override
        public Pair<LETTER, STATE> nextAndLetter() {
            this.mTransition = this.mIterator.next();
            return new Pair(this.mTransition.getLetter(), this.mTransition.getPred());
        }

        @Override
        public STATE getPred() {
            return this.mTransition.getPred();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }
    }

    private class EquivalenceClass
    implements IBlock<STATE> {
        private final int mId;
        private Set<STATE> mStates;
        private Set<STATE> mIntersection;
        private IncomingStatus mIncomingInt;
        private IncomingStatus mIncomingCall;
        private IncomingStatus mIncomingRet;
        private boolean mIsInitial;

        private EquivalenceClass(Set<STATE> set, boolean bl) {
            assert (!set.isEmpty());
            this.mId = ++ShrinkNwaAsDfa.this.mIds;
            this.mStates = set;
            this.reset();
        }

        public EquivalenceClass(Set<STATE> set) {
            this(set, false);
            this.mIncomingInt = IncomingStatus.IN_WL;
            this.mIncomingCall = IncomingStatus.IN_WL;
            this.mIncomingRet = IncomingStatus.IN_WL;
            shrinkNwaAsDfa.mWorkList.add(this);
        }

        public EquivalenceClass(Set<STATE> set, EquivalenceClass equivalenceClass) {
            this(set, true);
            boolean bl = false;
            switch (equivalenceClass.mIncomingInt) {
                case UNKNOWN: 
                case IN_WL: {
                    this.mIncomingInt = IncomingStatus.IN_WL;
                    bl = true;
                    break;
                }
                case NONE: {
                    this.mIncomingInt = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (equivalenceClass.mIncomingCall) {
                case UNKNOWN: 
                case IN_WL: {
                    this.mIncomingCall = IncomingStatus.IN_WL;
                    bl = true;
                    break;
                }
                case NONE: {
                    this.mIncomingCall = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (equivalenceClass.mIncomingRet) {
                case UNKNOWN: 
                case IN_WL: {
                    this.mIncomingRet = IncomingStatus.IN_WL;
                    bl = true;
                    break;
                }
                case NONE: {
                    this.mIncomingRet = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (bl) {
                shrinkNwaAsDfa.mWorkList.add(this);
            }
        }

        private void markAsInitial() {
            this.mIsInitial = true;
        }

        public int hashCode() {
            return this.mId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            assert (this.getClass() == object.getClass());
            EquivalenceClass equivalenceClass = (EquivalenceClass)object;
            return this.mId == equivalenceClass.mId;
        }

        private void reset() {
            this.mIntersection = new HashSet(ShrinkNwaAsDfa.computeHashCap(this.mStates.size()));
        }

        public String toString() {
            if (this.mStates == null) {
                return "negative equivalence class";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append("<[");
            stringBuilder.append((Object)this.mIncomingInt);
            stringBuilder.append(",");
            stringBuilder.append((Object)this.mIncomingCall);
            stringBuilder.append(",");
            stringBuilder.append((Object)this.mIncomingRet);
            stringBuilder.append("], [");
            for (Object STATE : this.mStates) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append("], [");
            string = "";
            for (Object STATE : this.mIntersection) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append("]>");
            return stringBuilder.toString();
        }

        public String toStringShort() {
            if (this.mStates == null) {
                return "negative equivalence class";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append("<");
            for (Object STATE : this.mStates) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }

        @Override
        public boolean isInitial() {
            return this.mIsInitial;
        }

        @Override
        public boolean isFinal() {
            return ShrinkNwaAsDfa.this.mOperand.isFinal(this.mStates.iterator().next());
        }

        @Override
        public STATE minimize(IMergeStateFactory<STATE> iMergeStateFactory) {
            return iMergeStateFactory.merge(this.mStates);
        }

        @Override
        public Iterator<STATE> iterator() {
            return this.mStates.iterator();
        }

        @Override
        public boolean isRepresentativeIndependentInternalsCalls() {
            return true;
        }

        static /* synthetic */ Set access$0(EquivalenceClass equivalenceClass) {
            return equivalenceClass.mStates;
        }
    }

    private static interface ITransitionIterator<LETTER, STATE> {
        public void nextState(STATE var1);

        public Pair<LETTER, STATE> nextAndLetter();

        public boolean hasNext();

        public STATE getPred();
    }

    private static enum IncomingStatus {
        UNKNOWN,
        IN_WL,
        NONE;

    }

    private class InternalTransitionIterator
    implements ITransitionIterator<LETTER, STATE> {
        private Iterator<IncomingInternalTransition<LETTER, STATE>> mIterator;
        private IncomingInternalTransition<LETTER, STATE> mTransition;

        private InternalTransitionIterator() {
        }

        @Override
        public void nextState(STATE STATE) {
            this.mIterator = ShrinkNwaAsDfa.this.mOperand.internalPredecessors(STATE).iterator();
        }

        @Override
        public STATE getPred() {
            return this.mTransition.getPred();
        }

        @Override
        public Pair<LETTER, STATE> nextAndLetter() {
            this.mTransition = this.mIterator.next();
            return new Pair(this.mTransition.getLetter(), this.mTransition.getPred());
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }
    }

    private class Partition
    implements IAutomatonStatePartition<STATE> {
        private final Collection<EquivalenceClass> mEquivalenceClasses = new LinkedList<EquivalenceClass>();
        private final HashMap<STATE, EquivalenceClass> mState2EquivalenceClass;

        public Partition() {
            this.mState2EquivalenceClass = new HashMap(ShrinkNwaAsDfa.computeHashCap(ShrinkNwaAsDfa.this.mOperand.size()));
        }

        private void addEcInitialization(Set<STATE> set) {
            EquivalenceClass equivalenceClass = new EquivalenceClass(set);
            this.mEquivalenceClasses.add(equivalenceClass);
            for (Object STATE : set) {
                this.mState2EquivalenceClass.put(STATE, equivalenceClass);
            }
        }

        private EquivalenceClass addEcSplit(EquivalenceClass equivalenceClass) {
            Set set = equivalenceClass.mIntersection;
            if (set.size() > equivalenceClass.mStates.size()) {
                set = equivalenceClass.mStates;
                equivalenceClass.mStates = equivalenceClass.mIntersection;
            }
            EquivalenceClass equivalenceClass2 = new EquivalenceClass(set, equivalenceClass);
            this.mEquivalenceClasses.add(equivalenceClass2);
            for (Object STATE : equivalenceClass2.mStates) {
                this.mState2EquivalenceClass.put(STATE, equivalenceClass2);
            }
            return equivalenceClass2;
        }

        private void splitState(STATE STATE, LinkedList<EquivalenceClass> linkedList) {
            EquivalenceClass equivalenceClass = this.mState2EquivalenceClass.get(STATE);
            if (equivalenceClass.mIntersection.isEmpty()) {
                assert (!linkedList.contains(equivalenceClass));
                linkedList.add(equivalenceClass);
            } else assert (linkedList.contains(equivalenceClass));
            this.splitStateFast(STATE, equivalenceClass);
        }

        private void splitStateFast(STATE STATE, EquivalenceClass equivalenceClass) {
            equivalenceClass.mIntersection.add(STATE);
            equivalenceClass.mStates.remove(STATE);
        }

        public boolean splitEquivalenceClasses(Iterable<STATE> iterable, Pair<LETTER, STATE> pair) {
            boolean bl = false;
            LinkedList<EquivalenceClass> linkedList = new LinkedList<EquivalenceClass>();
            for (Object object : iterable) {
                this.splitState(object, linkedList);
            }
            for (EquivalenceClass equivalenceClass : linkedList) {
                if (pair != null && !equivalenceClass.mStates.isEmpty()) {
                    Object object = pair.getSecond();
                    ArrayList arrayList = new ArrayList(equivalenceClass.mStates);
                    for (Object STATE : arrayList) {
                        if (ShrinkNwaAsDfa.this.mDoubleDecker.isDoubleDecker(STATE, object)) continue;
                        this.splitStateFast(STATE, equivalenceClass);
                    }
                }
                if (equivalenceClass.mStates.isEmpty()) {
                    equivalenceClass.mStates = equivalenceClass.mIntersection;
                } else {
                    bl = true;
                    this.addEcSplit(equivalenceClass);
                }
                equivalenceClass.reset();
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            String string = "";
            for (EquivalenceClass equivalenceClass : this.mEquivalenceClasses) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(equivalenceClass);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public IBlock<STATE> getBlock(STATE STATE) {
            return this.mState2EquivalenceClass.get(STATE);
        }

        public Set<STATE> getContainingSet(STATE STATE) {
            return this.mState2EquivalenceClass.get(STATE).mStates;
        }

        public int size() {
            return this.mEquivalenceClasses.size();
        }

        @Override
        public Iterator<IBlock<STATE>> blocksIterator() {
            return new Iterator<IBlock<STATE>>(){
                private final Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public IBlock<STATE> next() {
                    return this.mIt.next();
                }
            };
        }

        public Iterator<Set<STATE>> iterator() {
            return new Iterator<Set<STATE>>(){
                private final Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public Set<STATE> next() {
                    return this.mIt.next().mStates;
                }
            };
        }
    }

    private class ReturnTransitionIterator
    implements ITransitionIterator<LETTER, STATE> {
        private Iterator<IncomingReturnTransition<LETTER, STATE>> mIterator;
        private IncomingReturnTransition<LETTER, STATE> mTransition;

        private ReturnTransitionIterator() {
        }

        @Override
        public void nextState(STATE STATE) {
            this.mIterator = ShrinkNwaAsDfa.this.mOperand.returnPredecessors(STATE).iterator();
        }

        @Override
        public Pair<LETTER, STATE> nextAndLetter() {
            this.mTransition = this.mIterator.next();
            return new Pair(this.mTransition.getLetter(), this.mTransition.getHierPred());
        }

        @Override
        public STATE getPred() {
            return this.mTransition.getLinPred();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }
    }

    private static enum TransitionType {
        INTERNAL,
        CALL,
        RETURN;

    }

    private class WorkList
    extends AWorkList {
        private WorkList() {
        }

        @Override
        public EquivalenceClass next() {
            return (EquivalenceClass)this.mQueue.poll();
        }

        @Override
        public void add(EquivalenceClass equivalenceClass) {
            assert (equivalenceClass.mIncomingInt == IncomingStatus.IN_WL || equivalenceClass.mIncomingCall == IncomingStatus.IN_WL || equivalenceClass.mIncomingRet == IncomingStatus.IN_WL);
            super.add(equivalenceClass);
        }
    }
}

