/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.srparse.pattern;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Trace2PeaCompilerStateless;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScope;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class PatternType<T extends PatternType<?>> {
    private final List<CDD> mCdds;
    private final List<Rational> mDurations;
    private final List<String> mDurationNames;
    private final SrParseScope<?> mScope;
    private final String mId;
    private ReqPeas mPEAs;

    public PatternType(SrParseScope<?> srParseScope, String string, List<CDD> list, List<Rational> list2, List<String> list3) {
        this.mScope = Objects.requireNonNull(srParseScope);
        this.mId = Objects.requireNonNull(string);
        this.mCdds = Objects.requireNonNull(list);
        this.mDurations = Objects.requireNonNull(list2);
        this.mDurationNames = Objects.requireNonNull(list3);
    }

    public T create(SrParseScope<?> srParseScope, String string, List<CDD> list, List<Rational> list2, List<String> list3) {
        return (T)PatternBuilder.getConstructor(this.getClass()).construct(srParseScope, string, list, list2, list3);
    }

    public PatternType<T> rename(String string) {
        return PatternBuilder.getConstructor(this.getClass()).construct(this.getScope(), string, this.getCdds(), this.getDurations(), this.mDurationNames);
    }

    public List<Rational> getDurations() {
        return Collections.unmodifiableList(this.mDurations);
    }

    public List<String> getDurationNames() {
        return this.mDurationNames;
    }

    public List<CDD> getCdds() {
        return Collections.unmodifiableList(this.mCdds);
    }

    public CDD[] getCddsAsArray() {
        return this.getCdds().toArray(new CDD[this.getCdds().size()]);
    }

    private int[] getDurationsAsIntArray() {
        int[] nArray = new int[this.mDurations.size()];
        int n = 0;
        while (n < this.mDurations.size()) {
            Rational rational = this.mDurations.get(n);
            if (rational == null) {
                throw new UnsupportedOperationException("Unresolved duration in " + this.getId());
            }
            nArray[n] = SmtUtils.toInt((Rational)rational).intValueExact();
            ++n;
        }
        return nArray;
    }

    public String getId() {
        return this.mId;
    }

    public SrParseScope<?> getScope() {
        return this.mScope;
    }

    public ReqPeas transformToPea(ILogger iLogger, Durations durations) {
        if (this.mPEAs == null) {
            List<CounterTrace> list = this.constructCounterTrace();
            String string = this.getId();
            ArrayList<Map.Entry<CounterTrace, PhaseEventAutomata>> arrayList = new ArrayList<Map.Entry<CounterTrace, PhaseEventAutomata>>(list.size());
            int n = 0;
            for (CounterTrace counterTrace : list) {
                Trace2PeaCompilerStateless trace2PeaCompilerStateless = new Trace2PeaCompilerStateless(iLogger, string + "_ct" + n, counterTrace, durations.getConstNames());
                ++n;
                arrayList.add((Map.Entry<CounterTrace, PhaseEventAutomata>)new Pair((Object)counterTrace, (Object)trace2PeaCompilerStateless.getResult()));
            }
            this.mPEAs = new ReqPeas(this, arrayList);
        }
        return this.mPEAs;
    }

    public List<CounterTrace> constructCounterTrace() {
        CDD[] cDDArray = this.getCddsAsArray();
        int[] nArray = this.getDurationsAsIntArray();
        assert (cDDArray.length == this.getExpectedCddSize()) : "Wrong number of observables for pattern " + this.getName();
        assert (nArray.length == this.getExpectedDurationSize()) : "Wrong number of durations for pattern " + this.getName();
        return this.transform(cDDArray, nArray);
    }

    protected abstract List<CounterTrace> transform(CDD[] var1, int[] var2);

    public abstract int getExpectedCddSize();

    public abstract int getExpectedDurationSize();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected static CounterTrace counterTrace(CounterTrace.DCPhase ... dCPhaseArray) {
        if (dCPhaseArray == null || dCPhaseArray.length == 0) {
            throw new IllegalArgumentException("Need at least one phase");
        }
        return new CounterTrace(dCPhaseArray);
    }

    protected static CounterTrace counterTrace(CDD ... cDDArray) {
        if (cDDArray == null || cDDArray.length == 0) {
            throw new IllegalArgumentException("Need at least one phase");
        }
        CounterTrace.DCPhase[] dCPhaseArray = new CounterTrace.DCPhase[cDDArray.length];
        int n = 0;
        while (n < cDDArray.length) {
            dCPhaseArray[n] = PatternType.phase(cDDArray[n]);
            ++n;
        }
        return new CounterTrace(dCPhaseArray);
    }

    protected static CounterTrace.DCPhase phase(CDD cDD) {
        return new CounterTrace.DCPhase(cDD);
    }

    protected static CounterTrace.DCPhase phase(CDD cDD, CounterTrace.BoundTypes boundTypes, int n) {
        return new CounterTrace.DCPhase(cDD, boundTypes.asValue(), n);
    }

    protected static CounterTrace.DCPhase phaseE(CDD cDD, CounterTrace.BoundTypes boundTypes, int n) {
        return new CounterTrace.DCPhase(PatternType.cddT(), cDD, boundTypes.asValue(), n, Collections.emptySet(), true);
    }

    protected static CounterTrace.DCPhase phaseT() {
        return new CounterTrace.DCPhase();
    }

    protected static CDD cddT() {
        return CDD.TRUE;
    }

    private String createPeaSuffix() {
        String string = this.mScope == null ? "NoScope" : this.mScope.getClass().getSimpleName().substring(12);
        String string2 = this.getClass().getSimpleName();
        return string + "_" + string2.replace("Pattern", "");
    }

    public String toString() {
        assert (this.getScope() != null || this instanceof DeclarationPattern);
        if (this.getScope() == null) {
            return this.getClass().toString();
        }
        return this.getScope().toString() + this.getClass().toString();
    }

    public int hashCode() {
        return Objects.hash(this.mCdds, this.mDurations, this.mScope);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PatternType patternType = (PatternType)object;
        if (!Objects.equals(this.mDurations, patternType.mDurations)) {
            return false;
        }
        if (!Objects.equals(this.mScope, patternType.mScope)) {
            return false;
        }
        return Objects.equals(this.mCdds, patternType.mCdds);
    }

    public static final class ReqPeas {
        private final PatternType<?> mReq;
        private final List<Map.Entry<CounterTrace, PhaseEventAutomata>> mPeas;

        public ReqPeas(PatternType<?> patternType, List<Map.Entry<CounterTrace, PhaseEventAutomata>> list) {
            this.mReq = Objects.requireNonNull(patternType);
            this.mPeas = Collections.unmodifiableList(Objects.requireNonNull(list));
            if (this.mPeas.isEmpty()) {
                throw new IllegalArgumentException("peas is empty");
            }
        }

        public PatternType<?> getPattern() {
            return this.mReq;
        }

        public List<Map.Entry<CounterTrace, PhaseEventAutomata>> getCounterTrace2Pea() {
            return this.mPeas;
        }

        public boolean isStrict() {
            for (Map.Entry<CounterTrace, PhaseEventAutomata> entry : this.mPeas) {
                PhaseEventAutomata phaseEventAutomata = entry.getValue();
                if (!phaseEventAutomata.isStrict()) continue;
                return true;
            }
            return false;
        }

        public boolean isTotalised() {
            for (Map.Entry<CounterTrace, PhaseEventAutomata> entry : this.mPeas) {
                PhaseEventAutomata phaseEventAutomata = entry.getValue();
                if (phaseEventAutomata.isTotalised()) continue;
                return false;
            }
            return true;
        }

        public boolean isComplemented() {
            for (Map.Entry<CounterTrace, PhaseEventAutomata> entry : this.mPeas) {
                PhaseEventAutomata phaseEventAutomata = entry.getValue();
                if (phaseEventAutomata.isComplemented()) continue;
                return false;
            }
            return true;
        }
    }
}

