/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.paralleldfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.dataflow.DataflowState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.paralleldfg.ParallelDataflowgraph;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParallelDfgGeneratorObserver
extends BaseObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    IAbstractInterpretationResult<DataflowState<IcfgEdge>, IcfgEdge, IcfgLocation> mDataflowAnalysisResult;
    private Integer mEdgeCount;
    private Integer mNodeCount;
    private Integer mCFGEdgeCount;
    private Integer mCFGNodeCount;
    private ParallelDataflowgraph<IcfgEdge> mInitNode;
    private final Map<String, Integer> mStmtsPerThread;
    private final Map<String, Integer> mLocsPerThread;

    public ParallelDfgGeneratorObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mDataflowAnalysisResult = null;
        this.mEdgeCount = 0;
        this.mNodeCount = 0;
        this.mCFGEdgeCount = 0;
        this.mCFGNodeCount = 0;
        this.mInitNode = null;
        this.mStmtsPerThread = new HashMap<String, Integer>();
        this.mLocsPerThread = new HashMap<String, Integer>();
    }

    public boolean process(IElement iElement) throws Throwable {
        Collection<IcfgLocation> collection;
        IIcfg iIcfg = (IIcfg)iElement;
        int n = IcfgUtils.extractStartEdges((IIcfg)iIcfg).size();
        this.mDataflowAnalysisResult = this.obtainDataflowAnalysisResult(iIcfg);
        this.computeInitNode((IIcfg<IcfgLocation>)iIcfg);
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        for (Map.Entry object2 : iIcfg.getProcedureEntryNodes().entrySet()) {
            collection = this.nodesInGraph((IcfgLocation)object2.getValue());
            arrayList.addAll(collection);
        }
        List<List<IcfgLocation>> list = ParallelDfgGeneratorObserver.getEndErrorLocations(arrayList);
        List<IcfgLocation> list2 = list.get(0);
        collection = list.get(1);
        if (list2.isEmpty()) {
            return false;
        }
        List<ParallelDataflowgraph<IcfgEdge>> list3 = ParallelDfgGeneratorObserver.computeStartLocs(list2, collection);
        this.mNodeCount = this.mNodeCount + list3.size();
        this.mLogger.debug((Object)("The init Node is " + this.mInitNode.toString()));
        this.mLogger.debug((Object)("Number of Threads: " + (n - 1)));
        this.mLogger.debug((Object)("Number of Asserts: " + list2.size()));
        if (n == collection.size()) {
            this.mLogger.debug((Object)"Exactly one return per Thread");
        } else {
            this.mLogger.debug((Object)"More than one return per Thread.");
        }
        this.mLogger.debug((Object)("Number of start nodes: " + list3.size()));
        this.mLogger.debug((Object)"Start node(s):  ");
        for (ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph : list3) {
            this.mLogger.debug((Object)("  " + parallelDataflowgraph.toString()));
        }
        this.collectDFGEdges(list3);
        this.mLogger.debug((Object)"Information of the orignial CFG of the program: ");
        this.mLogger.debug((Object)("Total number of control flow nodes: " + String.valueOf(this.mCFGNodeCount)));
        this.mLogger.debug((Object)("Total number of control flowe edges: " + String.valueOf(this.mCFGEdgeCount)));
        this.mLogger.debug((Object)("Maximal number of nodes in the Parallel DFG: " + String.valueOf(this.computeMaxNodes())));
        this.mLogger.debug((Object)"Information of the Parallel DFG:");
        this.mLogger.debug((Object)("Total number of data flow nodes: " + String.valueOf(this.mNodeCount)));
        this.mLogger.debug((Object)("Total number of data flow edges: " + String.valueOf(this.mEdgeCount)));
        return false;
    }

    private IAbstractInterpretationResult<DataflowState<IcfgEdge>, IcfgEdge, IcfgLocation> obtainDataflowAnalysisResult(IIcfg<?> iIcfg) {
        IProgressAwareTimer iProgressAwareTimer = this.mServices.getProgressMonitorService().getChildTimer(0.2);
        return AbstractInterpreter.runFuture(iIcfg, (IProgressAwareTimer)iProgressAwareTimer, (IUltimateServiceProvider)this.mServices, (boolean)false, (ILogger)this.mLogger);
    }

    /*
     * WARNING - void declaration
     */
    private void collectDFGEdges(List<ParallelDataflowgraph<IcfgEdge>> list) {
        List<ParallelDataflowgraph<IcfgEdge>> list2 = list;
        HashSet<void> hashSet = new HashSet<void>();
        HashSet<IcfgEdge> hashSet2 = new HashSet<IcfgEdge>();
        while (!list2.isEmpty()) {
            ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph = list2.get(0);
            list2.remove(0);
            CodeBlock codeBlock = (CodeBlock)parallelDataflowgraph.getNodeLabel();
            Set set = codeBlock.getTransformula().getInVars().keySet();
            this.mLogger.debug((Object)("Explain " + set.size() + " variable(s) for the statement " + codeBlock.toString()));
            for (IProgramVar iProgramVar : set) {
                this.mLogger.debug((Object)("   explain the variable " + iProgramVar.toString()));
                List<ParallelDataflowgraph<IcfgEdge>> list3 = this.explain(iProgramVar, parallelDataflowgraph);
                for (ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph2 : list3) {
                    void parallelDataflowgraph22;
                    this.mLogger.debug((Object)("      by the statement " + parallelDataflowgraph2.getNodeLabel().toString()));
                    boolean bl = false;
                    if (this.mInitNode.compare(parallelDataflowgraph2).booleanValue()) {
                        bl = true;
                    } else if (hashSet2.contains(parallelDataflowgraph2.getNodeLabel())) {
                        for (ParallelDataflowgraph parallelDataflowgraph3 : hashSet) {
                            if (!parallelDataflowgraph3.compare(parallelDataflowgraph22).booleanValue()) continue;
                            ParallelDataflowgraph parallelDataflowgraph4 = parallelDataflowgraph3;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        list2.add((ParallelDataflowgraph<IcfgEdge>)parallelDataflowgraph22);
                        hashSet.add(parallelDataflowgraph22);
                        hashSet2.add((IcfgEdge)parallelDataflowgraph22.getNodeLabel());
                        this.mLogger.debug((Object)("       Added a node " + parallelDataflowgraph22.toString()));
                        this.mNodeCount = this.mNodeCount + 1;
                    }
                    parallelDataflowgraph22.addOutgoingNode(parallelDataflowgraph, (Object)iProgramVar);
                    parallelDataflowgraph.addIncomingNode((ModifiableLabeledEdgesMultigraph)parallelDataflowgraph22);
                    this.mLogger.debug((Object)("       Added an edge " + parallelDataflowgraph.toString() + "->" + String.valueOf(iProgramVar) + " " + parallelDataflowgraph22.toString()));
                    this.mEdgeCount = this.mEdgeCount + 1;
                }
            }
        }
    }

    private List<ParallelDataflowgraph<IcfgEdge>> explain(IProgramVar iProgramVar, ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph) {
        ArrayList<ParallelDataflowgraph<IcfgEdge>> arrayList = new ArrayList<ParallelDataflowgraph<IcfgEdge>>();
        Map<String, Set<IcfgLocation>> map = this.computeLocationSets(iProgramVar, parallelDataflowgraph.getLocations());
        boolean bl = true;
        for (Map.Entry<String, Set<IcfgLocation>> entry : parallelDataflowgraph.getLocations().entrySet()) {
            boolean bl2 = false;
            if (!iProgramVar.isGlobal() && iProgramVar.getProcedure() != entry.getKey()) continue;
            for (IcfgLocation icfgLocation : entry.getValue()) {
                DataflowState dataflowState = (DataflowState)this.mDataflowAnalysisResult.getLoc2SingleStates().get(icfgLocation);
                if (icfgLocation.toString().contains("ENTRY")) {
                    bl2 = true;
                    continue;
                }
                Set set = dataflowState.getNowriteLocations(iProgramVar);
                Set<IcfgLocation> set2 = this.mInitNode.getLocations(entry.getKey());
                IcfgLocation icfgLocation2 = null;
                IcfgEdge icfgEdge2 = set2.iterator();
                while (icfgEdge2.hasNext()) {
                    IcfgLocation icfgLocation3;
                    icfgLocation2 = icfgLocation3 = icfgEdge2.next();
                }
                if (set.contains(icfgLocation2)) {
                    bl2 = true;
                }
                Set object2 = dataflowState.getReachingDefinitions(iProgramVar);
                for (IcfgEdge icfgEdge2 : object2) {
                    HashMap<String, Set<IcfgLocation>> hashMap = new HashMap<String, Set<IcfgLocation>>(map);
                    HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
                    IcfgLocation icfgLocation4 = (IcfgLocation)icfgEdge2.getSource();
                    hashSet.add(icfgLocation4);
                    hashMap.put(entry.getKey(), hashSet);
                    ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph2 = new ParallelDataflowgraph<IcfgEdge>(icfgEdge2, hashMap);
                    arrayList.add(parallelDataflowgraph2);
                }
            }
            if (bl2) continue;
            bl = false;
        }
        if (bl) {
            arrayList.add(this.mInitNode);
        }
        return arrayList;
    }

    private Map<String, Set<IcfgLocation>> computeLocationSets(IProgramVar iProgramVar, Map<String, Set<IcfgLocation>> map) {
        HashMap<String, Set<IcfgLocation>> hashMap = new HashMap<String, Set<IcfgLocation>>();
        for (Map.Entry<String, Set<IcfgLocation>> entry : map.entrySet()) {
            HashSet hashSet = new HashSet(entry.getValue());
            if (!iProgramVar.isGlobal() && iProgramVar.getProcedure() != entry.getKey()) continue;
            for (IcfgLocation icfgLocation : entry.getValue()) {
                if (icfgLocation.toString().contains("ENTRY")) continue;
                DataflowState dataflowState = (DataflowState)this.mDataflowAnalysisResult.getLoc2SingleStates().get(icfgLocation);
                Set set = dataflowState.getNowriteLocations(iProgramVar);
                hashSet.addAll(set);
            }
            hashMap.put(entry.getKey(), hashSet);
        }
        return hashMap;
    }

    private Set<IcfgLocation> nodesInGraph(IcfgLocation icfgLocation) {
        IcfgLocation icfgLocation2;
        Integer n = 0;
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        arrayList.add(icfgLocation);
        while (!arrayList.isEmpty()) {
            icfgLocation2 = (IcfgLocation)arrayList.get(0);
            hashSet.add(icfgLocation2);
            arrayList.remove(0);
            List list = icfgLocation2.getOutgoingEdges();
            for (IcfgEdge icfgEdge : list) {
                n = n + 1;
                IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
                if (hashSet.contains(icfgLocation3) || arrayList.contains(icfgLocation3)) continue;
                arrayList.add(icfgLocation3);
            }
        }
        this.mCFGEdgeCount = this.mCFGEdgeCount + n;
        this.mCFGNodeCount = this.mCFGNodeCount + hashSet.size();
        icfgLocation2 = (BoogieIcfgLocation)icfgLocation;
        this.mStmtsPerThread.put(icfgLocation2.getProcedure(), hashSet.size());
        this.mLocsPerThread.put(icfgLocation2.getProcedure(), n);
        return hashSet;
    }

    private static List<List<IcfgLocation>> getEndErrorLocations(List<IcfgLocation> list) {
        IcfgLocation icfgLocation2;
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        ArrayList<IcfgLocation> arrayList2 = new ArrayList<IcfgLocation>();
        for (IcfgLocation icfgLocation2 : list) {
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)icfgLocation2;
            if (boogieIcfgLocation.isErrorLocation()) {
                arrayList.add(icfgLocation2);
            }
            if (icfgLocation2.getOutgoingEdges().size() != 0 || boogieIcfgLocation.isErrorLocation()) continue;
            arrayList2.add(icfgLocation2);
        }
        icfgLocation2 = new ArrayList();
        icfgLocation2.add(arrayList);
        icfgLocation2.add(arrayList2);
        return icfgLocation2;
    }

    private static List<ParallelDataflowgraph<IcfgEdge>> computeStartLocs(List<IcfgLocation> list, List<IcfgLocation> list2) {
        IcfgEdge icfgEdge;
        IcfgLocation icfgLocation;
        ArrayList<ParallelDataflowgraph<IcfgEdge>> arrayList = new ArrayList<ParallelDataflowgraph<IcfgEdge>>();
        HashMap<String, IcfgEdge> hashMap = new HashMap<String, IcfgEdge>();
        for (IcfgLocation icfgLocation2 : list2) {
            icfgLocation = icfgLocation2;
            if (hashMap.containsKey(icfgLocation.getProcedure())) {
                ((Set)hashMap.get(icfgLocation.getProcedure())).add(icfgLocation);
                continue;
            }
            if (icfgLocation.getProcedure() == "~init") continue;
            icfgEdge = new HashSet();
            icfgEdge.add(icfgLocation);
            hashMap.put(icfgLocation.getProcedure(), icfgEdge);
        }
        Iterator<IcfgLocation> iterator = list.iterator();
        while (iterator.hasNext()) {
            IcfgLocation icfgLocation2;
            icfgLocation = icfgLocation2 = iterator.next();
            assert (icfgLocation2.getIncomingEdges().size() == 1);
            icfgEdge = (IcfgEdge)icfgLocation2.getIncomingEdges().get(0);
            HashMap<String, Set<IcfgLocation>> hashMap2 = new HashMap<String, Set<IcfgLocation>>(hashMap);
            HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
            hashSet.add((IcfgLocation)icfgEdge.getSource());
            hashMap2.put(icfgLocation.getProcedure(), hashSet);
            ParallelDataflowgraph<IcfgEdge> parallelDataflowgraph = new ParallelDataflowgraph<IcfgEdge>(icfgEdge, hashMap2);
            arrayList.add(parallelDataflowgraph);
        }
        return arrayList;
    }

    private void computeInitNode(IIcfg<IcfgLocation> iIcfg) {
        HashMap<String, Set<IcfgLocation>> hashMap = new HashMap<String, Set<IcfgLocation>>();
        IcfgEdge icfgEdge = null;
        for (Map.Entry entry : iIcfg.getProcedureEntryNodes().entrySet()) {
            IcfgLocation icfgLocation = (IcfgLocation)entry.getValue();
            IcfgLocation icfgLocation2 = icfgLocation;
            if (icfgLocation2.getProcedure() == "~init") {
                icfgEdge = (IcfgEdge)icfgLocation.getOutgoingEdges().get(0);
                while (!((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges().isEmpty()) {
                    icfgEdge = (IcfgEdge)((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges().get(0);
                }
                continue;
            }
            HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
            hashSet.add(icfgLocation2);
            hashMap.put(icfgLocation2.getProcedure(), hashSet);
        }
        this.mInitNode = new ParallelDataflowgraph<Object>(icfgEdge, (Map<String, Set<IcfgLocation>>)hashMap);
        this.mNodeCount = this.mNodeCount + 1;
    }

    private Integer computeMaxNodes() {
        int n = 0;
        for (Map.Entry<String, Integer> entry : this.mStmtsPerThread.entrySet()) {
            if (entry.getKey() == "~init") continue;
            for (Map.Entry<String, Integer> entry2 : this.mLocsPerThread.entrySet()) {
                if (entry.getKey() == entry2.getKey() || entry2.getKey() == "~init") continue;
                n += entry.getValue() * entry2.getValue();
            }
        }
        return n;
    }
}

