/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import java.util.Map;

public class CompositeReason
extends LAReason {
    private final LAReason[] mReasons;
    private final Rational[] mCoeffs;
    private final InfinitesimalNumber mExactBound;

    public CompositeReason(LinVar linVar, InfinitesimalNumber infinitesimalNumber, boolean bl, LAReason[] lAReasonArray, Rational[] rationalArray, LiteralReason literalReason) {
        super(linVar, infinitesimalNumber, bl, literalReason);
        assert (literalReason != null);
        this.mReasons = lAReasonArray;
        this.mCoeffs = rationalArray;
        this.mExactBound = infinitesimalNumber;
        this.mBound = linVar.mIsInt ? (bl ? infinitesimalNumber.floor() : infinitesimalNumber.ceil()) : infinitesimalNumber;
        assert (!this.getVar().mIsInt || this.mBound.isIntegral());
    }

    @Override
    public InfinitesimalNumber getExactBound() {
        return this.mExactBound;
    }

    @Override
    InfinitesimalNumber explain(Explainer explainer, InfinitesimalNumber infinitesimalNumber, Rational rational) {
        Object object;
        Map.Entry<InfinitesimalNumber, BoundConstraint> entry;
        boolean bl = false;
        if (this.isUpper()) {
            entry = this.getVar().mConstraints.ceilingEntry(this.getBound());
            if (entry != null) {
                var6_6 = entry.getValue();
                if (var6_6.getDecideStatus() == var6_6 && explainer.canExplainWith(var6_6)) {
                    object = var6_6.getBound().sub(this.getBound());
                    if (infinitesimalNumber.compareTo((InfinitesimalNumber)object) > 0) {
                        explainer.addLiteral(var6_6.negate(), rational);
                        return infinitesimalNumber.sub((InfinitesimalNumber)object);
                    }
                } else {
                    bl = true;
                }
            }
        } else {
            entry = this.getVar().mConstraints.lowerEntry(this.getBound());
            if (entry != null) {
                var6_6 = entry.getValue();
                if (var6_6.getDecideStatus() == var6_6.negate() && explainer.canExplainWith(var6_6)) {
                    object = this.getBound().sub(var6_6.getInverseBound());
                    if (infinitesimalNumber.compareTo((InfinitesimalNumber)object) > 0) {
                        explainer.addLiteral(var6_6, rational);
                        return infinitesimalNumber.sub((InfinitesimalNumber)object);
                    }
                } else {
                    bl = true;
                }
            }
        }
        entry = !this.getVar().mIsInt ? InfinitesimalNumber.ZERO : (this.isUpper() ? this.mExactBound.sub(this.getBound()) : this.getBound().sub(this.mExactBound));
        int n = explainer.getDecideLevel();
        if (bl || infinitesimalNumber.compareTo((InfinitesimalNumber)((Object)entry)) > 0 && this.getLastLiteral().getDecideLevel() >= n) {
            boolean bl2;
            boolean bl3 = bl2 = infinitesimalNumber.compareTo((InfinitesimalNumber)((Object)entry)) > 0;
            if (!bl2) {
                explainer.addAnnotation(this, rational);
                return infinitesimalNumber;
            }
            infinitesimalNumber = infinitesimalNumber.sub((InfinitesimalNumber)((Object)entry));
            assert (infinitesimalNumber.compareTo(InfinitesimalNumber.ZERO) > 0);
            int n2 = 0;
            while (n2 < this.mReasons.length) {
                Rational rational2 = this.mCoeffs[n2];
                infinitesimalNumber = infinitesimalNumber.div(rational2.abs());
                infinitesimalNumber = this.mReasons[n2].explain(explainer, infinitesimalNumber, rational.mul(rational2));
                infinitesimalNumber = infinitesimalNumber.mul(rational2.abs());
                assert (infinitesimalNumber.compareTo(InfinitesimalNumber.ZERO) > 0);
                ++n2;
            }
            return infinitesimalNumber;
        }
        object = explainer.createComposite(this);
        assert (((Literal)object).getAtom().getDecideStatus() == object);
        explainer.addLiteral(((Literal)object).negate(), rational);
        return infinitesimalNumber;
    }
}

