/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.BacktranslatingProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.NwaInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PartialOrderAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.Petri2FiniteAutomatonAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriLbeInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.BasicCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopSWBnonRecursive;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.EagerReuseCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IWitnessTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IncrementalInclusionCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.LazyReuseCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.NwaCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.WitnessAutomatonAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.CegarLoopForPetriNet;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.IndependenceProviderFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency.PartialOrderCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class CegarLoopFactory<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mBaseServices;
    private final ILogger mLogger;
    private final Class<L> mTransitionClazz;
    private final TAPreferences mPrefs;
    private final Supplier<PetriNetLargeBlockEncoding.IPLBECompositionFactory<L>> mCreateCompositionFactory;
    private final ICopyActionFactory<L> mCopyFactory;
    private CegarLoopStatisticsGenerator mCegarLoopBenchmark;
    private IndependenceProviderFactory<L> mIndependenceProviderFactory;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency;

    public CegarLoopFactory(IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, TAPreferences tAPreferences, Supplier<PetriNetLargeBlockEncoding.IPLBECompositionFactory<L>> supplier, ICopyActionFactory<L> iCopyActionFactory) {
        this.mBaseServices = iUltimateServiceProvider;
        this.mLogger = this.mBaseServices.getLoggingService().getLogger(CegarLoopFactory.class);
        this.mTransitionClazz = clazz;
        this.mPrefs = tAPreferences;
        this.mCreateCompositionFactory = supplier;
        this.mCopyFactory = iCopyActionFactory;
    }

    public Pair<? extends BasicCegarLoop<L, ?>, IProofProducer<IIcfg<IcfgLocation>, ?>> constructCegarLoop(IUltimateServiceProvider iUltimateServiceProvider, DebugIdentifier debugIdentifier, IIcfg<IcfgLocation> iIcfg, Set<IcfgLocation> set, IWitnessTransformer<L> iWitnessTransformer, List<INestedWordAutomaton<String, String>> list) {
        Object object;
        this.mCegarLoopBenchmark = new CegarLoopStatisticsGenerator();
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        PredicateFactory predicateFactory = new PredicateFactory(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
        Set set2 = this.mPrefs.getHoareAnnotationPositions().getLocations(iIcfg);
        PredicateFactoryRefinement predicateFactoryRefinement = new PredicateFactoryRefinement(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), predicateFactory, this.mPrefs.getHoareSettings().computeHoareAnnotation(), set2);
        boolean bl = IcfgUtils.isConcurrent(iIcfg);
        if (bl) {
            if (iWitnessTransformer != null && this.mPrefs.getAutomataTypeConcurrency() != TAPreferences.Concurrency.FINITE_AUTOMATA) {
                this.mLogger.warn("Violation witness validation is only supported for CEGAR loops based on %s. Ignoring concurrency settiong %s and switching to %s.", new Object[]{TAPreferences.Concurrency.FINITE_AUTOMATA, this.mPrefs.getAutomataTypeConcurrency(), TAPreferences.Concurrency.FINITE_AUTOMATA});
                object = TAPreferences.Concurrency.FINITE_AUTOMATA;
            } else {
                object = this.mPrefs.getAutomataTypeConcurrency();
            }
            switch (CegarLoopFactory.$SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency()[object.ordinal()]) {
                case 3: {
                    this.requireNoReuse("POR-based analysis");
                    CegarLoopFactory.requireNoWitnesses(iWitnessTransformer, "POR-based analysis");
                    if (this.mIndependenceProviderFactory == null) {
                        this.mIndependenceProviderFactory = new IndependenceProviderFactory<L>(this.mBaseServices, this.mPrefs, this.mCopyFactory);
                    }
                    PartialOrderCegarLoop<L> partialOrderCegarLoop = new PartialOrderCegarLoop<L>(debugIdentifier, this.createPartialOrderAbstraction(iUltimateServiceProvider, predicateFactory, predicateFactoryRefinement, iIcfg, set), iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, iUltimateServiceProvider, this.mIndependenceProviderFactory.createProviders(iIcfg, predicateFactory), this.mTransitionClazz, predicateFactoryRefinement, this.mCopyFactory);
                    return new Pair(partialOrderCegarLoop, null);
                }
                case 2: {
                    this.requireNoReuse("Petri net-based analysis");
                    CegarLoopFactory.requireNoWitnesses(iWitnessTransformer, "Petri net-based analysis");
                    CegarLoopForPetriNet<L> cegarLoopForPetriNet = new CegarLoopForPetriNet<L>(debugIdentifier, this.createPetriAbstraction(iUltimateServiceProvider, predicateFactory, true, iIcfg, set), iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, iUltimateServiceProvider, this.mTransitionClazz, predicateFactoryRefinement);
                    return new Pair(cegarLoopForPetriNet, null);
                }
            }
        }
        object = this.createAutomataAbstractionProvider(iUltimateServiceProvider, bl, predicateFactory, predicateFactoryRefinement, iWitnessTransformer);
        INestedWordAutomaton iNestedWordAutomaton = (INestedWordAutomaton)this.constructInitialAbstraction((IInitialAbstractionProvider)object.getFirst(), iIcfg, set);
        NwaHoareProofProducer nwaHoareProofProducer = (NwaHoareProofProducer)((Supplier)object.getSecond()).get();
        Function function = (Function)object.getThird();
        NwaCegarLoop<L> nwaCegarLoop = this.createFiniteAutomataCegarLoop(iUltimateServiceProvider, debugIdentifier, iIcfg, predicateFactory, set, list, predicateFactoryRefinement, iWitnessTransformer, iNestedWordAutomaton, nwaHoareProofProducer);
        BacktranslatingProofProducer backtranslatingProofProducer = nwaHoareProofProducer == null || function == null ? null : new BacktranslatingProofProducer(iIcfg, (IProofProducer)nwaHoareProofProducer, function);
        return new Pair(nwaCegarLoop, (Object)backtranslatingProofProducer);
    }

    private NwaCegarLoop<L> createFiniteAutomataCegarLoop(IUltimateServiceProvider iUltimateServiceProvider, DebugIdentifier debugIdentifier, IIcfg<IcfgLocation> iIcfg, PredicateFactory predicateFactory, Set<IcfgLocation> set, List<INestedWordAutomaton<String, String>> list, PredicateFactoryRefinement predicateFactoryRefinement, IWitnessTransformer<L> iWitnessTransformer, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, NwaHoareProofProducer<L> nwaHoareProofProducer) {
        TraceAbstractionPreferenceInitializer.LanguageOperation languageOperation = (TraceAbstractionPreferenceInitializer.LanguageOperation)iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("LanguageOperation", TraceAbstractionPreferenceInitializer.LanguageOperation.class);
        CfgSmtToolkit cfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        if (languageOperation != TraceAbstractionPreferenceInitializer.LanguageOperation.DIFFERENCE) {
            return new IncrementalInclusionCegarLoop<L>(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, nwaHoareProofProducer, iUltimateServiceProvider, languageOperation, this.mTransitionClazz, predicateFactoryRefinement);
        }
        if (this.mPrefs.interpolantAutomaton() == TraceAbstractionPreferenceInitializer.InterpolantAutomaton.TOTALINTERPOLATION) {
            return new CegarLoopSWBnonRecursive<L>(debugIdentifier, iNestedWordAutomaton, (IIcfg<?>)iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, nwaHoareProofProducer, iUltimateServiceProvider, this.mTransitionClazz, predicateFactoryRefinement);
        }
        return switch (this.mPrefs.getFloydHoareAutomataReuse()) {
            case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.EAGER -> new EagerReuseCegarLoop<L>(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, nwaHoareProofProducer, iUltimateServiceProvider, Collections.emptyList(), list, this.mTransitionClazz, predicateFactoryRefinement);
            case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.LAZY_IN_ORDER -> new LazyReuseCegarLoop<L>(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, nwaHoareProofProducer, iUltimateServiceProvider, Collections.emptyList(), list, this.mTransitionClazz, predicateFactoryRefinement);
            case TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.NONE -> new NwaCegarLoop<L>(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, this.mPrefs, set, nwaHoareProofProducer, iUltimateServiceProvider, this.mTransitionClazz, predicateFactoryRefinement);
            default -> throw new MatchException(null, null);
        };
    }

    private void requireNoReuse(String string) {
        if (this.mPrefs.getFloydHoareAutomataReuse() != TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.NONE) {
            throw new UnsupportedOperationException("Floyd/Hoare automaton reuse not supported for " + string);
        }
    }

    private static void requireNoWitnesses(IWitnessTransformer<?> iWitnessTransformer, String string) {
        if (iWitnessTransformer != null) {
            throw new UnsupportedOperationException("Witness automata not supported for " + string);
        }
    }

    private Triple<IInitialAbstractionProvider<L, ? extends INestedWordAutomaton<L, IPredicate>>, Supplier<NwaHoareProofProducer<L>>, Function<IFloydHoareAnnotation<IPredicate>, IFloydHoareAnnotation<IcfgLocation>>> createAutomataAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, boolean bl, PredicateFactory predicateFactory, PredicateFactoryRefinement predicateFactoryRefinement, IWitnessTransformer<L> iWitnessTransformer) {
        if (!bl) {
            NwaInitialAbstractionProvider nwaInitialAbstractionProvider = new NwaInitialAbstractionProvider(iUltimateServiceProvider, (IEmptyStackStateFactory)predicateFactoryRefinement, this.mPrefs.interprocedural(), predicateFactory, this.mPrefs.getHoareSettings());
            if (iWitnessTransformer == null) {
                return new Triple((Object)nwaInitialAbstractionProvider, () -> ((NwaInitialAbstractionProvider)nwaInitialAbstractionProvider).getProofProducer(), arg_0 -> ((NwaInitialAbstractionProvider)nwaInitialAbstractionProvider).backtranslateProof(arg_0));
            }
            return new Triple(new WitnessAutomatonAbstractionProvider<L>(predicateFactory, nwaInitialAbstractionProvider, iWitnessTransformer), () -> null, null);
        }
        IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> iInitialAbstractionProvider = this.createPetriAbstractionProvider(iUltimateServiceProvider, predicateFactory, false);
        if (!this.mPrefs.applyOneShotPOR()) {
            Petri2FiniteAutomatonAbstractionProvider.Eager eager = new Petri2FiniteAutomatonAbstractionProvider.Eager(iUltimateServiceProvider, iInitialAbstractionProvider, (IPetriNet2FiniteAutomatonStateFactory)predicateFactoryRefinement);
            if (iWitnessTransformer == null) {
                return new Triple((Object)eager, () -> eager.getProofProducer(predicateFactory, this.mPrefs.getHoareSettings()), null);
            }
            return new Triple(new WitnessAutomatonAbstractionProvider<L>(predicateFactory, eager, iWitnessTransformer), () -> null, null);
        }
        if (iWitnessTransformer != null) {
            throw new UnsupportedOperationException("Witness validation with partial order reduction is not supported yet.");
        }
        return new Triple((Object)new PartialOrderAbstractionProvider((IInitialAbstractionProvider)new Petri2FiniteAutomatonAbstractionProvider.Lazy(iUltimateServiceProvider, iInitialAbstractionProvider, (IPetriNet2FiniteAutomatonStateFactory)predicateFactoryRefinement), iUltimateServiceProvider, (IEmptyStackStateFactory)predicateFactoryRefinement, predicateFactory, this.mPrefs.getPartialOrderMode(), this.mPrefs.getDfsOrderType(), this.mPrefs.getDfsOrderSeed()), () -> null, null);
    }

    private BoundedPetriNet<L, IPredicate> createPetriAbstraction(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, boolean bl, IIcfg<IcfgLocation> iIcfg, Set<IcfgLocation> set) {
        return this.constructInitialAbstraction(this.createPetriAbstractionProvider(iUltimateServiceProvider, predicateFactory, bl), iIcfg, set);
    }

    private IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> createPetriAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, boolean bl) {
        PetriInitialAbstractionProvider petriInitialAbstractionProvider = new PetriInitialAbstractionProvider(iUltimateServiceProvider, predicateFactory, bl);
        if (!this.mPrefs.applyOneShotLbe()) {
            return petriInitialAbstractionProvider;
        }
        return new PetriLbeInitialAbstractionProvider(iUltimateServiceProvider, (IInitialAbstractionProvider)petriInitialAbstractionProvider, this.mTransitionClazz, this.mPrefs.lbeIndependenceSettings(), this.mCreateCompositionFactory.get());
    }

    private INwaOutgoingLetterAndTransitionProvider<L, IPredicate> createPartialOrderAbstraction(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPetriNet2FiniteAutomatonStateFactory<IPredicate> iPetriNet2FiniteAutomatonStateFactory, IIcfg<IcfgLocation> iIcfg, Set<IcfgLocation> set) {
        return this.constructInitialAbstraction(this.createPartialOrderAbstractionProvider(iUltimateServiceProvider, predicateFactory, iPetriNet2FiniteAutomatonStateFactory), iIcfg, set);
    }

    private IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>> createPartialOrderAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPetriNet2FiniteAutomatonStateFactory<IPredicate> iPetriNet2FiniteAutomatonStateFactory) {
        IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> iInitialAbstractionProvider = this.createPetriAbstractionProvider(iUltimateServiceProvider, predicateFactory, false);
        return new Petri2FiniteAutomatonAbstractionProvider.Lazy(iUltimateServiceProvider, iInitialAbstractionProvider, iPetriNet2FiniteAutomatonStateFactory);
    }

    private <A extends IAutomaton<L, ?>> A constructInitialAbstraction(IInitialAbstractionProvider<L, A> iInitialAbstractionProvider, IIcfg<IcfgLocation> iIcfg, Set<IcfgLocation> set) {
        this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.OverallTime);
        this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime);
        try {
            IAutomaton iAutomaton = iInitialAbstractionProvider.getInitialAbstraction(iIcfg, set);
            return (A)iAutomaton;
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing initial abstraction");
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataOperationCanceledException);
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing initial abstraction");
            toolchainCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw toolchainCanceledException;
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataLibraryException);
        }
        finally {
            this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime);
            this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.OverallTime);
        }
    }

    public CegarLoopStatisticsGenerator getStatistics() {
        return this.mCegarLoopBenchmark;
    }

    public void shutdown() {
        if (this.mIndependenceProviderFactory != null) {
            this.mIndependenceProviderFactory.shutdown();
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency() {
        if ($SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency != null) {
            return $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency;
        }
        int[] nArray = new int[TAPreferences.Concurrency.values().length];
        try {
            nArray[TAPreferences.Concurrency.FINITE_AUTOMATA.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TAPreferences.Concurrency.PARTIAL_ORDER_FA.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TAPreferences.Concurrency.PETRI_NET.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$uni_freiburg$informatik$ultimate$plugins$generator$traceabstraction$preferences$TAPreferences$Concurrency = nArray;
        return nArray;
    }
}

