/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AcceptsInfiniteWords<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IPetriNet2FiniteAutomatonStateFactory<PLACE>> {
    protected final IPetriNetTransitionProvider<LETTER, PLACE> mOperand;
    private final Marking<PLACE> mInitialMarking;
    protected final NestedLassoWord<LETTER> mLassoWord;
    protected Set<MarkingOfFireSequence<LETTER, PLACE>> mFireSequenceTreeMarkings;
    protected int mFireSequenceIndex;
    protected final boolean mResult;

    public AcceptsInfiniteWords(AutomataLibraryServices automataLibraryServices, IPetriNetTransitionProvider<LETTER, PLACE> iPetriNetTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) throws PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNetTransitionProvider;
        this.mInitialMarking = new Marking(ImmutableSet.of(iPetriNetTransitionProvider.getInitialPlaces()));
        this.mLassoWord = nestedLassoWord;
        this.mFireSequenceTreeMarkings = new HashSet<MarkingOfFireSequence<LETTER, PLACE>>();
        this.mFireSequenceIndex = 0;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.isWordAcceptedByOmegaNet();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    @Override
    protected IPetriNetTransitionProvider<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    private final boolean isWordAcceptedByOmegaNet() throws PetriNetNot1SafeException {
        if (this.mLassoWord.getLoop().length() < 1) {
            return false;
        }
        this.computeMarkingsFromFirstWordRun();
        return this.computeLoopMarkingsAndCheckForAcceptance();
    }

    private void computeMarkingsFromFirstWordRun() throws PetriNetNot1SafeException {
        this.mFireSequenceTreeMarkings.add(new MarkingOfFireSequence(this.mInitialMarking, new HashSet(), 0));
        for (Object LETTER : this.mLassoWord.getStem()) {
            this.produceSuccessorMarkingsOfFireSequenceOfSet(LETTER);
        }
        for (Object LETTER : this.mLassoWord.getLoop()) {
            this.produceSuccessorMarkingsOfFireSequenceOfSet(LETTER);
        }
    }

    private final boolean computeLoopMarkingsAndCheckForAcceptance() throws PetriNetNot1SafeException {
        while (!this.mFireSequenceTreeMarkings.isEmpty()) {
            for (MarkingOfFireSequence<LETTER, PLACE> object : this.mFireSequenceTreeMarkings) {
                object.addHondaMarkingOfFireSequence(object.getMarking(), this.mFireSequenceIndex);
            }
            for (Object LETTER : this.mLassoWord.getLoop()) {
                this.produceSuccessorMarkingsOfFireSequenceOfSet(LETTER);
            }
            boolean bl = this.checkForAcceptingConditions();
            if (bl) {
                return true;
            }
            for (Pair<MarkingOfFireSequence<LETTER, PLACE>, Integer> pair : this.containsLoopingFiresequence(this.mFireSequenceTreeMarkings)) {
                if (((MarkingOfFireSequence)pair.getFirst()).getLastIndexOfShootingAcceptingStateInFireSequence() >= (Integer)pair.getSecond()) {
                    return true;
                }
                this.mFireSequenceTreeMarkings.remove(pair.getFirst());
            }
        }
        return false;
    }

    abstract boolean checkForAcceptingConditions();

    private void produceSuccessorMarkingsOfFireSequenceOfSet(LETTER LETTER) throws PetriNetNot1SafeException {
        HashSet<MarkingOfFireSequence<LETTER, PLACE>> hashSet = new HashSet<MarkingOfFireSequence<LETTER, PLACE>>();
        for (MarkingOfFireSequence<LETTER, PLACE> markingOfFireSequence : this.mFireSequenceTreeMarkings) {
            hashSet.addAll(this.getSuccessorMarkingsOfFireSequence(markingOfFireSequence, LETTER));
        }
        this.mFireSequenceTreeMarkings = hashSet;
        this.removeRedundantMarkings();
        ++this.mFireSequenceIndex;
    }

    private void removeRedundantMarkings() {
        HashSet<MarkingOfFireSequence<LETTER, PLACE>> hashSet = new HashSet<MarkingOfFireSequence<LETTER, PLACE>>();
        for (MarkingOfFireSequence<LETTER, PLACE> markingOfFireSequence : this.mFireSequenceTreeMarkings) {
            if (hashSet.contains(markingOfFireSequence)) continue;
            for (MarkingOfFireSequence<LETTER, PLACE> markingOfFireSequence2 : this.mFireSequenceTreeMarkings) {
                if (markingOfFireSequence == markingOfFireSequence2) continue;
                Set set = markingOfFireSequence2.getMarking().stream().collect(Collectors.toSet());
                if (!markingOfFireSequence.getMarking().containsAll(set)) continue;
                hashSet.add(markingOfFireSequence2);
            }
        }
        this.mFireSequenceTreeMarkings.removeAll(hashSet);
    }

    private Set<MarkingOfFireSequence<LETTER, PLACE>> getSuccessorMarkingsOfFireSequence(MarkingOfFireSequence<LETTER, PLACE> markingOfFireSequence, LETTER LETTER) throws PetriNetNot1SafeException {
        Set<Transition<LETTER, PLACE>> set = this.activeTransitionsWithSymbol(markingOfFireSequence.getMarking(), LETTER);
        HashSet<MarkingOfFireSequence<LETTER, PLACE>> hashSet = new HashSet<MarkingOfFireSequence<LETTER, PLACE>>();
        for (Transition<LETTER, PLACE> transition : set) {
            hashSet.add(this.getSuccessorMarkingOfFireSequence(markingOfFireSequence, transition));
        }
        return hashSet;
    }

    private Set<Transition<LETTER, PLACE>> activeTransitionsWithSymbol(Marking<PLACE> marking, LETTER LETTER) {
        HashSet<Transition<LETTER, PLACE>> hashSet = new HashSet<Transition<LETTER, PLACE>>();
        for (PLACE PLACE : marking) {
            this.mOperand.getSuccessors(PLACE).stream().filter(transition -> transition.getSymbol().equals(LETTER)).filter(transition -> marking.isTransitionEnabled(transition)).collect(Collectors.toSet()).forEach(hashSet::add);
        }
        return hashSet;
    }

    abstract MarkingOfFireSequence<LETTER, PLACE> getSuccessorMarkingOfFireSequence(MarkingOfFireSequence<LETTER, PLACE> var1, Transition<LETTER, PLACE> var2) throws PetriNetNot1SafeException;

    protected final Set<Pair<MarkingOfFireSequence<LETTER, PLACE>, Integer>> containsLoopingFiresequence(Set<MarkingOfFireSequence<LETTER, PLACE>> set) {
        HashSet<Pair<MarkingOfFireSequence<LETTER, PLACE>, Integer>> hashSet = new HashSet<Pair<MarkingOfFireSequence<LETTER, PLACE>, Integer>>();
        for (MarkingOfFireSequence<LETTER, PLACE> markingOfFireSequence : set) {
            for (Pair<Marking<PLACE>, Integer> pair : markingOfFireSequence.getHondaMarkingsOfFireSequence()) {
                Set set2 = ((Marking)pair.getFirst()).stream().collect(Collectors.toSet());
                if (!markingOfFireSequence.getMarking().containsAll(set2)) continue;
                hashSet.add(new Pair(markingOfFireSequence, (Object)((Integer)pair.getSecond())));
            }
        }
        return hashSet;
    }

    protected static class MarkingOfFireSequence<LETTER, PLACE> {
        private final Marking<PLACE> mMarking;
        private final Set<Pair<Marking<PLACE>, Integer>> mHondaMarkingsOfFireSequence;
        private final int mLastIndexOfShootingAcceptingStateInFireSequence;

        public MarkingOfFireSequence(Marking<PLACE> marking, Set<Pair<Marking<PLACE>, Integer>> set, int n) {
            this.mMarking = marking;
            this.mHondaMarkingsOfFireSequence = set;
            this.mLastIndexOfShootingAcceptingStateInFireSequence = n;
        }

        public final Marking<PLACE> getMarking() {
            return this.mMarking;
        }

        public Set<Pair<Marking<PLACE>, Integer>> getHondaMarkingsOfFireSequence() {
            return new HashSet<Pair<Marking<PLACE>, Integer>>(this.mHondaMarkingsOfFireSequence);
        }

        public void addHondaMarkingOfFireSequence(Marking<PLACE> marking, int n) {
            this.mHondaMarkingsOfFireSequence.add(new Pair(marking, (Object)n));
        }

        public final int getLastIndexOfShootingAcceptingStateInFireSequence() {
            return this.mLastIndexOfShootingAcceptingStateInFireSequence;
        }
    }
}

