/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.Term;

public class InterpolationInfo {
    Term[] mPartitions = new Term[5];
    int[] mStartOfSubTrees = new int[5];
    int mSize = 0;
    boolean mIsAndTerm = false;

    private void grow(int n) {
        int n2 = 2 * this.mPartitions.length;
        if (n2 < n) {
            n2 = n + 1;
        }
        Term[] termArray = new Term[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.mPartitions, 0, termArray, 0, this.mSize);
        System.arraycopy(this.mStartOfSubTrees, 0, nArray, 0, this.mSize);
        this.mPartitions = termArray;
        this.mStartOfSubTrees = nArray;
    }

    public void makeAndTerm() {
        this.mIsAndTerm = true;
    }

    public void addParent(Term term) {
        if (this.mSize + 1 >= this.mPartitions.length) {
            this.grow(this.mSize + 1);
        }
        this.mPartitions[this.mSize] = term;
        this.mStartOfSubTrees[this.mSize] = 0;
        ++this.mSize;
    }

    public void addSibling(InterpolationInfo interpolationInfo) {
        if (this.mSize + interpolationInfo.mSize >= this.mPartitions.length) {
            this.grow(this.mSize + interpolationInfo.mSize);
        }
        System.arraycopy(interpolationInfo.mPartitions, 0, this.mPartitions, this.mSize, interpolationInfo.mSize);
        int n = 0;
        while (n < interpolationInfo.mSize) {
            this.mStartOfSubTrees[this.mSize + n] = this.mSize + interpolationInfo.mStartOfSubTrees[n];
            ++n;
        }
        this.mSize += interpolationInfo.mSize;
    }

    public Term[] getPartition() {
        if (this.mPartitions.length != this.mSize) {
            Term[] termArray = new Term[this.mSize];
            System.arraycopy(this.mPartitions, 0, termArray, 0, this.mSize);
            return termArray;
        }
        return this.mPartitions;
    }

    public int[] getTreeStructure() {
        if (this.mStartOfSubTrees.length != this.mSize) {
            int[] nArray = new int[this.mSize];
            System.arraycopy(this.mStartOfSubTrees, 0, nArray, 0, this.mSize);
            return nArray;
        }
        return this.mStartOfSubTrees;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public boolean isAndTerm() {
        return this.mIsAndTerm;
    }

    public boolean isClosedTree() {
        return !this.mIsAndTerm && this.mSize > 0 && this.mStartOfSubTrees[this.mSize - 1] == 0;
    }
}

