/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;

public class GCCBuildCommandParser
extends AbstractBuildCommandParser
implements ILanguageSettingsEditableProvider {
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] includeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-I\\s*(?<quote>[\"'])(.*)\\k<quote>", "$2"), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-I\\s*([^\\s\"']*)", "$1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] systemIncludeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-isystem\\s*(?<quote>[\"'])(.*)\\k<quote>", "$2"), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-isystem\\s*([^\\s\"']*)", "$1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] frameworkOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-(F|(iframework))\\s*(?<quote>[\"'])(.*)\\k<quote>", "$4", 64), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("-(F|(iframework))\\s*([^\\s\"']*)", "$3", 64)};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] forceIncludeOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludeFileOptionParser("-include\\s*(?<quote>[\"'])(.*)\\k<quote>", "$2"), new AbstractLanguageSettingsOutputScanner.IncludeFileOptionParser("-include\\s*([^\\s\"']*)", "$1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] defineOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*(?<quote>[\"'])([^=]*)(=(.*))?\\k<quote>", "$2", "$4"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=(\"\\\\(\")(.*?)\\\\\"\")", "$1", "$3$4$3"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=(?<quote>\\\\([\"']))(.*?)\\k<quote>", "$1", "$3$4$3"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=(?<quote>[\"'])(.*?)\\k<quote>", "$1", "$3"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)=([^\\s\"']*)?", "$1", "$2"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-D\\s*([^\\s=\"']*)", "$1", "1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] undefineOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.MacroOptionParser("-U\\s*([^\\s=\"']*)", "$1", 32)};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] macrosOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.MacroFileOptionParser("-imacros\\s*(?<quote>[\"'])(.*)\\k<quote>", "$2"), new AbstractLanguageSettingsOutputScanner.MacroFileOptionParser("-imacros\\s*([^\\s\"']*)", "$1")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] libraryOptionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.LibraryPathOptionParser("-L\\s*(?<quote>[\"'])(.*)\\k<quote>", "$2"), new AbstractLanguageSettingsOutputScanner.LibraryPathOptionParser("-L\\s*([^\\s\"']*)", "$1"), new AbstractLanguageSettingsOutputScanner.LibraryFileOptionParser("-l\\s*([^\\s\"']*)", "lib$1.a")};
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] emptyParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[0];
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers;

    static {
        ArrayList<AbstractLanguageSettingsOutputScanner.AbstractOptionParser> parsers = new ArrayList<AbstractLanguageSettingsOutputScanner.AbstractOptionParser>(Arrays.asList(includeOptionParsers));
        Collections.addAll(parsers, systemIncludeOptionParsers);
        Collections.addAll(parsers, frameworkOptionParsers);
        Collections.addAll(parsers, forceIncludeOptionParsers);
        Collections.addAll(parsers, defineOptionParsers);
        Collections.addAll(parsers, undefineOptionParsers);
        Collections.addAll(parsers, macrosOptionParsers);
        Collections.addAll(parsers, libraryOptionParsers);
        optionParsers = parsers.toArray(new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[0]);
    }

    @Override
    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    @Override
    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers(String optionToParse) {
        if (optionToParse.length() <= 1) {
            return emptyParsers;
        }
        String optionName = optionToParse.substring(1);
        if (optionName.startsWith("I")) {
            return includeOptionParsers;
        }
        if (optionName.startsWith("D")) {
            return defineOptionParsers;
        }
        if (optionName.startsWith("l") || optionName.startsWith("L")) {
            return libraryOptionParsers;
        }
        if (optionName.startsWith("i")) {
            if (optionName.startsWith("include")) {
                return forceIncludeOptionParsers;
            }
            if (optionName.startsWith("isystem")) {
                return systemIncludeOptionParsers;
            }
            if (optionName.startsWith("imacros")) {
                return macrosOptionParsers;
            }
            if (optionName.startsWith("iframework")) {
                return frameworkOptionParsers;
            }
            return emptyParsers;
        }
        if (optionName.startsWith("F")) {
            return frameworkOptionParsers;
        }
        if (optionName.startsWith("U")) {
            return undefineOptionParsers;
        }
        return emptyParsers;
    }

    public GCCBuildCommandParser cloneShallow() throws CloneNotSupportedException {
        return (GCCBuildCommandParser)super.cloneShallow();
    }

    public GCCBuildCommandParser clone() throws CloneNotSupportedException {
        return (GCCBuildCommandParser)super.clone();
    }

    public static class GCCBuildCommandPatternHighlighter
    extends AbstractBuildCommandParser.AbstractBuildCommandPatternHighlighter {
        private static final String GCC_BUILD_COMMAND_PARSER_EXT = "org.eclipse.cdt.managedbuilder.core.GCCBuildCommandParser";

        public GCCBuildCommandPatternHighlighter() {
            super(GCC_BUILD_COMMAND_PARSER_EXT);
        }

        public Object clone() throws CloneNotSupportedException {
            GCCBuildCommandPatternHighlighter that = new GCCBuildCommandPatternHighlighter();
            that.setId(this.getId());
            that.setName(this.getName());
            RegexErrorPattern[] regexErrorPatternArray = this.getPatterns();
            int n = regexErrorPatternArray.length;
            int n2 = 0;
            while (n2 < n) {
                RegexErrorPattern pattern = regexErrorPatternArray[n2];
                that.addPattern((RegexErrorPattern)pattern.clone());
                ++n2;
            }
            return that;
        }
    }
}

