/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcUnknownResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.TreeAutomizerCEGAR;

public class TreeAutomizerObserver
extends BaseObserver {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final TAPreferences taPrefs;

    public TreeAutomizerObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.taPrefs = new TAPreferences(this.mServices);
    }

    public boolean process(IElement iElement) throws Throwable {
        HornAnnot hornAnnot = HornAnnot.getAnnotation((IElement)iElement);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"HornAnnot as passed to TreeAutomizer:");
            this.mLogger.debug((Object)hornAnnot);
        }
        if (!hornAnnot.getSymbolTable().getSkolemFunctions().isEmpty()) {
            this.mLogger.warn((Object)"Horn clauses contain skolem functions. TreeAutomizer does not support such Horn clauses.");
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new ChcUnknownResult(Activator.PLUGIN_ID, "UNKNOWN: unsupported Skolem functions"));
            return false;
        }
        TreeAutomizerCEGAR treeAutomizerCEGAR = new TreeAutomizerCEGAR(this.mServices, hornAnnot, this.taPrefs, this.mLogger);
        IResult iResult = treeAutomizerCEGAR.iterate();
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
        return false;
    }
}

