/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.graphml;

import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.witnessprinter.ProgramStatePrinter;
import java.util.Objects;

public class GeneratedWitnessEdge<TE, E> {
    private final String mId;
    private final AtomicTraceElement<TE> mATE;
    private final IProgramExecution.ProgramState<E> mState;
    private final IBacktranslationValueProvider<TE, E> mStringProvider;
    private final boolean mIsEnteringLoopHead;

    GeneratedWitnessEdge(AtomicTraceElement<TE> atomicTraceElement, IProgramExecution.ProgramState<E> programState, boolean bl, IBacktranslationValueProvider<TE, E> iBacktranslationValueProvider, long l) {
        assert (iBacktranslationValueProvider != null);
        this.mStringProvider = iBacktranslationValueProvider;
        this.mId = "E" + String.valueOf(l);
        this.mATE = atomicTraceElement;
        this.mState = programState;
        this.mIsEnteringLoopHead = bl;
    }

    public boolean isDummy() {
        return this.mATE == null && this.mState == null;
    }

    public String getName() {
        return this.mId;
    }

    public boolean hasAssumption() {
        return this.mState != null;
    }

    public boolean isInitial() {
        return this.mState != null && this.mATE == null;
    }

    public boolean hasStep() {
        return this.mATE != null;
    }

    public String isEnteringLoopHead() {
        return this.mIsEnteringLoopHead ? "true" : null;
    }

    public String getControl() {
        if (!this.hasStep()) {
            return null;
        }
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) {
            return "condition-false";
        }
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE)) {
            return "condition-true";
        }
        return null;
    }

    public String getStartLineNumber() {
        if (!this.hasStep()) {
            return null;
        }
        return String.valueOf(this.mStringProvider.getStartLineNumberFromStep(this.mATE.getStep()));
    }

    public String getEndLineNumber() {
        if (!this.hasStep()) {
            return null;
        }
        return String.valueOf(this.mStringProvider.getEndLineNumberFromStep(this.mATE.getStep()));
    }

    public String getAssumption() {
        return new ProgramStatePrinter<TE, E>(this.mStringProvider).stateAsExpression(this.mState, ProgramStatePrinter::isValidCVariable);
    }

    public String getEnterFunction() {
        if (!this.hasStep()) {
            return null;
        }
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.PROC_CALL)) {
            return this.mATE.getSucceedingProcedure();
        }
        return null;
    }

    public String getReturnFunction() {
        if (!this.hasStep()) {
            return null;
        }
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.PROC_RETURN)) {
            return this.mATE.getPrecedingProcedure();
        }
        return null;
    }

    public String getSourceCode() {
        boolean bl;
        if (!this.hasStep()) {
            return null;
        }
        String string = this.mStringProvider.getStringFromStep(this.mATE.getStep());
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE) || this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE);
        if (bl) {
            stringBuilder.append("[");
        }
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) {
            stringBuilder.append("!(");
            stringBuilder.append(string);
            stringBuilder.append(")");
        } else {
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public String getOriginFileName() {
        return this.mStringProvider.getFileNameFromStep(this.mATE.getStep());
    }

    public String toString() {
        if (Objects.equals(this.getStartLineNumber(), this.getEndLineNumber())) {
            return "L" + this.getStartLineNumber();
        }
        return "L" + this.getStartLineNumber() + "-L" + this.getEndLineNumber();
    }

    public String getThreadId() {
        if (this.mATE.hasThreadId()) {
            return String.valueOf(this.mATE.getThreadId());
        }
        return null;
    }

    public String getCreatedThreadId() {
        if (this.mATE.hasStepInfo(AtomicTraceElement.StepInfo.FORK)) {
            return String.valueOf(this.mATE.getForkedThreadId());
        }
        return null;
    }
}

