/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractGeneralizedAffineTerm<AVAR>
extends Term
implements IPolynomialTerm {
    protected final Map<AVAR, Rational> mAbstractVariable2Coefficient;
    protected final Rational mConstant;
    protected final Sort mSort;

    public AbstractGeneralizedAffineTerm() {
        super(0);
        this.mAbstractVariable2Coefficient = null;
        this.mConstant = null;
        this.mSort = null;
    }

    protected AbstractGeneralizedAffineTerm(Sort sort, Rational rational2, Map<AVAR, Rational> map) {
        super(0);
        Objects.requireNonNull(sort);
        Objects.requireNonNull(rational2);
        Objects.requireNonNull(map);
        this.mSort = sort;
        this.mConstant = rational2;
        assert (!SmtSortUtils.isBitvecSort(sort) || !rational2.isNegative()) : "Negative constant in BitVec term";
        assert (!SmtSortUtils.isBitvecSort(sort) || AbstractGeneralizedAffineTerm.isTrueForAllCoefficients(map, rational -> !rational.isNegative())) : "Negative coefficient in BitVec term " + String.valueOf(map);
        assert (!SmtSortUtils.isBitvecSort(sort) || rational2.isIntegral()) : "Non-integral constant in BitVec term";
        assert (!SmtSortUtils.isBitvecSort(sort) || AbstractGeneralizedAffineTerm.isTrueForAllCoefficients(map, rational -> rational.isIntegral())) : "Non-integral coefficient in BitVec term " + String.valueOf(map);
        assert (!SmtSortUtils.isIntSort(sort) || rational2.isIntegral()) : "Non-integral constant in Int term";
        assert (!SmtSortUtils.isIntSort(sort) || AbstractGeneralizedAffineTerm.isTrueForAllCoefficients(map, rational -> rational.isIntegral())) : "Non-integral coefficient in Int term " + String.valueOf(map);
        this.mAbstractVariable2Coefficient = map;
    }

    private static boolean isTrueForAllCoefficients(Map<?, Rational> map, Predicate<Rational> predicate) {
        return map.entrySet().stream().allMatch(entry -> predicate.test((Rational)entry.getValue()));
    }

    protected abstract AbstractGeneralizedAffineTerm<?> constructNew(Sort var1, Rational var2, Map<AVAR, Rational> var3);

    private static AffineTerm constructNewSingleVariableTerm(Term term) {
        return new AffineTerm(term.getSort(), Rational.ZERO, Collections.singletonMap(term, Rational.ONE));
    }

    protected abstract AVAR constructAbstractVar(Term var1);

    protected abstract Collection<Term> getFreeVars(AVAR var1);

    @Override
    public boolean isErrorTerm() {
        if (this.mAbstractVariable2Coefficient == null) {
            assert (this.mConstant == null);
            assert (this.mSort == null);
            return true;
        }
        assert (this.mConstant != null);
        assert (this.mSort != null);
        return false;
    }

    public abstract boolean isVariable(Term var1);

    @Override
    public boolean isConstant() {
        return this.mAbstractVariable2Coefficient.isEmpty();
    }

    @Override
    public boolean isZero() {
        return this.mConstant.equals((Object)Rational.ZERO) && this.mAbstractVariable2Coefficient.isEmpty();
    }

    @Override
    public boolean isIntegral() {
        if (!this.getConstant().isIntegral()) {
            return false;
        }
        for (Rational rational : this.getAbstractVariable2Coefficient().values()) {
            if (rational.isIntegral()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Rational getConstant() {
        return this.mConstant;
    }

    public void checkIfTermIsLegalVariable(Term term) {
        if (!(term instanceof TermVariable) && !(term instanceof ApplicationTerm)) {
            throw new IllegalArgumentException("Variable of AffineTerm has to be TermVariable or ApplicationTerm");
        }
    }

    Monomial getExclusiveMonomialOfSubject(Term term) {
        Monomial monomial = null;
        block5: for (AVAR AVAR : this.getAbstractVariable2Coefficient().keySet()) {
            if (AVAR instanceof Monomial) {
                Monomial monomial2 = (Monomial)AVAR;
                switch (monomial2.isExclusiveVariable(term)) {
                    case AS_EXCLUSIVE_VARIABlE: {
                        if (monomial != null) {
                            return null;
                        }
                        monomial = monomial2;
                        continue block5;
                    }
                    case NON_EXCLUSIVE_OR_SUBTERM: {
                        return null;
                    }
                    case NOT: {
                        continue block5;
                    }
                    default: {
                        throw new AssertionError((Object)"illegal value");
                    }
                }
            }
            if (term.equals(AVAR)) {
                if (monomial != null) {
                    return null;
                }
                monomial = new Monomial(term, Rational.ONE);
                continue;
            }
            boolean bl = new SubtermPropertyChecker(term2 -> term2 == term).isSatisfiedBySomeSubterm((Term)AVAR);
            if (!bl) continue;
            return null;
        }
        return monomial;
    }

    public String toString() {
        Map.Entry<AVAR, Rational> entry2;
        if (this.isErrorTerm()) {
            return "auxilliaryErrorTerm";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<AVAR, Rational> entry2 : this.mAbstractVariable2Coefficient.entrySet()) {
            stringBuilder.append(entry2.getValue().isNegative() ? " - " : " + ");
            stringBuilder.append(String.valueOf(((Rational)entry2.getValue()).abs()) + "*" + String.valueOf(entry2.getKey()));
        }
        if (!this.mConstant.equals((Object)Rational.ZERO) || stringBuilder.length() == 0) {
            if (this.mConstant.isNegative() || stringBuilder.length() > 0) {
                stringBuilder.append(this.mConstant.isNegative() ? " - " : " + ");
            }
            stringBuilder.append(this.mConstant.abs());
        }
        if (((String)((Object)(entry2 = stringBuilder.toString()))).charAt(0) == ' ') {
            entry2 = ((String)((Object)entry2)).substring(1);
        }
        return entry2;
    }

    protected abstract Term abstractVariableToTerm(Script var1, AVAR var2);

    protected abstract Term abstractVariableTimesCoeffToTerm(Script var1, AVAR var2, Rational var3);

    @Override
    public Term toTerm(Script script) {
        Term[] termArray = this.mConstant.equals((Object)Rational.ZERO) ? new Term[this.mAbstractVariable2Coefficient.size()] : new Term[this.mAbstractVariable2Coefficient.size() + 1];
        int n = 0;
        for (Map.Entry<AVAR, Rational> term2 : this.mAbstractVariable2Coefficient.entrySet()) {
            assert (!term2.getValue().equals((Object)Rational.ZERO)) : "zero is no legal coefficient in AffineTerm";
            termArray[n] = term2.getValue().equals((Object)Rational.ONE) ? this.abstractVariableToTerm(script, term2.getKey()) : this.abstractVariableTimesCoeffToTerm(script, term2.getKey(), term2.getValue());
            ++n;
        }
        if (!this.mConstant.equals((Object)Rational.ZERO)) {
            assert (this.mConstant.isIntegral() || SmtSortUtils.isRealSort(this.mSort));
            termArray[n] = SmtUtils.rational2Term(script, this.mConstant, this.mSort);
        }
        Term term = SmtUtils.sum(script, this.mSort, termArray);
        return term;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    Map<AVAR, Rational> getAbstractVariable2Coefficient() {
        return Collections.unmodifiableMap(this.mAbstractVariable2Coefficient);
    }

    public Map<Term, Rational> getAbstractVariableAsTerm2Coefficient(Script script) {
        HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            hashMap.put(this.abstractVariableToTerm(script, entry.getKey()), entry.getValue());
        }
        return hashMap;
    }

    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        throw new UnsupportedOperationException("This is an auxilliary Term and not supported by the solver");
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mConstant == null ? 0 : this.mConstant.hashCode());
        n = 31 * n + (this.mSort == null ? 0 : this.mSort.hashCode());
        n = 31 * n + (this.mAbstractVariable2Coefficient == null ? 0 : this.mAbstractVariable2Coefficient.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractGeneralizedAffineTerm abstractGeneralizedAffineTerm = (AbstractGeneralizedAffineTerm)object;
        if (this.mConstant == null ? abstractGeneralizedAffineTerm.mConstant != null : !this.mConstant.equals((Object)abstractGeneralizedAffineTerm.mConstant)) {
            return false;
        }
        if (this.mSort == null ? abstractGeneralizedAffineTerm.mSort != null : !this.mSort.equals(abstractGeneralizedAffineTerm.mSort)) {
            return false;
        }
        return !(this.mAbstractVariable2Coefficient == null ? abstractGeneralizedAffineTerm.mAbstractVariable2Coefficient != null : !this.mAbstractVariable2Coefficient.equals(abstractGeneralizedAffineTerm.mAbstractVariable2Coefficient));
    }

    protected abstract Pair<Rational, Rational> computeMinMax();

    protected Rational checkForModTerm(Term term) {
        ApplicationTerm applicationTerm = SmtUtils.getFunctionApplication(term, "mod");
        if (applicationTerm == null) {
            return null;
        }
        Term term2 = applicationTerm.getParameters()[1];
        Rational rational = SmtUtils.tryToConvertToLiteral(term2);
        if (rational == null) {
            return null;
        }
        return rational.abs();
    }

    public abstract AbstractGeneralizedAffineTerm<?> removeAndNegate(Monomial var1);

    private ApplicationTerm isDivision(String string) {
        Term term;
        Monomial monomial;
        if (!this.mConstant.equals((Object)Rational.ZERO)) {
            return null;
        }
        if (this.mAbstractVariable2Coefficient.size() != 1) {
            return null;
        }
        Map.Entry<AVAR, Rational> entry = this.mAbstractVariable2Coefficient.entrySet().iterator().next();
        if (!entry.getValue().equals((Object)Rational.ONE)) {
            return null;
        }
        AVAR AVAR = entry.getKey();
        if (AVAR instanceof Monomial) {
            monomial = (Monomial)AVAR;
            term = monomial.getSingleVariable();
        } else if (AVAR instanceof Term) {
            term = (Term)AVAR;
        } else {
            throw new AssertionError();
        }
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        monomial = (ApplicationTerm)term;
        if (!monomial.getFunction().getApplicationString().equals(string)) {
            return null;
        }
        return monomial;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IPolynomialTerm div(Script script, IPolynomialTerm ... iPolynomialTermArray) {
        void var3_4;
        AbstractGeneralizedAffineTerm abstractGeneralizedAffineTerm = this;
        IPolynomialTerm[] iPolynomialTermArray2 = iPolynomialTermArray;
        int n = iPolynomialTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPolynomialTerm iPolynomialTerm = iPolynomialTermArray2[n2];
            if (iPolynomialTerm.isConstant()) {
                if (SmtSortUtils.isIntSort(this.mSort)) {
                    AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm2 = var3_4.divInt(script, iPolynomialTerm.getConstant().numerator(), Collections.emptySet());
                } else {
                    if (SmtSortUtils.isBitvecSort(this.mSort)) {
                        throw new UnsupportedOperationException("Cannot apply div (meant for integers) to term whose sort is bitvector.");
                    }
                    if (!SmtSortUtils.isRealSort(this.mSort)) throw new UnsupportedOperationException();
                    AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm3 = var3_4.divReal(script, iPolynomialTerm.getConstant());
                }
            } else {
                String string = AbstractGeneralizedAffineTerm.getDivisionFuncname(this.getSort());
                AffineTerm affineTerm = AbstractGeneralizedAffineTerm.constructDivResultForNonSimplifiableCase(script, string, (IPolynomialTerm)var3_4, iPolynomialTerm.toTerm(script));
            }
            ++n2;
        }
        return var3_4;
    }

    public static String getDivisionFuncname(Sort sort) {
        String string;
        if (SmtSortUtils.isIntSort(sort)) {
            string = "div";
        } else {
            if (SmtSortUtils.isBitvecSort(sort)) {
                throw new UnsupportedOperationException();
            }
            if (SmtSortUtils.isRealSort(sort)) {
                string = "/";
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return string;
    }

    private static AffineTerm constructDivResultForNonSimplifiableCase(Script script, String string, IPolynomialTerm iPolynomialTerm, Term term) {
        return AbstractGeneralizedAffineTerm.constructNewSingleVariableTerm(SmtUtils.flattenIntoFirstArgument(script, string, iPolynomialTerm.toTerm(script), term));
    }

    /*
     * WARNING - void declaration
     */
    public AbstractGeneralizedAffineTerm<?> divInt(Script script, BigInteger bigInteger, Set<TermVariable> set) {
        void var7_13;
        Object object;
        Pair<Rational, Term> pair;
        if (!SmtSortUtils.isIntSort(this.getSort())) {
            throw new AssertionError((Object)"only for int");
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            return AbstractGeneralizedAffineTerm.constructDivResultForNonSimplifiableCase(script, "div", this, SmtUtils.constructIntegerValue(script, this.getSort(), bigInteger));
        }
        HashMap<Object, Rational> hashMap = new HashMap<Object, Rational>();
        HashMap<AVAR, Rational> hashMap2 = new HashMap<AVAR, Rational>();
        Rational rational2 = AbstractGeneralizedAffineTerm.toRational(bigInteger);
        for (Map.Entry<AVAR, Rational> rational3 : this.getAbstractVariable2Coefficient().entrySet()) {
            pair = rational3.getValue().div(rational2);
            if (pair.isIntegral()) {
                object = this.euclideanDivision(rational3.getValue(), bigInteger);
                hashMap.put(rational3.getKey(), (Rational)object);
                continue;
            }
            if (this.getFreeVars(rational3.getKey()).stream().anyMatch(set::contains)) {
                return null;
            }
            hashMap2.put(rational3.getKey(), rational3.getValue());
        }
        if (hashMap2.isEmpty()) {
            Rational rational = this.euclideanDivision(this.getConstant(), bigInteger);
        } else {
            Rational rational4;
            if (this.getConstant().div(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE)).isIntegral()) {
                Rational rational = this.euclideanDivision(this.getConstant(), bigInteger);
                rational4 = Rational.ZERO;
            } else {
                Rational rational = Rational.ZERO;
                rational4 = this.getConstant();
            }
            pair = this.divIntHelper(script, hashMap2, rational4, rational2);
            object = this.constructAbstractVar((Term)pair.getSecond());
            Rational rational = (Rational)hashMap.get(object);
            if (rational == null) {
                hashMap.put(object, (Rational)pair.getFirst());
            } else {
                Rational rational3 = rational.add((Rational)pair.getFirst());
                if (rational3.equals((Object)Rational.ZERO)) {
                    hashMap.remove(object);
                } else {
                    hashMap.put(object, rational3);
                }
            }
        }
        return this.constructNew(this.getSort(), (Rational)var7_13, hashMap);
    }

    private Pair<Rational, Term> divIntHelper(Script script, Map<AVAR, Rational> map, Rational rational, Rational rational2) {
        IPolynomialTerm iPolynomialTerm = this.constructNew(this.getSort(), rational, map);
        Rational rational3 = iPolynomialTerm.computeGcdOfCoefficientsAndConstant().gcd(rational2).abs();
        if (!rational3.equals((Object)Rational.ONE)) {
            iPolynomialTerm = iPolynomialTerm.divInvertible(rational3);
        }
        Term term = iPolynomialTerm.toTerm(script);
        Rational rational4 = rational2.div(rational3).abs();
        assert (rational4.isIntegral());
        Term term2 = SmtUtils.divIntFlatten(script, term, rational4.numerator());
        Rational rational5 = rational2.isNegative() ? Rational.MONE : Rational.ONE;
        return new Pair((Object)rational5, (Object)term2);
    }

    public AbstractGeneralizedAffineTerm<?> divReal(Script script, Rational rational) {
        if (!SmtSortUtils.isRealSort(this.getSort())) {
            throw new AssertionError((Object)"only for Real");
        }
        if (rational.equals((Object)Rational.ZERO)) {
            return AbstractGeneralizedAffineTerm.constructDivResultForNonSimplifiableCase(script, "/", this, rational.toTerm(this.getSort()));
        }
        return (AbstractGeneralizedAffineTerm)this.mul(rational.inverse());
    }

    protected Rational euclideanDivision(Rational rational, BigInteger bigInteger) {
        if (!rational.isIntegral()) {
            throw new AssertionError();
        }
        return AbstractGeneralizedAffineTerm.toRational(ArithmeticUtils.euclideanDiv((BigInteger)rational.numerator(), (BigInteger)bigInteger));
    }

    private static Rational toRational(BigInteger bigInteger) {
        return Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
    }

    @Override
    public abstract AbstractGeneralizedAffineTerm<?> divInvertible(Rational var1);

    @Override
    public IPolynomialTerm mod(Script script, IPolynomialTerm iPolynomialTerm) {
        if (iPolynomialTerm.isConstant()) {
            return this.mod(script, iPolynomialTerm.getConstant().numerator());
        }
        return AbstractGeneralizedAffineTerm.constructNewSingleVariableTerm(script.term("mod", new Term[]{this.toTerm(script), iPolynomialTerm.toTerm(script)}));
    }

    public IPolynomialTerm mod(Script script, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            Term term = script.term("mod", new Term[]{this.toTerm(script), SmtUtils.constructIntegerValue(script, this.getSort(), bigInteger)});
            return AbstractGeneralizedAffineTerm.constructNewSingleVariableTerm(term);
        }
        Map<AVAR, Rational> map = this.modPreprocessMap(script, bigInteger.abs());
        Rational rational = SmtUtils.toRational(ArithmeticUtils.euclideanMod((BigInteger)SmtUtils.toInt(this.getConstant()), (BigInteger)bigInteger.abs()));
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm = this.constructNew(this.getSort(), rational, map);
        if (map.isEmpty()) {
            return abstractGeneralizedAffineTerm;
        }
        Pair<Rational, Rational> pair = abstractGeneralizedAffineTerm.computeMinMax();
        if (pair != null && !((Rational)pair.getFirst()).isNegative() && ((Rational)pair.getSecond()).compareTo(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE)) < 0) {
            return abstractGeneralizedAffineTerm;
        }
        Rational rational2 = AbstractGeneralizedAffineTerm.computeGcdOfValues(map).gcd(rational).gcd(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE));
        assert (!rational2.isNegative() && !rational2.equals((Object)Rational.ZERO));
        if (rational2.equals((Object)Rational.ONE)) {
            Term term = script.term("mod", new Term[]{abstractGeneralizedAffineTerm.toTerm(script), SmtUtils.constructIntegerValue(script, this.getSort(), bigInteger.abs())});
            return AbstractGeneralizedAffineTerm.constructNewSingleVariableTerm(term);
        }
        IPolynomialTerm iPolynomialTerm = abstractGeneralizedAffineTerm.divInvertible(rational2);
        BigInteger bigInteger2 = bigInteger.abs().divide(rational2.numerator());
        IPolynomialTerm iPolynomialTerm2 = ((AbstractGeneralizedAffineTerm)iPolynomialTerm).mod(script, bigInteger2);
        return iPolynomialTerm2.mul(rational2);
    }

    private Map<AVAR, Rational> modPreprocessMap(Script script, BigInteger bigInteger) {
        assert (bigInteger.compareTo(BigInteger.ZERO) > 0) : "Divisor must be positive";
        SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
        for (Map.Entry<AVAR, Rational> entry : this.mAbstractVariable2Coefficient.entrySet()) {
            Rational rational = SmtUtils.toRational(ArithmeticUtils.euclideanMod((BigInteger)SmtUtils.toInt(entry.getValue()), (BigInteger)bigInteger));
            if (rational.equals((Object)Rational.ZERO)) continue;
            AVAR AVAR = this.constructAbstractVarForModulo(script, entry.getKey(), bigInteger);
            if (sparseMapBuilder.containsKey(AVAR)) {
                Rational rational2 = (Rational)sparseMapBuilder.get(AVAR);
                Rational rational3 = rational2.add(entry.getValue());
                Rational rational4 = SmtUtils.toRational(ArithmeticUtils.euclideanMod((BigInteger)SmtUtils.toInt(rational3), (BigInteger)bigInteger));
                if (rational4.equals((Object)Rational.ZERO)) {
                    sparseMapBuilder.remove(AVAR);
                    continue;
                }
                sparseMapBuilder.put(AVAR, (Object)rational4);
                continue;
            }
            sparseMapBuilder.put(AVAR, (Object)rational);
        }
        return sparseMapBuilder.getBuiltMap();
    }

    private AVAR constructAbstractVarForModulo(Script script, AVAR AVAR, BigInteger bigInteger) {
        ApplicationTerm applicationTerm = SmtUtils.getFunctionApplication(this.abstractVariableToTerm(script, AVAR), "mod");
        if (applicationTerm == null) {
            return AVAR;
        }
        assert (applicationTerm.getParameters().length == 2);
        Term term = applicationTerm.getParameters()[1];
        Rational rational = SmtUtils.tryToConvertToLiteral(term);
        if (rational == null) {
            return AVAR;
        }
        if (rational.div(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE)).isIntegral()) {
            Term term2 = applicationTerm.getParameters()[0];
            return this.constructAbstractVar(term2);
        }
        return AVAR;
    }

    @Override
    public abstract AbstractGeneralizedAffineTerm<AVAR> add(Rational var1);

    @Override
    public Equivalence compare(IPolynomialTerm iPolynomialTerm) {
        Equivalence equivalence;
        if (iPolynomialTerm instanceof AbstractGeneralizedAffineTerm) {
            AbstractGeneralizedAffineTerm abstractGeneralizedAffineTerm = (AbstractGeneralizedAffineTerm)iPolynomialTerm;
            equivalence = this.getAbstractVariable2Coefficient().equals(abstractGeneralizedAffineTerm.getAbstractVariable2Coefficient()) ? (this.getConstant().equals((Object)abstractGeneralizedAffineTerm.getConstant()) ? Equivalence.EQUALS : Equivalence.DISTINCT) : Equivalence.INCOMPARABLE;
        } else {
            equivalence = Equivalence.INCOMPARABLE;
        }
        return equivalence;
    }

    public static ComparisonResult compareRepresentation(PolynomialRelation polynomialRelation, PolynomialRelation polynomialRelation2) {
        Rational rational;
        Rational rational2;
        RelationSymbol relationSymbol;
        RelationSymbol relationSymbol2;
        if (!polynomialRelation.getPolynomialTerm().getSort().equals(polynomialRelation2.getPolynomialTerm().getSort())) {
            throw new AssertionError((Object)"Cannot compare polynomials of different sorts");
        }
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm = polynomialRelation.getPolynomialTerm();
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm2 = polynomialRelation2.getPolynomialTerm();
        if (!abstractGeneralizedAffineTerm.getAbstractVariable2Coefficient().equals(abstractGeneralizedAffineTerm2.getAbstractVariable2Coefficient())) {
            throw new AssertionError((Object)"incomparable");
        }
        if (SmtSortUtils.isIntSort(polynomialRelation.getPolynomialTerm().getSort())) {
            relationSymbol2 = polynomialRelation.getRelationSymbol().getCorrespondingNonStrictRelationSymbol();
            relationSymbol = polynomialRelation2.getRelationSymbol().getCorrespondingNonStrictRelationSymbol();
            rational2 = polynomialRelation.getPolynomialTerm().getConstant().add(polynomialRelation.getRelationSymbol().getOffsetForStrictToNonstrictTransformation());
            rational = polynomialRelation2.getPolynomialTerm().getConstant().add(polynomialRelation2.getRelationSymbol().getOffsetForStrictToNonstrictTransformation());
        } else {
            relationSymbol2 = polynomialRelation.getRelationSymbol();
            relationSymbol = polynomialRelation2.getRelationSymbol();
            rational2 = polynomialRelation.getPolynomialTerm().getConstant();
            rational = polynomialRelation2.getPolynomialTerm().getConstant();
        }
        ComparisonResult comparisonResult = AbstractGeneralizedAffineTerm.compare(relationSymbol2, relationSymbol, rational2, rational);
        assert (AbstractGeneralizedAffineTerm.doubleCheck(relationSymbol2, relationSymbol, rational2, rational, comparisonResult)) : "double check failed";
        return comparisonResult;
    }

    private static boolean doubleCheck(RelationSymbol relationSymbol, RelationSymbol relationSymbol2, Rational rational, Rational rational2, ComparisonResult comparisonResult) {
        ComparisonResult comparisonResult2 = AbstractGeneralizedAffineTerm.compare(relationSymbol2, relationSymbol, rational2, rational);
        if (comparisonResult == null) {
            return comparisonResult2 == null;
        }
        return comparisonResult.switchDirection().equals((Object)comparisonResult2);
    }

    private static ComparisonResult compare(RelationSymbol relationSymbol, RelationSymbol relationSymbol2, Rational rational, Rational rational2) throws AssertionError {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> AbstractGeneralizedAffineTerm.compareDistinct(rational, relationSymbol2, rational2);
            case RelationSymbol.EQ -> AbstractGeneralizedAffineTerm.compareEq(rational, relationSymbol2, rational2);
            case RelationSymbol.GEQ -> AbstractGeneralizedAffineTerm.compareGeq(rational, relationSymbol2, rational2);
            case RelationSymbol.GREATER -> AbstractGeneralizedAffineTerm.compareGreater(rational, relationSymbol2, rational2);
            case RelationSymbol.LEQ -> AbstractGeneralizedAffineTerm.compareLeq(rational, relationSymbol2, rational2);
            case RelationSymbol.LESS -> AbstractGeneralizedAffineTerm.compareLess(rational, relationSymbol2, rational2);
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareDistinct(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield null;
            }
            case RelationSymbol.EQ -> {
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.EXPLIES;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield null;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield null;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield null;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield null;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareEq(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.EQ -> {
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield ComparisonResult.INCONSISTENT;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareGeq(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.IMPLIES;
                }
                yield null;
            }
            case RelationSymbol.EQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.EXPLIES;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.EXPLIES;
                }
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareGreater(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.IMPLIES;
                }
                yield null;
            }
            case RelationSymbol.EQ -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.EXPLIES;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.EXPLIES;
                }
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareLeq(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.IMPLIES;
                }
                yield null;
            }
            case RelationSymbol.EQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.EXPLIES;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) > 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.EXPLIES;
                }
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) <= 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield ComparisonResult.IMPLIES;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static ComparisonResult compareLess(Rational rational, RelationSymbol relationSymbol, Rational rational2) {
        return switch (relationSymbol) {
            case RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> throw new AssertionError((Object)"not in PolynomialRelation");
            case RelationSymbol.DISTINCT -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.IMPLIES;
                }
                yield null;
            }
            case RelationSymbol.EQ -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield ComparisonResult.EXPLIES;
            }
            case RelationSymbol.GEQ -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.GREATER -> {
                if (rational.compareTo(rational2) >= 0) {
                    yield ComparisonResult.INCONSISTENT;
                }
                yield null;
            }
            case RelationSymbol.LEQ -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.EXPLIES;
                }
                yield ComparisonResult.IMPLIES;
            }
            case RelationSymbol.LESS -> {
                if (rational.compareTo(rational2) < 0) {
                    yield ComparisonResult.EXPLIES;
                }
                if (rational.equals((Object)rational2)) {
                    yield ComparisonResult.EQUIVALENT;
                }
                yield ComparisonResult.IMPLIES;
            }
            default -> throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)relationSymbol)));
        };
    }

    public static boolean areRepresentationsFusible(SmtUtils.Junction junction, PolynomialRelation polynomialRelation, PolynomialRelation polynomialRelation2) {
        Rational rational;
        Rational rational2;
        RelationSymbol relationSymbol;
        RelationSymbol relationSymbol2;
        if (!polynomialRelation.getPolynomialTerm().getSort().equals(polynomialRelation2.getPolynomialTerm().getSort())) {
            throw new AssertionError((Object)"Cannot compare polynomials of different sorts");
        }
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm = polynomialRelation.getPolynomialTerm();
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm2 = polynomialRelation2.getPolynomialTerm();
        if (!abstractGeneralizedAffineTerm.getAbstractVariable2Coefficient().equals(abstractGeneralizedAffineTerm2.getAbstractVariable2Coefficient())) {
            throw new AssertionError((Object)"incomparable");
        }
        if (!polynomialRelation.getRelationSymbol().isConvexInequality() && !polynomialRelation2.getRelationSymbol().isConvexInequality()) {
            return false;
        }
        if (SmtSortUtils.isIntSort(polynomialRelation.getPolynomialTerm().getSort())) {
            relationSymbol2 = polynomialRelation.getRelationSymbol().getCorrespondingNonStrictRelationSymbol();
            relationSymbol = polynomialRelation2.getRelationSymbol().getCorrespondingNonStrictRelationSymbol();
            rational2 = polynomialRelation.getPolynomialTerm().getConstant().add(polynomialRelation.getRelationSymbol().getOffsetForStrictToNonstrictTransformation());
            rational = polynomialRelation2.getPolynomialTerm().getConstant().add(polynomialRelation2.getRelationSymbol().getOffsetForStrictToNonstrictTransformation());
        } else {
            relationSymbol2 = polynomialRelation.getRelationSymbol();
            relationSymbol = polynomialRelation2.getRelationSymbol();
            rational2 = polynomialRelation.getPolynomialTerm().getConstant();
            rational = polynomialRelation2.getPolynomialTerm().getConstant();
        }
        return AbstractGeneralizedAffineTerm.areRepresentationsFusibleHelper(junction, relationSymbol2, relationSymbol, rational2, rational);
    }

    private static boolean areRepresentationsFusibleHelper(SmtUtils.Junction junction, RelationSymbol relationSymbol, RelationSymbol relationSymbol2, Rational rational, Rational rational2) {
        if (!relationSymbol.isConvexInequality() || !relationSymbol2.isConvexInequality()) {
            return false;
        }
        switch (junction) {
            case AND: {
                return (relationSymbol.equals((Object)RelationSymbol.LEQ) && relationSymbol2.equals((Object)RelationSymbol.GEQ) || relationSymbol.equals((Object)RelationSymbol.GEQ) && relationSymbol2.equals((Object)RelationSymbol.LEQ)) && rational2.equals((Object)rational);
            }
            case OR: {
                return (relationSymbol.equals((Object)RelationSymbol.LESS) && relationSymbol2.equals((Object)RelationSymbol.GREATER) || relationSymbol.equals((Object)RelationSymbol.GREATER) && relationSymbol2.equals((Object)RelationSymbol.LESS)) && rational2.equals((Object)rational);
            }
        }
        throw new AssertionError();
    }

    @Override
    public Rational computeGcdOfCoefficients() {
        Map<AVAR, Rational> map = this.mAbstractVariable2Coefficient;
        return AbstractGeneralizedAffineTerm.computeGcdOfValues(map);
    }

    public Rational computeGcdOfCoefficientsAndConstant() {
        return this.computeGcdOfCoefficients().gcd(this.getConstant());
    }

    private static Rational computeGcdOfValues(Map<?, Rational> map) {
        Rational rational = Rational.ZERO;
        for (Map.Entry<?, Rational> entry : map.entrySet()) {
            rational = rational.gcd(entry.getValue());
        }
        return rational;
    }

    public TermVariable[] getFreeVars() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public Theory getTheory() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public String toStringDirect() {
        throw new UnsupportedOperationException("AbstractGeneralizedAffineTerm is not a proper Term of our SMT library");
    }

    public static enum ComparisonResult {
        INCONSISTENT,
        IMPLIES,
        EXPLIES,
        EQUIVALENT;


        public ComparisonResult switchDirection() {
            return switch (this) {
                case EQUIVALENT -> this;
                case EXPLIES -> IMPLIES;
                case IMPLIES -> EXPLIES;
                case INCONSISTENT -> this;
                default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this)));
            };
        }
    }

    public static enum Equivalence {
        EQUALS,
        DISTINCT,
        INCOMPARABLE;

    }
}

