/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.bitvector;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import java.math.BigInteger;
import java.util.ArrayList;

public class BvUtils {
    private final Theory mTheory;
    private final LogicSimplifier mUtils;

    public BvUtils(Theory theory, LogicSimplifier logicSimplifier) {
        this.mTheory = theory;
        this.mUtils = logicSimplifier;
    }

    public boolean isConstRelation(Term term, Term term2) {
        return this.isConstant(term) && this.isConstant(term2);
    }

    public boolean isConstant(Term term) {
        return term instanceof ConstantTerm;
    }

    public BigInteger parseBitvectorConstant(Term term) {
        if (!(term instanceof ConstantTerm)) {
            throw new UnsupportedOperationException("Can't convert to bitstring: " + String.valueOf(term));
        }
        ConstantTerm constantTerm = (ConstantTerm)term;
        assert (constantTerm.getSort().isBitVecSort());
        if (constantTerm.getValue() instanceof String) {
            String string = (String)constantTerm.getValue();
            if (string.startsWith("#b")) {
                string = (String)constantTerm.getValue();
                return new BigInteger(string.substring(2), 2);
            }
            if (string.startsWith("#x")) {
                return new BigInteger(string.substring(2), 16);
            }
            throw new AssertionError((Object)("Unexpected bitvector constant: " + string));
        }
        return (BigInteger)constantTerm.getValue();
    }

    public Term getBvConstAsBinaryConst(FunctionSymbol functionSymbol, Sort sort) {
        if (sort.isBitVecSort()) {
            String string = functionSymbol.getName();
            assert (string.matches("bv\\d+"));
            Object object = new BigInteger(string.substring(2)).toString(2);
            int n = Integer.valueOf(sort.getIndices()[0]);
            if (((String)object).length() > n) {
                int n2 = ((String)object).length() - n;
                object = ((String)object).substring(n2);
            } else {
                String string2 = new String(new char[n - ((String)object).length()]).replace("\u0000", "0");
                object = string2 + (String)object;
            }
            Term term = this.mTheory.binary("#b" + (String)object);
            assert (term.getSort().equals(sort));
            return this.mTheory.binary("#b" + (String)object);
        }
        throw new UnsupportedOperationException("Can't convert bv constant: " + functionSymbol.getName());
    }

    private Term eliminateConcatPerfectMatch(FunctionSymbol functionSymbol, Term term, Term term2) {
        assert (functionSymbol.getName().equals("="));
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (!(term instanceof ApplicationTerm) || !(term2 instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
        if (!applicationTerm.getFunction().getName().equals("concat") || !applicationTerm2.getFunction().getName().equals("concat")) {
            return null;
        }
        if (!applicationTerm.getParameters()[0].getSort().getIndices().equals(applicationTerm2.getParameters()[0].getSort().getIndices())) {
            return null;
        }
        Term[] termArray = this.mTheory.term("=", new Term[]{applicationTerm.getParameters()[0], applicationTerm2.getParameters()[0]});
        Term term3 = this.mTheory.term("=", new Term[]{applicationTerm.getParameters()[1], applicationTerm2.getParameters()[1]});
        arrayList.add(this.simplifyBinaryBitVecEquality((Term)termArray));
        arrayList.add(this.simplifyBinaryBitVecEquality(term3));
        termArray = new Term[arrayList.size()];
        termArray = arrayList.toArray(termArray);
        return this.mTheory.and(termArray);
    }

    private Term eliminateConcatNoMatch(FunctionSymbol functionSymbol, Term term, Term term2) {
        assert (functionSymbol.getName().equals("="));
        assert (term.getSort().isBitVecSort());
        assert (term2.getSort().isBitVecSort());
        ApplicationTerm applicationTerm = null;
        Term term3 = null;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("concat")) {
            applicationTerm = (ApplicationTerm)term;
            term3 = term2;
        }
        if (term2 instanceof ApplicationTerm && ((ApplicationTerm)term2).getFunction().getName().equals("concat") && term3 == null) {
            applicationTerm = (ApplicationTerm)term2;
            term3 = term;
        }
        if (applicationTerm == null || term3 == null) {
            return null;
        }
        String[] stringArray = new String[]{String.valueOf(Integer.parseInt(applicationTerm.getParameters()[1].getSort().getIndices()[0]) - 1), "0"};
        FunctionSymbol functionSymbol2 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{term3.getSort()});
        Term term4 = this.propagateExtract(functionSymbol2, term3);
        String[] stringArray2 = new String[]{String.valueOf(Integer.parseInt(term3.getSort().getIndices()[0]) - 1), String.valueOf(Integer.parseInt(term3.getSort().getIndices()[0]) - Integer.parseInt(applicationTerm.getParameters()[0].getSort().getIndices()[0]))};
        FunctionSymbol functionSymbol3 = this.mTheory.getFunctionWithResult("extract", stringArray2, null, new Sort[]{term3.getSort()});
        Term term5 = this.propagateExtract(functionSymbol3, term3);
        Term term6 = this.mTheory.term("=", new Term[]{applicationTerm.getParameters()[0], term5});
        Term term7 = this.mTheory.term("=", new Term[]{applicationTerm.getParameters()[1], term4});
        return this.mTheory.and(new Term[]{this.simplifyBinaryBitVecEquality(term6), this.simplifyBinaryBitVecEquality(term7)});
    }

    public Term simplifyBitvectorConstantOp(FunctionSymbol functionSymbol, Term term, Term term2) {
        BigInteger bigInteger = this.parseBitvectorConstant(term);
        BigInteger bigInteger2 = this.parseBitvectorConstant(term2);
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
        assert (functionSymbol.isIntern());
        return this.mTheory.constant((Object)(switch (functionSymbol.getName()) {
            case "bvadd" -> bigInteger.add(bigInteger2).and(bigInteger3);
            case "bvudiv" -> bigInteger2.signum() == 0 ? bigInteger3 : bigInteger.divide(bigInteger2);
            case "bvurem" -> bigInteger2.signum() == 0 ? bigInteger : bigInteger.mod(bigInteger2);
            case "bvmul" -> bigInteger.multiply(bigInteger2).and(bigInteger3);
            case "bvsub" -> bigInteger.subtract(bigInteger2).and(bigInteger3);
            case "bvand" -> bigInteger.and(bigInteger2);
            case "bvor" -> bigInteger.or(bigInteger2);
            case "bvxor" -> bigInteger.xor(bigInteger2);
            case "bvnand" -> bigInteger.and(bigInteger2).xor(bigInteger3);
            case "bvnor" -> bigInteger.or(bigInteger2).xor(bigInteger3);
            case "bvxnor" -> bigInteger.xor(bigInteger2).xor(bigInteger3);
            default -> throw new UnsupportedOperationException("unknown function symbol: " + functionSymbol.getName());
        }), functionSymbol.getReturnSort());
    }

    public Term simplifyConcatConst(FunctionSymbol functionSymbol, Term term, Term term2) {
        assert (functionSymbol.getName().equals("concat"));
        int n = Integer.valueOf(term2.getSort().getIndices()[0]);
        BigInteger bigInteger = this.parseBitvectorConstant(term).shiftLeft(n).or(this.parseBitvectorConstant(term2));
        return this.mTheory.constant((Object)bigInteger, functionSymbol.getReturnSort());
    }

    public Term simplifyShiftConst(FunctionSymbol functionSymbol, Term term, Term term2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.parseBitvectorConstant(term);
        BigInteger bigInteger3 = this.parseBitvectorConstant(term2);
        int n = Integer.parseInt(term.getSort().getIndices()[0]);
        if (functionSymbol.getName().equals("bvshl")) {
            if (BigInteger.valueOf(n).compareTo(bigInteger3) <= 0) {
                bigInteger = BigInteger.ZERO;
            } else {
                BigInteger bigInteger4 = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
                bigInteger = bigInteger2.shiftLeft(bigInteger3.intValueExact()).and(bigInteger4);
            }
        } else if (functionSymbol.getName().equals("bvlshr")) {
            bigInteger = BigInteger.valueOf(n).compareTo(bigInteger3) <= 0 ? BigInteger.ZERO : bigInteger2.shiftRight(bigInteger3.intValueExact());
        } else {
            throw new UnsupportedOperationException("unknown function symbol: " + functionSymbol.getName());
        }
        return this.mTheory.constant((Object)bigInteger, functionSymbol.getReturnSort());
    }

    public Term simplifyNegConst(FunctionSymbol functionSymbol, Term term) {
        assert (functionSymbol.getName().equals("bvneg"));
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        BigInteger bigInteger = this.parseBitvectorConstant(term);
        if (bigInteger.equals(BigInteger.ZERO)) {
            return term;
        }
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n).subtract(bigInteger);
        return this.mTheory.constant((Object)bigInteger2, functionSymbol.getReturnSort());
    }

    public Term simplifyNotConst(FunctionSymbol functionSymbol, Term term) {
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        BigInteger bigInteger = this.parseBitvectorConstant(term);
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE).subtract(bigInteger);
        return this.mTheory.constant((Object)bigInteger2, functionSymbol.getReturnSort());
    }

    public Term simplifySelectConst(FunctionSymbol functionSymbol, Term term) {
        assert (functionSymbol.getName().equals("extract"));
        BigInteger bigInteger = this.parseBitvectorConstant(term);
        int n = Integer.parseInt(functionSymbol.getIndices()[1]);
        int n2 = Integer.parseInt(functionSymbol.getIndices()[0]);
        BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n - n2 + 1).subtract(BigInteger.ONE);
        BigInteger bigInteger3 = bigInteger.shiftLeft(n2).and(bigInteger2);
        return this.mTheory.constant((Object)bigInteger3, functionSymbol.getReturnSort());
    }

    public Term simplifyBvultConst(FunctionSymbol functionSymbol, Term term, Term term2) {
        BigInteger bigInteger;
        if (functionSymbol != null) assert (functionSymbol.getName().equals("bvult"));
        BigInteger bigInteger2 = this.parseBitvectorConstant(term);
        return bigInteger2.compareTo(bigInteger = this.parseBitvectorConstant(term2)) <= 0 ? this.mTheory.mTrue : this.mTheory.mFalse;
    }

    public Term simplifyBvslXConst(FunctionSymbol functionSymbol, Term term, Term term2) {
        assert (functionSymbol.getName().equals("bvslt") || functionSymbol.getName().equals("bvsle"));
        BigInteger bigInteger = this.parseBitvectorConstant(term);
        BigInteger bigInteger2 = this.parseBitvectorConstant(term2);
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(n - 1);
        int n2 = bigInteger.xor(bigInteger3).compareTo(bigInteger2.xor(bigInteger3));
        if (functionSymbol.getName().equals("bvslt") ? n2 < 0 : n2 <= 0) {
            return this.mTheory.mTrue;
        }
        return this.mTheory.mFalse;
    }

    public Term getProof(Term term, Term term2, IProofTracker iProofTracker, Annotation annotation) {
        Term term3 = iProofTracker.getProvedTerm(term2);
        Term term4 = iProofTracker.buildRewrite(term3, term, annotation);
        return iProofTracker.intern(term2, term4);
    }

    public Term getBvultTerm(Term term) {
        block41: {
            ApplicationTerm applicationTerm;
            if (term instanceof ApplicationTerm) {
                applicationTerm = (ApplicationTerm)term;
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                applicationTerm = (ApplicationTerm)annotatedTerm.getSubterm();
            } else {
                throw new UnsupportedOperationException("Not an Inequality");
            }
            assert (applicationTerm.getParameters().length == 2);
            int n = Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]);
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            Theory theory = term.getTheory();
            String[] stringArray = new String[2];
            int n2 = n - 1;
            stringArray[0] = String.valueOf(n2);
            stringArray[1] = String.valueOf(n2);
            FunctionSymbol functionSymbol2 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
            if (!functionSymbol.isIntern()) break block41;
            switch (functionSymbol.getName()) {
                case "bvult": {
                    if (applicationTerm.getParameters()[0].equals(applicationTerm.getParameters()[1])) {
                        return this.mTheory.mFalse;
                    }
                    if (this.isConstRelation(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1])) {
                        return this.simplifyBvultConst(applicationTerm.getFunction(), applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
                    }
                    return applicationTerm;
                }
                case "bvslt": {
                    if (applicationTerm.getParameters()[0].equals(applicationTerm.getParameters()[1])) {
                        return this.mTheory.mFalse;
                    }
                    if (this.isConstRelation(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1])) {
                        return this.simplifyBvslXConst(applicationTerm.getFunction(), applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
                    }
                    Term term2 = theory.or(new Term[]{theory.not(theory.or(new Term[]{theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[0]}), theory.binary("#b1")})), theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[1]}), theory.binary("#b0")}))})), theory.not(theory.or(new Term[]{theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[0]}), theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[1]})})), theory.not(theory.term("bvult", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]}))}))});
                    return term2;
                }
                case "bvule": {
                    Term term3 = theory.term("bvult", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]});
                    return theory.or(new Term[]{term3, theory.term("=", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]})});
                }
                case "bvsle": {
                    if (this.isConstRelation(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1])) {
                        return this.simplifyBvslXConst(applicationTerm.getFunction(), applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
                    }
                    Term term4 = theory.term("bvult", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]});
                    Term term5 = theory.or(new Term[]{term4, theory.term("=", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]})});
                    Term term6 = theory.or(new Term[]{theory.not(theory.or(new Term[]{theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[0]}), theory.binary("#b1")})), theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[1]}), theory.binary("#b0")}))})), theory.not(theory.or(new Term[]{theory.not(theory.term("=", new Term[]{theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[0]}), theory.term(functionSymbol2, new Term[]{applicationTerm.getParameters()[1]})})), theory.not(term5)}))});
                    return term6;
                }
                case "bvugt": {
                    if (applicationTerm.getParameters()[0].equals(applicationTerm.getParameters()[1])) {
                        return this.mTheory.mFalse;
                    }
                    if (this.isConstRelation(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1])) {
                        return this.simplifyBvultConst(null, applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]);
                    }
                    return theory.term("bvult", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]});
                }
                case "bvsgt": {
                    if (applicationTerm.getParameters()[0].equals(applicationTerm.getParameters()[1])) {
                        return this.mTheory.mFalse;
                    }
                    return this.getBvultTerm(theory.term("bvslt", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]}));
                }
                case "bvuge": {
                    Term term7 = this.isConstRelation(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]) ? this.simplifyBvultConst(null, applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]) : theory.term("bvult", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]});
                    return theory.or(new Term[]{term7, theory.term("=", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]})});
                }
                case "bvsge": {
                    return this.getBvultTerm(theory.term("bvsle", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]}));
                }
            }
            throw new UnsupportedOperationException("Not an Inequality function symbol: " + functionSymbol.getName());
        }
        throw new UnsupportedOperationException("Not an Inequality");
    }

    public Term bitMaskElimination(Term term) {
        Term term2 = null;
        String[] stringArray = new String[2];
        if (term instanceof ApplicationTerm) {
            Term term3;
            BigInteger bigInteger;
            char c;
            char c2;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getFunction().getName().equals("bvand")) {
                c2 = '0';
                c = '1';
            } else if (applicationTerm.getFunction().getName().equals("bvor")) {
                c2 = '1';
                c = '0';
            } else {
                return term;
            }
            Term term4 = applicationTerm.getParameters()[0];
            Term term5 = applicationTerm.getParameters()[1];
            if (this.isConstant(term4) && (term5 instanceof TermVariable || term5 instanceof ApplicationTerm)) {
                bigInteger = this.parseBitvectorConstant(term4);
                term3 = term5;
            } else if (term5 instanceof ConstantTerm && (term4 instanceof TermVariable || term4 instanceof ApplicationTerm)) {
                bigInteger = this.parseBitvectorConstant(term5);
                term3 = term4;
            } else {
                return term;
            }
            String string = bigInteger.toString(2);
            Object object = "#b";
            stringArray[0] = String.valueOf(string.length() - 1);
            int n = 0;
            while (n < string.length()) {
                char c3 = string.charAt(n);
                if (c3 == c2) {
                    object = (String)object + c3;
                    if (n > 0 && string.charAt(n - 1) == c) {
                        var15_15 = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
                        var16_16 = this.mTheory.term(var15_15, new Term[]{term3});
                        term2 = term2 != null ? this.mTheory.term("concat", new Term[]{term2, var16_16}) : var16_16;
                    }
                    stringArray[0] = String.valueOf(string.length() - n - 2);
                    if (n == string.length() - 1) {
                        term2 = term2 != null ? this.mTheory.term("concat", new Term[]{term2, this.mTheory.binary((String)object)}) : this.mTheory.binary((String)object);
                    }
                } else {
                    if (!((String)object).equals("#b")) {
                        term2 = term2 != null ? this.mTheory.term("concat", new Term[]{term2, this.mTheory.binary((String)object)}) : this.mTheory.binary((String)object);
                    }
                    object = "#b";
                    stringArray[1] = String.valueOf(string.length() - n - 1);
                    if (n == string.length() - 1) {
                        var15_15 = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
                        var16_16 = this.mTheory.term(var15_15, new Term[]{term3});
                        term2 = term2 != null ? this.mTheory.term("concat", new Term[]{term2, var16_16}) : var16_16;
                    }
                }
                ++n;
            }
            return term2;
        }
        return term;
    }

    public Term propagateExtract(FunctionSymbol functionSymbol, Term term) {
        block33: {
            ApplicationTerm applicationTerm;
            FunctionSymbol functionSymbol2;
            assert (functionSymbol.getName().equals("extract"));
            int n = Integer.parseInt(functionSymbol.getIndices()[1]);
            int n2 = Integer.parseInt(functionSymbol.getIndices()[0]);
            assert (n <= n2);
            if (!(term instanceof ApplicationTerm) || !(functionSymbol2 = (applicationTerm = (ApplicationTerm)term).getFunction()).isIntern()) break block33;
            switch (functionSymbol2.getName()) {
                case "concat": {
                    int n3 = Integer.parseInt(applicationTerm.getParameters()[1].getSort().getIndices()[0]);
                    if (n2 > n3 - 1) {
                        if (n > n3 - 1) {
                            String[] stringArray = new String[]{String.valueOf(n2 - n3), String.valueOf(n - n3)};
                            FunctionSymbol functionSymbol3 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
                            if (this.isConstRelation(applicationTerm.getParameters()[0], null)) {
                                return this.simplifySelectConst(functionSymbol3, applicationTerm.getParameters()[0]);
                            }
                            return this.mTheory.term(functionSymbol3, new Term[]{applicationTerm.getParameters()[0]});
                        }
                        String[] stringArray = new String[]{String.valueOf(n2 - n3), "0"};
                        FunctionSymbol functionSymbol4 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
                        String[] stringArray2 = new String[]{String.valueOf(n3 - 1), String.valueOf(n)};
                        FunctionSymbol functionSymbol5 = this.mTheory.getFunctionWithResult("extract", stringArray2, null, new Sort[]{applicationTerm.getParameters()[1].getSort()});
                        Term term2 = this.mTheory.term(functionSymbol4, new Term[]{applicationTerm.getParameters()[0]});
                        Term term3 = this.mTheory.term(functionSymbol5, new Term[]{applicationTerm.getParameters()[1]});
                        if (this.isConstRelation(applicationTerm.getParameters()[0], null)) {
                            term2 = this.simplifySelectConst(functionSymbol4, applicationTerm.getParameters()[0]);
                        }
                        if (this.isConstRelation(applicationTerm.getParameters()[1], null)) {
                            term3 = this.simplifySelectConst(functionSymbol5, applicationTerm.getParameters()[1]);
                        }
                        return this.mTheory.term("concat", new Term[]{term2, term3});
                    }
                    FunctionSymbol functionSymbol6 = this.mTheory.getFunctionWithResult("extract", functionSymbol.getIndices(), null, new Sort[]{applicationTerm.getParameters()[1].getSort()});
                    if (this.isConstRelation(applicationTerm.getParameters()[1], null)) {
                        return this.simplifySelectConst(functionSymbol6, applicationTerm.getParameters()[1]);
                    }
                    return this.mTheory.term(functionSymbol6, new Term[]{applicationTerm.getParameters()[1]});
                }
                case "extract": {
                    int n4 = Integer.parseInt(functionSymbol2.getIndices()[1]);
                    int n5 = n2 - n;
                    String[] stringArray = new String[]{String.valueOf(n + n4 + n5), String.valueOf(n + n4)};
                    FunctionSymbol functionSymbol7 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{applicationTerm.getParameters()[0].getSort()});
                    if (this.isConstRelation(applicationTerm.getParameters()[0], null)) {
                        return this.simplifySelectConst(functionSymbol7, applicationTerm.getParameters()[0]);
                    }
                    return this.mTheory.term(functionSymbol7, new Term[]{applicationTerm.getParameters()[0]});
                }
                case "bvand": {
                    assert (applicationTerm.getParameters().length == 2);
                    return this.mTheory.term("bvand", new Term[]{this.mTheory.term(functionSymbol, new Term[]{applicationTerm.getParameters()[0]}), this.mTheory.term(functionSymbol, new Term[]{applicationTerm.getParameters()[1]})});
                }
                case "bvor": {
                    assert (applicationTerm.getParameters().length == 2);
                    return this.mTheory.term("bvor", new Term[]{this.mTheory.term(functionSymbol, new Term[]{applicationTerm.getParameters()[0]}), this.mTheory.term(functionSymbol, new Term[]{applicationTerm.getParameters()[1]})});
                }
                case "bvnot": {
                    assert (applicationTerm.getParameters().length == 1);
                    return this.mTheory.term("bvnot", new Term[]{this.mTheory.term(functionSymbol, new Term[]{applicationTerm.getParameters()[0]})});
                }
            }
            if (this.isConstRelation(term, null)) {
                return this.simplifySelectConst(functionSymbol, term);
            }
            return this.mTheory.term(functionSymbol, new Term[]{term});
        }
        if (this.isConstRelation(term, null)) {
            return this.simplifySelectConst(functionSymbol, term);
        }
        return this.mTheory.term(functionSymbol, new Term[]{term});
    }

    public Term iterateOverBvEqualites(Term term) {
        if (term.equals(this.mTheory.mTrue) || term.equals(this.mTheory.mFalse)) {
            return term;
        }
        assert (term instanceof ApplicationTerm);
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (applicationTerm.getFunction().getName().equals("not")) {
            ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
            Term[] termArray = new Term[applicationTerm2.getParameters().length];
            int n = 0;
            while (n < applicationTerm2.getParameters().length) {
                Term term2 = applicationTerm2.getParameters()[n];
                assert (term2 instanceof ApplicationTerm);
                ApplicationTerm applicationTerm3 = (ApplicationTerm)term2;
                assert (applicationTerm3.getFunction().getName().equals("not"));
                termArray[n] = this.simplifyBinaryBitVecEquality(applicationTerm3.getParameters()[0]);
                ++n;
            }
            Term term3 = this.mTheory.not(this.mTheory.or(termArray));
            return term3;
        }
        if (applicationTerm.getFunction().getName().equals("=")) {
            assert (applicationTerm.getParameters().length == 2);
            Term term4 = this.simplifyBinaryBitVecEquality((Term)applicationTerm);
            return term4;
        }
        throw new UnsupportedOperationException("Not an Equality");
    }

    private Term simplifyBinaryBitVecEquality(Term term) {
        Term term2;
        AnnotatedTerm annotatedTerm;
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm) {
            applicationTerm = (ApplicationTerm)term;
        } else if (term instanceof AnnotatedTerm) {
            annotatedTerm = (AnnotatedTerm)term;
            applicationTerm = (ApplicationTerm)annotatedTerm.getSubterm();
        } else {
            throw new UnsupportedOperationException("Not an Equality");
        }
        if (term.equals(this.mTheory.mTrue) || term.equals(this.mTheory.mFalse)) {
            return term;
        }
        assert (applicationTerm.getFunction().getName().equals("="));
        annotatedTerm = (applicationTerm = (ApplicationTerm)this.orderParameters(applicationTerm.getFunction(), applicationTerm.getParameters())).getParameters()[0];
        if (annotatedTerm.equals(term2 = applicationTerm.getParameters()[1])) {
            return this.mTheory.mTrue;
        }
        if (this.isConstRelation((Term)annotatedTerm, term2)) {
            if (this.parseBitvectorConstant((Term)annotatedTerm).equals(this.parseBitvectorConstant(term2))) {
                return this.mTheory.mTrue;
            }
            return this.mTheory.mFalse;
        }
        Term term3 = this.eliminateConcatPerfectMatch(applicationTerm.getFunction(), (Term)annotatedTerm, term2);
        if (term3 != null) {
            if (((ApplicationTerm)term3).getFunction().getName().equals("and")) {
                return this.mUtils.convertAnd(term3);
            }
            return term3;
        }
        Term term4 = this.eliminateConcatNoMatch(applicationTerm.getFunction(), (Term)annotatedTerm, term2);
        if (term4 != null) {
            if (((ApplicationTerm)term4).getFunction().getName().equals("and")) {
                return this.mUtils.convertAnd(term4);
            }
            return term4;
        }
        return term;
    }

    public Term orderParameters(FunctionSymbol functionSymbol, Term[] termArray) {
        assert (termArray[0].getSort().isBitVecSort());
        assert (termArray.length == 2);
        assert (functionSymbol.getName().equals("=") || functionSymbol.getName().equals("bvadd") || functionSymbol.getName().equals("bvmul") || functionSymbol.getName().equals("bvand") || functionSymbol.getName().equals("bvor"));
        if (termArray[0].hashCode() < termArray[1].hashCode()) {
            return this.mTheory.term(functionSymbol, termArray);
        }
        if (termArray[0].hashCode() > termArray[1].hashCode()) {
            return this.mTheory.term(functionSymbol, new Term[]{termArray[1], termArray[0]});
        }
        return this.mTheory.term(functionSymbol, termArray);
    }

    public Term transformBvcomp(Term[] termArray) {
        Sort sort = this.mTheory.getSort("BitVec", new String[]{"1"}, new Sort[0]);
        return this.mTheory.term("ite", new Term[]{this.mTheory.term("=", new Term[]{termArray[0], termArray[1]}), this.mTheory.constant((Object)BigInteger.ONE, sort), this.mTheory.constant((Object)BigInteger.ZERO, sort)});
    }

    public Term transformBvsdiv(Term[] termArray) {
        String[] stringArray = new String[]{String.valueOf(Integer.valueOf(termArray[0].getSort().getIndices()[0]) - 1), String.valueOf(Integer.valueOf(termArray[0].getSort().getIndices()[0]) - 1)};
        Term term = this.mTheory.term("extract", stringArray, null, new Term[]{termArray[0]});
        Term term2 = this.mTheory.term("extract", stringArray, null, new Term[]{termArray[1]});
        Term term3 = this.mTheory.binary("#b0");
        Term term4 = this.mTheory.binary("#b1");
        Term term5 = this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term3, term}), this.mTheory.term("=", new Term[]{term3, term2})});
        Term term6 = this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term4, term}), this.mTheory.term("=", new Term[]{term3, term2})});
        Term term7 = this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term3, term}), this.mTheory.term("=", new Term[]{term4, term2})});
        Term term8 = this.mTheory.term("bvudiv", termArray);
        Term term9 = this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvudiv", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), termArray[1]})});
        Term term10 = this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvudiv", new Term[]{termArray[0], this.mTheory.term("bvneg", new Term[]{termArray[1]})})});
        Term term11 = this.mTheory.term("bvudiv", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), this.mTheory.term("bvneg", new Term[]{termArray[1]})});
        Term term12 = this.mTheory.term("ite", new Term[]{term7, term10, term11});
        Term term13 = this.mTheory.term("ite", new Term[]{term6, term9, term12});
        Term term14 = this.mTheory.term("ite", new Term[]{term5, term8, term13});
        return term14;
    }

    public Term transformBvsdivOld(Term[] termArray) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        String[] stringArray = new String[]{String.valueOf(n - 1), String.valueOf(n - 1)};
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{termArray[0].getSort()});
        Term term = this.mTheory.term(functionSymbol, new Term[]{termArray[0]});
        Term term2 = this.mTheory.term(functionSymbol, new Term[]{termArray[1]});
        String string = "#b" + new String(new char[n]).replace("\u0000", "0");
        String string2 = "#b" + new String(new char[n - 1]).replace("\u0000", "0") + "1";
        Term term3 = this.mTheory.term("=", new Term[]{termArray[1], this.mTheory.binary(string)});
        Term term4 = n > 1 ? this.mTheory.ifthenelse(this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), termArray[0], this.mTheory.binary(string2)) : this.mTheory.binary("#b1");
        Term term5 = this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), this.mTheory.term("bvudiv", new Term[]{termArray[0], termArray[1]}), this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b1")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvudiv", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), termArray[1]})}), this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b1")})}), this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvudiv", new Term[]{termArray[0], this.mTheory.term("bvneg", new Term[]{termArray[1]})})}), this.mTheory.term("bvudiv", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), this.mTheory.term("bvneg", new Term[]{termArray[1]})}))));
        return this.mTheory.ifthenelse(term3, term4, term5);
    }

    public Term transformBvsrem(Term[] termArray) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        String[] stringArray = new String[]{String.valueOf(n - 1), String.valueOf(n - 1)};
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{termArray[0].getSort()});
        Term term = this.mTheory.term(functionSymbol, new Term[]{termArray[0]});
        Term term2 = this.mTheory.term(functionSymbol, new Term[]{termArray[1]});
        Term term3 = this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), this.mTheory.term("bvurem", new Term[]{termArray[0], termArray[1]}), this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b1")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvurem", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), termArray[1]})}), this.mTheory.ifthenelse(this.mTheory.term("and", new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b1")})}), this.mTheory.term("bvurem", new Term[]{termArray[0], this.mTheory.term("bvneg", new Term[]{termArray[1]})}), this.mTheory.term("bvneg", new Term[]{this.mTheory.term("bvurem", new Term[]{this.mTheory.term("bvneg", new Term[]{termArray[0]}), this.mTheory.term("bvneg", new Term[]{termArray[1]})})}))));
        return term3;
    }

    public Term transformBvsmod(Term[] termArray) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        String[] stringArray = new String[]{String.valueOf(n - 1), String.valueOf(n - 1)};
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{termArray[0].getSort()});
        Term term = this.mTheory.term(functionSymbol, new Term[]{termArray[0]});
        Term term2 = this.mTheory.term(functionSymbol, new Term[]{termArray[1]});
        Term term3 = this.mTheory.ifthenelse(this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), termArray[0], this.mTheory.term("bvneg", new Term[]{termArray[0]}));
        Term term4 = this.mTheory.ifthenelse(this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")}), termArray[1], this.mTheory.term("bvneg", new Term[]{termArray[1]}));
        Term term5 = this.mTheory.term("bvurem", new Term[]{term3, term4});
        Term term6 = this.mTheory.constant((Object)BigInteger.ZERO, termArray[0].getSort());
        Term term7 = this.mTheory.ifthenelse(this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b1")})}), this.mTheory.term("bvadd", new Term[]{term5, termArray[1]}), this.mTheory.term("bvneg", new Term[]{term5}));
        Term term8 = this.mTheory.ifthenelse(this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b1")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), this.mTheory.term("bvadd", new Term[]{this.mTheory.term("bvneg", new Term[]{term5}), termArray[1]}), term7);
        Term term9 = this.mTheory.ifthenelse(this.mTheory.and(new Term[]{this.mTheory.term("=", new Term[]{term, this.mTheory.binary("#b0")}), this.mTheory.term("=", new Term[]{term2, this.mTheory.binary("#b0")})}), term5, term8);
        String string = "#b" + new String(new char[n]).replace("\u0000", "0");
        Term term10 = this.mTheory.term("=", new Term[]{termArray[1], this.mTheory.binary(string)});
        return this.mTheory.ifthenelse(term10, termArray[0], this.mTheory.ifthenelse(this.mTheory.term("=", new Term[]{term5, term6}), term5, term9));
    }

    public Term transformBvashr(Term[] termArray) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        String[] stringArray = new String[]{String.valueOf(n - 1), String.valueOf(n - 1)};
        FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("extract", (String[])stringArray.clone(), null, new Sort[]{termArray[0].getSort()});
        return this.mTheory.ifthenelse(this.mTheory.term("=", new Term[]{this.mTheory.term(functionSymbol, new Term[]{termArray[0]}), this.mTheory.binary("#b0")}), this.mTheory.term("bvlshr", new Term[]{termArray[0], termArray[1]}), this.mTheory.term("bvnot", new Term[]{this.mTheory.term("bvlshr", new Term[]{this.mTheory.term("bvnot", new Term[]{termArray[0]}), termArray[1]})}));
    }

    public Term transformRepeat(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (functionSymbol.getIndices()[0].equals("1")) {
            return termArray[0];
        }
        if (this.isConstRelation(termArray[0], null)) {
            String string = this.parseBitvectorConstant(termArray[0]).toString(2);
            String string2 = "#b" + string;
            int n = 1;
            while (n < Integer.parseInt(functionSymbol.getIndices()[0])) {
                string2 = string2 + string;
                ++n;
            }
            return this.mTheory.binary(string2);
        }
        Term term2 = termArray[0];
        int n = 1;
        while (n < Integer.parseInt(functionSymbol.getIndices()[0])) {
            term2 = this.mTheory.term("concat", new Term[]{term2, termArray[0]});
            ++n;
        }
        return term2;
    }

    public Term transformSignExtend(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (functionSymbol.getIndices()[0].equals("0")) {
            return termArray[0];
        }
        if (this.isConstRelation(termArray[0], null)) {
            Object object = "#b";
            String string = this.parseBitvectorConstant(termArray[0]).toString(2);
            object = (String)object + string.charAt(0);
            int n = 1;
            while (n < Integer.parseInt(functionSymbol.getIndices()[0])) {
                object = (String)object + string.charAt(0);
                ++n;
            }
            return this.mTheory.binary((String)object + string);
        }
        return term;
    }

    public Term transformRotateleft(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        int n2 = Integer.valueOf(functionSymbol.getIndices()[0]);
        if (n2 > n) {
            n2 %= n;
        }
        if (n2 == 0) {
            return termArray[0];
        }
        if (n == 1) {
            return termArray[0];
        }
        if (this.isConstRelation(termArray[0], null)) {
            String string = this.parseBitvectorConstant(termArray[0]).toString(2);
            String string2 = (String)string.subSequence(0, n2);
            String string3 = (String)string.subSequence(n2, string.length());
            return this.mTheory.binary("#b" + string3 + string2);
        }
        String[] stringArray = new String[]{String.valueOf(n - 2), String.valueOf(0)};
        String[] stringArray2 = new String[]{String.valueOf(n - 1), String.valueOf(n - 1)};
        String[] stringArray3 = new String[]{String.valueOf(n2 - 1)};
        FunctionSymbol functionSymbol2 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{termArray[0].getSort()});
        FunctionSymbol functionSymbol3 = this.mTheory.getFunctionWithResult("extract", stringArray2, null, new Sort[]{termArray[0].getSort()});
        FunctionSymbol functionSymbol4 = this.mTheory.getFunctionWithResult("rotate_left", stringArray3, null, new Sort[]{termArray[0].getSort()});
        Term term2 = this.mTheory.term("concat", new Term[]{this.mTheory.term(functionSymbol2, new Term[]{termArray[0]}), this.mTheory.term(functionSymbol3, new Term[]{termArray[0]})});
        return this.mTheory.term(functionSymbol4, new Term[]{term2});
    }

    public Term transformRotateright(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        int n = Integer.parseInt(termArray[0].getSort().getIndices()[0]);
        int n2 = Integer.valueOf(functionSymbol.getIndices()[0]);
        if (n2 > n) {
            n2 %= n;
        }
        if (n2 == 0) {
            return termArray[0];
        }
        if (n == 1) {
            return termArray[0];
        }
        if (this.isConstRelation(termArray[0], null)) {
            String string = this.parseBitvectorConstant(termArray[0]).toString(2);
            String string2 = (String)string.subSequence(0, string.length() - n2);
            String string3 = (String)string.subSequence(string.length() - n2, string.length());
            return this.mTheory.binary("#b" + string3 + string2);
        }
        String[] stringArray = new String[]{String.valueOf(0), String.valueOf(0)};
        String[] stringArray2 = new String[]{String.valueOf(n - 1), String.valueOf(1)};
        String[] stringArray3 = new String[]{String.valueOf(n2 - 1)};
        FunctionSymbol functionSymbol2 = this.mTheory.getFunctionWithResult("extract", stringArray, null, new Sort[]{termArray[0].getSort()});
        FunctionSymbol functionSymbol3 = this.mTheory.getFunctionWithResult("extract", stringArray2, null, new Sort[]{termArray[0].getSort()});
        FunctionSymbol functionSymbol4 = this.mTheory.getFunctionWithResult("rotate_left", stringArray3, null, new Sort[]{termArray[0].getSort()});
        Term term2 = this.mTheory.term("concat", new Term[]{this.mTheory.term(functionSymbol2, new Term[]{termArray[0]}), this.mTheory.term(functionSymbol3, new Term[]{termArray[0]})});
        return this.mTheory.term(functionSymbol4, new Term[]{term2});
    }

    public Term transformBvnot(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (this.isConstRelation(termArray[0], null)) {
            return this.simplifyNotConst(functionSymbol, termArray[0]);
        }
        return term;
    }

    public Term transformBvneg(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (this.isConstRelation(termArray[0], null)) {
            return this.simplifyNegConst(functionSymbol, termArray[0]);
        }
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        String string = new String(new char[n - 1]).replace("\u0000", "0");
        String string2 = "#b" + string + "1";
        Term term2 = this.mTheory.term("bvadd", new Term[]{this.mTheory.term("bvnot", new Term[]{termArray[0]}), this.mTheory.binary(string2)});
        return term2;
    }

    public Term transformBvxor(Term[] termArray) {
        assert (termArray.length == 2);
        return this.mTheory.term("bvor", new Term[]{this.mTheory.term("bvand", new Term[]{termArray[0], this.mTheory.term("bvnot", new Term[]{termArray[1]})}), this.mTheory.term("bvand", new Term[]{this.mTheory.term("bvnot", new Term[]{termArray[0]}), termArray[1]})});
    }

    public Term transformBvxnor(Term[] termArray) {
        assert (termArray.length == 2);
        return this.mTheory.term("bvor", new Term[]{this.mTheory.term("bvand", new Term[]{termArray[0], termArray[1]}), this.mTheory.term("bvand", new Term[]{this.mTheory.term("bvnot", new Term[]{termArray[0]}), this.mTheory.term("bvnot", new Term[]{termArray[1]})})});
    }

    public Term transformExtract(Term[] termArray, FunctionSymbol functionSymbol) {
        if (this.isConstRelation(termArray[0], null)) {
            return this.simplifySelectConst(functionSymbol, termArray[0]);
        }
        Term term = this.propagateExtract(functionSymbol, termArray[0]);
        return term;
    }

    public Term transformBvult(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        ApplicationTerm applicationTerm;
        Term term2 = this.getBvultTerm(term);
        if (term2 instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term2).getFunction().getName().equals("or")) {
            return this.mUtils.convertOr(term2);
        }
        return term2;
    }

    public Term transformConcat(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (this.isConstRelation(termArray[0], termArray[1])) {
            return this.simplifyConcatConst(functionSymbol, termArray[0], termArray[1]);
        }
        return term;
    }

    public Term transformBvArithmetic(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (this.isConstRelation(termArray[0], termArray[1])) {
            return this.simplifyBitvectorConstantOp(functionSymbol, termArray[0], termArray[1]);
        }
        return term;
    }

    public Term transformBvaddBvmul(Term[] termArray, FunctionSymbol functionSymbol) {
        if (this.isConstRelation(termArray[0], termArray[1])) {
            return this.simplifyBitvectorConstantOp(functionSymbol, termArray[0], termArray[1]);
        }
        return this.orderParameters(functionSymbol, termArray);
    }

    public Term transformBitwise(Term[] termArray, FunctionSymbol functionSymbol) {
        assert (termArray.length == 2);
        if (this.isConstRelation(termArray[0], termArray[1])) {
            return this.simplifyBitvectorConstantOp(functionSymbol, termArray[0], termArray[1]);
        }
        Term term = this.bitMaskElimination(this.orderParameters(functionSymbol, termArray));
        return term;
    }

    public Term transformShift(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        if (this.isConstRelation(termArray[0], termArray[1])) {
            return this.simplifyShiftConst(functionSymbol, termArray[0], termArray[1]);
        }
        return term;
    }

    public Term transformInequality(Term[] termArray, FunctionSymbol functionSymbol, Term term) {
        ApplicationTerm applicationTerm;
        Term term2 = this.getBvultTerm(term);
        if (term2 instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term2).getFunction().getName().equals("or")) {
            return this.mUtils.convertOr(term2);
        }
        return term2;
    }
}

