/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.PathExpressionComputer;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Regex;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.ProcedureGraph;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.ProcedureGraphBuilder;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.BackwardClosedOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.IDagOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagUtils;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexToDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.RegexStatUtils;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ProcedureResources {
    private final RegexDag<IIcfgTransition<IcfgLocation>> mRegexDag;
    private final BackwardClosedOverlay<IIcfgTransition<IcfgLocation>> mDagOverlayPathToReturn;
    private final BackwardClosedOverlay<IIcfgTransition<IcfgLocation>> mDagOverlayPathToLOIsAndEnterCalls;

    public ProcedureResources(SifaStats sifaStats, IIcfg<IcfgLocation> iIcfg, String string, Collection<IcfgLocation> collection, Collection<String> collection2) {
        ProcedureGraph procedureGraph = new ProcedureGraphBuilder(sifaStats, iIcfg).graphOfProcedure(string, collection, collection2);
        Map map = iIcfg.getProcedureEntryNodes();
        IcfgLocation icfgLocation3 = procedureGraph.getEntryNode();
        PathExpressionComputer pathExpressionComputer = RegexStatUtils.createPEComputer(sifaStats, procedureGraph);
        RegexToDag regexToDag = RegexStatUtils.createRegexToDag(sifaStats);
        ArrayList arrayList = new ArrayList(collection.size());
        ArrayList arrayList2 = new ArrayList(2 * collection2.size());
        collection.stream().peek(icfgLocation -> ProcedureResources.assertLoiFromSameProcedure(string, icfgLocation)).map(icfgLocation2 -> RegexDagUtils.markRegex(RegexStatUtils.exprBetween(sifaStats, pathExpressionComputer, icfgLocation3, icfgLocation2), icfgLocation2)).map(iRegex -> RegexStatUtils.addToDag(sifaStats, regexToDag, iRegex)).forEach(arrayList::add);
        collection2.stream().map(map::get).map(icfgLocation2 -> RegexDagUtils.markRegex(RegexStatUtils.exprBetween(sifaStats, pathExpressionComputer, icfgLocation3, icfgLocation2), icfgLocation2)).map(iRegex -> RegexStatUtils.addToDag(sifaStats, regexToDag, iRegex)).forEach(arrayList2::add);
        IcfgLocation icfgLocation4 = procedureGraph.getExitNode().orElse(null);
        IRegex iRegex2 = icfgLocation4 == null ? Regex.emptySet() : RegexStatUtils.exprBetween(sifaStats, pathExpressionComputer, icfgLocation3, icfgLocation4);
        RegexDagNode<IIcfgTransition<IcfgLocation>> regexDagNode = RegexStatUtils.addToDag(sifaStats, regexToDag, RegexDagUtils.markRegex(iRegex2, icfgLocation4));
        this.mRegexDag = RegexStatUtils.getDagAndReset(sifaStats, regexToDag);
        RegexStatUtils.compress(sifaStats, this.mRegexDag);
        this.mDagOverlayPathToLOIsAndEnterCalls = new BackwardClosedOverlay();
        arrayList.forEach(this.mDagOverlayPathToLOIsAndEnterCalls::addInclusive);
        arrayList2.forEach(this.mDagOverlayPathToLOIsAndEnterCalls::addExclusive);
        this.mDagOverlayPathToReturn = new BackwardClosedOverlay();
        this.mDagOverlayPathToReturn.addInclusive(regexDagNode);
    }

    private static void assertLoiFromSameProcedure(String string, IcfgLocation icfgLocation) {
        assert (string.equals(icfgLocation.getProcedure())) : "Location of interest from different procedure";
    }

    public RegexDag<IIcfgTransition<IcfgLocation>> getRegexDag() {
        return this.mRegexDag;
    }

    public IDagOverlay<IIcfgTransition<IcfgLocation>> getDagOverlayPathToReturn() {
        return this.mDagOverlayPathToReturn;
    }

    public IDagOverlay<IIcfgTransition<IcfgLocation>> getDagOverlayPathToLoisAndEnterCalls() {
        return this.mDagOverlayPathToLOIsAndEnterCalls;
    }
}

