/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;

public class CASTAmbiguousStatement
extends ASTAmbiguousNode
implements IASTAmbiguousStatement {
    private IASTStatement[] stmts = new IASTStatement[2];
    private int stmtsPos = -1;
    private IScope fScope;
    private IASTDeclaration fDeclaration;

    public CASTAmbiguousStatement(IASTStatement ... statements) {
        IASTStatement[] iASTStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement s = iASTStatementArray[n2];
            this.addStatement(s);
            ++n2;
        }
    }

    @Override
    protected void beforeResolution() {
        this.fScope = CVisitor.getContainingScope(this);
        if (this.fScope instanceof ICPPASTInternalScope) {
            ((ICPPASTInternalScope)this.fScope).populateCache();
        }
    }

    @Override
    protected void beforeAlternative(IASTNode alternative) {
        this.cleanupScope();
        if (alternative instanceof IASTDeclarationStatement && this.fScope instanceof CScope) {
            this.fDeclaration = ((IASTDeclarationStatement)alternative).getDeclaration();
            ((CScope)this.fScope).collectNames((IASTNode)this.fDeclaration);
        }
    }

    private void cleanupScope() {
        if (this.fScope instanceof IASTInternalScope && this.fDeclaration != null) {
            ((IASTInternalScope)this.fScope).removeNestedFromCache(this.fDeclaration);
        }
    }

    @Override
    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
        this.beforeAlternative(best);
        this.fDeclaration = null;
        this.fScope = null;
    }

    @Override
    public void addStatement(IASTStatement s) {
        this.assertNotFrozen();
        if (s != null) {
            this.stmts = ArrayUtil.appendAt(IASTStatement.class, this.stmts, ++this.stmtsPos, s);
            s.setParent(this);
            s.setPropertyInParent(STATEMENT);
        }
    }

    @Override
    public IASTStatement[] getStatements() {
        this.stmts = ArrayUtil.trimAt(IASTStatement.class, this.stmts, this.stmtsPos);
        return this.stmts;
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;
    }

    @Override
    public void addAttribute(IASTAttribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTAttributeSpecifier[] getAttributeSpecifiers() {
        return IASTAttributeSpecifier.EMPTY_ATTRIBUTE_SPECIFIER_ARRAY;
    }

    @Override
    public void addAttributeSpecifier(IASTAttributeSpecifier attributeSpecifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTNode[] getNodes() {
        return this.getStatements();
    }

    @Override
    public IASTStatement copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTStatement copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }
}

