/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrsAbstraction
implements IVasrsAbstraction<Rational> {
    private final QvasrAbstraction mQvasrAbstraction;
    private final Rational[][] mSimulationMatrix;
    private final Set<Term> mStates;
    private final Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> mTransitions;
    private Term mPreCon;
    private Term mPostCon;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public QvasrsAbstraction(QvasrAbstraction qvasrAbstraction, Set<Term> set, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        this.mQvasrAbstraction = qvasrAbstraction;
        this.mSimulationMatrix = qvasrAbstraction.getSimulationMatrix();
        this.mStates = set;
        this.mTransitions = new HashSet<Triple<Term, Pair<Rational[], Rational[]>, Term>>();
        this.mPreCon = null;
        this.mPostCon = null;
        this.mInVars = map;
        this.mOutVars = map2;
    }

    @Override
    public void addTransition(Triple<Term, Pair<Rational[], Rational[]>, Term> triple) {
        this.mTransitions.add(triple);
    }

    public QvasrAbstraction getAbstraction() {
        return this.mQvasrAbstraction;
    }

    @Override
    public Set<Term> getStates() {
        return this.mStates;
    }

    @Override
    public Set<Triple<Term, Pair<Rational[], Rational[]>, Term>> getTransitions() {
        return this.mTransitions;
    }

    public Rational[][] getSimulationMatrix() {
        return this.mSimulationMatrix;
    }

    @Override
    public Term getPreState() {
        return this.mPreCon;
    }

    @Override
    public Term getPostState() {
        return this.mPostCon;
    }

    @Override
    public void setPreState(Term term) {
        this.mPreCon = term;
    }

    @Override
    public void setPostState(Term term) {
        this.mPostCon = term;
    }

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    @Override
    public void setPrePostStates() {
        HashSet<Term> hashSet = new HashSet<Term>(this.mStates);
        HashSet<Term> hashSet2 = new HashSet<Term>(this.mStates);
        for (Triple<Term, Pair<Rational[], Rational[]>, Term> triple : this.mTransitions) {
            if (triple.getFirst() == triple.getThird()) continue;
            hashSet.remove(triple.getFirst());
            hashSet2.remove(triple.getThird());
        }
        this.mPreCon = hashSet.toArray(new Term[1])[0];
        this.mPostCon = hashSet2.toArray(new Term[1])[0];
    }
}

