/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ApplicationTermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ConstantTermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.INaryTermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.ITermEvaluatorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.termevaluator.VariableTermEvaluator;
import java.util.function.Supplier;

public class TermEvaluatorFactory<VALUE extends INonrelationalValue<VALUE>, STATE extends NonrelationalState<STATE, VALUE>>
implements ITermEvaluatorFactory<VALUE, STATE> {
    private final Function<Object, VALUE> mConstantValueExpressionEvaluatorCreator;
    private final int mMaxParallelStates;
    private final INonrelationalValueFactory<VALUE> mNonrelationalValueFactory;
    private final EvaluatorLogger mEvaluatorLogger;

    public TermEvaluatorFactory(ILogger iLogger, int n, Function<Object, VALUE> function, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory) {
        this.mMaxParallelStates = n;
        this.mConstantValueExpressionEvaluatorCreator = function;
        this.mNonrelationalValueFactory = iNonrelationalValueFactory;
        this.mEvaluatorLogger = new EvaluatorLogger(iLogger);
    }

    @Override
    public INaryTermEvaluator<VALUE, STATE> createApplicationTerm(int n, String string, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, Supplier<STATE> supplier) {
        assert (n >= 0);
        assert (string != null);
        return new ApplicationTermEvaluator<VALUE, STATE>(this.mEvaluatorLogger, n, string, this.mMaxParallelStates, iNonrelationalValueFactory, supplier);
    }

    @Override
    public ITermEvaluator<VALUE, STATE> createConstantValueEvaluator(Object object) {
        assert (object != null);
        return new ConstantTermEvaluator((INonrelationalValue)this.mConstantValueExpressionEvaluatorCreator.apply(object));
    }

    @Override
    public ITermEvaluator<VALUE, STATE> createVariableTermEvaluator(String string, Sort sort) {
        return new VariableTermEvaluator(string, sort, this.mNonrelationalValueFactory);
    }

    @FunctionalInterface
    public static interface Function<NAMETYPE, VALUETYPE> {
        public VALUETYPE apply(NAMETYPE var1);
    }
}

