/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmptyHeuristic;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeature;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractor;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SmtFeatureHeuristic<STATE, LETTER>
implements IsEmptyHeuristic.IHeuristic<STATE, LETTER> {
    private Map<LETTER, Double> mScoreCache = new HashMap<LETTER, Double>();
    private final SMTFeatureExtractionTermClassifier.ScoringMethod mScoringMethod;
    private final SMTFeatureExtractor mFeatureExtractor;

    public SmtFeatureHeuristic(SMTFeatureExtractionTermClassifier.ScoringMethod scoringMethod) {
        this.mScoringMethod = scoringMethod;
        this.mFeatureExtractor = new SMTFeatureExtractor(null, null, false);
    }

    public double checkTransition(LETTER LETTER) {
        if (LETTER instanceof IInternalAction) {
            SMTFeatureExtractionTermClassifier sMTFeatureExtractionTermClassifier = new SMTFeatureExtractionTermClassifier();
            Term term = ((IInternalAction)LETTER).getTransformula().getFormula();
            sMTFeatureExtractionTermClassifier.checkTerm(term);
            return sMTFeatureExtractionTermClassifier.getScore(this.mScoringMethod);
        }
        if (LETTER instanceof ICallAction) {
            return 1.0;
        }
        return 0.5;
    }

    @Override
    public double getHeuristicValue(STATE STATE, STATE STATE2, LETTER LETTER) {
        return this.mScoreCache.computeIfAbsent(LETTER, this::checkTransition);
    }

    @Override
    public double getConcreteCost(LETTER LETTER) {
        return this.mScoreCache.computeIfAbsent(LETTER, this::checkTransition);
    }

    public void compareSuccessors(List<IsEmptyHeuristic.Item> list) {
        HashMap hashMap = new HashMap();
        this.mScoreCache.clear();
        if (list.size() == 1) {
            this.mScoreCache.put(list.iterator().next().getLetter(), 0.5);
            return;
        }
        list.forEach(item -> {
            Object LETTER = item.getLetter();
            UnmodifiableTransFormula unmodifiableTransFormula = null;
            unmodifiableTransFormula = ((IAction)LETTER).getTransformula();
            hashMap.put(this.mFeatureExtractor.extractFeatureRaw(unmodifiableTransFormula.getFormula()), LETTER);
        });
        for (Map.Entry entry2 : hashMap.entrySet()) {
            SMTFeature sMTFeature = (SMTFeature)entry2.getKey();
            for (Map.Entry entry3 : hashMap.entrySet()) {
                Object v;
                SMTFeature sMTFeature2 = (SMTFeature)entry3.getKey();
                if (sMTFeature == sMTFeature2) continue;
                SMTFeature sMTFeature3 = SMTFeature.chooseLooser((SMTFeature)sMTFeature, (SMTFeature)sMTFeature2);
                Object v2 = hashMap.get(sMTFeature3);
                Double d = this.mScoreCache.getOrDefault(v2, 0.5) + 1.0;
                this.mScoreCache.put(v2, d);
                Object v3 = v = sMTFeature3 != sMTFeature ? entry2.getValue() : entry3.getValue();
                if (this.mScoreCache.containsKey(v)) continue;
                this.mScoreCache.put(v, 0.5);
            }
        }
        this.mScoreCache = this.mScoreCache.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SMTFeatureExtractionTermClassifier.normalize((double)((Double)entry.getValue()), (double)0.5, (double)1.0)));
    }

    public SMTFeatureExtractionTermClassifier.ScoringMethod getScoringMethod() {
        return this.mScoringMethod;
    }
}

