/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Rabin2BuchiAutomaton<LETTER, STATE, FACTORY extends IBlackWhiteStateFactory<STATE> & IEmptyStackStateFactory<STATE>>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final IRabinAutomaton<LETTER, STATE> mRabinAutomaton;
    private final FACTORY mFiniteOrNonFiniteStateFactory;
    private final HashMap<STATE, STATE> mBuchi2Rabin = new HashMap();
    private final HashSet<STATE> mInitialSet = new HashSet();
    private final HashSet<STATE> mNonFiniteSet = new HashSet();

    public Rabin2BuchiAutomaton(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, FACTORY FACTORY) {
        this.mRabinAutomaton = iRabinAutomaton;
        this.mFiniteOrNonFiniteStateFactory = FACTORY;
        for (STATE STATE : iRabinAutomaton.getInitialStates()) {
            this.mInitialSet.add(this.getFiniteVariant(STATE));
            STATE STATE2 = this.getNonFiniteVariant(STATE);
            if (STATE2 == null) continue;
            this.mInitialSet.add(STATE2);
        }
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return new VpAlphabet(this.mRabinAutomaton.getAlphabet());
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mInitialSet;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mInitialSet.contains(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mNonFiniteSet.contains(STATE) && this.mRabinAutomaton.isAccepting(this.mBuchi2Rabin.get(STATE));
    }

    @Override
    public int size() {
        return this.mBuchi2Rabin.size();
    }

    @Override
    public String sizeInformation() {
        return "Number of distinct computed states so far: " + this.size();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.getSucessors(STATE, this.mRabinAutomaton.getSuccessors(this.mBuchi2Rabin.get(STATE), LETTER));
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        return this.getSucessors(STATE, this.mRabinAutomaton.getSuccessors(this.mBuchi2Rabin.get(STATE)));
    }

    private Iterable<OutgoingInternalTransition<LETTER, STATE>> getSucessors(STATE STATE, Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        if (this.mNonFiniteSet.contains(STATE)) {
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
                STATE STATE2 = this.getNonFiniteVariant(outgoingInternalTransition.getSucc());
                if (STATE2 == null) continue;
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(outgoingInternalTransition.getLetter(), STATE2));
            }
            return arrayList;
        }
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            STATE STATE3 = outgoingInternalTransition.getSucc();
            arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(outgoingInternalTransition.getLetter(), this.getFiniteVariant(STATE3)));
            STATE STATE4 = this.getNonFiniteVariant(STATE3);
            if (STATE4 == null || !this.isFinal(STATE4)) continue;
            arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(outgoingInternalTransition.getLetter(), STATE4));
        }
        return arrayList;
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mFiniteOrNonFiniteStateFactory;
    }

    private STATE getFiniteVariant(STATE STATE) {
        STATE STATE2 = this.mFiniteOrNonFiniteStateFactory.getWhiteContent(STATE);
        if (this.mBuchi2Rabin.containsKey(STATE2)) {
            return STATE2;
        }
        this.mBuchi2Rabin.put(STATE2, STATE);
        return STATE2;
    }

    private STATE getNonFiniteVariant(STATE STATE) {
        STATE STATE2 = this.mFiniteOrNonFiniteStateFactory.getBlackContent(STATE);
        if (this.mNonFiniteSet.contains(STATE2)) {
            return STATE2;
        }
        if (!this.mRabinAutomaton.isFinite(STATE)) {
            this.mBuchi2Rabin.put(STATE2, STATE);
            this.mNonFiniteSet.add(STATE2);
            return STATE2;
        }
        return null;
    }

    @Override
    public STATE getEmptyStackState() {
        return ((IEmptyStackStateFactory)this.mFiniteOrNonFiniteStateFactory).createEmptyStackState();
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return Set.of();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return Set.of();
    }
}

