/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.RelevantVariables;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public abstract class InterpolatingTraceCheck<L extends IAction>
extends TraceCheck<L>
implements IInterpolatingTraceCheck<L> {
    protected final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    protected final IPredicateUnifier mPredicateUnifier;
    protected final PredicateFactory mPredicateFactory;
    protected IPredicate[] mInterpolants;
    protected final List<?> mControlConfigurationSequence;

    public InterpolatingTraceCheck(IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Counterexample<L> counterexample, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, ManagedScript managedScript, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, boolean bl, boolean bl2, SmtUtils.SimplificationTechnique simplificationTechnique) {
        super(iPredicate, iPredicate2, sortedMap, TraceCheckUtils.decoupleArrayValues(cfgSmtToolkit.getManagedScript(), new DefaultTransFormulas<L>(counterexample, iPredicate, iPredicate2, sortedMap, cfgSmtToolkit.getOldVarsAssignmentCache(), false)), iUltimateServiceProvider, cfgSmtToolkit, managedScript, assertCodeBlockOrder, bl, bl2, false);
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateFactory = predicateFactory;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mControlConfigurationSequence = counterexample.hasControlConfigurations() ? counterexample.getControlConfigurations() : null;
    }

    protected abstract void computeInterpolants(InterpolationTechnique var1);

    private boolean testRelevantVars() {
        boolean bl = true;
        RelevantVariables relevantVariables = new RelevantVariables(this.mNestedFormulas, this.mCsToolkit.getModifiableGlobalsTable());
        int n = 0;
        while (n < this.mInterpolants.length) {
            IPredicate iPredicate = this.mInterpolants[n];
            Set set = iPredicate.getVars();
            Set<IProgramVar> set2 = relevantVariables.getForwardRelevantVariables()[n + 1];
            Set<IProgramVar> set3 = relevantVariables.getBackwardRelevantVariables()[n + 1];
            if (!set2.containsAll(set)) {
                this.mLogger.warn((Object)"forward relevant variables wrong");
                bl = false;
            }
            if (!set3.containsAll(set)) {
                this.mLogger.warn((Object)"backward relevant variables wrong");
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public IPredicate[] getInterpolants() {
        if (this.isCorrect() == Script.LBool.UNSAT) {
            if (this.mInterpolants == null) {
                throw new AssertionError((Object)"No Interpolants");
            }
            assert (this.mInterpolants.length == this.mTrace.length() - 1);
            return this.mInterpolants;
        }
        throw new UnsupportedOperationException("Interpolants are only available if trace is correct.");
    }

    public final IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public boolean isPerfectSequence() {
        int n = (Integer)this.getStatistics().getValue(TraceCheckStatisticsDefinitions.PerfectInterpolantSequences.toString());
        assert (n == 0 || n == 1 || n == 2);
        return n == 1;
    }

    protected boolean checkPerfectSequence(TracePredicates tracePredicates) {
        if (this.mControlConfigurationSequence != null) {
            boolean bl;
            CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation = TraceCheckUtils.computeCoverageCapability(this.mServices, tracePredicates, this.mControlConfigurationSequence, this.mLogger, this.mPredicateUnifier);
            boolean bl2 = bl = backwardCoveringInformation.getPotentialBackwardCoverings() == backwardCoveringInformation.getSuccessfullBackwardCoverings();
            if (bl) {
                this.mTraceCheckBenchmarkGenerator.reportPerfectInterpolantSequences();
            }
            this.mTraceCheckBenchmarkGenerator.addBackwardCoveringInformation(backwardCoveringInformation);
            return bl;
        }
        return false;
    }
}

