/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomatonFilteredStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.TransitionConsistencyCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.StateRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.ReachableStatesCopy;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.Set;

public final class RemoveDeadEnds<LETTER, STATE>
extends StateRemoval<LETTER, STATE> {
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mReach;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mResult;

    public RemoveDeadEnds(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider);
        try {
            this.mReach = new NestedWordAutomatonReachableStates(this.mServices, this.mOperand);
            this.mReach.computeDeadEnds();
            this.mResult = new DoubleDeckerAutomatonFilteredStates<LETTER, STATE>(this.mServices, this.mReach, this.mReach.getWithOutDeadEnds());
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            String string = "removing dead ends from automaton with " + this.mOperand.size() + " states.";
            automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
            throw automataOperationCanceledException;
        }
        this.printExitMessage();
        assert (new TransitionConsistencyCheck<LETTER, STATE>(this.mResult).consistentForAll());
    }

    @Override
    public IDoubleDeckerAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    protected NestedWordAutomatonReachableStates<LETTER, STATE> getReach() {
        return this.mReach;
    }

    public int getInputSize() {
        return this.mReach.size();
    }

    @Override
    protected void modifyReachableStatesCopyForCheckResult(ReachableStatesCopy<LETTER, STATE> reachableStatesCopy) throws AutomataOperationCanceledException {
        reachableStatesCopy.removeDeadEnds();
    }

    @Override
    protected boolean checkDownStates(STATE STATE, DoubleDeckerAutomaton<LETTER, STATE> doubleDeckerAutomaton, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
        Set<STATE> set = doubleDeckerAutomaton.getDownStates(STATE);
        Set set2 = nestedWordAutomatonReachableStates.getWithOutDeadEnds().getDownStates(STATE, NestedWordAutomatonReachableStates.DoubleDeckerReachability.REACHABLE_AFTER_REMOVAL_OF_PRECIOUS_NOT_REACHERS);
        boolean bl = set.containsAll(set2);
        assert (bl);
        return bl;
    }

    @Override
    protected boolean checkResultFurther(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) throws AutomataOperationCanceledException {
        return this.checkAllStatesAreInReachableStatesCopy(iDoubleDeckerAutomaton);
    }
}

