/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.AuxVarGen;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphOracleAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator.SystemState;
import de.uni_freiburg.informatik.ultimate.reqtotest.testgenerator.TestGeneratorResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class CounterExampleToTest {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final Req2TestReqSymbolTable mReqSymbolTable;
    private final AuxVarGen mAuxVarGen;

    public CounterExampleToTest(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, Req2TestReqSymbolTable req2TestReqSymbolTable, AuxVarGen auxVarGen) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mReqSymbolTable = req2TestReqSymbolTable;
        this.mAuxVarGen = auxVarGen;
    }

    public IResult convertCounterExampleToTest(IResult iResult) {
        if (iResult instanceof CounterExampleResult) {
            return this.transformCounterExampleToExecutionSteps((CounterExampleResult)iResult);
        }
        if (iResult instanceof TimeoutResultAtElement) {
            return this.transformTimeOutResult((TimeoutResultAtElement)iResult);
        }
        if (iResult instanceof PositiveResult) {
            return this.transformPositiveResult((PositiveResult)iResult);
        }
        return null;
    }

    private IResult transformTimeOutResult(TimeoutResultAtElement<?> timeoutResultAtElement) {
        IElement iElement = timeoutResultAtElement.getElement();
        if (ReqGraphOracleAnnotation.getAnnotation(iElement) != null) {
            ReqGraphOracleAnnotation reqGraphOracleAnnotation = ReqGraphOracleAnnotation.getAnnotation(iElement);
            String string = String.format("Found no Test for (TIMEOUT): %s (%s)", reqGraphOracleAnnotation.getOracleVars(), reqGraphOracleAnnotation.getRequirementAut().getName());
            return new GenericResult("TestGen", string, string, IResultWithSeverity.Severity.WARNING);
        }
        return null;
    }

    private IResult transformPositiveResult(PositiveResult<?> positiveResult) {
        IElement iElement = positiveResult.getElement();
        if (ReqGraphOracleAnnotation.getAnnotation(iElement) != null) {
            ReqGraphOracleAnnotation reqGraphOracleAnnotation = ReqGraphOracleAnnotation.getAnnotation(iElement);
            String string = String.format("There is no test for (SAFE): %s (%s)", reqGraphOracleAnnotation.getOracleVars(), reqGraphOracleAnnotation.getRequirementAut().getName());
            return new GenericResult("TestGen", string, string, IResultWithSeverity.Severity.WARNING);
        }
        return null;
    }

    private IResult transformCounterExampleToExecutionSteps(CounterExampleResult<?, ?, ?> counterExampleResult) {
        IProgramExecution iProgramExecution = this.mServices.getBacktranslationService().translateProgramExecution(counterExampleResult.getProgramExecution());
        ArrayList<SystemState> arrayList = new ArrayList<SystemState>();
        ArrayList<List<ReqGraphAnnotation>> arrayList2 = new ArrayList<List<ReqGraphAnnotation>>();
        ArrayList<ReqGraphAnnotation> arrayList3 = new ArrayList<ReqGraphAnnotation>();
        ReqGraphOracleAnnotation reqGraphOracleAnnotation = null;
        int n = 0;
        while (n < iProgramExecution.getLength()) {
            block7: {
                IElement iElement;
                block6: {
                    AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(n);
                    iElement = (IElement)atomicTraceElement.getTraceElement();
                    if (!this.isTestPurposeAssertion(iElement)) break block6;
                    if (iProgramExecution.getProgramState(n) == null) break block7;
                    arrayList.add(this.generateSystemState((IProgramExecution.ProgramState<Expression>)iProgramExecution.getProgramState(n)));
                    arrayList2.add(arrayList3);
                    arrayList3 = new ArrayList();
                }
                if (ReqGraphAnnotation.getAnnotation(iElement) != null) {
                    arrayList3.add(ReqGraphAnnotation.getAnnotation(iElement));
                }
                if (ReqGraphOracleAnnotation.getAnnotation(iElement) != null) {
                    reqGraphOracleAnnotation = ReqGraphOracleAnnotation.getAnnotation(iElement);
                }
            }
            ++n;
        }
        this.mLogger.warn((Object)("Oracle: " + reqGraphOracleAnnotation.getAnnotationsAsMap().toString()));
        TestGeneratorResult testGeneratorResult = new TestGeneratorResult(this.mLogger, arrayList, arrayList2, reqGraphOracleAnnotation, this.mReqSymbolTable, this.mAuxVarGen);
        return testGeneratorResult;
    }

    private boolean isTestPurposeAssertion(IElement iElement) {
        NamedAttribute[] namedAttributeArray;
        if (iElement instanceof AssertStatement && (namedAttributeArray = ((AssertStatement)iElement).getAttributes()) != null && namedAttributeArray.length > 0) {
            NamedAttribute[] namedAttributeArray2 = namedAttributeArray;
            int n = namedAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedAttribute namedAttribute = namedAttributeArray2[n2];
                if (namedAttribute.getName() == "TEST_ORACLE_MARKER") {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private SystemState generateSystemState(IProgramExecution.ProgramState<Expression> programState) {
        LinkedHashMap<Expression, Collection<Expression>> linkedHashMap = new LinkedHashMap<Expression, Collection<Expression>>();
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        float f = 0.0f;
        for (Expression expression : programState.getVariables()) {
            if (expression instanceof IdentifierExpression && !this.mReqSymbolTable.isAuxVar(((IdentifierExpression)expression).getIdentifier())) {
                linkedHashMap.put(expression, programState.getValues((Object)expression));
                linkedHashSet.add(expression);
            }
            if (!(expression instanceof IdentifierExpression) || !((IdentifierExpression)expression).getIdentifier().equals("reqtotest_delta")) continue;
            Expression expression2 = programState.getValues((Object)expression).toArray(new Expression[programState.getValues((Object)expression).size()])[0];
            if (expression2 instanceof RealLiteral) {
                f = Float.parseFloat(((RealLiteral)expression2).getValue());
                continue;
            }
            if (!(expression2 instanceof IntegerLiteral)) continue;
            f = Float.parseFloat(((IntegerLiteral)expression2).getValue());
        }
        return new SystemState(linkedHashMap, f);
    }
}

