/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.AtomQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.CuckooHashSet;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DPLLEngine {
    private final LogProxy mLogger;
    public static final int COMPLETE = 0;
    public static final int INCOMPLETE_QUANTIFIER = 1;
    public static final int INCOMPLETE_THEORY = 2;
    public static final int INCOMPLETE_MEMOUT = 3;
    public static final int INCOMPLETE_UNKNOWN = 4;
    public static final int INCOMPLETE_TIMEOUT = 5;
    public static final int INCOMPLETE_CHECK = 6;
    public static final int INCOMPLETE_CANCELLED = 7;
    private static final String[] COMPLETENESS_STRINGS = new String[]{"Complete", "Quantifier in Assertion Stack", "Theories with incomplete decision procedure used", "Not enough memory", "Unknown internal error", "Sat check timed out", "Incomplete check used", "User requested cancellation"};
    private int mCompleteness = 0;
    private int mPushPopLevel = 0;
    private final ScopedArrayList<DPLLAtom> mAtomList;
    private final SimpleList<Clause> mClauses = new SimpleList();
    private Clause mUnsatClause = null;
    private final Set<Literal> mAssumptionLiterals = new LinkedHashSet<Literal>();
    private int mConflicts;
    private int mDecides;
    private int mTProps;
    private int mProps;
    private int mNumSolvedAtoms;
    private int mNumClauses;
    private int mNumAxiomClauses;
    SimpleList<Clause> mLearnedClauses = new SimpleList();
    private long mPropTime;
    private long mPropClauseTime;
    private long mExplainTime;
    private long mSetTime;
    private long mCheckTime;
    private long mBacktrackTime;
    private int mNumRandomSplits;
    private boolean mHasModel;
    double mAtomScale = 0.09090909090909094;
    double mClsScale = 0.00990099009900991;
    Clause.WatchList mPendingWatcherList = new Clause.WatchList();
    ArrayList<Literal> mDPLLStack = new ArrayList();
    private ITheory[] mTheories = new ITheory[0];
    private final AtomQueue mAtoms = new AtomQueue();
    private int mCurrentDecideLevel = 0;
    private int mBaseLevel = 0;
    private boolean mPGenabled = false;
    private ScopedHashMap<String, Literal> mAssignments;
    private final Random mRandom;
    private final TerminationRequest mCancel;

    public DPLLEngine(LogProxy logProxy, TerminationRequest terminationRequest) {
        assert (logProxy != null);
        this.mLogger = logProxy;
        this.mAtomList = new ScopedArrayList();
        this.mRandom = new Random();
        this.mCancel = terminationRequest;
    }

    public int getDecideLevel() {
        return this.mCurrentDecideLevel;
    }

    public void insertPropagatedLiteral(ITheory iTheory, Literal literal, int n) {
        DPLLAtom dPLLAtom;
        assert (literal.getAtom().mDecideStatus == null);
        assert (!this.mDPLLStack.contains(literal));
        assert (!this.mDPLLStack.contains(literal.negate()));
        assert (iTheory != null) : "Decision in propagation!!!";
        assert (this.checkDecideLevel());
        int n2 = this.mDPLLStack.size();
        int n3 = this.mCurrentDecideLevel;
        while (n3 > n) {
            dPLLAtom = this.mDPLLStack.get(--n2).getAtom();
            if (dPLLAtom.mExplanation == null) {
                --n3;
            }
            ++dPLLAtom.mStackPosition;
        }
        this.mDPLLStack.add(n2, literal);
        dPLLAtom = literal.getAtom();
        this.mAtomList.add(dPLLAtom);
        assert (!this.mAtoms.contains(dPLLAtom));
        dPLLAtom.mDecideLevel = n;
        dPLLAtom.mStackPosition = n2;
        dPLLAtom.mLastStatus = dPLLAtom.mDecideStatus = literal;
        dPLLAtom.mExplanation = iTheory;
        if (n <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(literal);
        }
        assert (this.checkDecideLevel());
    }

    public void insertPropagatedLiteralBefore(ITheory iTheory, Literal literal, Literal literal2) {
        DPLLAtom dPLLAtom = literal2.getAtom();
        assert (this.mDPLLStack.get(dPLLAtom.getStackPosition()).getAtom() == dPLLAtom);
        assert (dPLLAtom.mDecideStatus != null);
        assert (dPLLAtom.getStackPosition() >= 0);
        assert (literal.getAtom().mDecideStatus == null);
        assert (!this.mDPLLStack.contains(literal));
        assert (!this.mDPLLStack.contains(literal.negate()));
        assert (iTheory != null) : "Decision in propagation!!!";
        assert (this.checkDecideLevel());
        int n = dPLLAtom.getStackPosition();
        int n2 = dPLLAtom.getDecideLevel();
        if (dPLLAtom.mExplanation == null) {
            --n2;
        }
        this.mDPLLStack.add(n, literal);
        int n3 = n + 1;
        while (n3 < this.mDPLLStack.size()) {
            assert (this.mDPLLStack.get(n3).getAtom().getStackPosition() == n3 - 1);
            this.mDPLLStack.get((int)n3).getAtom().mStackPosition = n3;
            ++n3;
        }
        DPLLAtom dPLLAtom2 = literal.getAtom();
        this.mAtomList.add(dPLLAtom2);
        assert (!this.mAtoms.contains(dPLLAtom2));
        dPLLAtom2.mDecideLevel = n2;
        dPLLAtom2.mStackPosition = n;
        dPLLAtom2.mLastStatus = dPLLAtom2.mDecideStatus = literal;
        dPLLAtom2.mExplanation = iTheory;
        if (n2 <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(literal);
        }
        assert (this.checkDecideLevel());
    }

    private Clause propagateInternal() {
        while (true) {
            Clause clause;
            if ((clause = this.propagateTheories()) != null) {
                return clause;
            }
            int n = this.mDPLLStack.size();
            int n2 = this.mAtoms.size();
            clause = this.propagateClauses();
            if (clause != null) {
                return clause;
            }
            if (this.mDPLLStack.size() > n) continue;
            long l = 0L;
            l = System.nanoTime();
            this.mLogger.debug("DPLL: checkpoint");
            ITheory[] iTheoryArray = this.mTheories;
            int n3 = this.mTheories.length;
            int n4 = 0;
            while (n4 < n3) {
                ITheory iTheory = iTheoryArray[n4];
                clause = iTheory.checkpoint();
                if (clause != null) {
                    return clause;
                }
                ++n4;
            }
            this.mCheckTime += System.nanoTime() - l;
            clause = this.propagateTheories();
            if (clause != null) {
                return clause;
            }
            if (this.mDPLLStack.size() == n && this.mAtoms.size() == n2) break;
        }
        return null;
    }

    private Clause propagateTheories() {
        boolean bl;
        do {
            bl = false;
            this.mLogger.debug("DPLL: propagate theories");
            ITheory[] iTheoryArray = this.mTheories;
            int n = this.mTheories.length;
            int n2 = 0;
            while (n2 < n) {
                ITheory iTheory = iTheoryArray[n2];
                Literal literal = iTheory.getPropagatedLiteral();
                if (literal != null) {
                    do {
                        Clause clause;
                        if (literal.mAtom.mDecideStatus == null) {
                            ++this.mTProps;
                            if (literal.mAtom.mExplanation == null) {
                                literal.mAtom.mExplanation = iTheory;
                            }
                            if ((clause = this.setLiteral(literal)) == null) continue;
                            Literal[] literalArray = clause.mLiterals;
                            int n3 = clause.mLiterals.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Literal literal2 = literalArray[n4];
                                DPLLAtom dPLLAtom = literal2.getAtom();
                                assert (dPLLAtom.mDecideStatus == literal2.negate());
                                ++n4;
                            }
                            return clause;
                        }
                        if (literal.mAtom.mDecideStatus == literal) continue;
                        clause = iTheory.getUnitClause(literal);
                        return clause;
                    } while ((literal = iTheory.getPropagatedLiteral()) != null);
                    bl = true;
                }
                ++n2;
            }
        } while (bl);
        return null;
    }

    private Clause propagateClauses() {
        long l = 0L;
        l = System.nanoTime() - this.mSetTime;
        block0: while (!this.mPendingWatcherList.isEmpty()) {
            Literal literal;
            int n = this.mPendingWatcherList.getIndex();
            Clause clause = this.mPendingWatcherList.removeFirst();
            if (clause.mNext == null) continue;
            Literal[] literalArray = clause.mLiterals;
            if (n < literalArray.length) {
                literal = literalArray[n];
                if (literal.getAtom().getDecideStatus() != literal.negate()) {
                    literal.mWatchers.append(clause, n);
                    continue;
                }
            } else assert (n == 1 && literalArray.length == 1);
            literal = literalArray[1 - n];
            DPLLAtom dPLLAtom = literal.getAtom();
            if (dPLLAtom.mDecideStatus == literal) {
                dPLLAtom.mBacktrackWatchers.append(clause, n);
                continue;
            }
            int n2 = 2;
            while (n2 < literalArray.length) {
                Literal literal2 = literalArray[n2];
                DPLLAtom dPLLAtom2 = literal2.getAtom();
                Literal literal3 = dPLLAtom2.mDecideStatus;
                if (literal3 != literal2.negate()) {
                    if (clause.mActivity < this.mClsScale * 1.0E-150 && literal3 == null && clause.doCleanup(this)) {
                        clause.removeFromList();
                        continue block0;
                    }
                    int n3 = n2;
                    while (n3 > 2) {
                        literalArray[n3] = literalArray[n3 - 1];
                        --n3;
                    }
                    literalArray[2] = literalArray[n];
                    literalArray[n] = literal2;
                    literal2.mWatchers.append(clause, n);
                    continue block0;
                }
                ++n2;
            }
            if (dPLLAtom.mDecideStatus == null) {
                dPLLAtom.mBacktrackWatchers.append(clause, n);
                dPLLAtom.mExplanation = clause;
                ++this.mProps;
                clause = this.setLiteral(literal);
            } else {
                this.mPendingWatcherList.append(clause, n);
            }
            this.mPropClauseTime += System.nanoTime() - l - this.mSetTime;
            return clause;
        }
        this.mPropClauseTime += System.nanoTime() - l - this.mSetTime;
        return null;
    }

    private boolean checkConflict(Clause clause) {
        Literal[] literalArray = clause.mLiterals;
        int n = clause.mLiterals.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal = literalArray[n2];
            DPLLAtom dPLLAtom = literal.getAtom();
            assert (dPLLAtom.mDecideStatus == literal.negate());
            ++n2;
        }
        return true;
    }

    public Clause setLiteral(Literal literal) {
        this.mLogger.debug("S %s", literal);
        DPLLAtom dPLLAtom = literal.getAtom();
        assert (dPLLAtom.mDecideStatus == null);
        assert (this.mAtoms.contains(dPLLAtom));
        dPLLAtom.mStackPosition = this.mDPLLStack.size();
        this.mDPLLStack.add(literal);
        dPLLAtom.mDecideLevel = this.mCurrentDecideLevel;
        dPLLAtom.mDecideStatus = literal;
        if (!dPLLAtom.preferredStatusIsLocked()) {
            dPLLAtom.mLastStatus = dPLLAtom.mDecideStatus;
        }
        this.mAtoms.remove(dPLLAtom);
        this.mPendingWatcherList.moveAll(literal.negate().mWatchers);
        long l = System.nanoTime();
        Clause clause = null;
        if (this.mCurrentDecideLevel <= this.mBaseLevel) {
            ++this.mNumSolvedAtoms;
            this.generateLevel0Proof(literal);
        }
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            clause = iTheory.setLiteral(literal);
            if (clause != null) {
                assert (this.checkConflict(clause));
                break;
            }
            ++n2;
        }
        this.mSetTime += System.nanoTime() - l;
        return clause;
    }

    public void watchClause(Clause clause) {
        if (clause.getSize() <= 1) {
            if (clause.getSize() == 0) {
                if (this.mUnsatClause == null) {
                    this.mUnsatClause = clause;
                }
            } else {
                this.mPendingWatcherList.append(clause, 1);
            }
        } else {
            this.mPendingWatcherList.append(clause, 0);
            this.mPendingWatcherList.append(clause, 1);
        }
    }

    public void addClause(Clause clause) {
        this.mAtomScale += 0.09090909090909094;
        clause.mActivity = Double.POSITIVE_INFINITY;
        ++this.mNumAxiomClauses;
        assert (clause.mStacklevel == this.mPushPopLevel);
        this.mClauses.prepend(clause);
        this.watchClause(clause);
    }

    void removeClause(Clause clause) {
        clause.removeFromList();
    }

    public void addFormulaClause(Literal[] literalArray, ProofNode proofNode) {
        this.addFormulaClause(literalArray, proofNode, null);
    }

    public void addFormulaClause(Literal[] literalArray, ProofNode proofNode, ClauseDeletionHook clauseDeletionHook) {
        Clause clause = new Clause(literalArray, this.mPushPopLevel);
        clause.setDeletionHook(clauseDeletionHook);
        this.addClause(clause);
        if (this.isProofGenerationEnabled()) {
            assert (proofNode instanceof LeafNode);
            clause.setProof(proofNode);
        }
        this.mLogger.trace("Added clause %s", clause);
    }

    public void learnClause(Clause clause) {
        this.mAtomScale += 0.09090909090909094;
        ++this.mNumClauses;
        clause.mActivity = this.mClsScale;
        if (clause.getSize() <= 2) {
            clause.mActivity = Double.POSITIVE_INFINITY;
        }
        this.mLearnedClauses.append(clause);
        this.watchClause(clause);
    }

    private boolean checkDecideLevel() {
        int n = 0;
        int n2 = 0;
        for (Literal literal : this.mDPLLStack) {
            if (literal.getAtom().mExplanation == null) {
                ++n;
            }
            assert (literal.getAtom().mStackPosition == n2);
            assert (literal.getAtom().mDecideLevel == n);
            ++n2;
        }
        return n == this.mCurrentDecideLevel;
    }

    private int countLitsOnDecideLevel(Set<Literal> set) {
        Literal literal;
        int n = 0;
        int n2 = this.mDPLLStack.size();
        do {
            literal = this.mDPLLStack.get(--n2);
            assert (!set.contains(literal.negate()));
            if (!set.contains(literal)) continue;
            ++n;
        } while (literal.getAtom().mExplanation != null);
        return n;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Clause explainConflict(Clause var1_1) {
        this.mLogger.debug("explain conflict %s", new Object[]{var1_1});
        var2_2 = new HashSet<Literal>();
        var3_3 = null;
        if (this.isProofGenerationEnabled()) {
            var3_3 = new ArrayList<ResolutionNode.Antecedent>();
        }
        var4_4 = var1_1.mStacklevel;
        ++this.mConflicts;
        if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
            throw new AssertionError();
        }
        this.mAtomScale *= 1.1;
        this.mClsScale *= 1.01;
        var5_5 = new CuckooHashSet<Literal>();
        var6_6 = this.mBaseLevel + 1;
        var7_7 = 0;
        var8_8 = 0;
        var12_9 = var1_1.mLiterals;
        var11_10 = var1_1.mLiterals.length;
        var10_15 = 0;
        while (var10_15 < var11_10) {
            var9_20 = var12_9[var10_15];
            var13_21 = var9_20.getAtom();
            if (!DPLLEngine.$assertionsDisabled && var13_21.mDecideStatus != var9_20.negate()) {
                throw new AssertionError();
            }
            if (var13_21.mDecideLevel > this.mBaseLevel) {
                if (var13_21.mDecideLevel >= var6_6) {
                    if (var13_21.mDecideLevel > var6_6) {
                        var6_6 = var13_21.mDecideLevel;
                        var7_7 = 1;
                    } else {
                        ++var7_7;
                    }
                }
                var5_5.add(var9_20.negate());
            } else if (this.mAssumptionLiterals.contains(var9_20.negate())) {
                var5_5.add(var9_20.negate());
                ++var8_8;
            } else {
                var4_4 = this.level0resolve((Literal)var9_20, var2_2, var4_4);
            }
            var13_21.mActivity += this.mAtomScale;
            ++var10_15;
        }
        this.mLogger.debug("removing level0: %s", new Object[]{var5_5});
        if (var5_5.size() == var8_8) {
            for (Object var9_20 : var2_2) {
                var11_11 = this.getLevel0((Literal)var9_20);
                var15_31 = var11_11.mLiterals;
                var14_25 = var11_11.mLiterals.length;
                var13_22 = 0;
                while (var13_22 < var14_25) {
                    var12_9 = var15_31[var13_22];
                    if (var12_9 != var9_20) {
                        var5_5.add(var12_9.negate());
                    }
                    ++var13_22;
                }
            }
            var9_20 = new Literal[var5_5.size()];
            var10_17 = 0;
            for (Literal var11_12 : var5_5) {
                var9_20[var10_17++] = var11_12.negate();
            }
            if (!DPLLEngine.$assertionsDisabled && var10_17 != ((Object)var9_20).length) {
                throw new AssertionError();
            }
            var11_13 = new Clause((Literal[])var9_20, var4_4);
            if (this.isProofGenerationEnabled()) {
                for (Object var12_9 : var2_2) {
                    var3_3.add(new ResolutionNode.Antecedent((Literal)var12_9, this.getLevel0((Literal)var12_9)));
                }
                if (var3_3.isEmpty()) {
                    var11_13.setProof(var1_1.getProof());
                } else {
                    var12_9 = var3_3.toArray(new ResolutionNode.Antecedent[var3_3.size()]);
                    var11_13.setProof(new ResolutionNode(var1_1, (ResolutionNode.Antecedent[])var12_9));
                }
            }
            this.mUnsatClause = var11_13;
            return var11_13;
        }
        if (DPLLEngine.$assertionsDisabled || var7_7 >= true) ** GOTO lbl88
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            var9_20 = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            if (!DPLLEngine.$assertionsDisabled && var5_5.contains(var9_20.negate())) {
                throw new AssertionError();
            }
            if (!DPLLEngine.$assertionsDisabled && var5_5.contains(var9_20)) {
                throw new AssertionError();
            }
            this.backtrackLiteral((Literal)var9_20);
            if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                throw new AssertionError();
            }
lbl88:
            // 3 sources

            ** while (this.mCurrentDecideLevel > var6_6)
        }
lbl89:
        // 3 sources

        while (var7_7 > 1) {
            if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                throw new AssertionError();
            }
            if (!DPLLEngine.$assertionsDisabled && this.mCurrentDecideLevel != var6_6) {
                throw new AssertionError();
            }
            if (!DPLLEngine.$assertionsDisabled && this.countLitsOnDecideLevel(var5_5) != var7_7) {
                throw new AssertionError();
            }
            if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                throw new AssertionError();
            }
            var9_20 = this.mDPLLStack.get(this.mDPLLStack.size() - 1);
            if (!DPLLEngine.$assertionsDisabled && var5_5.contains(var9_20.negate())) {
                throw new AssertionError();
            }
            if (!var5_5.contains(var9_20)) {
                if (!DPLLEngine.$assertionsDisabled && var9_20.getAtom().mExplanation == null) {
                    throw new AssertionError();
                }
                if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                    throw new AssertionError();
                }
                this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
                this.backtrackLiteral((Literal)var9_20);
                if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                    throw new AssertionError();
                }
                continue;
            }
            var10_18 = this.getExplanation((Literal)var9_20);
            var10_18.mActivity += this.mClsScale;
            var4_4 = Math.max(var4_4, var10_18.mStacklevel);
            if (this.isProofGenerationEnabled()) {
                var3_3.add(new ResolutionNode.Antecedent((Literal)var9_20, var10_18));
            }
            this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral((Literal)var9_20);
            if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                throw new AssertionError();
            }
            var5_5.remove(var9_20);
            --var7_7;
            var11_14 = var9_20.getAtom();
            this.mLogger.debug("Resolving with %s pivot = %s", new Object[]{var10_18, var11_14});
            var15_32 = var10_18.mLiterals;
            var14_26 = var10_18.mLiterals.length;
            var13_23 = 0;
            while (var13_23 < var14_26) {
                var12_9 = var15_32[var13_23];
                if (var12_9 != var9_20) {
                    if (!DPLLEngine.$assertionsDisabled && var12_9.getAtom().mDecideStatus != var12_9.negate()) {
                        throw new AssertionError();
                    }
                    var16_36 = var12_9.getAtom().mDecideLevel;
                    if (this.mAssumptionLiterals.contains(var12_9.negate())) {
                        if (var5_5.add(var12_9.negate())) {
                            ++var8_8;
                        }
                    } else if (var16_36 > this.mBaseLevel) {
                        if (var5_5.add(var12_9.negate()) && var16_36 == var6_6) {
                            ++var7_7;
                        }
                    } else {
                        var4_4 = this.level0resolve((Literal)var12_9, var2_2, var4_4);
                    }
                    var12_9.getAtom().mActivity += this.mAtomScale;
                }
                ++var13_23;
            }
            if (!DPLLEngine.$assertionsDisabled && this.countLitsOnDecideLevel(var5_5) != var7_7) {
                throw new AssertionError();
            }
            this.mLogger.debug("new conflict: %s", new Object[]{var5_5});
        }
        if (!DPLLEngine.$assertionsDisabled && this.mCurrentDecideLevel != var6_6) {
            throw new AssertionError();
        }
        if (!DPLLEngine.$assertionsDisabled && this.countLitsOnDecideLevel(var5_5) != var7_7) {
            throw new AssertionError();
        }
        if (DPLLEngine.$assertionsDisabled || var7_7 == 1) ** GOTO lbl165
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            var9_20 = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            if (!DPLLEngine.$assertionsDisabled && var5_5.contains(var9_20.negate())) {
                throw new AssertionError();
            }
            this.backtrackLiteral((Literal)var9_20);
            if (!DPLLEngine.$assertionsDisabled && !this.checkDecideLevel()) {
                throw new AssertionError();
            }
lbl165:
            // 3 sources

            ** while (this.mCurrentDecideLevel >= var6_6)
        }
lbl166:
        // 1 sources

        this.findBacktrackingPoint(var5_5);
        this.mLogger.debug("Backtrack to %d", new Object[]{this.mDPLLStack.size()});
        var9_20 = this.computeRedundancy(var5_5);
        var10_19 = 1;
        var11_10 = this.mDPLLStack.size();
        while (var11_10 > this.mNumSolvedAtoms) {
            if (var9_20.get(var12_9 = this.mDPLLStack.get(--var11_10)) != var10_19 || !var5_5.contains(var12_9)) continue;
            var13_21 = this.getExplanation((Literal)var12_9);
            var13_21.mActivity += this.mClsScale;
            var4_4 = Math.max(var4_4, var13_21.mStacklevel);
            if (this.isProofGenerationEnabled()) {
                var3_3.add(new ResolutionNode.Antecedent((Literal)var12_9, (Clause)var13_21));
            }
            var5_5.remove(var12_9);
            var17_38 = var13_21.mLiterals;
            var16_36 = var13_21.mLiterals.length;
            var15_33 = 0;
            while (var15_33 < var16_36) {
                var14_27 = var17_38[var15_33];
                if (var14_27 != var12_9) {
                    if (!DPLLEngine.$assertionsDisabled && var14_27.getAtom().mDecideStatus != var14_27.negate()) {
                        throw new AssertionError();
                    }
                    var18_40 = var14_27.getAtom().mDecideLevel;
                    if (this.mAssumptionLiterals.contains(var14_27.negate())) {
                        if (var5_5.add(var14_27.negate())) {
                            ++var8_8;
                        }
                    } else if (var18_40 > this.mBaseLevel) {
                        var5_5.add(var14_27.negate());
                    } else {
                        var4_4 = this.level0resolve(var14_27, var2_2, var4_4);
                    }
                    var14_27.getAtom().mActivity += this.mAtomScale;
                }
                ++var15_33;
            }
        }
        this.mLogger.debug("removing redundancy yields %s", new Object[]{var5_5});
        for (Object var12_9 : var2_2) {
            var14_28 = this.getLevel0((Literal)var12_9);
            var18_41 = var14_28.mLiterals;
            var17_39 = var14_28.mLiterals.length;
            var16_36 = 0;
            while (var16_36 < var17_39) {
                var15_34 = var18_41[var16_36];
                if (var15_34 != var12_9) {
                    var5_5.add(var15_34.negate());
                }
                ++var16_36;
            }
        }
        var12_9 = new Literal[var5_5.size()];
        var13_24 = 0;
        for (Literal var14_29 : var5_5) {
            var12_9[var13_24++] = var14_29.negate();
        }
        if (!DPLLEngine.$assertionsDisabled && var12_9[((Object)var12_9).length - 1] == null) {
            throw new AssertionError();
        }
        var14_30 = new Clause((Literal[])var12_9, var4_4);
        if (this.isProofGenerationEnabled()) {
            for (ResolutionNode.Antecedent[] var15_35 : var2_2) {
                var3_3.add(new ResolutionNode.Antecedent((Literal)var15_35, this.getLevel0((Literal)var15_35)));
            }
            if (var3_3.isEmpty()) {
                var14_30.setProof(var1_1.getProof());
            } else {
                var15_35 = var3_3.toArray(new ResolutionNode.Antecedent[var3_3.size()]);
                var14_30.setProof(new ResolutionNode(var1_1, var15_35));
            }
        }
        this.mLogger.debug("Resolved to %s", new Object[]{var14_30});
        if (((Object)var12_9).length == var8_8) {
            this.mUnsatClause = var14_30;
        }
        return var14_30;
    }

    private boolean explain(Clause clause) {
        while (clause != null) {
            this.startBacktrack();
            clause = this.explainConflict(clause);
            this.learnClause(clause);
            if (this.mUnsatClause != null) {
                return true;
            }
            clause = this.finalizeBacktrack();
        }
        return false;
    }

    private final int level0resolve(Literal literal, Set<Literal> set, int n) {
        Clause clause = this.getLevel0(literal.negate());
        set.add(literal.negate());
        return clause.mStacklevel > n ? clause.mStacklevel : n;
    }

    private Clause getExplanation(Literal literal) {
        Object object = literal.getAtom().mExplanation;
        if (object instanceof ITheory) {
            Clause clause = ((ITheory)object).getUnitClause(literal);
            literal.getAtom().mExplanation = clause;
            assert (this.checkUnitClause(clause, literal));
            assert (this.checkDecideLevel());
            return clause;
        }
        assert (object == null || this.checkUnitClause((Clause)object, literal));
        return (Clause)object;
    }

    private HashMap<Literal, Integer> computeRedundancy(Set<Literal> set) {
        Integer n = 1;
        Integer n2 = 2;
        Integer n3 = 3;
        HashMap<Literal, Integer> hashMap = new HashMap<Literal, Integer>();
        for (Literal object2 : set) {
            if (object2.getAtom().getDecideStatus() == null) continue;
            assert (object2.getAtom().getDecideStatus() == object2);
            hashMap.put(object2, n);
        }
        ArrayDeque<Literal> arrayDeque = new ArrayDeque<Literal>();
        block1: for (Literal literal : set) {
            if (literal.getAtom().getDecideStatus() == null) continue;
            arrayDeque.addFirst(literal);
            block2: while (!arrayDeque.isEmpty()) {
                Literal literal2 = (Literal)arrayDeque.getFirst();
                assert (literal2.getAtom().getDecideStatus() == literal2);
                Clause clause = this.getExplanation(literal2);
                if (clause == null) {
                    while (arrayDeque.size() > 1) {
                        hashMap.put((Literal)arrayDeque.removeFirst(), n2);
                    }
                    hashMap.put((Literal)arrayDeque.removeFirst(), n3);
                    continue block1;
                }
                Literal[] literalArray = clause.mLiterals;
                int n4 = clause.mLiterals.length;
                int n5 = 0;
                while (n5 < n4) {
                    Literal literal3 = literalArray[n5];
                    assert (literal3.getAtom().getDecideStatus() != null);
                    if (literal3 != literal2 && literal3.getAtom().getDecideLevel() > this.mBaseLevel) {
                        Literal literal4 = literal3.negate();
                        assert (literal4.getAtom().getDecideStatus() == literal4);
                        Integer n6 = hashMap.get(literal4);
                        if (n6 == n2) {
                            while (arrayDeque.size() > 1) {
                                hashMap.put((Literal)arrayDeque.removeFirst(), n2);
                            }
                            hashMap.put((Literal)arrayDeque.removeFirst(), n3);
                            continue block1;
                        }
                        if (n6 == null) {
                            arrayDeque.addFirst(literal4);
                            continue block2;
                        }
                    }
                    ++n5;
                }
                hashMap.put((Literal)arrayDeque.removeFirst(), n);
            }
        }
        return hashMap;
    }

    private boolean checkUnitClause(Clause clause, Literal literal) {
        boolean bl = false;
        Literal[] literalArray = clause.mLiterals;
        int n = clause.mLiterals.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal2 = literalArray[n2];
            assert (literal2 != literal.negate()) : "Negation of unit literal in explanation";
            if (literal2 == literal) {
                bl = true;
            } else assert (literal2.mAtom.mDecideStatus == literal2.negate() && literal2.mAtom.getStackPosition() < literal.getAtom().getStackPosition()) : "Not a unit clause: " + String.valueOf(literal2) + " in " + String.valueOf(clause);
            ++n2;
        }
        assert (bl) : "Unit literal not in explanation";
        return bl;
    }

    private void startBacktrack() {
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.backtrackStart();
            ++n2;
        }
    }

    private Clause finalizeBacktrack() {
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            Clause clause = iTheory.backtrackComplete();
            if (clause != null) {
                return clause;
            }
            ++n2;
        }
        return null;
    }

    private void findBacktrackingPoint(Set<Literal> set) {
        int n = this.mDPLLStack.size();
        while (n > 0) {
            Literal literal;
            if (set.contains(literal = this.mDPLLStack.get(--n))) break;
            if (literal.getAtom().mExplanation != null) continue;
            while (this.mDPLLStack.size() > n) {
                this.backtrackLiteral(this.mDPLLStack.remove(this.mDPLLStack.size() - 1));
            }
        }
    }

    public void backtrackLiteral(Literal literal) {
        this.mLogger.debug("B %s", literal);
        DPLLAtom dPLLAtom = literal.getAtom();
        long l = System.nanoTime();
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.backtrackLiteral(literal);
            ++n2;
        }
        this.mBacktrackTime += System.nanoTime() - l;
        this.mPendingWatcherList.moveAll(dPLLAtom.mBacktrackWatchers);
        if (dPLLAtom.mExplanation == null) {
            this.decreaseDecideLevel();
        }
        dPLLAtom.mExplanation = null;
        dPLLAtom.mDecideStatus = null;
        dPLLAtom.mDecideLevel = -1;
        dPLLAtom.mStackPosition = -1;
        this.mAtoms.add(dPLLAtom);
    }

    private Clause checkConsistency() {
        long l = 0L;
        l = System.nanoTime();
        this.mLogger.debug("DPLL: final check");
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            Clause clause = iTheory.computeConflictClause();
            if (clause != null) {
                return clause;
            }
            if (!this.mAtoms.isEmpty()) break;
            ++n2;
        }
        this.mCheckTime += System.nanoTime() - l;
        return null;
    }

    private Literal chooseLiteral() {
        Literal literal = this.suggestions();
        if (literal != null) {
            return literal;
        }
        DPLLAtom dPLLAtom = this.mAtoms.peek();
        if (dPLLAtom == null) {
            return null;
        }
        assert (dPLLAtom.mDecideStatus == null);
        return dPLLAtom.getPreferredStatus();
    }

    private static final int luby_super(int n) {
        assert (n > 0);
        int n2 = 2;
        while (n2 < n + 1) {
            n2 *= 2;
        }
        if (n2 == n + 1) {
            return n2 / 2;
        }
        return DPLLEngine.luby_super(n - n2 / 2 + 1);
    }

    private void printStatistics() {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("Confl: " + this.mConflicts + " Props: " + this.mProps + " Tprops: " + this.mTProps + " Decides: " + this.mDecides + " RSplits: " + this.mNumRandomSplits);
            this.mLogger.info("Times: Expl: " + (double)(this.mExplainTime / 1000L) / 1000.0 + " Prop: " + (double)(this.mPropTime / 1000L) / 1000.0 + " PropClause: " + (double)(this.mPropClauseTime / 1000L) / 1000.0 + " Set: " + (double)(this.mSetTime / 1000L) / 1000.0 + " Check: " + (double)(this.mCheckTime / 1000L) / 1000.0 + " Back: " + (double)(this.mBacktrackTime / 1000L) / 1000.0);
            this.mLogger.info("Atoms: " + this.mNumSolvedAtoms + "/" + (this.mAtoms.size() + this.mDPLLStack.size()) + " Clauses: " + this.mNumClauses + " Axioms: " + this.mNumAxiomClauses);
            ITheory[] iTheoryArray = this.mTheories;
            int n = this.mTheories.length;
            int n2 = 0;
            while (n2 < n) {
                ITheory iTheory = iTheoryArray[n2];
                iTheory.printStatistics(this.mLogger);
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean solve() {
        this.mHasModel = false;
        if (this.mUnsatClause != null) {
            this.mLogger.debug("Using cached unsatisfiability");
            return false;
        }
        try {
            var1_1 = new HashMap<Literal, Double>();
            var3_3 = this.mClauses.iterator();
lbl8:
            // 2 sources

            block8: while (true) {
                block42: {
                    if (var3_3.hasNext()) break block42;
                    var3_3 = this.mAtoms.iterator();
                    if (true) ** GOTO lbl54
                }
                var2_5 = var3_3.next();
                var4_8 = 1.0;
                var9_27 = var2_5.mLiterals;
                var8_19 = var2_5.mLiterals.length;
                var7_16 = 0;
                while (true) {
                    block43: {
                        if (var7_16 < var8_19) break block43;
                        var9_27 = var2_5.mLiterals;
                        var8_19 = var2_5.mLiterals.length;
                        var7_16 = 0;
                        if (true) ** GOTO lbl44
                    }
                    var6_12 = var9_27[var7_16];
                    var10_33 = var6_12.getAtom().getDecideStatus();
                    if (var10_33 == var6_12) continue block8;
                    if (var10_33 != var6_12.negate()) {
                        var4_8 /= 2.0;
                    }
                    ++var7_16;
                }
                break;
            }
        }
        catch (OutOfMemoryError v0) {
            this.setCompleteness(3);
        }
        do {
            if ((var10_33 = (var6_12 = var9_27[var7_16]).getAtom().getDecideStatus()) != var6_12.negate()) {
                var11_39 = (Double)var1_1.get(var6_12);
                if (var11_39 == null) {
                    var1_1.put(var6_12, var4_8);
                } else {
                    var1_1.put(var6_12, var11_39 + var4_8);
                }
            }
            ++var7_16;
lbl44:
            // 2 sources

        } while (var7_16 < var8_19);
        ** while (true)
        do {
            var2_7 = (DPLLAtom)var3_3.next();
            var4_10 = (Double)var1_1.get(var2_7);
            var5_50 = (Double)var1_1.get(var2_7.negate());
            var6_14 = var4_10 == null ? 0.0 : var4_10;
            v1 = var8_21 = var5_50 == null ? 0.0 : var5_50;
            if (var2_7.preferredStatusIsLocked()) continue;
            var2_7.setPreferredStatus(var6_14 > var8_21 ? var2_7 : var2_7.negate());
lbl54:
            // 3 sources

        } while (var3_3.hasNext());
        var1_2 = System.nanoTime() - this.mSetTime - this.mBacktrackTime;
        var6_15 = this.mTheories;
        var5_51 = this.mTheories.length;
        var4_11 = 0;
        while (var4_11 < var5_51) {
            var3_3 = var6_15[var4_11];
            var7_18 = var3_3.startCheck();
            if (this.explain(var7_18)) {
            }
            ++var4_11;
        }
        var3_4 = 1;
        var4_11 = 500;
        while (!this.isTerminationRequested()) {
            block46: {
                block41: {
                    while ((var7_18 = this.propagateInternal()) == null && !this.isTerminationRequested()) {
                        block45: {
                            block44: {
                                var5_52 = System.nanoTime();
                                this.mPropTime += var5_52 - var1_2 - this.mSetTime - this.mBacktrackTime;
                                var1_2 = var5_52 - this.mSetTime - this.mBacktrackTime;
                                var8_22 = this.chooseLiteral();
                                if (var8_22 != null) break block44;
                                var7_18 = this.checkConsistency();
                                if (var7_18 != null) break block45;
                                var10_35 = false;
                                if (true) ** GOTO lbl90
                            }
                            this.increaseDecideLevel();
                            ++this.mDecides;
                            var7_18 = this.setLiteral(var8_22);
                            break block45;
                            do {
                                if (var9_29.getAtom().mExplanation == null) {
                                    this.increaseDecideLevel();
                                    ++this.mDecides;
                                }
                                var7_18 = this.setLiteral(var9_29);
                                var10_35 = true;
lbl90:
                                // 2 sources

                            } while (var7_18 != null && (var9_29 = this.suggestions()) != null);
                            if (var10_35 || !this.mPendingWatcherList.isEmpty() || !this.mAtoms.isEmpty()) break block45;
                            if (!this.mLogger.isInfoEnabled()) break block41;
                            this.printStatistics();
                            this.mLogger.info("Hooray, we found a model:");
                            var14_83 = this.mTheories;
                            var13_82 = this.mTheories.length;
                            var12_78 = 0;
                            if (true) ** GOTO lbl120
                        }
                        if (var7_18 == null && !this.isTerminationRequested()) continue;
                    }
                    var5_53 = System.nanoTime();
                    this.mPropTime += var5_53 - var1_2 - this.mSetTime - this.mBacktrackTime;
                    var1_2 = var5_53 - this.mSetTime - this.mBacktrackTime;
                    if (this.explain(var7_18)) {
                        var5_53 = System.nanoTime();
                        this.mExplainTime += var5_53 - var1_2 - this.mSetTime - this.mBacktrackTime;
                        var1_2 = var5_53 - this.mSetTime - this.mBacktrackTime;
                        this.printStatistics();
                        this.mLogger.info("Formula is unsat");
                    }
                    var5_53 = System.nanoTime();
                    this.mExplainTime += var5_53 - var1_2 - this.mSetTime - this.mBacktrackTime;
                    var1_2 = var5_53 - this.mSetTime - this.mBacktrackTime;
                    if (!(this.mAtomScale > 1.0E250)) break block46;
                    var9_30 = this.mAtoms.iterator();
                    if (true) ** GOTO lbl131
                    do {
                        var11_41 = var14_83[var12_78];
                        var11_41.dumpModel(this.mLogger);
                        ++var12_78;
lbl120:
                        // 2 sources

                    } while (var12_78 < var13_82);
                    if (this.mLogger.isTraceEnabled()) {
                        for (Literal var11_43 : this.mDPLLStack) {
                            this.mLogger.trace("%d: %s", new Object[]{var11_43.hashCode(), var11_43});
                        }
                    }
                }
                this.mHasModel = true;
                return this.mHasModel;
                do {
                    var8_23 = var9_30.next();
                    var8_23.mActivity *= 2.2250738585072014E-308;
lbl131:
                    // 2 sources

                } while (var9_30.hasNext());
                for (Literal var8_24 : this.mDPLLStack) {
                    var8_24.getAtom().mActivity *= 2.2250738585072014E-308;
                }
                this.mAtomScale *= 2.2250738585072014E-308;
            }
            if (this.mClsScale > 1.0E250) {
                for (Clause var9_31 : this.mLearnedClauses) {
                    var9_31.mActivity *= 2.2250738585072014E-308;
                }
                this.mClsScale *= 2.2250738585072014E-308;
            }
            if (--var4_11 == 0) {
                this.startBacktrack();
                var8_26 = this.mAtoms.peek();
                var9_32 = -1;
                var10_36 = this.mNumSolvedAtoms + this.mBaseLevel;
                while (var10_36 < this.mDPLLStack.size()) {
                    var11_45 = this.mDPLLStack.get(var10_36).getAtom();
                    if (var11_45.mExplanation == null && var11_45.mActivity < var8_26.mActivity) {
                        var9_32 = var10_36;
                        break;
                    }
                    ++var10_36;
                }
                if (var9_32 != -1) {
                    while (this.mDPLLStack.size() > var9_32) {
                        var10_37 = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
                        if (!DPLLEngine.$assertionsDisabled && var10_37.getAtom().mDecideLevel == this.mBaseLevel) {
                            throw new AssertionError();
                        }
                        var11_47 = var10_37.getAtom().mExplanation;
                        if (var11_47 instanceof Clause) {
                            ((Clause)var11_47).mActivity += this.mClsScale;
                        }
                        this.backtrackLiteral(var10_37);
                    }
                }
                this.unlearnClauses(this.mPushPopLevel);
                var7_18 = this.finalizeBacktrack();
                if (!DPLLEngine.$assertionsDisabled && var7_18 != null) {
                    throw new AssertionError();
                }
                ++var3_4;
                var13_81 = this.mTheories;
                var12_78 = this.mTheories.length;
                var11_48 = false;
                while (var11_49 < var12_78) {
                    var10_38 = var13_81[var11_49];
                    var10_38.restart(var3_4);
                    ++var11_49;
                }
                var4_11 = 500 * DPLLEngine.luby_super(var3_4);
                this.mLogger.info("Restart");
                this.printStatistics();
            }
            var1_2 = System.nanoTime() - this.mSetTime - this.mBacktrackTime;
        }
        finally {
            var19_58 = this.mTheories;
            var18_64 = this.mTheories.length;
            var17_70 = 0;
            ** while (var17_70 < var18_64)
        }
lbl-1000:
        // 1 sources

        {
            var16_76 = var19_58[var17_70];
            var16_76.endCheck();
            ++var17_70;
            continue;
        }
lbl192:
        // 1 sources

        return true;
    }

    private final void unlearnClauses(int n) {
        Iterator<Clause> iterator = this.mLearnedClauses.iterator();
        while (iterator.hasNext()) {
            Clause clause = iterator.next();
            if (!(clause.mActivity < this.mClsScale * 1.0E-150) && (clause.mStacklevel <= n || !clause.doCleanup(this))) continue;
            --this.mNumClauses;
            iterator.remove();
        }
    }

    private Literal suggestions() {
        Literal literal;
        ITheory iTheory;
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            iTheory = iTheoryArray[n2];
            literal = iTheory.getPropagatedLiteral();
            if (literal != null) {
                literal.mAtom.mExplanation = iTheory;
                assert (literal.getAtom().mDecideStatus == null);
                return literal;
            }
            ++n2;
        }
        iTheoryArray = this.mTheories;
        n = this.mTheories.length;
        n2 = 0;
        while (n2 < n) {
            iTheory = iTheoryArray[n2];
            literal = iTheory.getSuggestion();
            if (literal != null) {
                assert (literal.getAtom().mDecideStatus == null);
                return literal;
            }
            ++n2;
        }
        return null;
    }

    public void addAtom(DPLLAtom dPLLAtom) {
        this.mAtoms.add(dPLLAtom);
        this.mAtomList.add(dPLLAtom);
    }

    public void removeAtom(DPLLAtom dPLLAtom) {
        assert (dPLLAtom.mDecideStatus == null);
        this.mAtoms.remove(dPLLAtom);
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.removeAtom(dPLLAtom);
            ++n2;
        }
    }

    public void addTheory(ITheory iTheory) {
        ITheory[] iTheoryArray = new ITheory[this.mTheories.length + 1];
        System.arraycopy(this.mTheories, 0, iTheoryArray, 0, this.mTheories.length);
        iTheoryArray[this.mTheories.length] = iTheory;
        this.mTheories = iTheoryArray;
    }

    public void removeTheory() {
        ITheory[] iTheoryArray = new ITheory[this.mTheories.length - 1];
        System.arraycopy(this.mTheories, 0, iTheoryArray, 0, this.mTheories.length);
        this.mTheories = iTheoryArray;
    }

    public String dumpClauses(Theory theory) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Clause clause : this.mClauses) {
            stringBuilder.append("(assert ");
            Literal[] literalArray = clause.mLiterals;
            if (literalArray.length == 1) {
                stringBuilder.append(literalArray[0].getSMTFormula(theory)).append(")\n");
                continue;
            }
            stringBuilder.append("(or");
            Literal[] literalArray2 = literalArray;
            int n = literalArray.length;
            int n2 = 0;
            while (n2 < n) {
                Literal literal = literalArray2[n2];
                stringBuilder.append(' ').append(literal.getSMTFormula(theory));
                ++n2;
            }
            stringBuilder.append("))\n");
        }
        return stringBuilder.toString();
    }

    public void setCompleteness(int n) {
        this.mCompleteness = n;
    }

    public int getCompleteness() {
        return this.mCompleteness;
    }

    public void provideCompleteness(int n) {
        if (this.mCompleteness == 0) {
            this.mCompleteness = n;
        }
    }

    public String getCompletenessReason() {
        return COMPLETENESS_STRINGS[this.mCompleteness];
    }

    public void push() {
        if (this.mAssignments != null) {
            this.mAssignments.beginScope();
        }
        this.mAtomList.beginScope();
        ITheory[] iTheoryArray = this.getAttachedTheories();
        int n = iTheoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.push();
            ++n2;
        }
        ++this.mPushPopLevel;
    }

    public void pop(int n) {
        int n2;
        Object object;
        Iterator<Object> iterator;
        if (n < 1 || n > this.mPushPopLevel) {
            throw new IllegalArgumentException("Must pop a positive number less than the current stack level");
        }
        int n3 = this.mPushPopLevel - n;
        if (this.mUnsatClause != null && this.mUnsatClause.mStacklevel > n3) {
            this.mUnsatClause = null;
        }
        if (!this.mDPLLStack.isEmpty()) {
            iterator = this.mDPLLStack.listIterator(this.mDPLLStack.size());
            while (iterator.hasPrevious()) {
                object = iterator.previous();
                Object object2 = ((Literal)object).getAtom().mExplanation;
                if (object2 instanceof Clause) {
                    ((Clause)object2).mActivity += this.mClsScale;
                }
                this.backtrackLiteral((Literal)object);
            }
            this.mDPLLStack.clear();
            ITheory[] iTheoryArray = this.mTheories;
            n2 = this.mTheories.length;
            int n4 = 0;
            while (n4 < n2) {
                object = iTheoryArray[n4];
                object.backtrackAll();
                ++n4;
            }
        }
        this.unlearnClauses(n3);
        assert (this.mCurrentDecideLevel == 0);
        this.mNumSolvedAtoms = 0;
        iterator = this.mClauses.iterator();
        while (iterator.hasNext()) {
            object = (Clause)iterator.next();
            if (((Clause)object).mStacklevel <= n3) break;
            if (((Clause)object).doCleanup(this)) {
                iterator.remove();
                continue;
            }
            throw new InternalError("Input clause still blocked, but invalid");
        }
        int n5 = 0;
        while (n5 < n) {
            ITheory[] iTheoryArray = this.getAttachedTheories();
            int n6 = iTheoryArray.length;
            n2 = 0;
            while (n2 < n6) {
                ITheory iTheory = iTheoryArray[n2];
                iTheory.pop();
                ++n2;
            }
            if (this.mAssignments != null) {
                this.mAssignments.endScope();
            }
            for (DPLLAtom dPLLAtom : this.mAtomList.currentScope()) {
                this.removeAtom(dPLLAtom);
            }
            this.mAtomList.endScope();
            --this.mPushPopLevel;
            ++n5;
        }
        this.mCompleteness = 0;
        assert (this.mPushPopLevel == n3);
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public void showClauses(PrintWriter printWriter) {
        SimpleListable simpleListable = this.mClauses.mNext;
        while (simpleListable != this.mClauses) {
            printWriter.println(simpleListable);
            simpleListable = simpleListable.mNext;
        }
    }

    public boolean hasModel() {
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            this.provideCompleteness(iTheory.checkCompleteness());
            ++n2;
        }
        return this.mHasModel && this.mCompleteness == 0;
    }

    public void setProofGeneration(boolean bl) {
        this.mPGenabled = bl;
    }

    public boolean isProofGenerationEnabled() {
        return this.mPGenabled;
    }

    public Literal[] getUnsatAssumptions() {
        return this.mUnsatClause.mLiterals;
    }

    public Clause getProof() {
        assert (this.checkValidUnsatClause());
        Clause clause = this.mUnsatClause;
        if (this.mUnsatClause != null && this.mUnsatClause.getSize() > 0) {
            ResolutionNode.Antecedent[] antecedentArray = new ResolutionNode.Antecedent[this.mUnsatClause.getSize()];
            int n = 0;
            while (n < this.mUnsatClause.getSize()) {
                Literal literal = this.mUnsatClause.getLiteral(n).negate();
                antecedentArray[n] = new ResolutionNode.Antecedent(literal, new Clause(new Literal[]{literal}, new LeafNode(-7, null)));
                ++n;
            }
            ResolutionNode resolutionNode = new ResolutionNode(this.mUnsatClause, antecedentArray);
            clause = new Clause(new Literal[0], resolutionNode);
        }
        return clause;
    }

    private void generateLevel0Proof(Literal literal) {
        assert (literal.getAtom().mDecideLevel <= this.mBaseLevel) : "Level0 proof for non-level0 literal?";
        assert (!this.mAssumptionLiterals.contains(literal));
        HashSet<Object> hashSet = new HashSet<Object>();
        Clause clause = this.getExplanation(literal);
        if (clause.getSize() > 1) {
            Clause clause2;
            Literal[] literalArray;
            int n = clause.mStacklevel;
            Literal[] literalArray2 = clause.mLiterals;
            ResolutionNode.Antecedent[] antecedentArray = this.isProofGenerationEnabled() ? new ResolutionNode.Antecedent[clause.getSize() - 1] : null;
            int n2 = 0;
            Literal[] literalArray3 = literalArray2;
            int n3 = literalArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                literalArray = literalArray3[n4];
                if (literalArray.getAtom().mExplanation == null) {
                    assert (this.mAssumptionLiterals.contains(literalArray.negate()));
                    hashSet.add(literalArray);
                } else if (literalArray != literal) {
                    Clause clause3 = this.getLevel0(literalArray.negate());
                    if (this.isProofGenerationEnabled()) {
                        antecedentArray[n2++] = new ResolutionNode.Antecedent(literalArray.negate(), clause3);
                    }
                    int n5 = 0;
                    while (n5 < clause3.getSize()) {
                        Literal literal2 = clause3.getLiteral(n5);
                        if (literal2 != literalArray.negate()) {
                            assert (this.mAssumptionLiterals.contains(literal2.negate()));
                            hashSet.add(literal2);
                        }
                        ++n5;
                    }
                    n = Math.max(n, clause3.mStacklevel);
                }
                ++n4;
            }
            hashSet.add(literal);
            literalArray = hashSet.toArray(new Literal[hashSet.size()]);
            if (this.isProofGenerationEnabled()) {
                if (n2 == 0) {
                    clause2 = clause;
                } else {
                    if (n2 < antecedentArray.length) {
                        antecedentArray = Arrays.copyOf(antecedentArray, n2);
                    }
                    clause2 = new Clause(literalArray, new ResolutionNode(clause, antecedentArray), n);
                }
            } else {
                clause2 = new Clause(literalArray, n);
            }
            literal.getAtom().mExplanation = clause2;
        }
    }

    private boolean checkLevel0Clause(Clause clause, Literal literal) {
        boolean bl = false;
        Literal[] literalArray = clause.mLiterals;
        int n = clause.mLiterals.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal2 = literalArray[n2];
            if (literal2 == literal) {
                bl = true;
            } else assert (this.mAssumptionLiterals.contains(literal2.negate()));
            ++n2;
        }
        return bl;
    }

    private Clause getLevel0(Literal literal) {
        assert (literal.getAtom().mDecideLevel <= this.mBaseLevel);
        Object object = literal.getAtom().mExplanation;
        assert (object instanceof Clause);
        assert (this.checkLevel0Clause((Clause)object, literal));
        return (Clause)object;
    }

    public final void increaseDecideLevel() {
        this.mLogger.debug("Decide@%d", this.mDPLLStack.size());
        ++this.mCurrentDecideLevel;
        assert (this.mCurrentDecideLevel >= 0) : "Decidelevel negative";
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.increasedDecideLevel(this.mCurrentDecideLevel);
            ++n2;
        }
    }

    public final void decreaseDecideLevel() {
        --this.mCurrentDecideLevel;
        assert (this.mCurrentDecideLevel >= 0) : "Decidelevel negative";
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            iTheory.decreasedDecideLevel(this.mCurrentDecideLevel);
            ++n2;
        }
    }

    public ITheory[] getAttachedTheories() {
        return this.mTheories;
    }

    public int getAssertionStackLevel() {
        return this.mPushPopLevel;
    }

    public boolean inconsistent() {
        return this.mUnsatClause != null;
    }

    private boolean checkProofStackLevel(Clause clause, int n) {
        Object object;
        if (clause == null || clause.mProof == null) {
            return true;
        }
        if (clause.mStacklevel > n) {
            System.err.println("Clause " + String.valueOf(clause) + " above target level!");
            return false;
        }
        Literal[] literalArray = clause.mLiterals;
        int n2 = clause.mLiterals.length;
        int n3 = 0;
        while (n3 < n2) {
            object = literalArray[n3];
            if (((Literal)object).getAtom().mAssertionstacklevel > n) {
                System.err.println("Literal " + String.valueOf(object) + " in clause " + String.valueOf(clause) + " above target level");
                return false;
            }
            ++n3;
        }
        if (clause.mProof instanceof ResolutionNode) {
            object = (ResolutionNode)clause.mProof;
            if (!this.checkProofStackLevel(((ResolutionNode)object).getPrimary(), n)) {
                return false;
            }
            ResolutionNode.Antecedent[] antecedentArray = ((ResolutionNode)object).getAntecedents();
            int n4 = antecedentArray.length;
            n2 = 0;
            while (n2 < n4) {
                ResolutionNode.Antecedent antecedent = antecedentArray[n2];
                if (!this.checkProofStackLevel(antecedent.mAntecedent, n)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public Object getStatistics() {
        Object[] objectArray = new Object[this.mTheories.length + 1];
        Object[][] objectArrayArray = new Object[][]{{"Conflicts", this.mConflicts}, {"Propagations", this.mProps}, {"Theory_propagations", this.mTProps}, {"Decides", this.mDecides}, {"Random_splits", this.mNumRandomSplits}, {"Num_Atoms", this.mAtoms.size() + this.mDPLLStack.size()}, {"Solved_Atoms", this.mNumSolvedAtoms}, {"Clauses", this.mNumClauses}, {"Axioms", this.mNumAxiomClauses}, {"Times", new Object[][]{{"Explain", this.mExplainTime}, {"Propagation", this.mPropTime}, {"Set", this.mSetTime}, {"Check", this.mCheckTime}, {"Backtrack", this.mBacktrackTime}}}};
        objectArray[0] = new Object[]{":Core", objectArrayArray};
        int n = 1;
        while (n < objectArray.length) {
            objectArray[n] = this.mTheories[n - 1].getStatistics();
            ++n;
        }
        return objectArray;
    }

    public void setProduceAssignments(boolean bl) {
        assert (this.mPushPopLevel == 0 && this.mAssignments == null || this.mAssignments.isEmpty());
        this.mAssignments = bl ? new ScopedHashMap() : null;
    }

    public boolean isProduceAssignments() {
        return this.mAssignments != null;
    }

    public void trackAssignment(String string, Literal literal) {
        this.mAssignments.put((Object)string, (Object)literal);
    }

    public Assignments getAssignments() {
        if (!this.isProduceAssignments()) {
            return null;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(this.mAssignments.size(), 1.0f);
        for (Map.Entry entry : this.mAssignments.entrySet()) {
            hashMap.put((String)entry.getKey(), ((Literal)entry.getValue()).getAtom().mDecideStatus == entry.getValue());
        }
        return new Assignments(hashMap);
    }

    public boolean quickCheck() {
        if (this.mUnsatClause != null) {
            return false;
        }
        Clause clause = this.propagateInternal();
        boolean bl = !this.explain(clause);
        return bl;
    }

    public boolean propagate() {
        if (this.mUnsatClause != null) {
            return false;
        }
        Clause clause = null;
        ITheory[] iTheoryArray = this.mTheories;
        int n = this.mTheories.length;
        int n2 = 0;
        while (n2 < n) {
            ITheory iTheory = iTheoryArray[n2];
            clause = iTheory.startCheck();
            if (clause != null) break;
            ++n2;
        }
        if (clause == null) {
            clause = this.propagateInternal();
        }
        boolean bl = !this.explain(clause);
        ITheory[] iTheoryArray2 = this.mTheories;
        int n3 = this.mTheories.length;
        n = 0;
        while (n < n3) {
            ITheory iTheory = iTheoryArray2[n];
            iTheory.endCheck();
            ++n;
        }
        return bl;
    }

    public Random getRandom() {
        return this.mRandom;
    }

    public void setRandomSeed(long l) {
        this.mRandom.setSeed(l);
    }

    public void flipDecisions() {
        Object object;
        this.startBacktrack();
        while (this.mDPLLStack.size() > this.mBaseLevel + this.mNumSolvedAtoms) {
            object = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral((Literal)object);
            ((Literal)object).getAtom().mLastStatus = ((Literal)object).negate();
        }
        object = this.finalizeBacktrack();
        assert (object == null);
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
    }

    public void flipNamedLiteral(String string) throws SMTLIBException {
        Object object;
        this.startBacktrack();
        while (this.mDPLLStack.size() > this.mBaseLevel + this.mNumSolvedAtoms) {
            object = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral((Literal)object);
        }
        object = this.finalizeBacktrack();
        assert (object == null);
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
        Literal literal = (Literal)this.mAssignments.get((Object)string);
        if (literal == null) {
            throw new SMTLIBException("Name " + string + " not known");
        }
        DPLLAtom dPLLAtom = literal.getAtom();
        dPLLAtom.mLastStatus = dPLLAtom.mLastStatus == null ? dPLLAtom : dPLLAtom.mLastStatus.negate();
    }

    public SimpleList<Clause> getClauses() {
        return this.mClauses;
    }

    public Term[] getSatisfiedLiterals(Theory theory) {
        int n = 0;
        for (Literal object2 : this.mDPLLStack) {
            if (object2.getAtom() instanceof NamedAtom) continue;
            ++n;
        }
        Term[] termArray = new Term[n];
        int n2 = -1;
        for (Literal literal : this.mDPLLStack) {
            if (literal.getAtom() instanceof NamedAtom) continue;
            termArray[++n2] = literal.getSMTFormula(theory);
        }
        return termArray;
    }

    public boolean isTerminationRequested() {
        if (this.mCompleteness == 7 || this.mCancel.isTerminationRequested()) {
            this.mCompleteness = 7;
            return true;
        }
        return false;
    }

    public void clearAssumptions() {
        Object object;
        if (this.mCurrentDecideLevel == 0) {
            return;
        }
        this.startBacktrack();
        this.mAssumptionLiterals.clear();
        this.mLogger.debug("Clearing Assumptions (Baselevel is %d)", this.mBaseLevel);
        while (this.mCurrentDecideLevel > 0) {
            object = this.mDPLLStack.remove(this.mDPLLStack.size() - 1);
            this.backtrackLiteral((Literal)object);
        }
        assert (this.mCurrentDecideLevel == 0);
        this.mBaseLevel = 0;
        if (this.mUnsatClause != null && this.mUnsatClause.getSize() > 0) {
            this.mUnsatClause = null;
        }
        if ((object = this.finalizeBacktrack()) != null) {
            this.explain((Clause)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean assume(Literal[] literalArray) {
        assert (this.mCurrentDecideLevel == this.mBaseLevel);
        Literal[] literalArray2 = literalArray;
        int n = literalArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Literal literal = literalArray2[n2];
                this.mLogger.debug("Assuming Literal %s", literal);
                this.mAssumptionLiterals.add(literal);
                if (literal.getAtom().getDecideStatus() != null) {
                    if (literal.getAtom().getDecideStatus() == literal) {
                        this.mLogger.debug("Already set!");
                        break block8;
                    } else {
                        this.mUnsatClause = this.mAssumptionLiterals.contains(literal.negate()) ? new Clause(new Literal[]{literal}, new LeafNode(-7, null)) : this.getLevel0(literal.negate());
                        assert (this.checkValidUnsatClause());
                        assert (this.mBaseLevel == this.mCurrentDecideLevel);
                        return false;
                    }
                }
                this.increaseDecideLevel();
                Clause clause = this.setLiteral(literal);
                this.mBaseLevel = this.mCurrentDecideLevel;
                if (clause != null) {
                    this.mLogger.debug("Conflict when setting literal");
                    this.startBacktrack();
                    this.mUnsatClause = this.explainConflict(clause);
                    this.checkValidUnsatClause();
                    this.finalizeBacktrack();
                    return false;
                }
            }
            ++n2;
        }
        this.mLogger.debug("Setting base level to %d", this.mCurrentDecideLevel);
        return true;
    }

    private boolean checkValidUnsatClause() {
        if (this.mUnsatClause != null) {
            Literal[] literalArray = this.mUnsatClause.mLiterals;
            int n = this.mUnsatClause.mLiterals.length;
            int n2 = 0;
            while (n2 < n) {
                Literal literal = literalArray[n2];
                assert (this.mAssumptionLiterals.contains(literal.negate())) : "Not an assumption in unsat clause";
                ++n2;
            }
        }
        return true;
    }

    public void messWithActivityOfAtoms(Random random) {
        this.mAtoms.clear();
        for (DPLLAtom dPLLAtom : this.mAtomList) {
            dPLLAtom.mActivity += random.nextDouble() * this.mAtomScale;
            if (dPLLAtom.mDecideStatus != null) continue;
            this.mAtoms.add(dPLLAtom);
        }
    }

    public class AllSatIterator
    implements Iterator<Term[]> {
        private final Literal[] mPreds;
        private final Term[] mTerms;
        private Literal[] mBlocker;
        private int mBlockerSize;

        public AllSatIterator(Literal[] literalArray, Term[] termArray) {
            this.mPreds = literalArray;
            this.mTerms = termArray;
            assert (this.mPreds.length == this.mTerms.length);
            Literal[] literalArray2 = literalArray;
            int n = literalArray.length;
            int n2 = 0;
            while (n2 < n) {
                Literal literal = literalArray2[n2];
                if (!(literal.getAtom() instanceof DPLLAtom.TrueAtom)) {
                    ++this.mBlockerSize;
                }
                ++n2;
            }
        }

        @Override
        public boolean hasNext() {
            Clause clause;
            if (this.mBlocker != null && DPLLEngine.this.explain(clause = new Clause(this.mBlocker, DPLLEngine.this.mPushPopLevel))) {
                return false;
            }
            return DPLLEngine.this.solve() && DPLLEngine.this.hasModel();
        }

        @Override
        public Term[] next() {
            Term[] termArray = new Term[this.mPreds.length];
            this.mBlocker = new Literal[this.mBlockerSize];
            int n = 0;
            while (n < this.mPreds.length) {
                Literal literal = this.mPreds[n];
                if (!(literal.getAtom() instanceof DPLLAtom.TrueAtom)) {
                    this.mBlocker[n] = literal.getAtom().mDecideStatus.negate();
                }
                termArray[n] = literal.getAtom().mDecideStatus == literal ? this.mTerms[n] : this.mTerms[n].getTheory().term("not", new Term[]{this.mTerms[n]});
                ++n;
            }
            return termArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove model!");
        }
    }
}

