/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.ApplyConstructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseEprQuantifiedLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.ClauseLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.clauses.EprClause;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EprClauseFactory {
    EprTheory mEprTheory;
    private final ScopedHashMap<Set<Literal>, EprClause> mLiteralsToClause = new ScopedHashMap();

    public EprClauseFactory(EprTheory eprTheory) {
        this.mEprTheory = eprTheory;
    }

    public EprClause createResolvent(ClauseEprLiteral clauseEprLiteral, ClauseEprLiteral clauseEprLiteral2) {
        assert (clauseEprLiteral.getPolarity() != clauseEprLiteral2.getPolarity());
        int n = clauseEprLiteral.getArguments().size();
        assert (n == clauseEprLiteral2.getArguments().size());
        EprClause eprClause = clauseEprLiteral.getClause();
        EprClause eprClause2 = clauseEprLiteral2.getClause();
        List<ClauseLiteral> list = eprClause.getLiterals();
        List<ClauseLiteral> list2 = eprClause2.getLiterals();
        TermTuple termTuple = new TermTuple(clauseEprLiteral.getArguments().toArray(new Term[n]));
        TermTuple termTuple2 = new TermTuple(clauseEprLiteral2.getArguments().toArray(new Term[n]));
        TTSubstitution tTSubstitution = termTuple.match(termTuple2, this.mEprTheory.getEqualityManager());
        HashSet<ClauseLiteral> hashSet = new HashSet<ClauseLiteral>();
        hashSet.addAll(list);
        hashSet.remove(clauseEprLiteral);
        hashSet.addAll(list2);
        hashSet.remove(clauseEprLiteral2);
        Set<Literal> set = this.computeUnifiedLiteralsFromClauseLiterals(tTSubstitution, hashSet);
        EprClause eprClause3 = this.getEprClause(set);
        return eprClause3;
    }

    public EprClause getFactoredClause(ClauseEprQuantifiedLiteral clauseEprQuantifiedLiteral, ClauseEprLiteral clauseEprLiteral) {
        assert (clauseEprQuantifiedLiteral.getPolarity() == clauseEprLiteral.getPolarity());
        EprPredicate eprPredicate = clauseEprQuantifiedLiteral.getEprPredicate();
        assert (eprPredicate == clauseEprLiteral.getEprPredicate());
        assert (clauseEprQuantifiedLiteral.getClause() == clauseEprLiteral.getClause());
        int n = eprPredicate.getArity();
        EprClause eprClause = clauseEprQuantifiedLiteral.getClause();
        List<ClauseLiteral> list = eprClause.getLiterals();
        TermTuple termTuple = new TermTuple(clauseEprQuantifiedLiteral.getArguments().toArray(new Term[n]));
        TermTuple termTuple2 = new TermTuple(clauseEprLiteral.getArguments().toArray(new Term[n]));
        TTSubstitution tTSubstitution = termTuple.match(termTuple2, this.mEprTheory.getEqualityManager());
        HashSet<ClauseLiteral> hashSet = new HashSet<ClauseLiteral>();
        hashSet.addAll(list);
        hashSet.remove(clauseEprLiteral);
        Set<Literal> set = this.computeUnifiedLiteralsFromClauseLiterals(tTSubstitution, hashSet);
        Set<Literal> set2 = new ApplyConstructiveEqualityReasoning(this.mEprTheory, set).getResult();
        EprClause eprClause2 = this.getEprClause(set2);
        boolean bl = eprClause2.isConflict();
        assert (bl);
        return eprClause2;
    }

    public EprClause getEprClause(Set<Literal> set) {
        Set<Literal> set2 = this.alphaRenameLiterals(set);
        EprClause eprClause = (EprClause)this.mLiteralsToClause.get(set2);
        if (eprClause == null) {
            eprClause = new EprClause(set2, this.mEprTheory);
            this.mEprTheory.getLogger().debug("EPRDEBUG (EprClauseFactory): creating new clause " + String.valueOf(eprClause));
            this.mLiteralsToClause.put(set2, (Object)eprClause);
        } else {
            this.mEprTheory.getLogger().debug("EPRDEBUG (EprClauseFactory): clause has been added before " + String.valueOf(eprClause));
            eprClause.mClauseStateIsDirty = true;
        }
        return eprClause;
    }

    public void push() {
        this.mLiteralsToClause.beginScope();
    }

    public void pop() {
        this.mLiteralsToClause.endScope();
    }

    private Set<Literal> computeUnifiedLiteralsFromClauseLiterals(TTSubstitution tTSubstitution, Set<ClauseLiteral> set) {
        HashSet<Literal> hashSet = new HashSet<Literal>();
        for (ClauseLiteral clauseLiteral : set) {
            if (clauseLiteral instanceof ClauseEprQuantifiedLiteral) {
                ClauseEprQuantifiedLiteral clauseEprQuantifiedLiteral = (ClauseEprQuantifiedLiteral)clauseLiteral;
                EprPredicate eprPredicate = clauseEprQuantifiedLiteral.getEprPredicate();
                List<Term> list = clauseEprQuantifiedLiteral.getArguments();
                TermTuple termTuple = new TermTuple(list.toArray(new Term[list.size()]));
                TermTuple termTuple2 = tTSubstitution.apply(termTuple);
                Literal literal = null;
                if (termTuple2.isGround()) {
                    var12_12 = (EprGroundPredicateAtom)eprPredicate.getAtomForTermTuple(termTuple2, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), clauseEprQuantifiedLiteral.getAtom().getSourceAnnotation());
                    literal = clauseLiteral.getPolarity() ? var12_12 : var12_12.negate();
                } else {
                    var12_12 = (EprQuantifiedPredicateAtom)eprPredicate.getAtomForTermTuple(termTuple2, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), clauseEprQuantifiedLiteral.getAtom().getSourceAnnotation());
                    literal = clauseLiteral.getPolarity() ? var12_12 : var12_12.negate();
                }
                hashSet.add(literal);
                continue;
            }
            hashSet.add(clauseLiteral.getLiteral());
        }
        return hashSet;
    }

    private Set<Literal> alphaRenameLiterals(Set<Literal> set) {
        HashSet<Literal> hashSet = new HashSet<Literal>();
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (Literal literal : set) {
            if (literal.getAtom() instanceof EprQuantifiedEqualityAtom || literal.getAtom() instanceof EprQuantifiedPredicateAtom) {
                EprAtom eprAtom = this.applyAlphaRenamingToQuantifiedEprAtom((EprAtom)literal.getAtom(), hashMap);
                Literal literal2 = literal.getSign() == 1 ? eprAtom : eprAtom.negate();
                hashSet.add(literal2);
                continue;
            }
            hashSet.add(literal);
        }
        return hashSet;
    }

    private EprAtom applyAlphaRenamingToQuantifiedEprAtom(EprAtom eprAtom, Map<TermVariable, Term> map) {
        Object object;
        TermTuple termTuple;
        assert (eprAtom instanceof EprQuantifiedPredicateAtom || eprAtom instanceof EprQuantifiedEqualityAtom);
        ApplicationTerm applicationTerm = eprAtom.getArguments();
        int n = ((Term[])applicationTerm).length;
        int n2 = 0;
        while (n2 < n) {
            termTuple = applicationTerm[n2];
            if (!(termTuple instanceof ApplicationTerm) && !map.containsKey(termTuple)) {
                object = (TermVariable)termTuple;
                String string = object.getName();
                string = string.replaceAll("\\.\\d+", "");
                string = string.replaceAll("\\.(\\.)+", "");
                map.put((TermVariable)object, (Term)this.mEprTheory.getTheory().createFreshTermVariable(string, object.getSort()));
            }
            ++n2;
        }
        termTuple = eprAtom.getArgumentsAsTermTuple();
        TermTuple termTuple2 = termTuple.applySubstitution(map);
        FunctionSymbol functionSymbol = ((ApplicationTerm)eprAtom.getSMTFormula(this.mEprTheory.getTheory())).getFunction();
        applicationTerm = (ApplicationTerm)this.mEprTheory.getTheory().term(functionSymbol, termTuple2.terms);
        object = this.mEprTheory.getEprAtom(applicationTerm, 0, this.mEprTheory.getClausifier().getStackLevel(), eprAtom.getSourceAnnotation());
        return object;
    }
}

