/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class LinearRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 5376322220596462295L;
    private final AffineFunction mranking;

    public LinearRankingFunction(AffineFunction affineFunction) {
        this.mranking = affineFunction;
    }

    @Override
    public String getName() {
        return "affine";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        return Collections.unmodifiableSet(this.mranking.getVariables());
    }

    public AffineFunction getComponent() {
        return this.mranking;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("f");
        if (!this.mranking.isConstant()) {
            stringBuilder.append("(");
            boolean bl = true;
            for (IProgramVar iProgramVar : this.mranking.getVariables()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iProgramVar.getGloballyUniqueId());
                bl = false;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" = ");
        stringBuilder.append(this.mranking);
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        return new Term[]{this.mranking.asTerm(script)};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        BigInteger bigInteger = this.mranking.evaluate(map).ceil().numerator();
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            bigInteger = BigInteger.ZERO;
        }
        return Ordinal.fromInteger(bigInteger);
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.OMEGA;
    }
}

