/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import java.util.Collections;

public class Transition {
    private final Phase mSrc;
    private final Phase mDest;
    private final String[] mResets;
    private CDD mGuard;

    public Transition(Phase phase, CDD cDD, String[] stringArray, Phase phase2) {
        this.mSrc = phase;
        this.mGuard = cDD;
        this.mResets = stringArray;
        this.mDest = phase2;
    }

    public String toString() {
        String string = this.mDest.toString();
        if (string.length() < 33) {
            string = (string + "                                 ").substring(0, 33);
        }
        StringBuffer stringBuffer = new StringBuffer(" -> ").append(string).append(" guard ").append(this.mGuard);
        if (this.getResets().length > 0) {
            stringBuffer.append(" resets {");
            String string2 = "";
            int n = 0;
            while (n < this.getResets().length) {
                stringBuffer.append(string2).append(this.getResets()[n]);
                string2 = ",";
                ++n;
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public void simplifyGuard() {
        CDD[] cDDArray = this.mGuard.toDNF();
        int n = cDDArray.length;
        if (n >= 1) {
            CDD cDD = CDD.FALSE;
            CDD[] cDDArray2 = new CDD[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                CDD cDD2 = cDDArray[n3];
                CDD cDD3 = cDD2.unprime(Collections.emptySet());
                if (this.mDest.getStateInvariant().and(cDD3) != CDD.FALSE) {
                    String string = cDD2.toString();
                    if (!(!string.matches(cDD3.toString()) || string.contains("<") || string.contains(">") || string.contains("\u2264") || string.contains("\u2265"))) {
                        cDD2 = cDD2.prime(Collections.emptySet());
                    }
                    cDDArray2[n2] = cDD2;
                    cDD = cDD.or(cDD2);
                    ++n2;
                }
                ++n3;
            }
            this.mGuard = cDD;
        }
    }

    public Phase getDest() {
        return this.mDest;
    }

    public String[] getResets() {
        return this.mResets;
    }

    public Phase getSrc() {
        return this.mSrc;
    }

    public CDD getGuard() {
        return this.mGuard;
    }

    public void setGuard(CDD cDD) {
        this.mGuard = cDD;
    }
}

