/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaSuccessorStateProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.FkvSubsetComponentState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IFkvState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraint;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraintDrdCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.MultiOptimizationLevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementFkvStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BuchiComplementFKVNwa<LETTER, STATE>
implements INwaSuccessorStateProvider<LETTER, STATE> {
    private static final int WARN_SIZE_1 = 2;
    private static final int WARN_SIZE_2 = 4;
    private static final boolean O_IS_EMPTY = true;
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final int mUserDefinedMaxRank;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final SetOfStates<STATE> mSetOfStates;
    private final IBuchiComplementFkvStateFactory<STATE> mStateFactory;
    private final Map<DeterminizedState<LETTER, STATE>, STATE> mDet2res = new HashMap<DeterminizedState<LETTER, STATE>, STATE>();
    private final Map<STATE, FkvSubsetComponentState<LETTER, STATE>> mRes2scs = new HashMap<STATE, FkvSubsetComponentState<LETTER, STATE>>();
    private final Map<LevelRankingState<LETTER, STATE>, STATE> mLrk2res = new HashMap<LevelRankingState<LETTER, STATE>, STATE>();
    private final Map<STATE, LevelRankingState<LETTER, STATE>> mRes2lrk = new HashMap<STATE, LevelRankingState<LETTER, STATE>>();
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private int mHighestRank = -1;
    private final MultiOptimizationLevelRankingGenerator<LETTER, STATE, LevelRankingConstraint<LETTER, STATE>> mLevelRankingGenerator;
    private final STATE mSinkState;

    public BuchiComplementFKVNwa(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, IBuchiComplementFkvStateFactory<STATE> iBuchiComplementFkvStateFactory, MultiOptimizationLevelRankingGenerator.FkvOptimization fkvOptimization, int n) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iBuchiComplementFkvStateFactory;
        this.mSetOfStates = new SetOfStates(this.mStateFactory.createEmptyStackState());
        this.mStateDeterminizer = iStateDeterminizer;
        this.mUserDefinedMaxRank = n;
        this.mLevelRankingGenerator = new MultiOptimizationLevelRankingGenerator(this.mServices, this.mOperand, fkvOptimization, n);
        this.mSinkState = this.constructSinkState();
    }

    private void constructInitialState() {
        DeterminizedState<LETTER, STATE> determinizedState = this.mStateDeterminizer.initialState();
        this.getOrAdd(determinizedState, true);
    }

    private STATE constructSinkState() {
        DeterminizedState<LETTER, STATE> determinizedState = new DeterminizedState<LETTER, STATE>(this.mOperand);
        STATE STATE = this.mStateDeterminizer.getState(determinizedState);
        this.mSetOfStates.addState(false, true, STATE);
        this.mDet2res.put(determinizedState, STATE);
        this.mRes2scs.put(STATE, new FkvSubsetComponentState<LETTER, STATE>(determinizedState));
        return STATE;
    }

    private STATE getOrAdd(LevelRankingState<LETTER, STATE> levelRankingState) {
        if (levelRankingState.isEmpty()) {
            return this.mSinkState;
        }
        STATE STATE = this.mLrk2res.get(levelRankingState);
        if (STATE == null) {
            STATE = this.mStateFactory.buchiComplementFkv(levelRankingState);
            assert (STATE != null);
            this.mSetOfStates.addState(false, levelRankingState.isOempty(), STATE);
            this.mLrk2res.put(levelRankingState, STATE);
            this.mRes2lrk.put(STATE, levelRankingState);
            if (this.mHighestRank < levelRankingState.mHighestRank) {
                this.mHighestRank = levelRankingState.mHighestRank;
            }
        }
        return STATE;
    }

    private STATE getOrAdd(DeterminizedState<LETTER, STATE> determinizedState, boolean bl) {
        if (determinizedState.isEmpty()) {
            assert (!bl) : "sink cannot be initial";
            return this.mSinkState;
        }
        STATE STATE = this.mDet2res.get(determinizedState);
        if (STATE == null) {
            STATE = this.mStateDeterminizer.getState(determinizedState);
            assert (STATE != null);
            this.mSetOfStates.addState(bl, false, STATE);
            this.mDet2res.put(determinizedState, STATE);
            this.mRes2scs.put(STATE, new FkvSubsetComponentState<LETTER, STATE>(determinizedState));
        }
        return STATE;
    }

    public int getHighesRank() {
        return this.mHighestRank;
    }

    public int getPowersetStates() {
        return this.mRes2scs.size();
    }

    public int getRankStates() {
        return this.mRes2lrk.size();
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        this.constructInitialState();
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    @Override
    public Collection<STATE> internalSuccessors(STATE STATE, LETTER LETTER) {
        Object object;
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        FkvSubsetComponentState<LETTER, STATE> fkvSubsetComponentState = this.mRes2scs.get(STATE);
        if (fkvSubsetComponentState != null) {
            object = this.mStateDeterminizer.internalSuccessor(fkvSubsetComponentState.getDeterminizedState(), LETTER);
            STATE STATE2 = this.getOrAdd((DeterminizedState<LETTER, STATE>)object, false);
            arrayList.add(STATE2);
            this.internalSuccessorsHelper(STATE, LETTER, arrayList, fkvSubsetComponentState, true, true, null, 2);
        }
        if ((object = this.mRes2lrk.get(STATE)) != null) {
            this.internalSuccessorsHelper(STATE, LETTER, (Collection<STATE>)arrayList, (IFkvState<LETTER, STATE>)object, ((LevelRankingState)object).isOempty(), false, (LevelRankingState<LETTER, STATE>)object, 4);
        }
        return arrayList;
    }

    private void internalSuccessorsHelper(STATE STATE, LETTER LETTER, Collection<STATE> collection, IFkvState<LETTER, STATE> iFkvState, boolean bl, boolean bl2, LevelRankingState<LETTER, STATE> levelRankingState, int n) {
        LevelRankingConstraint<LETTER, STATE> levelRankingConstraint = this.getLevelRankingConstraintDrdCheck(bl, bl2, levelRankingState);
        levelRankingConstraint.internalSuccessorConstraints(iFkvState, LETTER);
        Collection<LevelRankingState<LETTER, STATE>> collection2 = this.generateLevelRankings(bl2, levelRankingConstraint);
        if (collection2.size() > n && this.mLogger.isWarnEnabled()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass());
            }
            this.mLogger.warn((Object)("big" + collection2.size()));
        }
        for (LevelRankingState<LETTER, STATE> levelRankingState2 : collection2) {
            STATE STATE2 = this.getOrAdd(levelRankingState2);
            collection.add(STATE2);
        }
    }

    @Override
    public Collection<STATE> callSuccessors(STATE STATE, LETTER LETTER) {
        Object object;
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        FkvSubsetComponentState<LETTER, STATE> fkvSubsetComponentState = this.mRes2scs.get(STATE);
        if (fkvSubsetComponentState != null) {
            object = this.mStateDeterminizer.callSuccessor(fkvSubsetComponentState.getDeterminizedState(), LETTER);
            STATE STATE2 = this.getOrAdd((DeterminizedState<LETTER, STATE>)object, false);
            arrayList.add(STATE2);
            this.callSuccessorsHelper(STATE, LETTER, arrayList, fkvSubsetComponentState, true, true, null);
        }
        if ((object = this.mRes2lrk.get(STATE)) != null) {
            this.callSuccessorsHelper(STATE, LETTER, (Collection<STATE>)arrayList, (IFkvState<LETTER, STATE>)object, ((LevelRankingState)object).isOempty(), false, (LevelRankingState<LETTER, STATE>)object);
        }
        return arrayList;
    }

    private void callSuccessorsHelper(STATE STATE, LETTER LETTER, Collection<STATE> collection, IFkvState<LETTER, STATE> iFkvState, boolean bl, boolean bl2, LevelRankingState<LETTER, STATE> levelRankingState) {
        LevelRankingConstraint<LETTER, STATE> levelRankingConstraint = this.getLevelRankingConstraintDrdCheck(bl, bl2, levelRankingState);
        levelRankingConstraint.callSuccessorConstraints(iFkvState, LETTER);
        Collection<LevelRankingState<LETTER, STATE>> collection2 = this.generateLevelRankings(bl2, levelRankingConstraint);
        for (LevelRankingState<LETTER, STATE> levelRankingState2 : collection2) {
            STATE STATE2 = this.getOrAdd(levelRankingState2);
            collection.add(STATE2);
        }
    }

    @Override
    public Collection<STATE> returnSuccessorsGivenHier(STATE STATE, STATE STATE2, LETTER LETTER) {
        Object object;
        Object object2;
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        FkvSubsetComponentState<LETTER, STATE> fkvSubsetComponentState = this.mRes2scs.get(STATE);
        FkvSubsetComponentState<LETTER, STATE> fkvSubsetComponentState2 = this.mRes2scs.get(STATE2);
        if (fkvSubsetComponentState != null) {
            object2 = this.mStateDeterminizer.returnSuccessor(fkvSubsetComponentState.getDeterminizedState(), fkvSubsetComponentState2.getDeterminizedState(), LETTER);
            object = this.getOrAdd((DeterminizedState<LETTER, STATE>)object2, false);
            arrayList.add(object);
            this.returnSuccessorsHelper(STATE, STATE2, LETTER, arrayList, fkvSubsetComponentState, fkvSubsetComponentState2, true, true, null);
        }
        object2 = this.mRes2lrk.get(STATE);
        if (this.mRes2scs.containsKey(STATE2)) {
            object = this.mRes2scs.get(STATE2);
        } else {
            assert (this.mRes2lrk.containsKey(STATE2));
            object = this.mRes2lrk.get(STATE2);
        }
        if (object2 != null) {
            this.returnSuccessorsHelper(STATE, STATE2, LETTER, (Collection<STATE>)arrayList, (IFkvState<LETTER, STATE>)object2, (IFkvState<LETTER, STATE>)object, ((LevelRankingState)object2).isOempty(), false, (LevelRankingState<LETTER, STATE>)object2);
        }
        return arrayList;
    }

    private void returnSuccessorsHelper(STATE STATE, STATE STATE2, LETTER LETTER, Collection<STATE> collection, IFkvState<LETTER, STATE> iFkvState, IFkvState<LETTER, STATE> iFkvState2, boolean bl, boolean bl2, LevelRankingState<LETTER, STATE> levelRankingState) {
        LevelRankingConstraint<LETTER, STATE> levelRankingConstraint = this.getLevelRankingConstraintDrdCheck(bl, bl2, levelRankingState);
        levelRankingConstraint.returnSuccessorConstraints(iFkvState, iFkvState2, LETTER);
        Collection<LevelRankingState<LETTER, STATE>> collection2 = this.generateLevelRankings(bl2, levelRankingConstraint);
        for (LevelRankingState<LETTER, STATE> levelRankingState2 : collection2) {
            STATE STATE3 = this.getOrAdd(levelRankingState2);
            collection.add(STATE3);
        }
    }

    private Collection<LevelRankingState<LETTER, STATE>> generateLevelRankings(boolean bl, LevelRankingConstraint<LETTER, STATE> levelRankingConstraint) {
        return this.mLevelRankingGenerator.generateLevelRankings(levelRankingConstraint, bl);
    }

    private LevelRankingConstraint<LETTER, STATE> getLevelRankingConstraintDrdCheck(boolean bl, boolean bl2, LevelRankingState<LETTER, STATE> levelRankingState) {
        return new LevelRankingConstraintDrdCheck<LETTER, STATE>(this.mOperand, bl, this.mUserDefinedMaxRank, this.mStateDeterminizer.useDoubleDeckers(), bl2, levelRankingState);
    }

    @Override
    public int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public String sizeInformation() {
        return "size Information not available";
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException();
    }
}

