/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.alternating.AlternatingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import java.util.BitSet;
import java.util.LinkedList;

public class RAFA_Determination<LETTER>
extends GeneralOperation<LETTER, IPredicate, IStateFactory<IPredicate>> {
    private final AlternatingAutomaton<LETTER, IPredicate> mAlternatingAutomaton;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateUnifier mPredicateUnifier;
    private final NestedWordAutomaton<LETTER, IPredicate> mResultAutomaton;

    public RAFA_Determination(AutomataLibraryServices automataLibraryServices, AlternatingAutomaton<LETTER, IPredicate> alternatingAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateUnifier predicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        super(automataLibraryServices);
        assert (alternatingAutomaton.isReversed());
        this.mAlternatingAutomaton = alternatingAutomaton;
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateUnifier = predicateUnifier;
        this.mResultAutomaton = new NestedWordAutomaton(automataLibraryServices, new VpAlphabet(alternatingAutomaton.getAlphabet()), iEmptyStackStateFactory);
        LinkedList<BitSet> linkedList = new LinkedList<BitSet>();
        linkedList.add(alternatingAutomaton.getFinalStatesBitVector());
        this.mResultAutomaton.addState(true, alternatingAutomaton.getAcceptingFunction().getResult(alternatingAutomaton.getFinalStatesBitVector()), (Object)this.getPredicate(alternatingAutomaton.getFinalStatesBitVector()));
        while (!linkedList.isEmpty()) {
            BitSet bitSet = (BitSet)linkedList.removeFirst();
            IPredicate iPredicate = this.getPredicate(bitSet);
            for (Object e : alternatingAutomaton.getAlphabet()) {
                BitSet bitSet2 = (BitSet)bitSet.clone();
                alternatingAutomaton.resolveLetter(e, bitSet2);
                if (bitSet2.isEmpty()) continue;
                IPredicate iPredicate2 = this.getPredicate(bitSet2);
                if (!this.mResultAutomaton.getStates().contains(iPredicate2)) {
                    this.mResultAutomaton.addState(false, alternatingAutomaton.getAcceptingFunction().getResult(bitSet2), (Object)iPredicate2);
                    linkedList.add(bitSet2);
                }
                this.mResultAutomaton.addInternalTransition((Object)iPredicate, e, (Object)iPredicate2);
            }
        }
    }

    private IPredicate getPredicate(BitSet bitSet) {
        IPredicate iPredicate = this.mPredicateUnifier.getTruePredicate();
        int n = RAFA_Determination.getNextSetBit(bitSet, 0);
        while (n != -1) {
            iPredicate = this.mPredicateUnifier.getOrConstructPredicate(this.mPredicateUnifier.getPredicateFactory().and(new IPredicate[]{iPredicate, (IPredicate)this.mAlternatingAutomaton.getStates().get(n)}));
            n = RAFA_Determination.getNextSetBit(bitSet, n + 1);
        }
        return iPredicate;
    }

    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mResultAutomaton;
    }

    public boolean checkResult(IStateFactory<IPredicate> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    private static int getNextSetBit(BitSet bitSet, int n) {
        int n2 = n;
        while (n2 < bitSet.size()) {
            if (bitSet.get(n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

