/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import java.util.EnumSet;

public class BoogieBacktranslationValueProvider
implements IBacktranslationValueProvider<BoogieASTNode, Expression> {
    public int getStartLineNumberFromStep(BoogieASTNode boogieASTNode) {
        if (boogieASTNode.getLocation() == null) {
            return -1;
        }
        return boogieASTNode.getLocation().getStartLine();
    }

    public int getEndLineNumberFromStep(BoogieASTNode boogieASTNode) {
        if (boogieASTNode.getLocation() == null) {
            return -1;
        }
        return boogieASTNode.getLocation().getEndLine();
    }

    public int getLineNumberFromStep(BoogieASTNode boogieASTNode, EnumSet<AtomicTraceElement.StepInfo> enumSet) {
        return this.getStartLineNumberFromStep(boogieASTNode);
    }

    public int getColumnNumberFromStep(BoogieASTNode boogieASTNode, EnumSet<AtomicTraceElement.StepInfo> enumSet) {
        if (boogieASTNode.getLocation() == null) {
            return -1;
        }
        return boogieASTNode.getLocation().getStartColumn();
    }

    public String getOriginFileNameFromStep(BoogieASTNode boogieASTNode) {
        ILocation iLocation = boogieASTNode.getLocation();
        if (iLocation == null) {
            return null;
        }
        return iLocation.getFileName();
    }

    public String getFunctionFromStep(BoogieASTNode boogieASTNode) {
        ILocation iLocation = boogieASTNode.getLocation();
        if (iLocation == null) {
            return null;
        }
        return iLocation.getFunction();
    }

    public String getStringFromStep(BoogieASTNode boogieASTNode) {
        if (boogieASTNode instanceof Statement) {
            return BoogiePrettyPrinter.print((Statement)boogieASTNode);
        }
        if (boogieASTNode instanceof Specification) {
            return BoogiePrettyPrinter.print((Specification)boogieASTNode);
        }
        if (boogieASTNode instanceof Expression) {
            return BoogiePrettyPrinter.print((Expression)boogieASTNode);
        }
        throw new IllegalArgumentException("current step is neither Statement nor Specification nor Expression");
    }

    public String getStringFromTraceElement(BoogieASTNode boogieASTNode) {
        return this.getStringFromStep(boogieASTNode);
    }

    public String getStringFromExpression(Expression expression) {
        return BoogiePrettyPrinter.print(expression);
    }

    public String getFileNameFromStep(BoogieASTNode boogieASTNode) {
        return boogieASTNode.getLocation().getFileName();
    }

    public boolean isValidAssumptionLocation(BoogieASTNode boogieASTNode) {
        return true;
    }
}

