/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree;

import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.List;

public class TreeAutomatonRule<LETTER extends IRankedLetter, STATE> {
    private final LETTER mLetter;
    private final List<STATE> mSrc;
    private final STATE mDest;

    public TreeAutomatonRule(LETTER LETTER, List<STATE> list, STATE STATE) {
        assert (LETTER.getRank() == list.size());
        this.mLetter = LETTER;
        this.mSrc = list;
        this.mDest = STATE;
    }

    public List<STATE> getSource() {
        return this.mSrc;
    }

    public LETTER getLetter() {
        return this.mLetter;
    }

    public STATE getDest() {
        return this.mDest;
    }

    public int getArity() {
        return this.mLetter.getRank();
    }

    public String toString() {
        return "(" + this.mSrc.toString() + " | " + this.mLetter.toString() + " | " + this.mDest.toString() + ")";
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TreeAutomatonRule treeAutomatonRule = (TreeAutomatonRule)object;
        if (!this.mDest.equals(treeAutomatonRule.mDest) || !this.mLetter.equals(treeAutomatonRule.mLetter) || treeAutomatonRule.mSrc.size() != this.mSrc.size()) {
            return false;
        }
        int n = 0;
        while (n < this.mSrc.size()) {
            if (!this.mSrc.get(n).equals(treeAutomatonRule.mSrc.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.hashHsieh((int)31, (Object[])new Object[]{this.mDest, this.mSrc, this.mLetter});
    }
}

