/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser;

import de.uni_freiburg.informatik.ultimate.core.lib.results.InvalidWitnessErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.witnessparser.Activator;
import de.uni_freiburg.informatik.ultimate.witnessparser.WitnessAutomatonConstructor;
import de.uni_freiburg.informatik.ultimate.witnessparser.YamlWitnessParser;
import de.uni_freiburg.informatik.ultimate.witnessparser.preferences.WitnessParserPreferences;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import edu.uci.ics.jung.io.GraphIOException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class WitnessParser
implements ISource {
    private static final String[] FILE_TYPES = new String[]{"graphml", "yaml", "yml"};
    private IUltimateServiceProvider mServices;
    private String mFilename;
    private ModelType.Type mWitnessType;
    private ILogger mLogger;

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void init() {
    }

    public void finish() {
    }

    public String getPluginName() {
        return "Witness Parser";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IPreferenceInitializer getPreferences() {
        return new WitnessParserPreferences();
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    public boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            return this.parseAST(fileArray[0]);
        }
        throw new UnsupportedOperationException("Cannot parse more than one file");
    }

    private Witness parseYaml(File file) {
        try {
            Witness witness = YamlWitnessParser.parseWitness(file);
            this.mWitnessType = witness.isCorrectnessWitness() ? ModelType.Type.CORRECTNESS_WITNESS : ModelType.Type.VIOLATION_WITNESS;
            return witness;
        }
        catch (IOException iOException) {
            this.mWitnessType = ModelType.Type.OTHER;
            return null;
        }
    }

    private IElement parseGraphML(File file) {
        WitnessAutomatonConstructor witnessAutomatonConstructor = new WitnessAutomatonConstructor(this.mServices);
        try {
            IElement iElement = witnessAutomatonConstructor.constructWitnessAutomaton(file);
            this.mWitnessType = witnessAutomatonConstructor.getWitnessType();
            return iElement;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.reportInvalidWitnessResult(fileNotFoundException.getMessage(), InvalidWitnessErrorResult.InvalidWitnessReasons.FILE_NOT_FOUND);
        }
        catch (GraphIOException graphIOException) {
            this.reportInvalidWitnessResult(graphIOException.getMessage(), InvalidWitnessErrorResult.InvalidWitnessReasons.XML_INVALID);
        }
        this.mWitnessType = ModelType.Type.OTHER;
        return null;
    }

    private IElement parseAST(File file) {
        this.mFilename = file.getAbsolutePath();
        if (file.getName().endsWith("yaml") || file.getName().endsWith("yml")) {
            return this.parseYaml(file);
        }
        if (file.getName().endsWith("graphml")) {
            return this.parseGraphML(file);
        }
        throw new AssertionError((Object)String.format("Unable to parse %s as witness.", file.getName()));
    }

    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    public ModelType getOutputDefinition() {
        return new ModelType(this.getPluginID(), this.mWitnessType, Collections.singleton(this.mFilename));
    }

    public void reportInvalidWitnessResult(String string, InvalidWitnessErrorResult.InvalidWitnessReasons invalidWitnessReasons) {
        InvalidWitnessErrorResult invalidWitnessErrorResult = new InvalidWitnessErrorResult(Activator.PLUGIN_ID, invalidWitnessReasons, string);
        this.mLogger.error((Object)string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)invalidWitnessErrorResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }
}

