/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConstructionCache<K, V>
implements Map<K, V> {
    private final Map<K, V> mMap;
    private final IValueConstruction<K, V> mValueComputation;

    public ConstructionCache(IValueConstruction<K, V> iValueConstruction, Map<K, V> map) {
        this.mValueComputation = iValueConstruction;
        this.mMap = map;
    }

    public ConstructionCache(IValueConstruction<K, V> iValueConstruction) {
        this(iValueConstruction, new HashMap());
    }

    public V getOrConstruct(K k) {
        V v = this.mMap.get(k);
        if (v == null) {
            v = this.mValueComputation.constructValue(k);
            this.mMap.put(k, v);
        }
        return v;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.mMap.get(object);
    }

    @Override
    public V put(K k, V v) {
        return this.mMap.put(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.mMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.mMap.putAll(map);
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mMap.entrySet();
    }

    @FunctionalInterface
    public static interface IValueConstruction<K, V> {
        public V constructValue(K var1);
    }
}

