/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonEpimorphism;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.ITransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.StraightLineInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TotalInterpolationAutomatonBuilder<LETTER extends IIcfgTransition<?>>
implements IInterpolantAutomatonBuilder<LETTER, IPredicate> {
    private final List<IPredicate> mStateSequence;
    private final NestedWordAutomaton<LETTER, IPredicate> mIA;
    private final PredicateFactory mPredicateFactory;
    private final IPredicateUnifier mPredicateUnifier;
    private final INestedWordAutomaton<LETTER, IPredicate> mAbstraction;
    private final CfgSmtToolkit mCsToolkit;
    private final ArrayDeque<IPredicate> mWorklist = new ArrayDeque();
    private final Set<IPredicate> mAnnotated = new HashSet<IPredicate>();
    private final AutomatonEpimorphism<IPredicate> mEpimorphism;
    private final IHoareTripleChecker mHtc;
    private final InterpolationTechnique mInterpolation;
    private final TotalInterpolationBenchmarkGenerator mBenchmarkGenerator = new TotalInterpolationBenchmarkGenerator();
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mCollectInterpolantStatistics;

    public TotalInterpolationAutomatonBuilder(INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, List<IPredicate> list, CfgSmtToolkit cfgSmtToolkit, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, InterpolationTechnique interpolationTechnique, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique, boolean bl, IPredicateUnifier iPredicateUnifier, TracePredicates tracePredicates) throws AutomataOperationCanceledException {
        this.mServices = iUltimateServiceProvider;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mCollectInterpolantStatistics = bl;
        this.mStateSequence = list;
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateFactory = (PredicateFactory)this.mPredicateUnifier.getPredicateFactory();
        this.mAbstraction = iNestedWordAutomaton;
        VpAlphabet vpAlphabet = NestedWordAutomataUtils.getVpAlphabet(iNestedWordAutomaton);
        this.mIA = new StraightLineInterpolantAutomatonBuilder(this.mServices, null, vpAlphabet, Collections.singletonList(tracePredicates), (IEmptyStackStateFactory<IPredicate>)predicateFactoryForInterpolantAutomata, StraightLineInterpolantAutomatonBuilder.InitialAndAcceptingStateMode.ONLY_FIRST_INITIAL_ONLY_FALSE_ACCEPTING).getResult();
        this.mInterpolation = interpolationTechnique;
        this.mEpimorphism = new AutomatonEpimorphism(new AutomataLibraryServices(this.mServices));
        IPredicate iPredicate2 = this.mStateSequence.get(0);
        this.mEpimorphism.insert((Object)iPredicate2, (Object)tracePredicates.getPrecondition());
        this.mAnnotated.add(iPredicate2);
        this.mWorklist.add(iPredicate2);
        this.addInterpolants(this.mStateSequence, tracePredicates.getPredicates());
        iPredicate2 = this.mStateSequence.get(this.mStateSequence.size() - 1);
        this.mEpimorphism.insert((Object)iPredicate2, (Object)tracePredicates.getPostcondition());
        this.mAnnotated.add(iPredicate2);
        this.mWorklist.add(iPredicate2);
        this.mHtc = HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)iUltimateServiceProvider, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)this.mPredicateUnifier);
        for (IPredicate iPredicate2 : list) {
            this.mWorklist.add(iPredicate2);
            this.mAnnotated.add(iPredicate2);
        }
        while (!this.mWorklist.isEmpty()) {
            iPredicate2 = this.mWorklist.removeFirst();
            this.doThings(iPredicate2);
        }
        this.mBenchmarkGenerator.addEdgeCheckerData(this.mHtc.getStatistics());
    }

    private void doThings(IPredicate iPredicate) throws AutomataOperationCanceledException {
        for (OutgoingInternalTransition outgoingInternalTransition : this.mAbstraction.internalSuccessors((Object)iPredicate)) {
            this.continueCheckForOutgoingPath(iPredicate, (ITransitionlet<LETTER, IPredicate>)outgoingInternalTransition, (IPredicate)outgoingInternalTransition.getSucc());
        }
        for (OutgoingInternalTransition outgoingInternalTransition : this.mAbstraction.callSuccessors((Object)iPredicate)) {
            this.continueCheckForOutgoingPath(iPredicate, (ITransitionlet<LETTER, IPredicate>)outgoingInternalTransition, (IPredicate)outgoingInternalTransition.getSucc());
        }
        for (OutgoingInternalTransition outgoingInternalTransition : this.mAbstraction.returnSuccessors((Object)iPredicate)) {
            if (!this.mAnnotated.contains(outgoingInternalTransition.getHierPred())) continue;
            this.continueCheckForOutgoingPath(iPredicate, (ITransitionlet<LETTER, IPredicate>)outgoingInternalTransition, (IPredicate)outgoingInternalTransition.getSucc());
        }
    }

    private void continueCheckForOutgoingPath(IPredicate iPredicate, ITransitionlet<LETTER, IPredicate> iTransitionlet, IPredicate iPredicate2) throws AutomataOperationCanceledException {
        if (this.mAnnotated.contains(iPredicate2)) {
            IPredicate iPredicate3;
            IPredicate iPredicate4 = (IPredicate)this.mEpimorphism.getMapping((Object)iPredicate);
            if (!this.interpolantAutomatonContainsTransition(iPredicate4, iTransitionlet, iPredicate3 = (IPredicate)this.mEpimorphism.getMapping((Object)iPredicate2))) {
                this.mBenchmarkGenerator.incrementPathLenght1();
                this.checkRunOfLenthOne(iPredicate4, iTransitionlet, iPredicate3);
            }
        } else {
            this.mBenchmarkGenerator.incrementRunSearches();
            NestedRun<LETTER, IPredicate> nestedRun = this.findRun(iPredicate2, this.mAnnotated);
            if (nestedRun != null) {
                NestedRun<LETTER, IPredicate> nestedRun2 = this.constructRunOfLengthOne(iPredicate, iTransitionlet);
                NestedRun nestedRun3 = nestedRun2.concatenate(nestedRun);
                this.checkRun(nestedRun3);
            }
        }
    }

    private boolean interpolantAutomatonContainsTransition(IPredicate iPredicate, ITransitionlet<LETTER, IPredicate> iTransitionlet, IPredicate iPredicate2) {
        if (iTransitionlet instanceof OutgoingInternalTransition) {
            OutgoingInternalTransition outgoingInternalTransition = (OutgoingInternalTransition)iTransitionlet;
            Set set = this.mIA.succInternal((Object)iPredicate, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()));
            return set.contains(iPredicate2);
        }
        if (iTransitionlet instanceof OutgoingCallTransition) {
            OutgoingCallTransition outgoingCallTransition = (OutgoingCallTransition)iTransitionlet;
            Set set = this.mIA.succCall((Object)iPredicate, (Object)((IIcfgTransition)outgoingCallTransition.getLetter()));
            return set.contains(iPredicate2);
        }
        if (iTransitionlet instanceof OutgoingReturnTransition) {
            OutgoingReturnTransition outgoingReturnTransition = (OutgoingReturnTransition)iTransitionlet;
            IPredicate iPredicate3 = (IPredicate)this.mEpimorphism.getMapping((Object)((IPredicate)outgoingReturnTransition.getHierPred()));
            Set set = this.mIA.succReturn((Object)iPredicate, (Object)iPredicate3, (Object)((IIcfgTransition)outgoingReturnTransition.getLetter()));
            return set.contains(iPredicate2);
        }
        if (iTransitionlet instanceof SummaryReturnTransition) {
            SummaryReturnTransition summaryReturnTransition = (SummaryReturnTransition)iTransitionlet;
            IPredicate iPredicate4 = (IPredicate)this.mEpimorphism.getMapping((Object)((IPredicate)summaryReturnTransition.getLinPred()));
            Set set = this.mIA.succReturn((Object)iPredicate4, (Object)iPredicate, (Object)((IIcfgTransition)summaryReturnTransition.getLetter()));
            return set != null && set.contains(iPredicate2);
        }
        throw new AssertionError((Object)("unsupported" + String.valueOf(iTransitionlet.getClass())));
    }

    private NestedRun<LETTER, IPredicate> constructRunOfLengthOne(IPredicate iPredicate, ITransitionlet<LETTER, IPredicate> iTransitionlet) {
        if (iTransitionlet instanceof OutgoingInternalTransition) {
            OutgoingInternalTransition outgoingInternalTransition = (OutgoingInternalTransition)iTransitionlet;
            return new NestedRun((Object)iPredicate, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), -2, (Object)((IPredicate)outgoingInternalTransition.getSucc()));
        }
        if (iTransitionlet instanceof OutgoingCallTransition) {
            OutgoingCallTransition outgoingCallTransition = (OutgoingCallTransition)iTransitionlet;
            return new NestedRun((Object)iPredicate, (Object)((IIcfgTransition)outgoingCallTransition.getLetter()), Integer.MAX_VALUE, (Object)((IPredicate)outgoingCallTransition.getSucc()));
        }
        if (iTransitionlet instanceof OutgoingReturnTransition) {
            OutgoingReturnTransition outgoingReturnTransition = (OutgoingReturnTransition)iTransitionlet;
            return new NestedRun((Object)iPredicate, (Object)((IIcfgTransition)outgoingReturnTransition.getLetter()), Integer.MIN_VALUE, (Object)((IPredicate)outgoingReturnTransition.getSucc()));
        }
        if (iTransitionlet instanceof SummaryReturnTransition) {
            SummaryReturnTransition summaryReturnTransition = (SummaryReturnTransition)iTransitionlet;
            return new NestedRun((Object)((IPredicate)summaryReturnTransition.getLinPred()), (Object)((IIcfgTransition)summaryReturnTransition.getLetter()), Integer.MIN_VALUE, (Object)((IPredicate)summaryReturnTransition.getSucc()));
        }
        throw new AssertionError((Object)("unsupported" + String.valueOf(iTransitionlet.getClass())));
    }

    private void checkRunOfLenthOne(IPredicate iPredicate, ITransitionlet<LETTER, IPredicate> iTransitionlet, IPredicate iPredicate2) {
        if (iTransitionlet instanceof OutgoingInternalTransition) {
            OutgoingInternalTransition outgoingInternalTransition = (OutgoingInternalTransition)iTransitionlet;
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkInternal(iPredicate, (IInternalAction)iTransitionlet.getLetter(), iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                this.mIA.addInternalTransition((Object)iPredicate, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), (Object)iPredicate2);
            }
        } else if (iTransitionlet instanceof OutgoingCallTransition) {
            OutgoingCallTransition outgoingCallTransition = (OutgoingCallTransition)iTransitionlet;
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkCall(iPredicate, (ICallAction)outgoingCallTransition.getLetter(), iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                this.mIA.addCallTransition((Object)iPredicate, (Object)((IIcfgTransition)outgoingCallTransition.getLetter()), (Object)iPredicate2);
            }
        } else if (iTransitionlet instanceof OutgoingReturnTransition) {
            OutgoingReturnTransition outgoingReturnTransition = (OutgoingReturnTransition)iTransitionlet;
            IPredicate iPredicate3 = (IPredicate)this.mEpimorphism.getMapping((Object)((IPredicate)outgoingReturnTransition.getHierPred()));
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkReturn(iPredicate, iPredicate3, (IReturnAction)outgoingReturnTransition.getLetter(), iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                this.mIA.addReturnTransition((Object)iPredicate, (Object)iPredicate3, (Object)((IIcfgTransition)outgoingReturnTransition.getLetter()), (Object)iPredicate2);
            }
        } else if (iTransitionlet instanceof SummaryReturnTransition) {
            SummaryReturnTransition summaryReturnTransition = (SummaryReturnTransition)iTransitionlet;
            IPredicate iPredicate4 = (IPredicate)this.mEpimorphism.getMapping((Object)((IPredicate)summaryReturnTransition.getLinPred()));
            IncrementalPlicationChecker.Validity validity = this.mHtc.checkReturn(iPredicate4, iPredicate, (IReturnAction)summaryReturnTransition.getLetter(), iPredicate2);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                this.mIA.addReturnTransition((Object)iPredicate4, (Object)iPredicate, (Object)((IIcfgTransition)summaryReturnTransition.getLetter()), (Object)iPredicate2);
            }
        } else {
            throw new AssertionError((Object)("unsupported" + String.valueOf(iTransitionlet.getClass())));
        }
    }

    private void checkRun(NestedRun<LETTER, IPredicate> nestedRun) {
        IPredicate iPredicate = (IPredicate)nestedRun.getStateAtPosition(0);
        IPredicate iPredicate2 = (IPredicate)nestedRun.getStateAtPosition(nestedRun.getLength() - 1);
        IPredicate iPredicate3 = (IPredicate)this.mEpimorphism.getMapping((Object)iPredicate);
        IPredicate iPredicate4 = (IPredicate)this.mEpimorphism.getMapping((Object)iPredicate2);
        SortedMap<Integer, IPredicate> sortedMap = this.computePendingContexts(nestedRun);
        Counterexample counterexample = new Counterexample((Word)nestedRun.getWord(), nestedRun.getStateSequence());
        InterpolatingTraceCheckCraig interpolatingTraceCheckCraig = switch (this.mInterpolation) {
            case InterpolationTechnique.Craig_NestedInterpolation, InterpolationTechnique.Craig_TreeInterpolation -> new InterpolatingTraceCheckCraig(iPredicate3, iPredicate4, sortedMap, counterexample, this.mServices, this.mCsToolkit, this.mPredicateFactory, this.mPredicateUnifier, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, false, this.mCollectInterpolantStatistics, this.mInterpolation, true, this.mSimplificationTechnique);
            case InterpolationTechnique.ForwardPredicates, InterpolationTechnique.BackwardPredicates, InterpolationTechnique.FPandBP, InterpolationTechnique.FPandBPonlyIfFpWasNotPerfect -> new TraceCheckSpWp(iPredicate3, iPredicate4, sortedMap, counterexample, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, true, this.mServices, false, this.mPredicateFactory, this.mPredicateUnifier, this.mInterpolation, this.mCsToolkit.getManagedScript(), this.mSimplificationTechnique, this.mCollectInterpolantStatistics);
            default -> throw new UnsupportedOperationException("unsupported interpolation");
        };
        this.mBenchmarkGenerator.addTraceCheckData((IStatisticsDataProvider)interpolatingTraceCheckCraig.getStatistics());
        if (interpolatingTraceCheckCraig.isCorrect() == Script.LBool.UNSAT) {
            this.mBenchmarkGenerator.incrementUsefullRunGeq2();
            int n = this.addInterpolants((List<IPredicate>)nestedRun.getStateSequence(), interpolatingTraceCheckCraig.getInterpolants());
            this.mBenchmarkGenerator.reportAdditionalInterpolants(n);
            this.addTransitions((InterpolatingTraceCheck<LETTER>)interpolatingTraceCheckCraig);
        } else {
            this.mBenchmarkGenerator.incrementUselessRunGeq2();
        }
    }

    private SortedMap<Integer, IPredicate> computePendingContexts(NestedRun<LETTER, IPredicate> nestedRun) {
        TreeMap<Integer, IPredicate> treeMap = new TreeMap<Integer, IPredicate>();
        Iterator iterator = nestedRun.getWord().getPendingReturns().keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            IPredicate iPredicate = (IPredicate)nestedRun.getStateAtPosition(n);
            Set set = NestedWordAutomataUtils.hierarchicalPredecessorsOutgoing((Object)iPredicate, (Object)((IIcfgTransition)nestedRun.getSymbol(n)), this.mAbstraction);
            IPredicate iPredicate2 = this.getSomeAnnotatedState(set);
            if (iPredicate2 == null) {
                throw new AssertionError((Object)"found nothing");
            }
            treeMap.put(n, (IPredicate)this.mEpimorphism.getMapping((Object)iPredicate2));
        }
        return treeMap;
    }

    private IPredicate getSomeAnnotatedState(Iterable<IPredicate> iterable) {
        for (IPredicate iPredicate : iterable) {
            if (!this.mAnnotated.contains(iPredicate)) continue;
            return iPredicate;
        }
        return null;
    }

    private void addTransitions(InterpolatingTraceCheck<LETTER> interpolatingTraceCheck) {
        TracePredicates tracePredicates = new TracePredicates(interpolatingTraceCheck);
        NestedWord nestedWord = TraceCheckUtils.toNestedWord((List)interpolatingTraceCheck.getTrace());
        int n = 0;
        while (n < nestedWord.length()) {
            if (nestedWord.isInternalPosition(n)) {
                this.mIA.addInternalTransition((Object)tracePredicates.getPredicate(n), (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)tracePredicates.getPredicate(n + 1));
            } else if (nestedWord.isCallPosition(n)) {
                this.mIA.addCallTransition((Object)tracePredicates.getPredicate(n), (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)tracePredicates.getPredicate(n + 1));
            } else if (nestedWord.isReturnPosition(n)) {
                IPredicate iPredicate;
                if (nestedWord.isPendingReturn(n)) {
                    iPredicate = (IPredicate)interpolatingTraceCheck.getPendingContexts().get(n);
                } else {
                    int n2 = nestedWord.getCallPosition(n);
                    iPredicate = tracePredicates.getPredicate(n2);
                }
                this.mIA.addReturnTransition((Object)tracePredicates.getPredicate(n), (Object)iPredicate, (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)tracePredicates.getPredicate(n + 1));
            } else {
                throw new AssertionError();
            }
            ++n;
        }
    }

    private int addInterpolants(List<IPredicate> list, IPredicate[] iPredicateArray) {
        return this.addInterpolants(list, Arrays.asList(iPredicateArray));
    }

    private int addInterpolants(List<IPredicate> list, List<IPredicate> list2) {
        int n = 0;
        int n2 = 0;
        for (IPredicate iPredicate : list2) {
            IPredicate iPredicate2 = list.get(n2 + 1);
            if (!this.mIA.getStates().contains(iPredicate)) {
                this.mIA.addState(false, false, (Object)iPredicate);
                ++n;
            }
            this.mAnnotated.add(iPredicate2);
            this.mEpimorphism.insert((Object)iPredicate2, (Object)iPredicate);
            this.mWorklist.add(iPredicate2);
            ++n2;
        }
        return n;
    }

    private NestedRun<LETTER, IPredicate> findRun(IPredicate iPredicate, Set<IPredicate> set) throws AutomataOperationCanceledException {
        return new IsEmpty(new AutomataLibraryServices(this.mServices), this.mAbstraction, Collections.singleton(iPredicate), Collections.emptySet(), this.mAnnotated).getNestedRun();
    }

    @Override
    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mIA;
    }

    public TotalInterpolationBenchmarkGenerator getTotalInterpolationBenchmark() {
        return this.mBenchmarkGenerator;
    }

    public static class TotalInterpolationBenchmarkGenerator
    implements IStatisticsDataProvider {
        private int mAdditionalInterpolants = 0;
        private int mPathLenght1 = 0;
        private int mRunSearches = 0;
        private int mUsefullRunGeq2 = 0;
        private int mUselessRunGeq2 = 0;
        private final StatisticsData mEcData = new StatisticsData();
        private final StatisticsData mTcData = new StatisticsData();

        public Collection<String> getKeys() {
            return TotalInterpolationBenchmarkType.getInstance().getKeys();
        }

        public void reportAdditionalInterpolants(int n) {
            this.mAdditionalInterpolants += n;
        }

        public void incrementPathLenght1() {
            ++this.mPathLenght1;
        }

        public void incrementRunSearches() {
            ++this.mRunSearches;
        }

        public void incrementUsefullRunGeq2() {
            ++this.mUsefullRunGeq2;
        }

        public void incrementUselessRunGeq2() {
            ++this.mUselessRunGeq2;
        }

        public void addEdgeCheckerData(IStatisticsDataProvider iStatisticsDataProvider) {
            this.mEcData.aggregateBenchmarkData(iStatisticsDataProvider);
        }

        public void addTraceCheckData(IStatisticsDataProvider iStatisticsDataProvider) {
            this.mTcData.aggregateBenchmarkData(iStatisticsDataProvider);
        }

        public Object getValue(String string) {
            switch (string) {
                case "AdditionalInterpolants": {
                    return this.mAdditionalInterpolants;
                }
                case "RunLenght1": {
                    return this.mPathLenght1;
                }
                case "RunSearches": {
                    return this.mRunSearches;
                }
                case "UsefullRunGeq2": {
                    return this.mUsefullRunGeq2;
                }
                case "UselessRunGeq2": {
                    return this.mUselessRunGeq2;
                }
                case "traceCheckBenchmarks": {
                    return this.mTcData;
                }
                case "EdgeCheckerBenchmarks": {
                    return this.mEcData;
                }
            }
            throw new AssertionError((Object)"unknown key");
        }

        public IStatisticsType getBenchmarkType() {
            return TotalInterpolationBenchmarkType.getInstance();
        }
    }

    public static class TotalInterpolationBenchmarkType
    implements IStatisticsType {
        private static TotalInterpolationBenchmarkType s_Instance = new TotalInterpolationBenchmarkType();
        public static final String s_AdditionalInterpolants = "AdditionalInterpolants";
        public static final String s_PathLenght1 = "RunLenght1";
        public static final String s_RunSearches = "RunSearches";
        public static final String s_UsefullRunGeq2 = "UsefullRunGeq2";
        public static final String s_UselessRunGeq2 = "UselessRunGeq2";
        public static final String s_TraceCheckBenchmarks = "traceCheckBenchmarks";
        public static final String s_EdgeCheckerBenchmarks = "EdgeCheckerBenchmarks";

        public static TotalInterpolationBenchmarkType getInstance() {
            return s_Instance;
        }

        public Collection<String> getKeys() {
            return Arrays.asList(s_AdditionalInterpolants, s_PathLenght1, s_RunSearches, s_UsefullRunGeq2, s_UselessRunGeq2, s_TraceCheckBenchmarks, s_EdgeCheckerBenchmarks);
        }

        public Object aggregate(String string, Object object, Object object2) {
            switch (string) {
                case "RunLenght1": 
                case "AdditionalInterpolants": 
                case "UsefullRunGeq2": 
                case "RunSearches": 
                case "UselessRunGeq2": {
                    return (Integer)object + (Integer)object2;
                }
                case "EdgeCheckerBenchmarks": 
                case "traceCheckBenchmarks": {
                    StatisticsData statisticsData = (StatisticsData)object;
                    StatisticsData statisticsData2 = (StatisticsData)object2;
                    statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)statisticsData2);
                    return statisticsData;
                }
            }
            throw new AssertionError((Object)"unknown key");
        }

        public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = new String[]{s_AdditionalInterpolants, s_PathLenght1, s_RunSearches, s_UsefullRunGeq2, s_UselessRunGeq2};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray[n2];
                int n3 = (Integer)iStatisticsDataProvider.getValue(string);
                stringBuilder.append(string);
                stringBuilder.append(": ");
                stringBuilder.append(n3);
                stringBuilder.append("  ");
                ++n2;
            }
            stringBuilder.append(s_TraceCheckBenchmarks);
            stringBuilder.append(": ");
            string = (StatisticsData)iStatisticsDataProvider.getValue(s_TraceCheckBenchmarks);
            stringBuilder.append((Object)string);
            stringBuilder.append("  ");
            stringBuilder.append(s_EdgeCheckerBenchmarks);
            stringBuilder.append(": ");
            StatisticsData statisticsData = (StatisticsData)iStatisticsDataProvider.getValue(s_EdgeCheckerBenchmarks);
            stringBuilder.append(statisticsData);
            return stringBuilder.toString();
        }
    }
}

