/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.IScopedMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class BaseScopedSet<E>
implements Set<E> {
    private final IScopedMap<E, Object> mBacking;

    protected BaseScopedSet(IScopedMap<E, Object> iScopedMap) {
        this.mBacking = iScopedMap;
    }

    public void beginScope() {
        this.mBacking.beginScope();
    }

    public void endScope() {
        this.mBacking.endScope();
    }

    @Override
    public boolean add(E e) {
        return this.mBacking.put(e, this) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.mBacking.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.mBacking.get(object) == this;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mBacking.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mBacking.isEmptyScope();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mBacking.keySet().iterator();
    }

    public Iterable<E> currentScope() {
        return this.mBacking.currentScopeKeys();
    }

    @Override
    public boolean remove(Object object) {
        return this.mBacking.remove(object) != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mBacking.size();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = -1;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            objectArray[++n] = iterator.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        T[] TArray2 = TArray.length >= n ? TArray : Arrays.copyOf(TArray, n);
        int n2 = -1;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            TArray2[++n2] = iterator.next();
        }
        return TArray2;
    }

    public String toString() {
        return this.mBacking.keySet().toString();
    }
}

