/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.bitvector;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.bitvector.BvUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.math.BigInteger;

public class BvToIntUtils {
    private final Theory mTheory;
    private final Sort mInteger;
    private final BvUtils mBvUtils;
    IProofTracker mTracker;
    boolean mDealWithBvToNatAndNatToBvInPreprocessing;

    public BvToIntUtils(Theory theory, LogicSimplifier logicSimplifier, BvUtils bvUtils, IProofTracker iProofTracker, boolean bl) {
        this.mTheory = theory;
        this.mBvUtils = bvUtils;
        this.mTracker = iProofTracker;
        this.mInteger = theory.getSort("Int", new Sort[0]);
        this.mDealWithBvToNatAndNatToBvInPreprocessing = bl;
    }

    public Term bv2nat(Term term, boolean bl) {
        assert (term.getSort().isBitVecSort());
        if (term instanceof ApplicationTerm && this.mDealWithBvToNatAndNatToBvInPreprocessing) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getFunction().getName().equals("nat2bv")) {
                Term term2 = applicationTerm.getParameters()[0];
                if (bl) {
                    int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
                    Rational rational = this.pow2(n);
                    if (term2 instanceof ConstantTerm) {
                        Rational rational2 = (Rational)((ConstantTerm)term2).getValue();
                        return rational2.sub(rational.mul(rational2.div(rational).floor())).toTerm(this.mInteger);
                    }
                    return this.mTheory.term("mod", new Term[]{term2, rational.toTerm(this.mInteger)});
                }
                return term2;
            }
            if (applicationTerm.getFunction().getName().equals("ite")) {
                return this.mTheory.term("ite", new Term[]{applicationTerm.getParameters()[0], this.bv2nat(applicationTerm.getParameters()[1], bl), this.bv2nat(applicationTerm.getParameters()[2], bl)});
            }
        }
        return this.mTheory.term("bv2nat", new Term[]{term});
    }

    public Term nat2bv(Term term, String[] stringArray) {
        assert (term.getSort().isNumericSort());
        return this.mTheory.term("nat2bv", stringArray, null, new Term[]{term});
    }

    private Rational pow2(int n) {
        return Rational.valueOf((BigInteger)BigInteger.ONE.shiftLeft(n), (BigInteger)BigInteger.ONE);
    }

    public Term translateBvConstantTerm(ConstantTerm constantTerm) {
        assert (constantTerm.getSort().isBitVecSort());
        return this.nat2bv(this.translateConstant(constantTerm.getValue()), constantTerm.getSort().getIndices());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Term translateConstant(Object object) {
        BigInteger bigInteger;
        Sort sort = this.mTheory.getSort("Int", new Sort[0]);
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("#b")) {
                string = (String)object;
                bigInteger = new BigInteger(string.substring(2), 2);
                return this.mTheory.rational(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort);
            } else {
                if (!string.startsWith("#x")) throw new UnsupportedOperationException("Unexpected constant type");
                bigInteger = new BigInteger(string.substring(2), 16);
            }
            return this.mTheory.rational(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort);
        } else {
            if (!(object instanceof BigInteger)) throw new UnsupportedOperationException("Unexpected constant type");
            bigInteger = (BigInteger)object;
        }
        return this.mTheory.rational(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), sort);
    }

    public Term trackBvRewrite(Term term, Term term2, Annotation annotation) {
        return this.mTracker.transitivity(term, this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term2, annotation));
    }

    public Term translateBvArithmetic(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Annotation annotation = null;
        Polynomial polynomial = new Polynomial(this.bv2nat(termArray[0], false));
        Polynomial polynomial2 = new Polynomial(this.bv2nat(termArray[1], false));
        switch (functionSymbol.getName()) {
            case "bvadd": {
                polynomial.add(Rational.ONE, polynomial2);
                annotation = ProofConstants.RW_BVADD2INT;
                break;
            }
            case "bvsub": {
                polynomial.add(Rational.MONE, polynomial2);
                annotation = ProofConstants.RW_BVSUB2INT;
                break;
            }
            case "bvmul": {
                polynomial.mul(polynomial2);
                annotation = ProofConstants.RW_BVMUL2INT;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not an artihmetic BitVector Function: " + functionSymbol.getName());
            }
        }
        String string = polynomial.toTerm(this.mInteger);
        string = this.nat2bv((Term)string, termArray[0].getSort().getIndices());
        return this.trackBvRewrite(term, (Term)string, annotation);
    }

    public Term translateBvNeg(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = this.mTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Polynomial polynomial = new Polynomial();
        polynomial.add(Rational.MONE, this.bv2nat(termArray[0], false));
        Term term3 = polynomial.toTerm(this.mInteger);
        Term term4 = this.nat2bv(term3, termArray[0].getSort().getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_BVNOT2INT);
    }

    public Term translateBvNot(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = this.mTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = Integer.valueOf(functionSymbol.getReturnSort().getIndices()[0]);
        Polynomial polynomial = new Polynomial();
        polynomial.add(this.pow2(n).add(Rational.MONE));
        polynomial.add(Rational.MONE, this.bv2nat(termArray[0], false));
        Term term3 = polynomial.toTerm(this.mInteger);
        Term term4 = this.nat2bv(term3, termArray[0].getSort().getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_BVNOT2INT);
    }

    public Term translateConcat(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = Integer.valueOf(termArray[1].getSort().getIndices()[0]);
        Polynomial polynomial = new Polynomial();
        polynomial.add(this.pow2(n), this.bv2nat(termArray[0], false));
        polynomial.add(Rational.ONE, this.bv2nat(termArray[1], true));
        Term term3 = polynomial.toTerm(this.mInteger);
        Term term4 = this.nat2bv(term3, functionSymbol.getReturnSort().getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_CONCAT2INT);
    }

    public Term translateBvudiv(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = Integer.valueOf(functionSymbol.getReturnSort().getIndices()[0]);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        Term term3 = this.mTheory.rational(Rational.valueOf((BigInteger)bigInteger.pow(n).subtract(BigInteger.ONE), (BigInteger)BigInteger.ONE), this.mTheory.getSort("Int", new Sort[0]));
        Term term4 = this.mTheory.term("=", new Term[]{this.bv2nat(termArray[1], true), this.mTheory.rational(Rational.ZERO, this.mTheory.getSort("Int", new Sort[0]))});
        Term term5 = term3;
        Term term6 = this.mTheory.term("div", new Term[]{this.bv2nat(termArray[0], true), this.bv2nat(termArray[1], true)});
        Term term7 = this.nat2bv(this.mTheory.term("ite", new Term[]{term4, term5, term6}), functionSymbol.getReturnSort().getIndices());
        return this.trackBvRewrite(term, term7, ProofConstants.RW_BVUDIV2INT);
    }

    public Term translateBvurem(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        if (this.mBvUtils.isConstRelation(termArray[0], termArray[1])) {
            Term term3 = this.mBvUtils.simplifyBitvectorConstantOp(functionSymbol, termArray[0], termArray[1]);
            return this.trackBvRewrite(term, term3, ProofConstants.RW_BVEVAL);
        }
        Sort sort = this.mTheory.getSort("Int", new Sort[0]);
        Term term4 = this.bv2nat(termArray[0], true);
        Term term5 = this.bv2nat(termArray[1], true);
        Term term6 = this.mTheory.term("=", new Term[]{term5, this.mTheory.rational(Rational.ZERO, sort)});
        Term term7 = term4;
        Term term8 = this.mTheory.term("mod", new Term[]{term4, term5});
        Term term9 = this.nat2bv(this.mTheory.term("ite", new Term[]{term6, term7, term8}), functionSymbol.getReturnSort().getIndices());
        return this.trackBvRewrite(term, term9, ProofConstants.RW_BVUREM2INT);
    }

    public int log2(int n) {
        int n2 = 0;
        while ((long)n >= 1L << n2) {
            ++n2;
        }
        return n2 - 1;
    }

    public Term translateBvshl(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2;
        Term term3 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        Term term4 = this.bv2nat(termArray[0], false);
        Term term5 = this.bv2nat(termArray[1], true);
        int n = Integer.valueOf(functionSymbol.getReturnSort().getIndices()[0]);
        Term term6 = this.mTheory.rational(Rational.ZERO, this.mInteger);
        if (term5 instanceof ConstantTerm) {
            Rational rational = (Rational)((ConstantTerm)term5).getValue();
            if (rational.numerator().compareTo(BigInteger.valueOf(n)) >= 0) {
                term2 = term6;
            } else {
                int n2 = rational.numerator().intValueExact();
                Polynomial polynomial = new Polynomial();
                polynomial.add(this.pow2(n2), term4);
                term2 = polynomial.toTerm(this.mInteger);
            }
        } else {
            int n3 = this.log2(n);
            Polynomial polynomial = new Polynomial(term5);
            Term term7 = term4;
            int n4 = n3;
            while (n4 >= 0) {
                Rational rational = Rational.valueOf((long)(1 << n4), (long)1L);
                Polynomial polynomial2 = new Polynomial();
                polynomial2.add(rational);
                polynomial2.add(Rational.MONE, polynomial);
                Term term8 = this.mTheory.term("<=", new Term[]{polynomial2.toTerm(this.mInteger), term6});
                polynomial.add(Rational.ONE, this.mTheory.term("ite", new Term[]{term8, rational.negate().toTerm(this.mInteger), term6}));
                Polynomial polynomial3 = new Polynomial();
                polynomial3.add(this.pow2(1 << n4), term7);
                term7 = this.mTheory.term("ite", new Term[]{term8, polynomial3.toTerm(this.mInteger), term7});
                --n4;
            }
            term2 = term7;
        }
        return this.trackBvRewrite(term, this.nat2bv(term2, functionSymbol.getReturnSort().getIndices()), ProofConstants.RW_BVSHL2INT);
    }

    public Term translateBvlshr(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2;
        Term term3 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        int n = Integer.valueOf(functionSymbol.getReturnSort().getIndices()[0]);
        Term term4 = this.bv2nat(termArray[0], true);
        Term term5 = this.bv2nat(termArray[1], true);
        Term term6 = this.mTheory.rational(Rational.ZERO, this.mInteger);
        if (term5 instanceof ConstantTerm) {
            int n2;
            Rational rational = (Rational)((ConstantTerm)term5).getValue();
            term2 = rational.numerator().compareTo(BigInteger.valueOf(n)) >= 0 ? term6 : ((n2 = rational.numerator().intValueExact()) == 0 ? term4 : this.mTheory.term("div", new Term[]{term4, this.pow2(n2).toTerm(this.mInteger)}));
        } else {
            int n3 = this.log2(n);
            Polynomial polynomial = new Polynomial(term5);
            Term term7 = term4;
            int n4 = n3;
            while (n4 >= 0) {
                Rational rational = Rational.valueOf((long)(1 << n4), (long)1L);
                Polynomial polynomial2 = new Polynomial();
                polynomial2.add(rational);
                polynomial2.add(Rational.MONE, polynomial);
                Term term8 = this.mTheory.term("<=", new Term[]{polynomial2.toTerm(this.mInteger), term6});
                polynomial.add(Rational.ONE, this.mTheory.term("ite", new Term[]{term8, rational.negate().toTerm(this.mInteger), term6}));
                Term term9 = this.mTheory.term("div", new Term[]{term7, this.pow2(1 << n4).toTerm(this.mInteger)});
                term7 = this.mTheory.term("ite", new Term[]{term8, term9, term7});
                --n4;
            }
            term2 = term7;
        }
        return this.trackBvRewrite(term, this.nat2bv(term2, functionSymbol.getReturnSort().getIndices()), ProofConstants.RW_BVLSHR2INT);
    }

    public Term translateExtract(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term term2 = iProofTracker.getProvedTerm(term);
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        if (this.mBvUtils.isConstant(termArray[0])) {
            Term term3 = this.mBvUtils.simplifySelectConst(functionSymbol, termArray[0]);
            return this.trackBvRewrite(term, term3, ProofConstants.RW_BVEVAL);
        }
        Sort sort = this.mTheory.getSort("Int", new Sort[0]);
        Term term4 = this.bv2nat(termArray[0], false);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        int n = Integer.parseInt(functionSymbol.getIndices()[1]);
        int n2 = Integer.parseInt(functionSymbol.getIndices()[0]);
        Term term5 = this.mTheory.rational(Rational.valueOf((BigInteger)bigInteger.pow(n), (BigInteger)BigInteger.ONE), sort);
        int n3 = n2 - n + 1;
        String[] stringArray = new String[]{String.valueOf(n3)};
        Term term6 = this.nat2bv(this.mTheory.term("div", new Term[]{term4, term5}), stringArray);
        return this.trackBvRewrite(term, term6, ProofConstants.RW_EXTRACT2INT);
    }

    public Term translateRelations(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        boolean bl;
        String string;
        Term[] termArray = ((ApplicationTerm)iProofTracker.getProvedTerm(term)).getParameters();
        int n = Integer.valueOf(termArray[0].getSort().getIndices()[0]);
        assert (functionSymbol.isIntern());
        Annotation annotation = switch (functionSymbol.getName()) {
            case "distinct" -> {
                string = "distinct";
                bl = false;
                yield ProofConstants.RW_BVEQ2INT;
            }
            case "=" -> {
                string = "=";
                bl = false;
                yield ProofConstants.RW_BVEQ2INT;
            }
            case "bvult" -> {
                string = "<";
                bl = false;
                yield ProofConstants.RW_BVULT2INT;
            }
            case "bvule" -> {
                string = "<=";
                bl = false;
                yield ProofConstants.RW_BVULE2INT;
            }
            case "bvugt" -> {
                string = ">";
                bl = false;
                yield ProofConstants.RW_BVUGT2INT;
            }
            case "bvuge" -> {
                string = ">=";
                bl = false;
                yield ProofConstants.RW_BVUGE2INT;
            }
            case "bvslt" -> {
                string = "<";
                bl = true;
                yield ProofConstants.RW_BVSLT2INT;
            }
            case "bvsle" -> {
                string = "<=";
                bl = true;
                yield ProofConstants.RW_BVSLE2INT;
            }
            case "bvsgt" -> {
                string = ">";
                bl = true;
                yield ProofConstants.RW_BVSGT2INT;
            }
            case "bvsge" -> {
                string = ">=";
                bl = true;
                yield ProofConstants.RW_BVSGE2INT;
            }
            default -> throw new AssertionError((Object)"unexpected relation");
        };
        Term[] termArray2 = new Term[termArray.length];
        int n2 = 0;
        while (n2 < termArray.length) {
            termArray2[n2] = this.bv2nat(termArray[n2], !bl);
            if (bl) {
                termArray2[n2] = this.uts(n, termArray2[n2]);
            }
            ++n2;
        }
        Term term2 = this.mTheory.term(string, termArray2);
        return this.trackBvRewrite(term, term2, annotation);
    }

    private final Term uts(int n, Term term) {
        Rational rational = this.pow2(n - 1);
        Rational rational2 = this.pow2(n);
        if (term instanceof ConstantTerm) {
            Rational rational3 = (Rational)((ConstantTerm)term).getValue();
            rational3 = rational3.sub(rational3.add(rational).div(rational2).floor().mul(rational2));
            return rational3.toTerm(this.mInteger);
        }
        Polynomial polynomial = new Polynomial(term);
        polynomial.add(rational);
        Term term2 = polynomial.toTerm(this.mInteger);
        polynomial.add(rational2.negate(), this.mTheory.term("div", new Term[]{term2, rational2.toTerm(this.mInteger)}));
        polynomial.add(rational.negate());
        return polynomial.toTerm(this.mInteger);
    }

    public Term bitBlastAndConstant(Term term, Rational rational, int n) {
        int n2;
        assert (rational.isIntegral());
        BigInteger bigInteger = rational.numerator();
        Polynomial polynomial = new Polynomial();
        if (term instanceof ConstantTerm) {
            Rational rational2 = (Rational)((ConstantTerm)term).getValue();
            assert (rational2.isIntegral());
            BigInteger bigInteger2 = rational2.numerator().and(bigInteger);
            return Rational.valueOf((BigInteger)bigInteger2, (BigInteger)BigInteger.ONE).toTerm(this.mInteger);
        }
        while ((n2 = bigInteger.getLowestSetBit()) < n && n2 >= 0) {
            BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(n2);
            bigInteger = bigInteger.add(bigInteger3);
            if (n2 == 0) {
                polynomial.add(Rational.ONE, term);
            } else {
                Rational rational3 = Rational.valueOf((BigInteger)bigInteger3, (BigInteger)BigInteger.ONE);
                polynomial.add(rational3, this.mTheory.term("div", new Term[]{term, rational3.toTerm(this.mInteger)}));
            }
            int n3 = bigInteger.getLowestSetBit();
            if (n3 >= n || n3 < 0) break;
            BigInteger bigInteger4 = BigInteger.ONE.shiftLeft(n3);
            bigInteger = bigInteger.subtract(bigInteger4);
            Rational rational4 = Rational.valueOf((BigInteger)bigInteger4, (BigInteger)BigInteger.ONE);
            polynomial.add(rational4.negate(), this.mTheory.term("div", new Term[]{term, rational4.toTerm(this.mInteger)}));
        }
        return polynomial.toTerm(this.mInteger);
    }

    public Term bitBlastAnd(Term term, Term term2, int n) {
        if (term2 instanceof ConstantTerm) {
            return this.bitBlastAndConstant(term, (Rational)((ConstantTerm)term2).getValue(), n);
        }
        if (term instanceof ConstantTerm) {
            return this.bitBlastAndConstant(term2, (Rational)((ConstantTerm)term).getValue(), n);
        }
        Term term3 = this.mTheory.rational(Rational.ONE, this.mInteger);
        Term term4 = this.mTheory.rational(Rational.ZERO, this.mInteger);
        Polynomial polynomial = new Polynomial();
        int n2 = 0;
        while (n2 < n) {
            Term term5 = this.mTheory.term("ite", new Term[]{this.mTheory.term("=", new Term[]{this.isel(n2, term), term3}), this.isel(n2, term2), term4});
            polynomial.add(this.pow2(n2), term5);
            ++n2;
        }
        return polynomial.toTerm(this.mInteger);
    }

    public Term translateBvandSum(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Sort sort = functionSymbol.getReturnSort();
        int n = Integer.valueOf(sort.getIndices()[0]);
        Term[] termArray = ((ApplicationTerm)iProofTracker.getProvedTerm(term)).getParameters();
        Term term2 = this.bv2nat(termArray[0], false);
        Term term3 = this.bv2nat(termArray[1], false);
        Term term4 = this.nat2bv(this.bitBlastAnd(term2, term3, n), sort.getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_BVBLAST);
    }

    private Term isel(int n, Term term) {
        Sort sort = this.mTheory.getSort("Int", new Sort[0]);
        Term term2 = this.mTheory.rational(Rational.TWO, sort);
        Term term3 = this.mTheory.rational(Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE), sort);
        return this.mTheory.term("mod", new Term[]{this.mTheory.term("div", new Term[]{term, term3}), term2});
    }

    public Term translateBvor(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term[] termArray = ((ApplicationTerm)iProofTracker.getProvedTerm(term)).getParameters();
        Term term2 = this.bv2nat(termArray[0], false);
        Term term3 = this.bv2nat(termArray[1], false);
        Sort sort = functionSymbol.getReturnSort();
        int n = Integer.valueOf(sort.getIndices()[0]);
        Polynomial polynomial = new Polynomial(term2);
        polynomial.add(Rational.ONE, term3);
        polynomial.add(Rational.MONE, this.bitBlastAnd(term2, term3, n));
        Term term4 = this.nat2bv(polynomial.toTerm(this.mInteger), sort.getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_BVBLAST);
    }

    public Term translateBvxor(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Term[] termArray = ((ApplicationTerm)iProofTracker.getProvedTerm(term)).getParameters();
        Term term2 = this.bv2nat(termArray[0], false);
        Term term3 = this.bv2nat(termArray[1], false);
        Sort sort = functionSymbol.getReturnSort();
        int n = Integer.valueOf(sort.getIndices()[0]);
        Polynomial polynomial = new Polynomial(term2);
        polynomial.add(Rational.ONE, term3);
        polynomial.add(Rational.TWO.negate(), this.bitBlastAnd(term2, term3, n));
        Term term4 = this.nat2bv(polynomial.toTerm(this.mInteger), sort.getIndices());
        return this.trackBvRewrite(term, term4, ProofConstants.RW_BVBLAST);
    }

    public Term translateExtend(IProofTracker iProofTracker, FunctionSymbol functionSymbol, Term term) {
        Annotation annotation;
        Term term2;
        Term[] termArray = ((ApplicationTerm)iProofTracker.getProvedTerm(term)).getParameters();
        if (functionSymbol.getName().equals("zero_extend")) {
            term2 = this.bv2nat(termArray[0], true);
            annotation = ProofConstants.RW_ZEROEXTEND;
        } else {
            int n = Integer.valueOf(termArray[0].getSort().getIndices()[0]);
            term2 = this.uts(n, this.bv2nat(termArray[0], false));
            annotation = ProofConstants.RW_SIGNEXTEND;
        }
        Term term3 = this.nat2bv(term2, functionSymbol.getReturnSort().getIndices());
        return this.trackBvRewrite(term, term3, annotation);
    }
}

