/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.AuxVarGen;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.ReqGraphOracleAnnotation;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.Req2TestReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.ReqGuardGraph;
import de.uni_freiburg.informatik.ultimate.reqtotest.req.TimedLabel;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GraphToBoogie {
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    public static final String GLOBAL_CLOCK_VAR = "reqtotest_delta";
    public static final String LOCATION_PREFIX = "reqtotest_pc_";
    public static final String LOCATION_PRIME = "'";
    public static final String TEST_ORACLE_MARKER = "TEST_ORACLE_MARKER";
    private final ILogger mLogger;
    private final Req2TestReqSymbolTable mSymbolTable;
    private final BoogieLocation mDummyLocation;
    private final List<ReqGuardGraph> mRequirements;
    private final Unit mUnit;
    private final Map<ReqGuardGraph, String> mGraphToPc;
    private final Map<ReqGuardGraph, String> mGraphToPcPrime;
    private final Term2Expression mTerm2Expression;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final AuxVarGen mThreeValuedAuxVarGen;

    public GraphToBoogie(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, Req2TestReqSymbolTable req2TestReqSymbolTable, AuxVarGen auxVarGen, List<ReqGuardGraph> list, Script script, ManagedScript managedScript) {
        this.mLogger = iLogger;
        this.mSymbolTable = req2TestReqSymbolTable;
        this.mDummyLocation = GraphToBoogie.generateDummyLocation();
        this.mRequirements = list;
        this.mGraphToPc = new LinkedHashMap<ReqGuardGraph, String>();
        this.mGraphToPcPrime = new LinkedHashMap<ReqGuardGraph, String>();
        this.generatePcVars();
        this.mScript = script;
        this.mManagedScript = managedScript;
        this.mThreeValuedAuxVarGen = auxVarGen;
        HashRelation hashRelation = new HashRelation();
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Int", new Sort[0]), (Object)BoogieType.TYPE_INT);
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Real", new Sort[0]), (Object)BoogieType.TYPE_REAL);
        hashRelation.addPair((Object)this.mManagedScript.getScript().sort("Bool", new Sort[0]), (Object)BoogieType.TYPE_BOOL);
        this.mTerm2Expression = new Term2Expression(new TypeSortTranslator(hashRelation, this.mScript, iUltimateServiceProvider), (ITerm2ExpressionSymbolTable)req2TestReqSymbolTable, this.mManagedScript);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.mSymbolTable.constructVariableDeclarations());
        arrayList.addAll(this.generateEncodingVarDeclaration());
        arrayList.add(this.getMainProcedure());
        this.mUnit = new Unit((ILocation)this.mDummyLocation, arrayList.toArray(new Declaration[arrayList.size()]));
    }

    private void generatePcVars() {
        int n = 0;
        for (ReqGuardGraph reqGuardGraph : this.mRequirements) {
            this.mGraphToPc.put(reqGuardGraph, LOCATION_PREFIX + Integer.toString(n));
            this.mGraphToPcPrime.put(reqGuardGraph, LOCATION_PREFIX + Integer.toString(n) + LOCATION_PRIME);
            ++n;
        }
    }

    public Unit getAst() {
        return this.mUnit;
    }

    private Declaration getMainProcedure() {
        ModifiesSpecification modifiesSpecification = new ModifiesSpecification((ILocation)this.mDummyLocation, false, this.generateModifiesVariableList());
        ModifiesSpecification[] modifiesSpecificationArray = new ModifiesSpecification[]{modifiesSpecification};
        Attribute[] attributeArray = new Attribute[]{};
        String[] stringArray = new String[]{};
        VarList[] varListArray = new VarList[]{};
        VarList[] varListArray2 = new VarList[]{};
        VariableDeclaration[] variableDeclarationArray = new VariableDeclaration[]{};
        Body body = new Body((ILocation)this.mDummyLocation, variableDeclarationArray, this.generateProcedureBody());
        return new Procedure((ILocation)this.mDummyLocation, attributeArray, "testGen", stringArray, varListArray, varListArray2, (Specification[])modifiesSpecificationArray, body);
    }

    private Statement[] generateProcedureBody() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(this.mSymbolTable.constructConstantAssignments());
        arrayList.addAll(this.generatePcInitialization());
        arrayList.addAll(this.generateClockInitialization());
        arrayList.add(this.generateWhileStatement());
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private Statement generateWhileStatement() {
        return new WhileStatement((ILocation)this.mDummyLocation, (Expression)new WildcardExpression((ILocation)this.mDummyLocation), new LoopInvariantSpecification[0], this.generateWhileBody());
    }

    private Statement[] generateWhileBody() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new HavocStatement((ILocation)new BoogieLocation("", 0, 0, 1, 1), this.generateHavocVariableList()));
        for (ReqGuardGraph reqGuardGraph : this.mRequirements) {
            arrayList.addAll(this.graphToBoogie(reqGuardGraph));
        }
        arrayList.addAll(this.generateDefineUseAssumtions());
        arrayList.addAll(this.generateTestOracleAssertion());
        arrayList.addAll(this.generateNextLoopStateAssignment());
        arrayList.addAll(this.generateClockUpdates());
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private List<Statement> graphToBoogie(ReqGuardGraph reqGuardGraph) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<ReqGuardGraph> linkedList = new LinkedList<ReqGuardGraph>();
        linkedList.add(reqGuardGraph);
        Statement[] statementArray = new Statement[]{};
        while (linkedList.size() > 0) {
            object = (ReqGuardGraph)((Object)linkedList.poll());
            hashSet.add(object);
            Statement[] statementArray2 = new Statement[]{new AssumeStatement((ILocation)this.mDummyLocation, (Expression)new BooleanLiteral((ILocation)this.mDummyLocation, false))};
            int n = 0;
            while (n < object.getOutgoingNodes().size()) {
                ReqGuardGraph reqGuardGraph2 = (ReqGuardGraph)((Object)object.getOutgoingNodes().get(n));
                TimedLabel timedLabel = (TimedLabel)object.getOutgoingEdgeLabels().get(n);
                if (!hashSet.contains((Object)reqGuardGraph2) && !linkedList.contains((Object)reqGuardGraph2)) {
                    linkedList.add(reqGuardGraph2);
                }
                statementArray2 = this.generateInnerIf(statementArray2, reqGuardGraph, (ReqGuardGraph)((Object)object), reqGuardGraph2, timedLabel);
                ++n;
            }
            statementArray = new Statement[]{this.generateOuterIf(reqGuardGraph, (ReqGuardGraph)((Object)object), statementArray2, statementArray)};
        }
        object = new ArrayList();
        object.add(statementArray[0]);
        return object;
    }

    private Statement generateOuterIf(ReqGuardGraph reqGuardGraph, ReqGuardGraph reqGuardGraph2, Statement[] statementArray, Statement[] statementArray2) {
        IntegerLiteral integerLiteral = new IntegerLiteral((ILocation)this.mDummyLocation, Integer.toString(reqGuardGraph2.getLabel()));
        IdentifierExpression identifierExpression = new IdentifierExpression((ILocation)this.mDummyLocation, this.mGraphToPc.get((Object)reqGuardGraph));
        BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mDummyLocation, BinaryExpression.Operator.COMPEQ, (Expression)integerLiteral, (Expression)identifierExpression);
        return new IfStatement((ILocation)this.mDummyLocation, (Expression)binaryExpression, statementArray, statementArray2);
    }

    private Statement[] generateInnerIf(Statement[] statementArray, ReqGuardGraph reqGuardGraph, ReqGuardGraph reqGuardGraph2, ReqGuardGraph reqGuardGraph3, TimedLabel timedLabel) {
        Statement[] statementArray2;
        Statement statement;
        Statement statement2 = this.generateVarIntAssignment(this.mGraphToPcPrime.get((Object)reqGuardGraph), reqGuardGraph3.getLabel());
        AssumeStatement assumeStatement = new AssumeStatement((ILocation)this.mDummyLocation, (Expression)new BinaryExpression((ILocation)this.mDummyLocation, BinaryExpression.Operator.LOGICAND, this.mTerm2Expression.translate(timedLabel.getGuard()), this.mTerm2Expression.translate(timedLabel.getClockGuard())));
        ReqGraphAnnotation reqGraphAnnotation = new ReqGraphAnnotation(reqGuardGraph, timedLabel, reqGuardGraph2);
        reqGraphAnnotation.annotate((IElement)assumeStatement);
        if (timedLabel.getReset() != null) {
            statement = this.generateVarRealAssignment(timedLabel.getReset().getName(), 0.0f);
            statementArray2 = new Statement[]{assumeStatement, statement, statement2};
        } else {
            statementArray2 = new Statement[]{assumeStatement, statement2};
        }
        statement = new IfStatement((ILocation)this.mDummyLocation, (Expression)new WildcardExpression((ILocation)this.mDummyLocation), statementArray2, statementArray);
        return new Statement[]{statement};
    }

    private List<Declaration> generateEncodingVarDeclaration() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        Collection<String> collection = this.mGraphToPc.values();
        String[] stringArray = collection.toArray(new String[collection.size()]);
        VarList[] varListArray = new VarList[]{new VarList((ILocation)this.mDummyLocation, stringArray, BoogieType.TYPE_INT.toASTType((ILocation)this.mDummyLocation))};
        arrayList.add((Declaration)new VariableDeclaration((ILocation)this.mDummyLocation, EMPTY_ATTRIBUTES, varListArray));
        Collection<String> collection2 = this.mGraphToPcPrime.values();
        String[] stringArray2 = collection2.toArray(new String[collection2.size()]);
        VarList[] varListArray2 = new VarList[]{new VarList((ILocation)this.mDummyLocation, stringArray2, BoogieType.TYPE_INT.toASTType((ILocation)this.mDummyLocation))};
        arrayList.add((Declaration)new VariableDeclaration((ILocation)this.mDummyLocation, EMPTY_ATTRIBUTES, varListArray2));
        varListArray = new VarList[]{new VarList((ILocation)this.mDummyLocation, new String[]{GLOBAL_CLOCK_VAR}, BoogieType.TYPE_REAL.toASTType((ILocation)this.mDummyLocation))};
        arrayList.add((Declaration)new VariableDeclaration((ILocation)this.mDummyLocation, EMPTY_ATTRIBUTES, varListArray));
        return arrayList;
    }

    private List<Statement> generateNextLoopStateAssignment() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (ReqGuardGraph reqGuardGraph : this.mRequirements) {
            arrayList.add(this.generateVarVarAssignment(this.mGraphToPc.get((Object)reqGuardGraph), this.mGraphToPcPrime.get((Object)reqGuardGraph)));
        }
        return arrayList;
    }

    private Statement generateVarVarAssignment(String string, String string2) {
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{new VariableLHS((ILocation)this.mDummyLocation, string)};
        Expression[] expressionArray = new Expression[]{new IdentifierExpression((ILocation)this.mDummyLocation, string2)};
        return new AssignmentStatement((ILocation)this.mDummyLocation, leftHandSideArray, expressionArray);
    }

    private Statement generateVarIntAssignment(String string, int n) {
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{new VariableLHS((ILocation)this.mDummyLocation, string)};
        Expression[] expressionArray = new Expression[]{new IntegerLiteral((ILocation)this.mDummyLocation, Integer.toString(n))};
        return new AssignmentStatement((ILocation)this.mDummyLocation, leftHandSideArray, expressionArray);
    }

    private Statement generateVarRealAssignment(String string, float f) {
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{new VariableLHS((ILocation)this.mDummyLocation, string)};
        Expression[] expressionArray = new Expression[]{new RealLiteral((ILocation)this.mDummyLocation, Float.toString(f))};
        return new AssignmentStatement((ILocation)this.mDummyLocation, leftHandSideArray, expressionArray);
    }

    private VariableLHS[] generateHavocVariableList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mSymbolTable.getInputVars());
        arrayList.addAll(this.mSymbolTable.getHiddenVars());
        arrayList.addAll(this.mSymbolTable.getOutputVars());
        arrayList.addAll(this.mSymbolTable.getAuxVars());
        VariableLHS[] variableLHSArray = new VariableLHS[arrayList.size()];
        int n = 0;
        while (n < variableLHSArray.length) {
            variableLHSArray[n] = new VariableLHS((ILocation)this.mDummyLocation, (String)arrayList.get(n));
            ++n;
        }
        return variableLHSArray;
    }

    private VariableLHS[] generateModifiesVariableList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mSymbolTable.getInputVars());
        arrayList.addAll(this.mSymbolTable.getHiddenVars());
        arrayList.addAll(this.mSymbolTable.getOutputVars());
        arrayList.addAll(this.mSymbolTable.getConstVars());
        arrayList.addAll(this.mSymbolTable.getAuxVars());
        arrayList.addAll(this.mSymbolTable.getClockVars());
        arrayList.addAll(this.mGraphToPcPrime.values());
        arrayList.addAll(this.mGraphToPc.values());
        arrayList.add(GLOBAL_CLOCK_VAR);
        VariableLHS[] variableLHSArray = new VariableLHS[arrayList.size()];
        int n = 0;
        while (n < variableLHSArray.length) {
            variableLHSArray[n] = new VariableLHS((ILocation)this.mDummyLocation, (String)arrayList.get(n));
            ++n;
        }
        return variableLHSArray;
    }

    private List<Statement> generatePcInitialization() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (ReqGuardGraph reqGuardGraph : this.mRequirements) {
            arrayList.add(this.generateVarIntAssignment(this.mGraphToPc.get((Object)reqGuardGraph), reqGuardGraph.getLabel()));
        }
        return arrayList;
    }

    private List<Statement> generateClockInitialization() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (String string : this.mSymbolTable.getClockVars()) {
            arrayList.add(this.generateVarRealAssignment(string, 0.0f));
        }
        arrayList.add(this.generateVarRealAssignment(GLOBAL_CLOCK_VAR, 1.0f));
        return arrayList;
    }

    private static BoogieLocation generateDummyLocation() {
        return new BoogieLocation("", 1, 1, 1, 1);
    }

    private List<Statement> generateDefineUseAssumtions() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        List<Term> list = this.mThreeValuedAuxVarGen.getDefineAssumeGuards();
        for (Term term : list) {
            AssumeStatement assumeStatement = new AssumeStatement((ILocation)this.mDummyLocation, this.mTerm2Expression.translate(term));
            arrayList.add((Statement)assumeStatement);
        }
        return arrayList;
    }

    private List<Statement> generateTestOracleAssertion() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        NamedAttribute namedAttribute = new NamedAttribute((ILocation)this.mDummyLocation, TEST_ORACLE_MARKER, new Expression[0]);
        AssertStatement assertStatement = new AssertStatement((ILocation)this.mDummyLocation, new NamedAttribute[]{namedAttribute}, (Expression)new BooleanLiteral((ILocation)this.mDummyLocation, true));
        arrayList.add((Statement)assertStatement);
        Map<ReqGuardGraph, Term> map = this.mThreeValuedAuxVarGen.getOracleAssertions();
        for (ReqGuardGraph reqGuardGraph : map.keySet()) {
            Term term = map.get((Object)reqGuardGraph);
            arrayList.add(this.generateTestOracleAssertion(reqGuardGraph, term));
        }
        return arrayList;
    }

    private Statement generateTestOracleAssertion(ReqGuardGraph reqGuardGraph, Term term) {
        AssertStatement assertStatement = new AssertStatement((ILocation)this.mDummyLocation, this.mTerm2Expression.translate(term));
        ReqGraphOracleAnnotation reqGraphOracleAnnotation = new ReqGraphOracleAnnotation(reqGuardGraph, term, this.mThreeValuedAuxVarGen.getEffectVariables(reqGuardGraph));
        reqGraphOracleAnnotation.annotate((IElement)assertStatement);
        return assertStatement;
    }

    private List<Statement> generateClockUpdates() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        arrayList.add((Statement)new HavocStatement((ILocation)this.mDummyLocation, new VariableLHS[]{new VariableLHS((ILocation)this.mDummyLocation, GLOBAL_CLOCK_VAR)}));
        arrayList.add((Statement)new AssumeStatement((ILocation)this.mDummyLocation, (Expression)new BinaryExpression((ILocation)this.mDummyLocation, BinaryExpression.Operator.COMPGEQ, (Expression)new IdentifierExpression((ILocation)this.mDummyLocation, GLOBAL_CLOCK_VAR), (Expression)new RealLiteral((ILocation)this.mDummyLocation, "1.0"))));
        for (String string : this.mSymbolTable.getClockVars()) {
            arrayList.add((Statement)new AssignmentStatement((ILocation)this.mDummyLocation, (LeftHandSide[])new VariableLHS[]{new VariableLHS((ILocation)this.mDummyLocation, string)}, new Expression[]{new BinaryExpression((ILocation)this.mDummyLocation, BinaryExpression.Operator.ARITHPLUS, (Expression)new IdentifierExpression((ILocation)this.mDummyLocation, string), (Expression)new IdentifierExpression((ILocation)this.mDummyLocation, GLOBAL_CLOCK_VAR))}));
        }
        return arrayList;
    }
}

