/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting.datastructures;

import java.math.BigInteger;
import java.util.Objects;

public class AtomicCounterAssingment {
    private final String mLhsCounter;
    private final String mRhsCounter;
    private final BigInteger mRhsNaturalNumber;

    public AtomicCounterAssingment(String string, String string2, BigInteger bigInteger) {
        Objects.nonNull(string);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Literal in counter assignment mus be non-negative");
        }
        this.mLhsCounter = string;
        this.mRhsCounter = string2;
        this.mRhsNaturalNumber = bigInteger;
    }

    public String getLhsCounter() {
        return this.mLhsCounter;
    }

    public String getRhsCounter() {
        return this.mRhsCounter;
    }

    public BigInteger getRhsNaturalNumber() {
        return this.mRhsNaturalNumber;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLhsCounter());
        stringBuilder.append(" := ");
        stringBuilder.append('\"');
        if (this.mRhsCounter == null) {
            stringBuilder.append(this.getRhsNaturalNumber());
        } else {
            stringBuilder.append(String.format("(+ %s %s)", this.getRhsCounter(), this.getRhsNaturalNumber()));
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

