/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class UnfTransformer
extends TermTransformer {
    private final Script mScript;
    private static Set<String> mRelationSymbols = Arrays.stream(RelationSymbol.values()).map(Object::toString).collect(Collectors.toSet());

    public UnfTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (UnfTransformer.isEqualityOrDisequalityWithMoreThanTwoParams(applicationTerm)) {
                Term term2 = SmtUtils.binarize(this.mScript, applicationTerm);
                this.convert(term2);
            } else {
                super.convert(term);
            }
        } else if (term instanceof ConstantTerm) {
            Term term3;
            if (!SmtSortUtils.isNumericSort(term.getSort())) {
                term3 = term;
            } else {
                ConstantTerm constantTerm = (ConstantTerm)term;
                Rational rational = SmtUtils.toRational(constantTerm);
                term3 = rational.toTerm(term.getSort());
            }
            this.setResult(term3);
        } else {
            super.convert(term);
        }
    }

    private static boolean isEqualityOrDisequalityWithMoreThanTwoParams(ApplicationTerm applicationTerm) {
        return (applicationTerm.getFunction().getName().equals("=") || applicationTerm.getFunction().getName().equals("distinct")) && applicationTerm.getParameters().length > 2;
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        PolynomialRelation polynomialRelation;
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        String string = functionSymbol.getApplicationString();
        Term term = SmtUtils.unfTerm(this.mScript, functionSymbol, termArray);
        if (mRelationSymbols.contains(string) && (polynomialRelation = PolynomialRelation.of(this.mScript, term)) != null) {
            term = polynomialRelation.toTerm(this.mScript);
        }
        this.setResult(term);
    }

    public static Term apply(Script script, Term term) {
        return new UnfTransformer(script).transform(term);
    }
}

