/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseAST;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AtsASTNode
extends BaseAST<AtsASTNode> {
    private static final long serialVersionUID = 8077752308820134631L;
    protected List<AtsASTNode> mChildren;
    protected AtsASTNode mParent;
    protected Class<?> mReturnType;
    protected Class<?> mExpectingType;
    private final Map<Class<?>, Class<?>> mPrimitiveToClassTypes;

    public AtsASTNode(ILocation iLocation) {
        iLocation.annotate((IElement)this);
        this.mChildren = new ArrayList<AtsASTNode>();
        this.mParent = null;
        this.mPrimitiveToClassTypes = new HashMap();
        this.mPrimitiveToClassTypes.put(Integer.TYPE, Integer.class);
        this.mPrimitiveToClassTypes.put(Boolean.TYPE, Boolean.class);
    }

    public AtsASTNode getIncomingNode() {
        return this.mParent;
    }

    public List<AtsASTNode> getOutgoingNodes() {
        return this.mChildren;
    }

    public boolean addIncomingNode(AtsASTNode atsASTNode) {
        this.mParent = atsASTNode;
        return true;
    }

    public boolean addOutgoingNode(AtsASTNode atsASTNode) {
        this.mChildren.add(atsASTNode);
        if (atsASTNode != null) {
            atsASTNode.addIncomingNode(this);
        }
        return true;
    }

    public Class<?> getReturnType() {
        return this.mReturnType;
    }

    public Class<?> getExpectingType() {
        return this.mExpectingType;
    }

    public void setType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        if (this.mPrimitiveToClassTypes.containsKey(clazz)) {
            clazz2 = this.mPrimitiveToClassTypes.get(clazz);
        }
        this.setReturnType(clazz2);
        this.setExpectingType(clazz2);
    }

    public void setReturnType(Class<?> clazz) {
        this.mReturnType = clazz;
    }

    public void setExpectingType(Class<?> clazz) {
        this.mExpectingType = clazz;
    }

    public ILocation getLocation() {
        return ILocation.getAnnotation((IElement)this);
    }

    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AtsASTNode atsASTNode : this.mChildren) {
            stringBuilder.append(atsASTNode.getAsString());
        }
        return stringBuilder.toString();
    }
}

