/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.OctagonMatrix;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.OctagonState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.StateBasedDomain;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.RewriteEqualityTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.OctagonRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;

public class OctagonDomain
extends StateBasedDomain<OctagonState> {
    public OctagonDomain(ILogger iLogger, SymbolicTools symbolicTools, int n, Supplier<IProgressAwareTimer> supplier) {
        super(symbolicTools, n, iLogger, supplier, new OctagonStateProvider(symbolicTools.getScript()));
    }

    private static class OctagonStateProvider
    implements StateBasedDomain.IStateProvider<OctagonState> {
        private final Script mScript;
        private final TermTransformer mTermTransformer;

        public OctagonStateProvider(Script script) {
            this.mScript = script;
            this.mTermTransformer = new RewriteEqualityTransformer(script);
        }

        @Override
        public OctagonState toState(Term[] octagonRelation) {
            ArrayList<OctagonRelation> arrayList = new ArrayList<OctagonRelation>();
            HashSet<Term> hashSet = new HashSet<Term>();
            OctagonRelation octagonRelation22 = octagonRelation;
            int n = ((Term[])octagonRelation22).length;
            int n2 = 0;
            while (n2 < n) {
                OctagonRelation octagonRelation3;
                Term term2 = octagonRelation22[n2];
                PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)this.mScript, (Term)term2);
                if (polynomialRelation != null && (octagonRelation3 = OctagonRelation.from((PolynomialRelation)polynomialRelation)) != null) {
                    arrayList.add(octagonRelation3);
                    hashSet.add(octagonRelation3.getVar1());
                    hashSet.add(octagonRelation3.getVar2());
                }
                ++n2;
            }
            boolean bl = true;
            HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
            hashSet.stream().sorted(Comparator.comparing(Term::toString)).forEach(term -> {
                Integer n = hashMap.put((Term)term, hashMap.size());
            });
            OctagonMatrix octagonMatrix = new OctagonMatrix(hashMap.size());
            for (OctagonRelation octagonRelation22 : arrayList) {
                bl &= !SmtSortUtils.isRealSort((Sort)octagonRelation22.getVar1().getSort());
                octagonMatrix.processRelation(octagonRelation22, hashMap);
            }
            return new OctagonState(hashMap, octagonMatrix, bl);
        }

        @Override
        public OctagonState getTopState() {
            return OctagonState.TOP;
        }

        @Override
        public Term preprocessTerm(Term term) {
            return this.mTermTransformer.transform(term);
        }
    }
}

