/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityAllowStores;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FindSelects {
    private final HashRelation<EdgeInfo, ArrayUpdate> mEdgeToCellUpdates;
    private final HashRelation<EdgeInfo, ArrayEqualityAllowStores> mEdgeToArrayRelations;
    private final ManagedScript mMgdScript;
    private final Set<SelectInfo> mSelectInfos;
    private Set<ArrayGroup> mArrayGroups;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final HeapSeparatorBenchmark mStatistics;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public FindSelects(ILogger iLogger, ManagedScript managedScript, List<IProgramVarOrConst> list, HeapSeparatorBenchmark heapSeparatorBenchmark, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups) {
        this.mMgdScript = managedScript;
        this.mLogger = iLogger;
        this.mStatistics = heapSeparatorBenchmark;
        this.mHeapArrays = list;
        this.mEdgeToCellUpdates = new HashRelation();
        this.mEdgeToArrayRelations = new HashRelation();
        this.mSelectInfos = new HashSet<SelectInfo>();
        this.mCsiag = computeStoreInfosAndArrayGroups;
    }

    public void processEdge(IcfgEdge icfgEdge) {
        Object object;
        Set set32;
        UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
        EdgeInfo edgeInfo = new EdgeInfo(icfgEdge);
        List list = MultiDimensionalSelect.extractSelectShallow((Term)unmodifiableTransFormula.getFormula());
        if (!list.isEmpty() && !(set32 = SmtUtils.extractApplicationTerms((String)"select", (Term)unmodifiableTransFormula.getFormula(), (boolean)false)).equals(object = list.stream().map(multiDimensionalSelect -> SmtUtils.extractApplicationTerms((String)"select", (Term)multiDimensionalSelect.toTerm(this.mMgdScript.getScript()), (boolean)false)).reduce((set, set2) -> DataStructureUtils.union((Set)set, (Set)set2)).get())) {
            throw new AssertionError();
        }
        for (Set set32 : list) {
            ArrayCellAccess arrayCellAccess = new ArrayCellAccess((MultiDimensionalSelect)set32);
            if (!this.mCsiag.isArrayTermSubjectToSeparation(edgeInfo, arrayCellAccess.getArray())) continue;
            ArrayGroup arrayGroup = this.mCsiag.getArrayGroupForTermInEdge(edgeInfo, arrayCellAccess.getArray());
            SelectInfo selectInfo = new SelectInfo(arrayCellAccess, edgeInfo, arrayGroup, this.mMgdScript);
            this.mSelectInfos.add(selectInfo);
        }
    }

    public Set<SelectInfo> getSelectInfos() {
        if (this.mSelectInfos == null) {
            throw new IllegalStateException("call finish first");
        }
        return this.mSelectInfos;
    }

    public void finish() {
    }
}

