/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ModifiableTransFormula
extends TransFormula {
    private final Map<TermVariable, IProgramVar> mInVarsReverseMapping = new LinkedHashMap<TermVariable, IProgramVar>();
    private final Map<TermVariable, IProgramVar> mOutVarsReverseMapping = new LinkedHashMap<TermVariable, IProgramVar>();
    private Term mFormula;

    public ModifiableTransFormula(Term term) {
        super(new LinkedHashMap<IProgramVar, TermVariable>(), new LinkedHashMap<IProgramVar, TermVariable>(), new LinkedHashSet<TermVariable>(), new LinkedHashSet<IProgramConst>());
        this.mFormula = term;
    }

    public ModifiableTransFormula(ModifiableTransFormula modifiableTransFormula) {
        this(modifiableTransFormula.getFormula());
        this.mInVars.putAll(modifiableTransFormula.mInVars);
        this.mInVarsReverseMapping.putAll(modifiableTransFormula.mInVarsReverseMapping);
        this.mOutVars.putAll(modifiableTransFormula.mOutVars);
        this.mOutVarsReverseMapping.putAll(modifiableTransFormula.mOutVarsReverseMapping);
        this.mAuxVars.addAll(modifiableTransFormula.mAuxVars);
        this.mNonTheoryConsts.addAll(modifiableTransFormula.mNonTheoryConsts);
    }

    public Map<Term, IProgramVar> getInVarsReverseMapping() {
        return Collections.unmodifiableMap(this.mInVarsReverseMapping);
    }

    public Map<Term, IProgramVar> getOutVarsReverseMapping() {
        return Collections.unmodifiableMap(this.mOutVarsReverseMapping);
    }

    public void addInVar(IProgramVar iProgramVar, TermVariable termVariable) {
        Term term = (Term)this.mInVars.put(iProgramVar, termVariable);
        if (term == null) {
            this.mInVarsReverseMapping.put(termVariable, iProgramVar);
        } else if (term != termVariable) {
            throw new IllegalArgumentException(String.valueOf(term) + " is already the inVar of " + String.valueOf(iProgramVar));
        }
    }

    public void removeInVar(IProgramVar iProgramVar) {
        Term term = (Term)this.mInVars.remove(iProgramVar);
        if (term == null) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
        this.mInVarsReverseMapping.remove(term);
    }

    public void addOutVar(IProgramVar iProgramVar, TermVariable termVariable) {
        Term term = (Term)this.mOutVars.put(iProgramVar, termVariable);
        if (term == null) {
            this.mOutVarsReverseMapping.put(termVariable, iProgramVar);
        } else if (term != termVariable) {
            throw new IllegalArgumentException(String.valueOf(term) + " is already the outVar of " + String.valueOf(iProgramVar));
        }
    }

    public void removeOutVar(IProgramVar iProgramVar) {
        Term term = (Term)this.mOutVars.remove(iProgramVar);
        if (term == null) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
        this.mOutVarsReverseMapping.remove(term);
    }

    public void removeAuxVar(TermVariable termVariable) {
        boolean bl = this.mAuxVars.remove(termVariable);
        if (!bl) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
    }

    public void addAuxVars(Set<TermVariable> set) {
        this.mAuxVars.addAll(set);
    }

    @Override
    public Term getFormula() {
        return this.mFormula;
    }

    public void setFormula(Term term) {
        this.mFormula = term;
    }

    public void addNonTheoryConsts(Collection<IProgramConst> collection) {
        this.mNonTheoryConsts.addAll(collection);
    }

    public boolean auxVarsDisjointFromInOutVars() {
        for (Term term : this.mAuxVars) {
            if (this.mInVarsReverseMapping.containsKey(term)) {
                return false;
            }
            if (!this.mOutVarsReverseMapping.containsKey(term)) continue;
            return false;
        }
        return true;
    }

    public TermVariable allAreInOutAux(TermVariable[] termVariableArray) {
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray2[n2];
            if (!this.isInOurAux(termVariable)) {
                return termVariable;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<IProgramVar> getAssignedVars() {
        return Collections.unmodifiableSet(TransFormulaUtils.computeAssignedVars(this.mInVars, this.mOutVars));
    }

    private boolean isInOurAux(TermVariable termVariable) {
        if (this.mInVarsReverseMapping.containsKey(termVariable) || this.mOutVarsReverseMapping.containsKey(termVariable)) {
            return true;
        }
        return this.mAuxVars.contains(termVariable);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InVars: ");
        stringBuilder.append(this.mInVars.toString());
        stringBuilder.append("\nOutVars: ");
        stringBuilder.append(this.mOutVars.toString());
        stringBuilder.append("\nAuxVars: ");
        stringBuilder.append(this.mAuxVars.toString());
        stringBuilder.append("\nTransition formula: ");
        stringBuilder.append(new SMTPrettyPrinter(this.mFormula));
        return stringBuilder.toString();
    }
}

