/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class CallReturnPyramideInstanceProvider {
    private final ManagedScript mMgdScript;
    private final BeforeCallCoincidingInstancesClassifier mBeforeCallCoincidingInstancesClassifier;
    private final AfterCallCoincidingInstancesClassifier mAfterCallCoincidingInstancesClassifier;
    private final BeforeReturnCoincidingInstancesClassifier mBeforeReturnCoincidingInstancesClassifier;
    private final AfterReturnCoincidingInstancesClassifier mAfterReturnCoincidingInstancesClassifier;
    private final FourWayInstanceProvider mInstanceProvider;
    private final Set<IProgramVar> mVarsAssignedOnReturn;
    private final Set<IProgramVar> mCalleeInParams;
    private final Set<IProgramNonOldVar> mModifiableGlobals;
    private final Set<TermVariable> mFreshTermVariables = new HashSet<TermVariable>();

    public CallReturnPyramideInstanceProvider(ManagedScript managedScript, Set<IProgramVar> set, Set<IProgramVar> set2, Set<IProgramNonOldVar> set3, Instance instance) {
        this.mMgdScript = managedScript;
        this.mVarsAssignedOnReturn = set;
        this.mCalleeInParams = set2;
        this.mModifiableGlobals = set3;
        this.mBeforeCallCoincidingInstancesClassifier = new BeforeCallCoincidingInstancesClassifier();
        this.mAfterCallCoincidingInstancesClassifier = new AfterCallCoincidingInstancesClassifier();
        this.mBeforeReturnCoincidingInstancesClassifier = new BeforeReturnCoincidingInstancesClassifier();
        this.mAfterReturnCoincidingInstancesClassifier = new AfterReturnCoincidingInstancesClassifier();
        this.mInstanceProvider = new FourWayInstanceProvider(instance);
    }

    public Term getInstance(IProgramVar iProgramVar, Instance instance) {
        switch (instance) {
            case BEFORE_CALL: {
                return this.mInstanceProvider.getInstance(iProgramVar, this.mBeforeCallCoincidingInstancesClassifier.getInstances(iProgramVar));
            }
            case AFTER_CALL: {
                return this.mInstanceProvider.getInstance(iProgramVar, this.mAfterCallCoincidingInstancesClassifier.getInstances(iProgramVar));
            }
            case BEFORE_RETURN: {
                return this.mInstanceProvider.getInstance(iProgramVar, this.mBeforeReturnCoincidingInstancesClassifier.getInstances(iProgramVar));
            }
            case AFTER_RETURN: {
                return this.mInstanceProvider.getInstance(iProgramVar, this.mAfterReturnCoincidingInstancesClassifier.getInstances(iProgramVar));
            }
        }
        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)instance)));
    }

    public boolean isWrittenOnReturn(IProgramVar iProgramVar) {
        return this.mVarsAssignedOnReturn.contains(iProgramVar);
    }

    public boolean isModifiableByCallee(IProgramNonOldVar iProgramNonOldVar) {
        return this.mModifiableGlobals.contains(iProgramNonOldVar);
    }

    public boolean inInParam(ILocalProgramVar iLocalProgramVar) {
        return this.mCalleeInParams.contains(iLocalProgramVar);
    }

    public Set<TermVariable> getFreshTermVariables() {
        return this.mFreshTermVariables;
    }

    private class AfterCallCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private AfterCallCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar iLocalProgramVar) {
            if (CallReturnPyramideInstanceProvider.this.inInParam(iLocalProgramVar)) {
                return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.AFTER_CALL);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar iProgramNonOldVar) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(iProgramNonOldVar)) {
                return EnumSet.of(Instance.AFTER_CALL);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar iProgramOldVar) {
            return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
        }
    }

    private class AfterReturnCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private AfterReturnCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar iLocalProgramVar) {
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iLocalProgramVar)) {
                return EnumSet.of(Instance.AFTER_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar iProgramNonOldVar) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(iProgramNonOldVar)) {
                if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                    return EnumSet.of(Instance.AFTER_RETURN);
                }
                return EnumSet.of(Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                return EnumSet.of(Instance.AFTER_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar iProgramOldVar) {
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }
    }

    private class BeforeCallCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private BeforeCallCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar iLocalProgramVar) {
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iLocalProgramVar)) {
                return EnumSet.of(Instance.BEFORE_CALL);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar iProgramNonOldVar) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(iProgramNonOldVar)) {
                return EnumSet.of(Instance.BEFORE_CALL);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar iProgramOldVar) {
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_RETURN);
        }
    }

    private class BeforeReturnCoincidingInstancesClassifier
    extends CoincidingInstancesClassifier {
        private BeforeReturnCoincidingInstancesClassifier() {
        }

        @Override
        public EnumSet<Instance> getInstancesLocal(ILocalProgramVar iLocalProgramVar) {
            if (CallReturnPyramideInstanceProvider.this.inInParam(iLocalProgramVar)) {
                return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar iProgramNonOldVar) {
            if (CallReturnPyramideInstanceProvider.this.isModifiableByCallee(iProgramNonOldVar)) {
                if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                    return EnumSet.of(Instance.BEFORE_RETURN);
                }
                return EnumSet.of(Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
            }
            if (CallReturnPyramideInstanceProvider.this.isWrittenOnReturn(iProgramNonOldVar)) {
                return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN);
            }
            return EnumSet.of(Instance.BEFORE_CALL, Instance.AFTER_CALL, Instance.BEFORE_RETURN, Instance.AFTER_RETURN);
        }

        @Override
        public EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar iProgramOldVar) {
            return EnumSet.of(Instance.AFTER_CALL, Instance.BEFORE_RETURN);
        }
    }

    private static abstract class CoincidingInstancesClassifier {
        private CoincidingInstancesClassifier() {
        }

        public EnumSet<Instance> getInstances(IProgramVar iProgramVar) {
            if (iProgramVar instanceof ILocalProgramVar) {
                return this.getInstancesLocal((ILocalProgramVar)iProgramVar);
            }
            if (iProgramVar instanceof IProgramNonOldVar) {
                return this.getInstancesGlobalNonOld((IProgramNonOldVar)iProgramVar);
            }
            if (iProgramVar instanceof IProgramOldVar) {
                return this.getInstancesGlobalOld((IProgramOldVar)iProgramVar);
            }
            throw new AssertionError((Object)"unknown kind of variable");
        }

        public abstract EnumSet<Instance> getInstancesLocal(ILocalProgramVar var1);

        public abstract EnumSet<Instance> getInstancesGlobalNonOld(IProgramNonOldVar var1);

        public abstract EnumSet<Instance> getInstancesGlobalOld(IProgramOldVar var1);
    }

    private static class DefaultTermVariableProvider
    implements ConstructionCache.IValueConstruction<IProgramVar, TermVariable> {
        private DefaultTermVariableProvider() {
        }

        public TermVariable constructValue(IProgramVar iProgramVar) {
            return iProgramVar.getTermVariable();
        }
    }

    private class FourWayInstanceProvider {
        private final Instance mPriorityInstance;
        private final EnumMap<Instance, ConstructionCache<IProgramVar, TermVariable>> mInstanceProviders = new EnumMap(Instance.class);

        public FourWayInstanceProvider(Instance instance) {
            this.mPriorityInstance = instance;
            Instance[] instanceArray = Instance.values();
            int n = instanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instance instance2 = instanceArray[n2];
                if (instance2 == this.mPriorityInstance) {
                    this.mInstanceProviders.put(instance2, (ConstructionCache<IProgramVar, TermVariable>)new ConstructionCache((ConstructionCache.IValueConstruction)new DefaultTermVariableProvider()));
                } else {
                    this.mInstanceProviders.put(instance2, (ConstructionCache<IProgramVar, TermVariable>)new ConstructionCache((ConstructionCache.IValueConstruction)new FreshTermVariableProvider(instance2)));
                }
                ++n2;
            }
        }

        private TermVariable getInstance(IProgramVar iProgramVar, EnumSet<Instance> enumSet) {
            if (enumSet.contains((Object)this.mPriorityInstance)) {
                return (TermVariable)this.mInstanceProviders.get((Object)this.mPriorityInstance).getOrConstruct((Object)iProgramVar);
            }
            return (TermVariable)this.mInstanceProviders.get(enumSet.iterator().next()).getOrConstruct((Object)iProgramVar);
        }
    }

    private class FreshTermVariableProvider
    implements ConstructionCache.IValueConstruction<IProgramVar, TermVariable> {
        private final Instance mInstance;

        public FreshTermVariableProvider(Instance instance) {
            this.mInstance = instance;
        }

        public TermVariable constructValue(IProgramVar iProgramVar) {
            String string = iProgramVar.getGloballyUniqueId() + "_" + this.mInstance.toString();
            TermVariable termVariable = CallReturnPyramideInstanceProvider.this.mMgdScript.constructFreshTermVariable(string, iProgramVar.getTermVariable().getSort());
            CallReturnPyramideInstanceProvider.this.mFreshTermVariables.add(termVariable);
            return termVariable;
        }
    }

    public static enum Instance {
        BEFORE_CALL,
        AFTER_CALL,
        BEFORE_RETURN,
        AFTER_RETURN;

    }
}

