/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StringLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final MemoryHandler mMemoryHandler;
    private final ProcedureManager mProcedureManager;
    private final ExpressionTranslation mExpressionTranslation;
    private final TypeSizeAndOffsetComputer mTypeSizeComputer;

    public StringLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, AuxVarInfoBuilder auxVarInfoBuilder, MemoryHandler memoryHandler, ProcedureManager procedureManager, ExpressionTranslation expressionTranslation, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryHandler = memoryHandler;
        this.mProcedureManager = procedureManager;
        this.mExpressionTranslation = expressionTranslation;
        this.mTypeSizeComputer = typeSizeAndOffsetComputer;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_memcpy", this::handleMemcpy));
        arrayList.add(new ILibraryModel.FunctionModel("__memcpy", this::handleMemcpy));
        arrayList.add(new ILibraryModel.FunctionModel("memcpy", this::handleMemcpy));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_memmove", this::handleMemmove));
        arrayList.add(new ILibraryModel.FunctionModel("__memmove", this::handleMemmove));
        arrayList.add(new ILibraryModel.FunctionModel("memmove", this::handleMemmove));
        arrayList.add(new ILibraryModel.FunctionModel("memset", this::handleMemset));
        arrayList.add(new ILibraryModel.FunctionModel("memcmp", this::handleMemCmp));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_strchr", this::handleStrChr));
        arrayList.add(new ILibraryModel.FunctionModel("strchr", this::handleStrChr));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_strlen", this::handleStrLen));
        arrayList.add(new ILibraryModel.FunctionModel("strlen", this::handleStrLen));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_strcmp", this::handleStrCmp));
        arrayList.add(new ILibraryModel.FunctionModel("strcmp", this::handleStrCmp));
        arrayList.add(new ILibraryModel.FunctionModel("strncmp", this::handleStrnCmp));
        arrayList.add(new ILibraryModel.FunctionModel("strcpy", this::handleStrCpy));
        arrayList.add(new ILibraryModel.FunctionModel("strncpy", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("toupper", this::handleToUpper));
        arrayList.add(new ILibraryModel.FunctionModel("strtok", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("strcat", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("strncat", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleUnsupportedFunctionByOverapproximation(iDispatcher, iLocation, string, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("strcspn", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("strpbrk", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)))));
        arrayList.add(new ILibraryModel.FunctionModel("memchr", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleStringSearch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3)));
        arrayList.add(new ILibraryModel.FunctionModel("strstr", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleStringSearch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("strrchr", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleStringSearch(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2)));
        arrayList.add(new ILibraryModel.FunctionModel("strerror", this::handleStrerror));
        arrayList.add(new ILibraryModel.FunctionModel("strspn", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("iswxdigit", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        return arrayList;
    }

    private Result handleStringSearch(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        this.mHelper.checkArguments(iLocation, n, string, iASTFunctionCallExpression.getArguments());
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        int n2 = iASTInitializerClauseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IASTInitializerClause iASTInitializerClause = iASTInitializerClauseArray[n3];
            if (!this.mHelper.isStringLiteral(iASTInitializerClause)) {
                ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause);
                expressionResultBuilder.addAllExceptLrValue(expressionResult);
            }
            ++n3;
        }
        expressionResultBuilder.addOverapprox(new Overapprox(string, iLocation));
        return expressionResultBuilder.addAllIncludingLrValue(this.mHelper.getNondetStringOrNull(iLocation)).build();
    }

    private Result handleStrerror(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mHelper.checkArguments(iLocation, 1, string, iASTFunctionCallExpression.getArguments());
        return new ExpressionResultBuilder().addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTFunctionCallExpression.getArguments()[0])).addAllIncludingLrValue(this.mHelper.getNondetStringOrNull(iLocation)).build();
    }

    private ExpressionResult handleStrCmp(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        return this.handleMemoryComparison(iDispatcher, iLocation, string, iASTInitializerClauseArray[0], iASTInitializerClauseArray[1]);
    }

    private ExpressionResult handleStrnCmp(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[2]));
        expressionResultBuilder.addAllIncludingLrValue(this.handleMemoryComparison(iDispatcher, iLocation, string, iASTInitializerClauseArray[0], iASTInitializerClauseArray[1]));
        return expressionResultBuilder.build();
    }

    private Result handleStrCpy(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        MemoryModelDeclarations memoryModelDeclarations = MemoryModelDeclarations.C_STRCPY;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        CPointer cPointer = new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR));
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[0], cPointer);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[1], cPointer);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, expressionResult.getLrValue().getCType(), SFO.AUXVAR.STRCPYRES);
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)memoryModelDeclarations.getName(), (Expression[])new Expression[]{expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue()});
        for (Overapprox overapprox : expressionResultBuilder.getOverappr()) {
            overapprox.annotate((IElement)callStatement);
        }
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)callStatement);
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), CPointer.voidPointer()));
        this.mMemoryHandler.requireMemoryModelFeature(memoryModelDeclarations);
        this.mProcedureManager.registerProcedure(memoryModelDeclarations.getName());
        return expressionResultBuilder.build();
    }

    private Result handleStrLen(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        expressionResultBuilder.addDeclarations(expressionResult.getDeclarations());
        expressionResultBuilder.addStatements(expressionResult.getStatements());
        expressionResultBuilder.addOverapprox(expressionResult.getOverapprs());
        expressionResultBuilder.addAuxVars(expressionResult.getAuxVars());
        expressionResultBuilder.addNeighbourUnionFields(expressionResult.getNeighbourUnionFields());
        expressionResultBuilder.addStatements(this.mMemoryHandler.constructMemsafetyChecksForPointerExpression(iLocation, expressionResult.getLrValue().getValue()));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        Overapprox overapprox = new Overapprox(string, iLocation);
        expressionResultBuilder.addOverapprox(overapprox);
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), cPrimitive);
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    private Result handleStrChr(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        expressionResultBuilder.addDeclarations(expressionResult.getDeclarations()).addStatements(expressionResult.getStatements()).addOverapprox(expressionResult.getOverapprs()).addAuxVars(expressionResult.getAuxVars()).addNeighbourUnionFields(expressionResult.getNeighbourUnionFields());
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        expressionResultBuilder.addDeclarations(expressionResult2.getDeclarations()).addStatements(expressionResult2.getStatements()).addOverapprox(expressionResult2.getOverapprs()).addAuxVars(expressionResult2.getAuxVars()).addNeighbourUnionFields(expressionResult2.getNeighbourUnionFields());
        CPointer cPointer = new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR));
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        Expression expression = this.mExpressionTranslation.constructNullPointer(iLocation);
        expressionResultBuilder.addStatements(this.mMemoryHandler.constructMemsafetyChecksForPointerExpression(iLocation, expressionResult.getLrValue().getValue()));
        IdentifierExpression identifierExpression = auxVarInfo.getExp();
        Expression expression2 = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 28, MemoryHandler.getPointerBaseAddress((Expression)identifierExpression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), MemoryHandler.getPointerBaseAddress(expression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Object object = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 28, MemoryHandler.getPointerOffset((Expression)identifierExpression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), MemoryHandler.getPointerOffset(expression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression2, (Expression)object);
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 28, MemoryHandler.getPointerBaseAddress((Expression)identifierExpression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), MemoryHandler.getPointerBaseAddress(expressionResult.getLrValue().getValue(), iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 10, this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), new BigInteger("0")), this.mExpressionTranslation.getCTypeOfPointerComponents(), MemoryHandler.getPointerOffset((Expression)identifierExpression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression6 = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 10, MemoryHandler.getPointerOffset((Expression)identifierExpression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), (Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)this.mMemoryHandler.getLengthArray(iLocation), (Expression[])new Expression[]{MemoryHandler.getPointerBaseAddress(expressionResult.getLrValue().getValue(), iLocation)}), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression7 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression4, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression5, (Expression)expression6));
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression3, (Expression)expression7));
        expressionResultBuilder.addStatement((Statement)assumeStatement);
        expression2 = new Overapprox(string, iLocation);
        expressionResultBuilder.addOverapprox((Overapprox)expression2);
        object = new RValue((Expression)identifierExpression, cPointer);
        expressionResultBuilder.setLrValue((LRValue)object);
        return expressionResultBuilder.build();
    }

    private Result handleToUpper(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mHelper.checkArguments(iLocation, 1, string, iASTFunctionCallExpression.getArguments());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTFunctionCallExpression.getArguments()[0]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        Expression expression = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(97L));
        Expression expression3 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(122L));
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, expression, cPrimitive, expression2, cPrimitive);
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, expression, cPrimitive, expression3, cPrimitive);
        Expression expression6 = ExpressionFactory.and((ILocation)iLocation, List.of(expression4, expression5));
        Expression expression7 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 5, expression, cPrimitive, this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(32L)), cPrimitive);
        Expression expression8 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression6, (Expression)expression7, (Expression)expression);
        return expressionResultBuilder.setLrValue(new RValue(expression8, cPrimitive)).build();
    }

    private ExpressionResult handleMemCmp(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[2]));
        expressionResultBuilder.addAllIncludingLrValue(this.handleMemoryComparison(iDispatcher, iLocation, string, iASTInitializerClauseArray[0], iASTInitializerClauseArray[1]));
        return expressionResultBuilder.build();
    }

    private ExpressionResult handleMemoryComparison(IDispatcher iDispatcher, ILocation iLocation, String string, IASTInitializerClause iASTInitializerClause, IASTInitializerClause iASTInitializerClause2) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause);
        expressionResultBuilder.addDeclarations(expressionResult.getDeclarations());
        expressionResultBuilder.addStatements(expressionResult.getStatements());
        expressionResultBuilder.addOverapprox(expressionResult.getOverapprs());
        expressionResultBuilder.addAuxVars(expressionResult.getAuxVars());
        expressionResultBuilder.addNeighbourUnionFields(expressionResult.getNeighbourUnionFields());
        expressionResultBuilder.addStatements(this.mMemoryHandler.constructMemsafetyChecksForPointerExpression(iLocation, expressionResult.getLrValue().getValue()));
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause2);
        expressionResultBuilder.addDeclarations(expressionResult2.getDeclarations());
        expressionResultBuilder.addStatements(expressionResult2.getStatements());
        expressionResultBuilder.addOverapprox(expressionResult2.getOverapprs());
        expressionResultBuilder.addAuxVars(expressionResult2.getAuxVars());
        expressionResultBuilder.addNeighbourUnionFields(expressionResult2.getNeighbourUnionFields());
        expressionResultBuilder.addStatements(this.mMemoryHandler.constructMemsafetyChecksForPointerExpression(iLocation, expressionResult2.getLrValue().getValue()));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        Overapprox overapprox = new Overapprox(string, iLocation);
        expressionResultBuilder.addOverapprox(overapprox);
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), cPrimitive);
        expressionResultBuilder.setLrValue(rValue);
        return expressionResultBuilder.build();
    }

    private Result handleMemset(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        ExpressionResult expressionResult4 = this.mExpressionTranslation.convertIntToInt(iLocation, expressionResult2, new CPrimitive(CPrimitive.CPrimitives.INT));
        ExpressionResult expressionResult5 = this.mExpressionTranslation.convertIntToInt(iLocation, expressionResult3, this.mTypeSizeComputer.getSizeT());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().setLrValue(expressionResult.getLrValue());
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue(expressionResult4);
        expressionResultBuilder.addAllExceptLrValue(expressionResult5);
        CPointer cPointer = CPointer.voidPointer();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.MEMSETRES);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)this.mMemoryHandler.constructUltimateMemsetCall(iLocation, expressionResult.getLrValue().getValue(), expressionResult4.getLrValue().getValue(), expressionResult5.getLrValue().getValue(), auxVarInfo.getLhs()));
        return expressionResultBuilder.build();
    }

    private Result handleMemcpy(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleMemCopyOrMove(iDispatcher, iASTFunctionCallExpression, iLocation, string, SFO.AUXVAR.MEMCPYRES, MemoryModelDeclarations.C_MEMCPY);
    }

    private Result handleMemmove(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleMemCopyOrMove(iDispatcher, iASTFunctionCallExpression, iLocation, string, SFO.AUXVAR.MEMMOVERES, MemoryModelDeclarations.C_MEMMOVE);
    }

    private Result handleMemCopyOrMove(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, SFO.AUXVAR aUXVAR, MemoryModelDeclarations memoryModelDeclarations) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        CPointer cPointer = CPointer.voidPointer();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[0], cPointer);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[1], cPointer);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.transformDispatchDecaySwitchImplicitConversion(iDispatcher, iLocation, iASTInitializerClauseArray[2], this.mTypeSizeComputer.getSizeT());
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        expressionResultBuilder.addAllExceptLrValue(expressionResult3);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, expressionResult.getLrValue().getCType(), aUXVAR);
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)memoryModelDeclarations.getName(), (Expression[])new Expression[]{expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), expressionResult3.getLrValue().getValue()});
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)callStatement);
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), CPointer.voidPointer()));
        this.mMemoryHandler.requireMemoryModelFeature(memoryModelDeclarations);
        this.mProcedureManager.registerProcedure(memoryModelDeclarations.getName());
        return expressionResultBuilder.build();
    }
}

