/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.looppreprocessor;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.PredicateHelper;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.looppreprocessor.ILoopPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.looppreprocessor.LoopPreprocessorTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoopPreprocessor<L extends IIcfgTransition<?>>
implements ILoopPreprocessor<IcfgLocation, L, UnmodifiableTransFormula> {
    private final ManagedScript mScript;
    private final ILogger mLogger;
    private final PredicateHelper<L> mPredHelper;
    private final IUltimateServiceProvider mServices;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final CfgSmtToolkit mCsToolkit;
    private final List<String> mOptions;

    public LoopPreprocessor(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, IPredicateUnifier iPredicateUnifier, PredicateHelper<L> predicateHelper, CfgSmtToolkit cfgSmtToolkit, List<String> list) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mPredHelper = predicateHelper;
        this.mServices = iUltimateServiceProvider;
        this.mCsToolkit = cfgSmtToolkit;
        this.mReplacementVarFactory = new ReplacementVarFactory(this.mCsToolkit, false);
        this.mOptions = list;
    }

    @Override
    public Map<IcfgLocation, List<UnmodifiableTransFormula>> preProcessLoopInterprocedual(Map<IcfgLocation, Set<List<L>>> map) {
        HashMap<IcfgLocation, List<UnmodifiableTransFormula>> hashMap = new HashMap<IcfgLocation, List<UnmodifiableTransFormula>>();
        for (Map.Entry<IcfgLocation, Set<List<L>>> entry : map.entrySet()) {
            Object object;
            IcfgLocation icfgLocation = entry.getKey();
            if (entry.getValue() == null) continue;
            boolean bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (List<L> list : entry.getValue()) {
                String string2;
                object = SequentialComposition.getInterproceduralTransFormula((CfgSmtToolkit)this.mCsToolkit, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, list, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
                for (String string2 : this.mOptions) {
                    if (!SmtUtils.extractApplicationTerms((String)string2, (Term)object.getFormula(), (boolean)false).isEmpty()) {
                        object = this.preProcessing(string2, (UnmodifiableTransFormula)object);
                    }
                    if ("No DNF".equals(string2)) {
                        bl = true;
                    }
                    this.mLogger.debug((Object)"Preprocess");
                }
                string2 = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)object, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mScript);
                if (bl) {
                    arrayList.add(object);
                    continue;
                }
                arrayList.addAll(LoopPreprocessorTransformulaTransformer.splitDisjunction((ModifiableTransFormula)string2, this.mScript, this.mServices));
            }
            if (bl) {
                UnmodifiableTransFormula[] unmodifiableTransFormulaArray = arrayList.toArray(new UnmodifiableTransFormula[arrayList.size()]);
                UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (boolean)false, (UnmodifiableTransFormula[])unmodifiableTransFormulaArray);
                object = new ArrayList();
                ((ArrayList)object).add(unmodifiableTransFormula);
                hashMap.put(icfgLocation, (List<UnmodifiableTransFormula>)object);
            } else {
                hashMap.put(icfgLocation, arrayList);
            }
            this.mLogger.debug((Object)"Loop preprocessed");
        }
        return hashMap;
    }

    @Override
    public Map<IcfgLocation, List<UnmodifiableTransFormula>> preProcessLoop(Map<IcfgLocation, Set<List<L>>> map) {
        HashMap<IcfgLocation, List<UnmodifiableTransFormula>> hashMap = new HashMap<IcfgLocation, List<UnmodifiableTransFormula>>();
        for (Map.Entry<IcfgLocation, Set<List<L>>> entry : map.entrySet()) {
            IcfgLocation icfgLocation = entry.getKey();
            if (entry.getValue() == null) continue;
            ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
            for (List<L> list : entry.getValue()) {
                String string2;
                List<UnmodifiableTransFormula> list2 = this.convertActionToFormula(list);
                UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, list2);
                boolean bl = false;
                for (String string2 : this.mOptions) {
                    if (!SmtUtils.extractApplicationTerms((String)string2, (Term)unmodifiableTransFormula.getFormula(), (boolean)false).isEmpty()) {
                        unmodifiableTransFormula = this.preProcessing(string2, unmodifiableTransFormula);
                    }
                    if ("no DNF".equals(string2)) {
                        bl = true;
                    }
                    this.mLogger.debug((Object)"Preprocess");
                }
                string2 = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mScript);
                if (bl) {
                    arrayList.add(unmodifiableTransFormula);
                    continue;
                }
                arrayList.addAll(LoopPreprocessorTransformulaTransformer.splitDisjunction((ModifiableTransFormula)string2, this.mScript, this.mServices));
            }
            hashMap.put(icfgLocation, arrayList);
            this.mLogger.debug((Object)"Loop preprocessed");
        }
        return hashMap;
    }

    private UnmodifiableTransFormula preProcessing(String string, UnmodifiableTransFormula unmodifiableTransFormula) {
        ModifiableTransFormula modifiableTransFormula = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mScript);
        switch (string) {
            case "mod": {
                return LoopPreprocessorTransformulaTransformer.moduloTransformation(modifiableTransFormula, this.mScript, this.mReplacementVarFactory, this.mServices);
            }
            case "not": {
                return LoopPreprocessorTransformulaTransformer.notTransformation(modifiableTransFormula, this.mScript);
            }
            case "div": {
                return LoopPreprocessorTransformulaTransformer.divisionTransformation(modifiableTransFormula, this.mScript, this.mReplacementVarFactory);
            }
            case "ite": {
                return LoopPreprocessorTransformulaTransformer.iteTransformation(modifiableTransFormula, this.mScript);
            }
        }
        return unmodifiableTransFormula;
    }

    private List<UnmodifiableTransFormula> convertActionToFormula(List<L> list) {
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        for (IIcfgTransition iIcfgTransition : list) {
            arrayList.add(iIcfgTransition.getTransformula());
        }
        return arrayList;
    }
}

