/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefBaseAnnotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ReachDefMapAnnotationProvider<T extends ReachDefBaseAnnotation>
implements IAnnotationProvider<T> {
    private static final String sDefaultKey = "Default";
    private final HashMap<HashKey, T> mMap = new HashMap();
    private final HashSet<String> mKeys = new HashSet();

    public ReachDefMapAnnotationProvider() {
        this.mKeys.add(sDefaultKey);
    }

    @Override
    public T getAnnotation(IElement iElement) {
        return this.getAnnotation(iElement, sDefaultKey);
    }

    @Override
    public void annotate(IElement iElement, T t) {
        this.annotate(iElement, t, sDefaultKey);
    }

    @Override
    public T getAnnotation(IElement iElement, String string) {
        assert (string != null && !string.isEmpty());
        return (T)((Object)((ReachDefBaseAnnotation)((Object)this.mMap.get(new HashKey(iElement, string)))));
    }

    @Override
    public void annotate(IElement iElement, T t, String string) {
        assert (string != null && !string.isEmpty());
        this.mKeys.add(string);
        this.mMap.put(new HashKey(iElement, string), t);
    }

    @Override
    public List<T> getAllAnnotations(IElement iElement) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (String string : this.mKeys) {
            T t = this.getAnnotation(iElement, string);
            if (t == null) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    private static final class HashKey {
        private final IElement element;
        private final String uniqueId;

        HashKey(IElement iElement, String string) {
            this.element = iElement;
            this.uniqueId = string;
        }

        public int hashCode() {
            return Objects.hash(this.element, this.uniqueId);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HashKey hashKey = (HashKey)object;
            if (this.element == null ? hashKey.element != null : !this.element.equals(hashKey.element)) {
                return false;
            }
            return !(this.uniqueId == null ? hashKey.uniqueId != null : !this.uniqueId.equals(hashKey.uniqueId));
        }

        public String toString() {
            return "[" + this.uniqueId + "] " + String.valueOf(this.element);
        }
    }
}

