/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResultReporter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionBenchmarks;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionStarter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstractionwithafas.TAwAFAsCegarLoop;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;

public class TraceAbstractionWithAFAsObserver
extends BaseObserver {
    private final IElement mGraphroot = null;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;

    public TraceAbstractionWithAFAsObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) {
        Collection collection2;
        BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iElement;
        TAPreferences tAPreferences = new TAPreferences(this.mServices);
        CfgSmtToolkit cfgSmtToolkit = boogieIcfgContainer.getCfgSmtToolkit();
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
        new TraceAbstractionBenchmarks((IIcfg)boogieIcfgContainer);
        Map map = boogieIcfgContainer.getProcedureErrorNodes();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Collection collection2 : map.values()) {
            linkedHashSet.addAll(collection2);
        }
        collection2 = new PredicateFactoryRefinement(this.mServices, cfgSmtToolkit.getManagedScript(), predicateFactory, false, Collections.emptySet());
        Object object = new TAwAFAsCegarLoop<IcfgEdge>((DebugIdentifier)TraceAbstractionStarter.AllErrorsAtOnceDebugIdentifier.INSTANCE, (IIcfg<?>)boogieIcfgContainer, cfgSmtToolkit, predicateFactory, tAPreferences, linkedHashSet, this.mServices, IcfgEdge.class, (PredicateFactoryRefinement)collection2);
        CegarLoopResult cegarLoopResult = object.runCegar();
        CegarLoopResultReporter cegarLoopResultReporter = new CegarLoopResultReporter(this.mServices, this.mLogger, Activator.PLUGIN_ID, "TraceAbstractionWithAFAs");
        cegarLoopResultReporter.reportCegarLoopResult(cegarLoopResult);
        cegarLoopResultReporter.reportAllSafeResultIfNecessary(cegarLoopResult, linkedHashSet.size());
        TraceAbstractionBenchmarks traceAbstractionBenchmarks = new TraceAbstractionBenchmarks((IIcfg)boogieIcfgContainer);
        IStatisticsDataProvider iStatisticsDataProvider = object.getCegarLoopBenchmark();
        traceAbstractionBenchmarks.aggregateBenchmarkData(iStatisticsDataProvider);
        this.reportBenchmark((ICsvProviderProvider)traceAbstractionBenchmarks);
        return false;
    }

    private <T> void reportBenchmark(ICsvProviderProvider<T> iCsvProviderProvider) {
        StatisticsResult statisticsResult = new StatisticsResult("TraceAbstractionWithAFAs", "Ultimate CodeCheck benchmark data", iCsvProviderProvider);
        this.reportResult((IResult)statisticsResult);
    }

    public BoogieIcfgLocation getErrorPP(IProgramExecution<IcfgEdge, Term> iProgramExecution) {
        int n = iProgramExecution.getLength() - 1;
        IIcfgTransition iIcfgTransition = (IIcfgTransition)iProgramExecution.getTraceElement(n).getTraceElement();
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)iIcfgTransition.getTarget();
        return boogieIcfgLocation;
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }

    public IElement getRoot() {
        return this.mGraphroot;
    }
}

