/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class UnionFind<E>
implements IPartition<E>,
Cloneable {
    private final Comparator<E> mElementComparator;
    private final Map<E, ImmutableSet<E>> mEquivalenceClass = new HashMap<E, ImmutableSet<E>>();
    private final Map<ImmutableSet<E>, E> mRepresentative = new HashMap<ImmutableSet<E>, E>();

    public UnionFind() {
        this.mElementComparator = null;
    }

    public UnionFind(Comparator<E> comparator) {
        assert (comparator != null) : "use other constructor in this case!";
        this.mElementComparator = comparator;
    }

    protected UnionFind(UnionFind<E> unionFind) {
        for (Map.Entry<ImmutableSet<E>, E> entry : unionFind.mRepresentative.entrySet()) {
            E e = entry.getValue();
            ImmutableSet<E> immutableSet = entry.getKey();
            for (E e2 : immutableSet) {
                Set set = this.mEquivalenceClass.put(e2, immutableSet);
                assert (set == null) : "element was contained twice";
            }
            this.mRepresentative.put(immutableSet, e);
        }
        this.mElementComparator = unionFind.mElementComparator;
        assert (this.representativesAreMinimal());
    }

    public void addEquivalenceClass(ImmutableSet<E> immutableSet) {
        if (this.mElementComparator == null) {
            this.addEquivalenceClass(immutableSet, null);
        } else {
            this.addEquivalenceClass(immutableSet, this.findMinimalElement(immutableSet));
        }
        assert (this.representativesAreMinimal());
    }

    public void addEquivalenceClass(ImmutableSet<E> immutableSet, E e) {
        E e22;
        assert (DataStructureUtils.haveEmptyIntersection(immutableSet, this.getAllElements()));
        assert (!immutableSet.isEmpty());
        assert (e == null || immutableSet.contains(e));
        assert (this.mElementComparator == null || e != null) : "if we don't give a representative for the new blockhere, this method might violate the invariant that the representative is always the minimal element.";
        assert (this.mElementComparator == null || this.mElementComparator.compare(e, this.findMinimalElement(immutableSet)) <= 0);
        for (E e22 : immutableSet) {
            this.mEquivalenceClass.put(e22, immutableSet);
        }
        E e3 = e22 = e == null ? immutableSet.iterator().next() : e;
        assert (this.mEquivalenceClass.get(e22) != null);
        this.mRepresentative.put(immutableSet, e22);
        assert (this.representativesAreMinimal());
    }

    public UnionFind<E> clone() {
        return new UnionFind<E>(this);
    }

    public E find(E e) {
        ImmutableSet<E> immutableSet = this.mEquivalenceClass.get(e);
        return this.mRepresentative.get(immutableSet);
    }

    public Set<E> find(Set<E> set) {
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : set) {
            E e2 = this.find(e);
            if (e2 == null) continue;
            hashSet.add(e2);
        }
        return hashSet;
    }

    public E findAndConstructEquivalenceClassIfNeeded(E e) {
        E e2 = this.find(e);
        if (e2 == null) {
            this.makeEquivalenceClass(e);
            return e;
        }
        return e2;
    }

    public Set<E> getAllElements() {
        return Collections.unmodifiableSet(this.mEquivalenceClass.keySet());
    }

    public Collection<Set<E>> getAllEquivalenceClasses() {
        LinkedList<Set<ImmutableSet<E>>> linkedList = new LinkedList<Set<ImmutableSet<E>>>();
        for (E e : this.getAllRepresentatives()) {
            linkedList.add(this.getEquivalenceClassMembers(e));
        }
        return linkedList;
    }

    public Collection<E> getAllRepresentatives() {
        return Collections.unmodifiableCollection(this.mRepresentative.values());
    }

    @Override
    public ImmutableSet<E> getContainingSet(E e) {
        return this.getEquivalenceClassMembers(e);
    }

    public Comparator<E> getElementComparator() {
        return this.mElementComparator;
    }

    public ImmutableSet<E> getEquivalenceClassMembers(E e) {
        return this.mEquivalenceClass.get(e);
    }

    @Override
    public Iterator<Set<E>> iterator() {
        return this.getAllEquivalenceClasses().iterator();
    }

    public void makeEquivalenceClass(E e) {
        if (this.mEquivalenceClass.containsKey(e)) {
            throw new IllegalArgumentException("Already contained " + String.valueOf(e));
        }
        ImmutableSet<E> immutableSet = ImmutableSet.singleton(e);
        this.mEquivalenceClass.put(e, immutableSet);
        this.mRepresentative.put(immutableSet, e);
    }

    public void remove(E e) {
        this.remove(e, null);
    }

    public void remove(E e, E e2) {
        Object object22;
        assert (e2 == null || this.find(e2) == this.find(e));
        ImmutableSet<E> immutableSet = this.mEquivalenceClass.get(e);
        HashSet<E> hashSet = new HashSet<E>(immutableSet);
        hashSet.remove(e);
        ImmutableSet<Object> immutableSet2 = ImmutableSet.of(hashSet);
        if (this.find(e).equals(e)) {
            if (immutableSet.size() == 1) {
                this.mEquivalenceClass.remove(e);
                this.mRepresentative.remove(immutableSet);
                assert (this.areMembersConsistent());
                return;
            }
            if (this.mElementComparator == null) {
                if (e2 == null) {
                    object22 = immutableSet2.iterator().next();
                } else {
                    assert (immutableSet2.contains(e2));
                    object22 = e2;
                }
            } else {
                Object iterator = this.findMinimalElement(immutableSet2);
                if (e2 == null) {
                    object22 = iterator;
                } else {
                    if (this.mElementComparator.compare(e2, iterator) != 0) {
                        throw new IllegalArgumentException("newRepChoice must be compatible with the element comparator!");
                    }
                    object22 = e2;
                }
            }
            this.mRepresentative.put(immutableSet, object22);
        }
        for (Object object22 : immutableSet2) {
            this.mEquivalenceClass.put(object22, immutableSet2);
        }
        this.mEquivalenceClass.remove(e);
        object22 = this.mRepresentative.get(immutableSet);
        this.mRepresentative.remove(immutableSet);
        assert (!object22.equals(e));
        this.mRepresentative.put(immutableSet2, object22);
        assert (this.areMembersConsistent());
        assert (this.representativesAreMinimal());
    }

    public void removeAll(Collection<E> collection) {
        collection.forEach(this::remove);
    }

    @Override
    public int size() {
        return this.mRepresentative.size();
    }

    public String toString() {
        return this.mRepresentative.toString();
    }

    public void transformElements(Function<E, E> function) {
        HashMap<ImmutableSet<E>, E> hashMap = new HashMap<ImmutableSet<E>, E>(this.mRepresentative);
        for (Map.Entry<ImmutableSet<E>, E> entry : hashMap.entrySet()) {
            E e2;
            for (E e2 : entry.getKey()) {
                this.mEquivalenceClass.remove(e2);
            }
            this.mRepresentative.remove(entry.getKey());
            e2 = function.apply(entry.getValue());
            ImmutableSet immutableSet = entry.getKey().stream().map(function).collect(ImmutableSet.collector());
            Iterator iterator = immutableSet.iterator();
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                this.mEquivalenceClass.put(e3, immutableSet);
            }
            this.mRepresentative.put(immutableSet, e2);
        }
        assert (this.representativesAreMinimal());
    }

    public void union(Collection<E> collection) {
        Iterator<E> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        E e = iterator.next();
        while (iterator.hasNext()) {
            this.union(e, iterator.next());
        }
    }

    public boolean union(E e, E e2) {
        E e3;
        Object object;
        ImmutableSet<E> immutableSet;
        ImmutableSet<E> immutableSet2;
        ImmutableSet<E> immutableSet3 = this.mEquivalenceClass.get(e);
        if (immutableSet3 == (immutableSet2 = this.mEquivalenceClass.get(e2))) {
            return false;
        }
        boolean bl = immutableSet3.size() > immutableSet2.size();
        ImmutableSet<E> immutableSet4 = bl ? immutableSet3 : immutableSet2;
        ImmutableSet<E> immutableSet5 = immutableSet = bl ? immutableSet2 : immutableSet3;
        Object object2 = this.mElementComparator != null ? (this.mElementComparator.compare(object = this.mRepresentative.get(immutableSet3), e3 = this.mRepresentative.get(immutableSet2)) > 0 ? e3 : object) : this.mRepresentative.get(immutableSet4);
        this.mRepresentative.remove(immutableSet4);
        this.mRepresentative.remove(immutableSet);
        object = ImmutableSet.of(DataStructureUtils.union(immutableSet, immutableSet4));
        Iterator iterator = ((ImmutableSet)object).iterator();
        while (iterator.hasNext()) {
            e3 = iterator.next();
            this.mEquivalenceClass.put(e3, (ImmutableSet<E>)object);
        }
        this.mRepresentative.put((ImmutableSet<E>)object, object2);
        assert (this.representativesAreMinimal());
        return true;
    }

    public static <E> Triple<UnionFind<E>, HashRelation<E, E>, HashRelation<E, E>> intersectPartitionBlocks(UnionFind<E> unionFind, UnionFind<E> unionFind2) {
        assert (unionFind.mElementComparator == unionFind2.mElementComparator);
        UnionFind unionFind3 = new UnionFind(unionFind.mElementComparator);
        HashRelation<E, E> hashRelation = new HashRelation<E, E>();
        HashRelation<E, E> hashRelation2 = new HashRelation<E, E>();
        for (Set<E> set : unionFind.getAllEquivalenceClasses()) {
            Object object;
            E e = unionFind.find(set.iterator().next());
            HashRelation<E, E> hashRelation3 = new HashRelation<E, E>();
            for (Object object2 : set) {
                object = unionFind2.find(object2);
                hashRelation3.addPair(object, object2);
            }
            for (Object object2 : hashRelation3.getDomain()) {
                object = hashRelation3.getImage(object2);
                unionFind3.addEquivalenceClass(ImmutableSet.of(object));
                E e2 = unionFind3.find(object.iterator().next());
                hashRelation.addPair(e, e2);
                hashRelation2.addPair(object2, e2);
            }
        }
        assert (unionFind3.representativesAreMinimal());
        assert (UnionFind.sanityCheckIntersectPartitionBlocks(unionFind, unionFind2, unionFind3, hashRelation, hashRelation2));
        return new Triple<UnionFind<E>, HashRelation<E, E>, HashRelation<E, E>>(unionFind3, hashRelation, hashRelation2);
    }

    public static <E> UnionFind<E> unionPartitionBlocks(UnionFind<E> unionFind, UnionFind<E> unionFind2) {
        if (unionFind.mElementComparator != unionFind2.mElementComparator) {
            throw new AssertionError((Object)"Cannot combine partitions with different comparators");
        }
        Object object = unionFind.clone();
        for (Set<E> set : unionFind2.getAllEquivalenceClasses()) {
            HashSet<E> hashSet = new HashSet<E>();
            HashSet<E> hashSet2 = new HashSet<E>();
            for (E e : set) {
                E e2 = ((UnionFind)object).find(e);
                if (e2 != null) {
                    hashSet2.add(e2);
                    continue;
                }
                hashSet.add(e);
            }
            if (!hashSet.isEmpty()) {
                E e;
                e = ((UnionFind)object).mElementComparator == null ? hashSet.iterator().next() : ((UnionFind)object).findMinimalElement(hashSet);
                ((UnionFind)object).addEquivalenceClass(ImmutableSet.of(hashSet), e);
                hashSet2.add(e);
            }
            ((UnionFind)object).union(hashSet2);
        }
        assert (((UnionFind)object).areMembersConsistent());
        assert (((UnionFind)object).representativesAreMinimal());
        return object;
    }

    private boolean areMembersConsistent() {
        for (E object : this.mRepresentative.values()) {
            if (this.mEquivalenceClass.containsKey(object)) continue;
            return false;
        }
        for (Set set : this.mEquivalenceClass.values()) {
            if (this.mRepresentative.containsKey(set)) continue;
            return false;
        }
        for (Set set : this.mRepresentative.keySet()) {
            if (this.mEquivalenceClass.containsValue(set)) continue;
            return false;
        }
        return true;
    }

    private E findMinimalElement(Set<E> set) {
        assert (!set.isEmpty());
        Iterator<E> iterator = set.iterator();
        E e = iterator.next();
        while (iterator.hasNext()) {
            E e2 = iterator.next();
            E e3 = e = this.mElementComparator.compare(e2, e) < 0 ? e2 : e;
        }
        return e;
    }

    private boolean representativesAreMinimal() {
        if (this.mElementComparator == null) {
            return true;
        }
        for (Map.Entry<ImmutableSet<E>, E> entry : this.mRepresentative.entrySet()) {
            E e = entry.getValue();
            for (E e2 : entry.getKey()) {
                assert (this.mElementComparator.compare(e, e2) <= 0);
            }
        }
        return true;
    }

    boolean sanityCheck() {
        assert (this.assertRepresentativeMapIsInjective());
        return true;
    }

    private static <E> boolean sanityCheckIntersectPartitionBlocks(UnionFind<E> unionFind, UnionFind<E> unionFind2, UnionFind<E> unionFind3, HashRelation<E, E> hashRelation, HashRelation<E, E> hashRelation2) {
        for (Object d : hashRelation.getDomain()) {
            if (unionFind.find(d) != d) {
                assert (false);
                return false;
            }
            for (Object r : hashRelation.getImage(d)) {
                if (unionFind3.find(r) == r) continue;
                assert (false);
                return false;
            }
        }
        for (Object d : hashRelation2.getDomain()) {
            if (unionFind2.find(d) != d) {
                assert (false);
                return false;
            }
            for (Object r : hashRelation2.getImage(d)) {
                if (unionFind3.find(r) == r) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    private boolean assertRepresentativeMapIsInjective() {
        HashSet<E> hashSet = new HashSet<E>();
        for (E e : this.mRepresentative.values()) {
            assert (!hashSet.contains(e));
            hashSet.add(e);
        }
        return true;
    }
}

