/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ProgramVarUtils {
    private static final String AUX_VAR_PREFIX = "c_aux_";

    private ProgramVarUtils() {
    }

    public static String generateConstantIdentifierForAuxVar(TermVariable termVariable) {
        return AUX_VAR_PREFIX + termVariable.getName();
    }

    public static ApplicationTerm constructPrimedConstant(ManagedScript managedScript, Object object, Sort sort, String string) {
        String string2 = "c_" + string + "_primed";
        managedScript.declareFun(object, string2, new Sort[0], sort);
        ApplicationTerm applicationTerm = (ApplicationTerm)managedScript.term(object, string2, new Term[0]);
        return applicationTerm;
    }

    public static ApplicationTerm constructDefaultConstant(ManagedScript managedScript, Object object, Sort sort, String string) {
        String string2 = "c_" + string;
        managedScript.declareFun(object, string2, new Sort[0], sort);
        ApplicationTerm applicationTerm = (ApplicationTerm)managedScript.term(object, string2, new Term[0]);
        return applicationTerm;
    }

    public static ApplicationTerm constructConstantForAuxVar(ManagedScript managedScript, TermVariable termVariable) {
        String string = ProgramVarUtils.generateConstantIdentifierForAuxVar(termVariable);
        TermVariable termVariable2 = termVariable;
        managedScript.lock((Object)termVariable2);
        managedScript.declareFun((Object)termVariable2, string, new Sort[0], termVariable.getSort());
        ApplicationTerm applicationTerm = (ApplicationTerm)managedScript.term((Object)termVariable2, string, new Term[0]);
        managedScript.unlock((Object)termVariable2);
        return applicationTerm;
    }

    public static ApplicationTerm getAuxVarConstant(ManagedScript managedScript, TermVariable termVariable) {
        String string = ProgramVarUtils.generateConstantIdentifierForAuxVar(termVariable);
        return (ApplicationTerm)managedScript.getScript().term(string, new Term[0]);
    }

    public static Set<IProgramNonOldVar> extractNonOldVars(Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        HashSet<IProgramNonOldVar> hashSet = new HashSet<IProgramNonOldVar>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            if (iProgramVar instanceof IProgramNonOldVar) {
                hashSet.add((IProgramNonOldVar)iProgramVar);
            }
            ++n2;
        }
        return hashSet;
    }

    public static Set<IProgramOldVar> extractOldVars(Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        HashSet<IProgramOldVar> hashSet = new HashSet<IProgramOldVar>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            if (iProgramVar instanceof IProgramOldVar) {
                hashSet.add((IProgramOldVar)iProgramVar);
            }
            ++n2;
        }
        return hashSet;
    }

    public static Term renameNonOldGlobalsToOldGlobals(Term term, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript) {
        IProgramNonOldVar iProgramNonOldVar2;
        Set<IProgramNonOldVar> set = ProgramVarUtils.extractNonOldVars(term, iIcfgSymbolTable);
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramNonOldVar iProgramNonOldVar2 : set) {
            if (iProgramNonOldVar2 == null) continue;
            IProgramOldVar iProgramOldVar = iProgramNonOldVar2.getOldVar();
            hashMap.put(iProgramNonOldVar2.getTermVariable(), iProgramOldVar.getTermVariable());
        }
        iProgramNonOldVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
        return iProgramNonOldVar2;
    }

    public static Term renameOldGlobalsToNonOldGlobals(Term term, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript) {
        IProgramOldVar iProgramOldVar2;
        Set<IProgramOldVar> set = ProgramVarUtils.extractOldVars(term, iIcfgSymbolTable);
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramOldVar iProgramOldVar2 : set) {
            if (iProgramOldVar2 == null) continue;
            IProgramNonOldVar iProgramNonOldVar = iProgramOldVar2.getNonOldVar();
            hashMap.put(iProgramOldVar2.getTermVariable(), iProgramNonOldVar.getTermVariable());
        }
        iProgramOldVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
        return iProgramOldVar2;
    }

    public static String buildBoogieVarName(String string, String string2, boolean bl, boolean bl2) {
        Object object;
        if (bl) {
            assert (string2 == null);
            object = bl2 ? "old(" + string + ")" : string;
        } else {
            assert (!bl2) : "only global vars can be oldvars";
            object = string2 + "_" + string;
        }
        return object;
    }

    public static ProgramNonOldVar constructGlobalProgramVarPair(String string, Sort sort, ManagedScript managedScript, Object object) {
        String string2 = null;
        Object object2 = ProgramVarUtils.buildBoogieVarName(string, string2, true, true);
        Object object3 = managedScript.variable((String)object2, sort);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(managedScript, object, sort, (String)object2);
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(managedScript, object, sort, (String)object2);
        ProgramOldVar programOldVar = new ProgramOldVar(string, (TermVariable)object3, applicationTerm, applicationTerm2);
        object3 = ProgramVarUtils.buildBoogieVarName(string, string2, true, false);
        applicationTerm = managedScript.variable((String)object3, sort);
        applicationTerm2 = ProgramVarUtils.constructDefaultConstant(managedScript, object, sort, (String)object3);
        ApplicationTerm applicationTerm3 = ProgramVarUtils.constructPrimedConstant(managedScript, object, sort, (String)object3);
        object2 = new ProgramNonOldVar(string, (TermVariable)applicationTerm, applicationTerm2, applicationTerm3, programOldVar);
        programOldVar.setNonOldVar((IProgramNonOldVar)object2);
        return object2;
    }

    public static ILocalProgramVar constructLocalProgramVar(String string, String string2, Sort sort, ManagedScript managedScript, Object object) {
        String string3 = ProgramVarUtils.buildBoogieVarName(string, string2, false, false);
        TermVariable termVariable = managedScript.variable(string3, sort);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(managedScript, object, sort, string3);
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(managedScript, object, sort, string3);
        return new LocalProgramVar(string, string2, termVariable, applicationTerm, applicationTerm2);
    }

    public static IProgramVar transferProgramVar(TermTransferrer termTransferrer, IProgramVar iProgramVar) {
        if (iProgramVar instanceof ILocalProgramVar) {
            return new TransferredLocalProgramVar((ILocalProgramVar)iProgramVar, termTransferrer);
        }
        if (iProgramVar instanceof IProgramNonOldVar) {
            return new TransferredProgramNonOldVar((IProgramNonOldVar)iProgramVar, termTransferrer);
        }
        if (iProgramVar instanceof IProgramOldVar) {
            return new TransferredProgramNonOldVar(((IProgramOldVar)iProgramVar).getNonOldVar(), termTransferrer).getOldVar();
        }
        if (iProgramVar instanceof IReplacementVar) {
            return new TransferredReplacementVar((IReplacementVar)iProgramVar, termTransferrer);
        }
        return new TransferredProgramVar<IProgramVar>(iProgramVar, termTransferrer);
    }

    public static IProgramConst transferProgramConst(TermTransferrer termTransferrer, IProgramConst iProgramConst) {
        return new TransferredProgramConst(iProgramConst, termTransferrer);
    }

    private static class TransferredLocalProgramVar
    extends TransferredProgramVar<ILocalProgramVar>
    implements ILocalProgramVar {
        private static final long serialVersionUID = 1L;

        public TransferredLocalProgramVar(ILocalProgramVar iLocalProgramVar, TermTransferrer termTransferrer) {
            super(iLocalProgramVar, termTransferrer);
        }

        @Override
        public String getIdentifier() {
            return ((ILocalProgramVar)this.mOriginalProgramVar).getIdentifier();
        }
    }

    private static final class TransferredProgramConst
    implements IProgramConst {
        private final IProgramConst mProgConst;
        private final Term mTerm;
        private final ApplicationTerm mDefaultConst;
        private static final long serialVersionUID = 1L;

        private TransferredProgramConst(IProgramConst iProgramConst, TermTransferrer termTransferrer) {
            this.mProgConst = iProgramConst;
            this.mTerm = termTransferrer.transform(iProgramConst.getTerm());
            this.mDefaultConst = (ApplicationTerm)termTransferrer.transform((Term)iProgramConst.getDefaultConstant());
        }

        @Override
        public String getGloballyUniqueId() {
            return this.mProgConst.getGloballyUniqueId();
        }

        @Override
        public boolean isGlobal() {
            return this.mProgConst.isGlobal();
        }

        @Override
        public Term getTerm() {
            return this.mTerm;
        }

        @Override
        public String getIdentifier() {
            return this.mProgConst.getIdentifier();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mDefaultConst;
        }

        public String toString() {
            return this.mProgConst.toString();
        }
    }

    private static class TransferredProgramNonOldVar
    implements IProgramNonOldVar {
        private static final long serialVersionUID = 1L;
        private final IProgramVar mNonOld;
        private final IProgramOldVar mOld;
        private final String mIdentifier;

        public TransferredProgramNonOldVar(IProgramNonOldVar iProgramNonOldVar, TermTransferrer termTransferrer) {
            this.mNonOld = new TransferredProgramVar<IProgramNonOldVar>(iProgramNonOldVar, termTransferrer);
            this.mOld = new TransferredProgramOldVar(this, iProgramNonOldVar.getOldVar(), termTransferrer);
            this.mIdentifier = iProgramNonOldVar.getIdentifier();
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mNonOld.getTermVariable();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mNonOld.getDefaultConstant();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mNonOld.getPrimedConstant();
        }

        @Override
        public Term getTerm() {
            return this.mNonOld.getTerm();
        }

        @Override
        public String getIdentifier() {
            return this.mIdentifier;
        }

        @Override
        public IProgramOldVar getOldVar() {
            return this.mOld;
        }

        public String toString() {
            return this.mNonOld.toString();
        }
    }

    private static class TransferredProgramOldVar
    implements IProgramOldVar {
        private static final long serialVersionUID = 1L;
        private final IProgramVar mOld;
        private final IProgramNonOldVar mNonOld;

        private TransferredProgramOldVar(IProgramNonOldVar iProgramNonOldVar, IProgramOldVar iProgramOldVar, TermTransferrer termTransferrer) {
            this.mOld = new TransferredProgramVar<IProgramOldVar>(iProgramOldVar, termTransferrer);
            this.mNonOld = iProgramNonOldVar;
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mOld.getTermVariable();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mOld.getDefaultConstant();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mOld.getPrimedConstant();
        }

        @Override
        public Term getTerm() {
            return this.mOld.getTerm();
        }

        @Override
        public String getIdentifierOfNonOldVar() {
            return this.mNonOld.getIdentifier();
        }

        @Override
        public IProgramNonOldVar getNonOldVar() {
            return this.mNonOld;
        }

        public String toString() {
            return this.mOld.toString();
        }
    }

    private static class TransferredProgramVar<L extends IProgramVar>
    implements IProgramVar {
        private static final long serialVersionUID = 1L;
        protected final L mOriginalProgramVar;
        private final Term mTerm;
        private final TermVariable mTermVar;
        private final ApplicationTerm mPrimedConstant;
        private final ApplicationTerm mDefaultConstant;

        private TransferredProgramVar(L l, TermTransferrer termTransferrer) {
            this.mOriginalProgramVar = l;
            this.mTerm = termTransferrer.transform(l.getTerm());
            this.mTermVar = (TermVariable)termTransferrer.transform((Term)l.getTermVariable());
            this.mPrimedConstant = (ApplicationTerm)termTransferrer.transform((Term)l.getPrimedConstant());
            this.mDefaultConstant = (ApplicationTerm)termTransferrer.transform((Term)l.getDefaultConstant());
        }

        @Override
        public String getGloballyUniqueId() {
            return this.mOriginalProgramVar.getGloballyUniqueId();
        }

        @Override
        public boolean isGlobal() {
            return this.mOriginalProgramVar.isGlobal();
        }

        @Override
        public Term getTerm() {
            return this.mTerm;
        }

        @Override
        public boolean isOldvar() {
            return this.mOriginalProgramVar.isOldvar();
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mTermVar;
        }

        @Override
        public String getProcedure() {
            return this.mOriginalProgramVar.getProcedure();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mPrimedConstant;
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mDefaultConstant;
        }

        public String toString() {
            return this.mOriginalProgramVar.toString();
        }
    }

    private static class TransferredReplacementVar
    extends TransferredProgramVar<IReplacementVar>
    implements IReplacementVar {
        private static final long serialVersionUID = 1L;
        private final Term mDefinition;

        public TransferredReplacementVar(IReplacementVar iReplacementVar, TermTransferrer termTransferrer) {
            super(iReplacementVar, termTransferrer);
            this.mDefinition = termTransferrer.transform(iReplacementVar.getDefinition());
        }

        @Override
        public Term getDefinition() {
            return this.mDefinition;
        }
    }
}

