/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BarelyCoveredLevelRankingsGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraint;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraintDrdCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.MultiOptimizationLevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class MultiOptimizationLevelRankingGenerator<LETTER, STATE, CONSTRAINT extends LevelRankingConstraint<LETTER, STATE>>
extends LevelRankingGenerator<LETTER, STATE, CONSTRAINT> {
    private static final boolean DEBUG_CHECK_MORE_THAN_ONLY_O_ESCAPE = false;
    private final FkvOptimization mOptimization;

    public MultiOptimizationLevelRankingGenerator(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, FkvOptimization fkvOptimization, int n) {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, n);
        this.mOptimization = fkvOptimization;
    }

    @Override
    public Collection<LevelRankingState<LETTER, STATE>> generateLevelRankings(CONSTRAINT CONSTRAINT, boolean bl) {
        switch (this.mOptimization) {
            case HEIMAT1: {
                return new HeiMatTightLevelRankingStateGenerator(CONSTRAINT, false).computeResult();
            }
            case HEIMAT2: {
                return new HeiMatTightLevelRankingStateGenerator(CONSTRAINT, true).computeResult();
            }
            case HIGH_EVEN: {
                return new HighEvenTightLevelRankingStateGenerator(CONSTRAINT).computeResult();
            }
            case SCHEWE: {
                return this.generateLevelRankingsSchewe(CONSTRAINT, bl);
            }
            case ELASTIC: {
                return this.generateLevelRankingsElastic(CONSTRAINT, bl);
            }
            case TIGHT_LEVEL_RANKINGS: {
                return new TightLevelRankingStateGenerator(CONSTRAINT).computeResult();
            }
        }
        throw new UnsupportedOperationException();
    }

    private Collection<LevelRankingState<LETTER, STATE>> generateLevelRankingsSchewe(CONSTRAINT CONSTRAINT, boolean bl) {
        if (bl) {
            return new MaxTightLevelRankingStateGeneratorInitial(CONSTRAINT).computeResult();
        }
        return new MaxTightLevelRankingStateGeneratorNonInitial(CONSTRAINT).computeResult();
    }

    private Collection<LevelRankingState<LETTER, STATE>> generateLevelRankingsElastic(CONSTRAINT CONSTRAINT, boolean bl) {
        if (bl) {
            return new HeiMatTightLevelRankingStateGenerator(CONSTRAINT, false).computeResult();
        }
        EnumSet<LevelRankingConstraint.VoluntaryRankDecrease> enumSet = EnumSet.of(LevelRankingConstraint.VoluntaryRankDecrease.ALLOWS_O_ESCAPE);
        return new BarelyCoveredLevelRankingsGenerator(this.mServices, this.mOperand, this.mUserDefinedMaxRank, true, false, true, enumSet).generateLevelRankings((LevelRankingConstraintDrdCheck)CONSTRAINT, false);
    }

    public static enum FkvOptimization {
        HEIMAT1,
        HEIMAT2,
        TIGHT_LEVEL_RANKINGS,
        HIGH_EVEN,
        SCHEWE,
        ELASTIC;

    }

    private class HeiMatTightLevelRankingStateGenerator
    extends TightLevelRankingStateGenerator {
        private static final int THOUSAND = 1000;
        private final TreeHashRelation<Integer, DoubleDecker<StateWithRankInfo<STATE>>> mUnrestrictedMaxRank2DoubleDeckerWithRankInfo;
        private final boolean mSuccessorsOfFinalsWantToLeaveO;

        public HeiMatTightLevelRankingStateGenerator(LevelRankingConstraint<LETTER, STATE> levelRankingConstraint, boolean bl) {
            super(levelRankingConstraint);
            this.mSuccessorsOfFinalsWantToLeaveO = bl;
            this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo = new TreeHashRelation();
            for (DoubleDecker doubleDecker : this.mUnrestrictedDoubleDeckerWithRankInfo) {
                Integer n = (Integer)((HashMap)levelRankingConstraint.mLevelRanking.get(doubleDecker.getDown())).get(doubleDecker.getUp().getState());
                this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.addPair((Object)n, doubleDecker);
            }
        }

        @Override
        Collection<LevelRankingState<LETTER, STATE>> computeResult() {
            int n = this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.size();
            if (n == 0) {
                return Collections.emptyList();
            }
            LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation = new LevelRankingWithSacrificeInformation(this);
            this.recursivelyComputeResults(0, levelRankingWithSacrificeInformation, 0, n);
            return this.mResult;
        }

        private DoubleDecker<StateWithRankInfo<STATE>>[] getUnrestrictedWithMaxRank(int n) {
            DoubleDecker[] doubleDeckerArray = new DoubleDecker[]{};
            DoubleDecker[] doubleDeckerArray2 = this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getDomain().contains(n) ? this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getImage((Object)n).toArray(doubleDeckerArray) : doubleDeckerArray;
            return doubleDeckerArray2;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void recursivelyComputeResults(int n, LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation, int n2, int n3) {
            assert (n % 2 == 0);
            assert (n2 + n3 == this.mUnrestrictedDoubleDeckerWithRankInfo.size());
            DoubleDecker<StateWithRankInfo<STATE>>[] doubleDeckerArray = this.getUnrestrictedWithMaxRank(n);
            if (n3 == doubleDeckerArray.length) {
                levelRankingWithSacrificeInformation.addOddRanks(doubleDeckerArray, n - 1);
                this.addResult(levelRankingWithSacrificeInformation.assignRestrictedAndGetLevelRankingState());
                return;
            }
            if (levelRankingWithSacrificeInformation.numberUnsatisfiedLowerRanks() + 1 > n3) {
                throw new AssertionError((Object)"unable to assign all ranks");
            }
            DoubleDecker[] doubleDeckerArray2 = this.getUnrestrictedWithMaxRank(n + 1);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            DoubleDecker<StateWithRankInfo<STATE>>[] doubleDeckerArray3 = doubleDeckerArray;
            int n4 = doubleDeckerArray.length;
            int n5 = 0;
            while (n5 < n4) {
                DoubleDecker doubleDecker = doubleDeckerArray3[n5];
                if (this.mConstraint.inO(doubleDecker.getDown(), doubleDecker.getUp().getState())) {
                    if (this.mSuccessorsOfFinalsWantToLeaveO && !MultiOptimizationLevelRankingGenerator.this.mOperand.isFinal(doubleDecker.getUp().getState()) && LevelRankingState.isEven(doubleDecker.getUp().getRank())) {
                        arrayList.add(doubleDecker);
                    } else {
                        arrayList2.add(doubleDecker);
                    }
                } else {
                    arrayList3.add(doubleDecker);
                }
                ++n5;
            }
            int n6 = n > 0 ? (int)Math.pow(2.0, doubleDeckerArray.length) : 1;
            n5 = levelRankingWithSacrificeInformation.numberUnsatisfiedLowerRanks() + 1 - (n3 - doubleDeckerArray.length);
            n4 = n3 - doubleDeckerArray.length - doubleDeckerArray2.length;
            int n7 = n2 + doubleDeckerArray.length + doubleDeckerArray2.length;
            this.surplus(n);
            this.surplus(n);
            int n8 = n3 - (levelRankingWithSacrificeInformation.numberUnsatisfiedLowerRanks() + 1);
            int n9 = this.surplus(n);
            levelRankingWithSacrificeInformation.numberUnsatisfiedLowerRanks();
            int n10 = Math.max(levelRankingWithSacrificeInformation.numberUnsatisfiedLowerRanks() - n9, 0);
            if (n10 > 1 && n6 > 1) {
                MultiOptimizationLevelRankingGenerator.this.mLogger.info((Object)"Sacrifice!");
            }
            int n11 = (int)Math.pow(2.0, arrayList.size());
            int n12 = (int)Math.pow(2.0, arrayList2.size());
            int n13 = (int)Math.pow(2.0, arrayList3.size());
            assert (n6 == n11 * n12 * n13);
            this.outerLoop(n, levelRankingWithSacrificeInformation, doubleDeckerArray2, arrayList, arrayList2, arrayList3, n5, n4, n7, n8, n10, n11, n12, n13);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void outerLoop(Integer n, LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation, DoubleDecker[] doubleDeckerArray, List list, List list2, List list3, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            int n10 = 0;
            while (n10 < n7) {
                int n11 = Integer.bitCount(n10);
                if (n11 + list3.size() >= n2) {
                    int n12 = 0;
                    while (n12 < n8) {
                        int n13 = Integer.bitCount(n12);
                        if (n11 + n13 + list3.size() >= n2) {
                            this.innerLoop(n, levelRankingWithSacrificeInformation, doubleDeckerArray, list, list2, list3, n2, n3, n4, n5, n6, n9, n10, n11, n12, n13);
                        }
                        ++n12;
                    }
                }
                ++n10;
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void innerLoop(int n, LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation, DoubleDecker[] doubleDeckerArray, List list, List list2, List list3, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
            int n12 = 0;
            while (n12 < n7) {
                int n13 = Integer.bitCount(n12);
                if (n9 + n11 + n13 >= n2 && (n11 <= 0 && n13 <= 0 || n9 + n11 + n13 <= n6)) {
                    LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation2 = new LevelRankingWithSacrificeInformation(this, levelRankingWithSacrificeInformation);
                    int n14 = 0;
                    while (n14 < list.size()) {
                        if (BigInteger.valueOf(n8).testBit(n14)) {
                            levelRankingWithSacrificeInformation2.addOddRank((DoubleDecker)list.get(n14), n - 1, true);
                        }
                        ++n14;
                    }
                    n14 = 0;
                    while (n14 < list2.size()) {
                        if (BigInteger.valueOf(n10).testBit(n14)) {
                            levelRankingWithSacrificeInformation2.addOddRank((DoubleDecker)list2.get(n14), n - 1, true);
                        }
                        ++n14;
                    }
                    n14 = 0;
                    while (n14 < list3.size()) {
                        if (BigInteger.valueOf(n12).testBit(n14)) {
                            levelRankingWithSacrificeInformation2.addOddRank((DoubleDecker)list3.get(n14), n - 1, true);
                        }
                        ++n14;
                    }
                    levelRankingWithSacrificeInformation2.increaseCurrentRank();
                    assert (levelRankingWithSacrificeInformation2.mCurrentRank == n);
                    n14 = 0;
                    int n15 = 0;
                    while (n15 < list.size()) {
                        if (!BigInteger.valueOf(n8).testBit(n15)) {
                            levelRankingWithSacrificeInformation2.addEvenRank((DoubleDecker)list.get(n15), n);
                            ++n14;
                        }
                        ++n15;
                    }
                    n15 = 0;
                    while (n15 < list2.size()) {
                        if (!BigInteger.valueOf(n10).testBit(n15)) {
                            levelRankingWithSacrificeInformation2.addEvenRank((DoubleDecker)list2.get(n15), n);
                            ++n14;
                        }
                        ++n15;
                    }
                    n15 = 0;
                    while (n15 < list3.size()) {
                        if (!BigInteger.valueOf(n12).testBit(n15)) {
                            levelRankingWithSacrificeInformation2.addEvenRank((DoubleDecker)list3.get(n15), n);
                            ++n14;
                        }
                        ++n15;
                    }
                    assert (n14 <= n5);
                    levelRankingWithSacrificeInformation2.increaseCurrentRank();
                    levelRankingWithSacrificeInformation2.addOddRanks(doubleDeckerArray, n + 1);
                    n15 = levelRankingWithSacrificeInformation2.numberUnsatisfiedLowerRanks();
                    if (n3 == n15) {
                        levelRankingWithSacrificeInformation2.assignRemainingUnrestricted(n + 1, n3);
                        this.addResult(levelRankingWithSacrificeInformation2.assignRestrictedAndGetLevelRankingState());
                    } else {
                        this.recursivelyComputeResults(n + 2, levelRankingWithSacrificeInformation2, n4, n3);
                    }
                }
                ++n12;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int surplus(int n) {
            int n2;
            int n3;
            Iterator iterator = this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.descendingDomain().iterator();
            assert (iterator.hasNext());
            int n4 = (Integer)iterator.next();
            if (n4 == Integer.MAX_VALUE) {
                if (!iterator.hasNext()) return 0;
                n3 = (Integer)iterator.next();
            } else {
                n3 = n4;
            }
            int n5 = this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.numberOfPairsWithGivenDomainElement((Object)Integer.MAX_VALUE);
            if (LevelRankingState.isEven(n3)) {
                n2 = n5 > 0 ? 0 : this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.numberOfPairsWithGivenDomainElement((Object)n3);
                n4 = n3 - 1;
            } else {
                n2 = 0;
                n4 = n3;
            }
            while (n4 >= n) {
                assert (LevelRankingState.isOdd(n4));
                int n6 = this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.numberOfPairsWithGivenDomainElement((Object)n4);
                if ((n2 += n6 - 1) < 0) {
                    assert (n2 == -1);
                    n2 = 0;
                }
                n4 -= 2;
            }
            return n2;
        }

        private void addResult(LevelRankingState<LETTER, STATE> levelRankingState) {
            assert (levelRankingState.mLevelRanking.size() == this.mConstraint.mLevelRanking.size());
            this.mResult.add(levelRankingState);
        }

        public String toString() {
            return this.mConstraint.toString() + " Unrestricted: " + String.valueOf(this.mUnrestrictedDoubleDeckerWithRankInfo);
        }

        void assignRemainingUnrestricted(int n, LevelRankingState<LETTER, STATE> levelRankingState, int n2) {
            int n3 = n2;
            assert (n % 2 != 0) : "maxrank is always odd";
            Integer n4 = Integer.MAX_VALUE;
            if (this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getDomain().contains(n4)) {
                for (DoubleDecker doubleDecker : this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getImage((Object)n4)) {
                    levelRankingState.addRank((StateWithRankInfo)doubleDecker.getDown(), ((StateWithRankInfo)doubleDecker.getUp()).getState(), n, false);
                    --n3;
                }
            }
            assert (n3 >= 0);
            int n5 = n + 1;
            while (n3 > 0) {
                if (this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getDomain().contains(n5)) {
                    for (Object object : this.mUnrestrictedMaxRank2DoubleDeckerWithRankInfo.getImage((Object)n5)) {
                        levelRankingState.addRank((StateWithRankInfo)((DoubleDecker)object).getDown(), ((StateWithRankInfo)((DoubleDecker)object).getUp()).getState(), n, false);
                        --n3;
                    }
                }
                if (++n5 > 1000) {
                    throw new AssertionError((Object)"forgotten rank bound?, there are no automata with rank > 1000 in the nature");
                }
            }
        }

        private static class LevelRankingWithSacrificeInformation {
            private final LevelRankingState<LETTER, STATE> mLrs;
            private int mCurrentRank;
            private final TreeSet<Integer> mUnSatisfiedOddRanks;
            private final List<DoubleDecker<StateWithRankInfo<STATE>>> mSacrificedDoubleDeckerWithRankInfos;
            final /* synthetic */ HeiMatTightLevelRankingStateGenerator this$1;

            public LevelRankingWithSacrificeInformation(de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.MultiOptimizationLevelRankingGenerator$HeiMatTightLevelRankingStateGenerator.LevelRankingWithSacrificeInformation levelRankingWithSacrificeInformation) {
                this.this$1 = var1_1;
                this.mCurrentRank = -1;
                this.mLrs = new LevelRankingState(levelRankingWithSacrificeInformation.mLrs);
                this.mCurrentRank = levelRankingWithSacrificeInformation.mCurrentRank;
                this.mUnSatisfiedOddRanks = new TreeSet<Integer>((SortedSet<Integer>)levelRankingWithSacrificeInformation.mUnSatisfiedOddRanks);
                this.mSacrificedDoubleDeckerWithRankInfos = new ArrayList(levelRankingWithSacrificeInformation.mSacrificedDoubleDeckerWithRankInfos);
            }

            LevelRankingWithSacrificeInformation(HeiMatTightLevelRankingStateGenerator heiMatTightLevelRankingStateGenerator) {
                this.this$1 = heiMatTightLevelRankingStateGenerator;
                this.mCurrentRank = -1;
                this.mLrs = new LevelRankingState(((HeiMatTightLevelRankingStateGenerator)heiMatTightLevelRankingStateGenerator).MultiOptimizationLevelRankingGenerator.this.mOperand);
                this.mUnSatisfiedOddRanks = new TreeSet();
                this.mSacrificedDoubleDeckerWithRankInfos = new ArrayList();
            }

            int numberUnsatisfiedLowerRanks() {
                return this.mUnSatisfiedOddRanks.size();
            }

            void increaseCurrentRank() {
                ++this.mCurrentRank;
                if (this.mCurrentRank % 2 != 0) {
                    this.mUnSatisfiedOddRanks.add(this.mCurrentRank);
                }
            }

            void addOddRank(DoubleDecker<StateWithRankInfo<STATE>> doubleDecker, int n, boolean bl) {
                assert (n % 2 != 0);
                assert (n == this.mCurrentRank);
                this.mLrs.addRank(doubleDecker.getDown(), doubleDecker.getUp().getState(), n, false);
                this.mUnSatisfiedOddRanks.pollLast();
                if (bl) {
                    this.mSacrificedDoubleDeckerWithRankInfos.add(doubleDecker);
                }
            }

            void addOddRanks(DoubleDecker<StateWithRankInfo<STATE>>[] doubleDeckerArray, int n) {
                DoubleDecker<StateWithRankInfo<STATE>>[] doubleDeckerArray2 = doubleDeckerArray;
                int n2 = doubleDeckerArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    DoubleDecker doubleDecker = doubleDeckerArray2[n3];
                    this.addOddRank(doubleDecker, n, false);
                    ++n3;
                }
            }

            void addEvenRank(DoubleDecker<StateWithRankInfo<STATE>> doubleDecker, int n) {
                assert (n % 2 == 0);
                assert (n == this.mCurrentRank);
                boolean bl = this.this$1.mConstraint.inO(doubleDecker.getDown(), doubleDecker.getUp().getState());
                this.mLrs.addRank(doubleDecker.getDown(), doubleDecker.getUp().getState(), n, bl);
                if (!this.mUnSatisfiedOddRanks.isEmpty()) {
                    Integer n2 = this.mUnSatisfiedOddRanks.last();
                    assert (n2 < n);
                }
            }

            public LevelRankingState<LETTER, STATE> assignRestrictedAndGetLevelRankingState() {
                if (!this.mUnSatisfiedOddRanks.isEmpty()) {
                    throw new AssertionError((Object)"not all odd ranks assigned yet");
                }
                assert (this.mLrs.mHighestRank % 2 != 0) : "maxrank is always odd";
                for (DoubleDecker doubleDecker : this.this$1.mRestrictedDoubleDeckerWithRankInfo) {
                    Integer n;
                    boolean bl = this.this$1.mConstraint.inO(doubleDecker.getDown(), doubleDecker.getUp().getState());
                    if (this.this$1.mConstraint.getRank(doubleDecker.getDown(), doubleDecker.getUp().getState()) <= this.mLrs.mHighestRank) {
                        int n2 = this.this$1.mConstraint.getRank(doubleDecker.getDown(), doubleDecker.getUp().getState());
                        n = n2 % 2 == 0 ? Integer.valueOf(n2) : Integer.valueOf(n2 - 1);
                    } else {
                        if (this.mSacrificedDoubleDeckerWithRankInfos.size() > 1) {
                            ((HeiMatTightLevelRankingStateGenerator)this.this$1).MultiOptimizationLevelRankingGenerator.this.mLogger.warn((Object)"unneccessary sacrifice !!! this state is is not needed, construction can be optimized, contact Matthias");
                        }
                        n = this.mLrs.mHighestRank - 1;
                    }
                    this.mLrs.addRank(doubleDecker.getDown(), doubleDecker.getUp().getState(), n, bl);
                }
                return this.mLrs;
            }

            void assignRemainingUnrestricted(Integer n, int n2) {
                assert (n == this.mCurrentRank);
                assert (n2 >= this.mUnSatisfiedOddRanks.size());
                this.this$1.assignRemainingUnrestricted(n, this.mLrs, n2);
                this.mUnSatisfiedOddRanks.clear();
            }
        }
    }

    private class HighEvenTightLevelRankingStateGenerator
    extends TightLevelRankingStateGenerator {
        public HighEvenTightLevelRankingStateGenerator(LevelRankingConstraint<LETTER, STATE> levelRankingConstraint) {
            super(levelRankingConstraint);
        }

        @Override
        protected void initializeRestricted(int n) {
            if (n == 0) {
                int n2 = 0;
                while (n2 < this.mRestrictedRank.length) {
                    this.mRestrictedRank[n2] = 0;
                    ++n2;
                }
                return;
            }
            assert (n > 0 && n % 2 != 0);
            int n3 = 0;
            while (n3 < this.mRestrictedRank.length) {
                this.mRestrictedRank[n3] = n < (Integer)this.mRestrictedMaxRank.get(n3) ? n - 1 : ((Integer)this.mRestrictedMaxRank.get(n3) % 2 != 0 ? (Integer)this.mRestrictedMaxRank.get(n3) - 1 : (Integer)this.mRestrictedMaxRank.get(n3));
                ++n3;
            }
        }

        @Override
        protected boolean increaseDigitUnrestricted(int n) {
            int n2;
            int n3 = this.mUnrestrictedRank[n];
            if (n3 == this.maxTightRankUnrestricted(n)) {
                this.mUnrestrictedRank[n] = 1;
                return true;
            }
            assert (this.maxTightRankUnrestricted(n) >= 1);
            if (n3 + 2 <= this.maxTightRankUnrestricted(n)) {
                n2 = n3 + 2;
            } else {
                n2 = n3 + 1;
                assert (n2 == this.maxTightRankUnrestricted(n));
                assert (n2 % 2 == 0);
            }
            this.mUnrestrictedRank[n] = n2;
            return false;
        }

        @Override
        protected boolean increaseCounterRestricted(int n) {
            return true;
        }

        @Override
        protected void initializeUnrestricted() {
            int n = 0;
            while (n < this.mUnrestrictedRank.length) {
                this.mUnrestrictedRank[n] = 1;
                ++n;
            }
        }
    }

    private class MaxTightLevelRankingStateGeneratorInitial
    extends TightLevelRankingStateGenerator {
        private final List<DoubleDecker<StateWithRankInfo<STATE>>> mFinalDoubleDeckerWithRankInfos;
        private final List<DoubleDecker<StateWithRankInfo<STATE>>> mNonFinalDoubleDeckerWithRankInfos;

        public MaxTightLevelRankingStateGeneratorInitial(LevelRankingConstraint<LETTER, STATE> levelRankingConstraint) {
            super(levelRankingConstraint);
            this.mFinalDoubleDeckerWithRankInfos = new ArrayList();
            this.mNonFinalDoubleDeckerWithRankInfos = new ArrayList();
            for (StateWithRankInfo stateWithRankInfo : levelRankingConstraint.getDownStates()) {
                for (StateWithRankInfo stateWithRankInfo2 : levelRankingConstraint.getUpStates(stateWithRankInfo)) {
                    assert (stateWithRankInfo2.getRank() == MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank);
                    DoubleDecker doubleDecker = new DoubleDecker(stateWithRankInfo, stateWithRankInfo2);
                    if (MultiOptimizationLevelRankingGenerator.this.mOperand.isFinal(stateWithRankInfo2.getState())) {
                        this.mFinalDoubleDeckerWithRankInfos.add(doubleDecker);
                        continue;
                    }
                    this.mNonFinalDoubleDeckerWithRankInfos.add(doubleDecker);
                }
            }
        }

        public void rec(int n, Map<DoubleDecker<StateWithRankInfo<STATE>>, Integer> map) {
            if (map.size() == this.mNonFinalDoubleDeckerWithRankInfos.size()) {
                int n2 = n - 2;
                LevelRankingState levelRankingState = this.constructLevelRankingState(map, n2);
                this.mResult.add(levelRankingState);
            } else {
                for (DoubleDecker doubleDecker : this.mNonFinalDoubleDeckerWithRankInfos) {
                    if (map.containsKey(doubleDecker)) continue;
                    HashMap hashMap = new HashMap(map);
                    hashMap.put(doubleDecker, n);
                    this.rec(n + 2, hashMap);
                }
                this.addLevelRankingState(n, map);
            }
        }

        private void addLevelRankingState(int n, Map<DoubleDecker<StateWithRankInfo<STATE>>, Integer> map) {
            HashMap hashMap = new HashMap(map);
            for (DoubleDecker doubleDecker : this.mNonFinalDoubleDeckerWithRankInfos) {
                if (hashMap.containsKey(doubleDecker)) continue;
                hashMap.put(doubleDecker, n);
            }
            int n2 = n;
            LevelRankingState levelRankingState = this.constructLevelRankingState(hashMap, n2);
            this.mResult.add(levelRankingState);
        }

        private LevelRankingState<LETTER, STATE> constructLevelRankingState(Map<DoubleDecker<StateWithRankInfo<STATE>>, Integer> map, int n) {
            assert (map.size() == this.mNonFinalDoubleDeckerWithRankInfos.size()) : "not ready for construction";
            int n2 = n - 1;
            LevelRankingState levelRankingState = new LevelRankingState(MultiOptimizationLevelRankingGenerator.this.mOperand);
            for (Map.Entry object : map.entrySet()) {
                DoubleDecker doubleDecker = object.getKey();
                levelRankingState.addRank(doubleDecker.getDown(), doubleDecker.getUp().getState(), object.getValue(), false);
            }
            for (DoubleDecker doubleDecker : this.mFinalDoubleDeckerWithRankInfos) {
                levelRankingState.addRank((StateWithRankInfo)doubleDecker.getDown(), ((StateWithRankInfo)doubleDecker.getUp()).getState(), n2, true);
            }
            assert (levelRankingState.isMaximallyTight()) : "not maximally tight";
            return levelRankingState;
        }

        @Override
        Collection<LevelRankingState<LETTER, STATE>> computeResult() {
            if (!this.mNonFinalDoubleDeckerWithRankInfos.isEmpty()) {
                Map map = Collections.emptyMap();
                this.rec(1, map);
            }
            return this.mResult;
        }
    }

    private class MaxTightLevelRankingStateGeneratorNonInitial
    extends TightLevelRankingStateGenerator {
        public MaxTightLevelRankingStateGeneratorNonInitial(LevelRankingConstraint<LETTER, STATE> levelRankingConstraint) {
            super(levelRankingConstraint);
        }

        @Override
        Collection<LevelRankingState<LETTER, STATE>> computeResult() {
            if (this.mConstraint.getDownStates().isEmpty()) {
                return Collections.emptySet();
            }
            if (!this.mConstraint.isTight()) {
                return this.mResult;
            }
            LevelRankingState levelRankingState = new LevelRankingState(MultiOptimizationLevelRankingGenerator.this.mOperand);
            for (StateWithRankInfo stateWithRankInfo : this.mConstraint.getDownStates()) {
                for (StateWithRankInfo stateWithRankInfo2 : this.mConstraint.getUpStates(stateWithRankInfo)) {
                    int n = stateWithRankInfo2.getRank();
                    if (MultiOptimizationLevelRankingGenerator.this.mOperand.isFinal(stateWithRankInfo2.getState()) && LevelRankingState.isOdd(n)) {
                        --n;
                    }
                    if (stateWithRankInfo2.isInO() && LevelRankingState.isEven(n)) {
                        levelRankingState.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), n, true);
                        continue;
                    }
                    levelRankingState.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), n, false);
                }
            }
            if (!levelRankingState.isTight()) {
                assert (this.mResult.isEmpty());
                return this.mResult;
            }
            this.mResult.add(levelRankingState);
            this.computeResultHelper(levelRankingState);
            return this.mResult;
        }

        private void computeResultHelper(LevelRankingState<LETTER, STATE> levelRankingState) {
            if (levelRankingState.isOempty()) {
                return;
            }
            LevelRankingState levelRankingState2 = new LevelRankingState(MultiOptimizationLevelRankingGenerator.this.mOperand);
            for (StateWithRankInfo stateWithRankInfo : levelRankingState.getDownStates()) {
                for (StateWithRankInfo stateWithRankInfo2 : levelRankingState.getUpStates(stateWithRankInfo)) {
                    int n = stateWithRankInfo2.getRank();
                    if (!stateWithRankInfo2.isInO()) {
                        levelRankingState2.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), n, false);
                        continue;
                    }
                    if (n == 0 || MultiOptimizationLevelRankingGenerator.this.mOperand.isFinal(stateWithRankInfo2.getState())) {
                        levelRankingState2.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), n, true);
                        continue;
                    }
                    levelRankingState2.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), n - 1, false);
                }
            }
            if (!levelRankingState2.equals(levelRankingState)) {
                this.mResult.add(levelRankingState2);
            }
        }
    }

    class TightLevelRankingStateGenerator {
        protected int[] mUnrestrictedRank;
        protected final List<Integer> mRestrictedMaxRank = new ArrayList<Integer>();
        protected int[] mRestrictedRank;
        protected final List<LevelRankingState<LETTER, STATE>> mResult = new ArrayList();
        protected final LevelRankingConstraint<LETTER, STATE> mConstraint;
        private final List<DoubleDecker<StateWithRankInfo<STATE>>> mUnrestrictedDoubleDeckerWithRankInfo = new ArrayList();
        private final List<Integer> mUnrestrictedMaxRank = new ArrayList<Integer>();
        private final List<DoubleDecker<StateWithRankInfo<STATE>>> mRestrictedDoubleDeckerWithRankInfo = new ArrayList();

        public TightLevelRankingStateGenerator(LevelRankingConstraint<LETTER, STATE> levelRankingConstraint) {
            this.mConstraint = levelRankingConstraint;
            this.partitionIntoRestrictedAndUnrestricted();
        }

        Collection<LevelRankingState<LETTER, STATE>> computeResult() {
            boolean bl;
            if (this.mUnrestrictedRank.length == 0 && this.mRestrictedRank.length == 0) {
                return Collections.emptySet();
            }
            this.initializeUnrestricted();
            do {
                boolean bl2;
                int n;
                if ((n = this.getMaxNatOrZero(this.mUnrestrictedRank)) % 2 == 0 || !this.isOntoOddNatsUpToX(this.mUnrestrictedRank, n)) continue;
                this.initializeRestricted(n);
                do {
                    this.constructComplementState();
                } while (!(bl2 = this.increaseCounterRestricted(n)));
            } while (!(bl = this.increaseCounterUnrestricted()));
            return this.mResult;
        }

        private void partitionIntoRestrictedAndUnrestricted() {
            for (StateWithRankInfo stateWithRankInfo : this.mConstraint.getDownStates()) {
                for (StateWithRankInfo stateWithRankInfo2 : this.mConstraint.getUpStates(stateWithRankInfo)) {
                    Integer n = stateWithRankInfo2.getRank();
                    if (MultiOptimizationLevelRankingGenerator.this.mOperand.isFinal(stateWithRankInfo2.getState()) || n == 0) {
                        this.mRestrictedDoubleDeckerWithRankInfo.add(new DoubleDecker(stateWithRankInfo, stateWithRankInfo2));
                        this.mRestrictedMaxRank.add(n);
                        continue;
                    }
                    this.mUnrestrictedDoubleDeckerWithRankInfo.add(new DoubleDecker(stateWithRankInfo, stateWithRankInfo2));
                    this.mUnrestrictedMaxRank.add(n);
                }
            }
            this.mUnrestrictedRank = new int[this.mUnrestrictedMaxRank.size()];
            this.mRestrictedRank = new int[this.mRestrictedMaxRank.size()];
        }

        private void constructComplementState() {
            boolean bl;
            int n;
            StateWithRankInfo stateWithRankInfo;
            StateWithRankInfo stateWithRankInfo2;
            DoubleDecker doubleDecker;
            LevelRankingState levelRankingState = new LevelRankingState(MultiOptimizationLevelRankingGenerator.this.mOperand);
            int n2 = 0;
            while (n2 < this.mRestrictedRank.length) {
                doubleDecker = this.mRestrictedDoubleDeckerWithRankInfo.get(n2);
                stateWithRankInfo2 = doubleDecker.getDown();
                stateWithRankInfo = doubleDecker.getUp();
                n = this.mRestrictedRank[n2];
                bl = this.mConstraint.inO(stateWithRankInfo2, stateWithRankInfo.getState());
                levelRankingState.addRank(stateWithRankInfo2, stateWithRankInfo.getState(), n, bl);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.mUnrestrictedRank.length) {
                doubleDecker = this.mUnrestrictedDoubleDeckerWithRankInfo.get(n2);
                stateWithRankInfo2 = doubleDecker.getDown();
                stateWithRankInfo = doubleDecker.getUp();
                n = this.mUnrestrictedRank[n2];
                bl = this.mConstraint.inO(stateWithRankInfo2, stateWithRankInfo.getState()) && n % 2 == 0;
                levelRankingState.addRank(stateWithRankInfo2, stateWithRankInfo.getState(), n, bl);
                ++n2;
            }
            this.mResult.add(levelRankingState);
        }

        private int getMaxNatOrZero(int[] nArray) {
            int n = 0;
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
            return n;
        }

        private boolean isOntoOddNatsUpToX(int[] nArray, int n) {
            assert (n % 2 != 0);
            int[] nArray2 = new int[n + 1];
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2];
                nArray2[n3] = nArray2[n3] + 1;
                ++n2;
            }
            n2 = 1;
            while (n2 <= n) {
                if (nArray2[n2] == 0) {
                    return false;
                }
                n2 += 2;
            }
            return true;
        }

        protected void initializeUnrestricted() {
            int n = 0;
            while (n < this.mUnrestrictedRank.length) {
                this.mUnrestrictedRank[n] = 0;
                ++n;
            }
        }

        protected void initializeRestricted(int n) {
            int n2 = 0;
            while (n2 < this.mRestrictedRank.length) {
                this.mRestrictedRank[n2] = 0;
                ++n2;
            }
        }

        private boolean increaseCounterUnrestricted() {
            boolean bl;
            if (this.mUnrestrictedRank.length == 0) {
                return true;
            }
            int n = 0;
            while ((bl = this.increaseDigitUnrestricted(n)) && ++n < this.mUnrestrictedRank.length) {
            }
            return bl;
        }

        protected boolean increaseDigitUnrestricted(int n) {
            int n2 = this.mUnrestrictedRank[n];
            int n3 = n2 + 1;
            assert (this.maxTightRankUnrestricted(n) >= 1);
            if (n3 <= this.maxTightRankUnrestricted(n)) {
                this.mUnrestrictedRank[n] = n3;
                return false;
            }
            this.mUnrestrictedRank[n] = 0;
            return true;
        }

        protected boolean increaseCounterRestricted(int n) {
            boolean bl;
            if (this.mRestrictedRank.length == 0) {
                return true;
            }
            int n2 = 0;
            while ((bl = this.increaseDigitRestricted(n2, n)) && ++n2 < this.mRestrictedRank.length) {
            }
            return bl;
        }

        private boolean increaseDigitRestricted(int n, int n2) {
            int n3 = this.mRestrictedRank[n];
            int n4 = n3 + 2;
            if (n4 <= this.maxTightRankRestricted(n, n2)) {
                this.mRestrictedRank[n] = n4;
                return false;
            }
            this.mRestrictedRank[n] = 0;
            return true;
        }

        protected int maxTightRankUnrestricted(int n) {
            int n2 = this.mUnrestrictedMaxRank.size() * 2 - 1;
            if (n2 <= MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank) {
                if (this.mUnrestrictedMaxRank.get(n) <= n2) {
                    return this.mUnrestrictedMaxRank.get(n);
                }
                return n2;
            }
            if (this.mUnrestrictedMaxRank.get(n) <= MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank) {
                return this.mUnrestrictedMaxRank.get(n);
            }
            return MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank;
        }

        private int maxTightRankRestricted(int n, int n2) {
            if (n2 <= MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank) {
                if (this.mRestrictedMaxRank.get(n) <= n2) {
                    return this.mRestrictedMaxRank.get(n);
                }
                return n2;
            }
            if (this.mRestrictedMaxRank.get(n) <= MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank) {
                return this.mRestrictedMaxRank.get(n);
            }
            return MultiOptimizationLevelRankingGenerator.this.mUserDefinedMaxRank;
        }
    }
}

