/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InvariantSynthesisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.CFGInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.InvariantSynthesisStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.KindOfInvariant;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class PathInvariantsGenerator<LETTER extends IAction>
implements IInterpolantGenerator<LETTER> {
    private final NestedWord<LETTER> mWord;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final IPredicate[] mInterpolants;
    private final IPredicateUnifier mPredicateUnifier;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final InterpolantComputationStatus mInterpolantComputationStatus;
    private final InvariantSynthesisStatisticsGenerator mPathInvariantsStats;

    public PathInvariantsGenerator(IUltimateServiceProvider iUltimateServiceProvider, NestedWord<LETTER> nestedWord, List<IcfgLocation> list, IPredicate iPredicate, IPredicate iPredicate2, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, IIcfg<?> iIcfg, InvariantSynthesisSettings invariantSynthesisSettings, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mWord = nestedWord;
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLogger.info("Current word and run: %s, %s", new Object[]{nestedWord, list});
        Set<IcfgEdge> set = PathInvariantsGenerator.extractTransitionsFromRun(nestedWord, list, iIcfg.getCfgSmtToolkit().getIcfgEdgeFactory());
        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)"PathInvariantsPathProgram", iIcfg, set, Collections.emptySet(), icfgLocation -> true);
        PathProgram pathProgram = pathProgramConstructionResult.getPathProgram();
        Map map = pathProgramConstructionResult.getLocationMapping();
        CFGInvariantsGenerator cFGInvariantsGenerator = new CFGInvariantsGenerator((IIcfg<IcfgLocation>)pathProgram, iUltimateServiceProvider, iPredicate, iPredicate2, predicateFactory, iPredicateUnifier, invariantSynthesisSettings, iIcfg.getCfgSmtToolkit(), KindOfInvariant.SAFETY);
        Map<IcfgLocation, IPredicate> map2 = cFGInvariantsGenerator.synthesizeInvariants();
        this.mPathInvariantsStats = cFGInvariantsGenerator.getInvariantSynthesisStatistics();
        if (map2 != null) {
            this.mInterpolants = new IPredicate[list.size()];
            int n = 0;
            while (n < list.size()) {
                IcfgLocation icfgLocation2 = list.get(n);
                IcfgLocation icfgLocation3 = (IcfgLocation)map.get(icfgLocation2);
                this.mInterpolants[n] = map2.get(icfgLocation3);
                this.mLogger.info((Object)("Interpolant no " + n + " " + this.mInterpolants[n].toString()));
                ++n;
            }
            this.mLogger.info((Object)"Invariants found and processed.");
            this.mLogger.info((Object)("Got a Invariant map of length " + this.mInterpolants.length));
            this.mInterpolantComputationStatus = new InterpolantComputationStatus();
        } else {
            this.mInterpolants = null;
            this.mLogger.info((Object)"No invariants found.");
            this.mInterpolantComputationStatus = new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.ALGORITHM_FAILED, null);
        }
    }

    public static Set<? extends IcfgEdge> extractTransitionsFromRun(NestedWord<? extends IAction> nestedWord, List<IcfgLocation> list, IcfgEdgeFactory icfgEdgeFactory) {
        int n = list.size();
        LinkedHashSet<IcfgInternalTransition> linkedHashSet = new LinkedHashSet<IcfgInternalTransition>(n - 1);
        IcfgLocation icfgLocation = null;
        int n2 = 0;
        while (n2 < n) {
            IcfgLocation icfgLocation2 = list.get(n2);
            if (n2 > 0) {
                if (!nestedWord.isInternalPosition(n2 - 1)) {
                    throw new UnsupportedOperationException("interprocedural traces are not supported (yet)");
                }
                UnmodifiableTransFormula unmodifiableTransFormula = ((IAction)nestedWord.getSymbol(n2 - 1)).getTransformula();
                linkedHashSet.add(icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, icfgLocation2.getPayload(), unmodifiableTransFormula));
            }
            icfgLocation = icfgLocation2;
            ++n2;
        }
        return linkedHashSet;
    }

    public List<LETTER> getTrace() {
        return this.mWord.asList();
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        throw new UnsupportedOperationException("Call/Return not supported yet");
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public IPredicate[] getInterpolants() {
        if (this.mInterpolants == null) {
            return null;
        }
        IPredicate[] iPredicateArray = new IPredicate[this.mInterpolants.length - 2];
        System.arraycopy(this.mInterpolants, 1, iPredicateArray, 0, this.mInterpolants.length - 2);
        return iPredicateArray;
    }

    public boolean isPerfectSequence() {
        CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation = TraceCheckUtils.computeCoverageCapability((IUltimateServiceProvider)this.mServices, (IInterpolantGenerator)this, (ILogger)this.mLogger);
        boolean bl = backwardCoveringInformation.getPotentialBackwardCoverings() == backwardCoveringInformation.getSuccessfullBackwardCoverings();
        return bl;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mInterpolantComputationStatus;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mPathInvariantsStats;
    }

    public static enum InvariantSynthesisStatisticsDefinitions implements IStatisticsElement
    {
        ProgramSizeConjuncts(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ProgramSizeDisjuncts(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ProgramLocs(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ProgramLocsLbe(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ProgramVars(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SumOfTemplateInequalities(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SizeOfLargestTemplate(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        SizeOfSmallestTemplate(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        MaxNumOfInequalities(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        MaxRound(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        SumVarsPerLoc(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SumNonLiveVarsPerLoc(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SumNonUnsatCoreLocs(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SumNonUnsatCoreVars(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        TreeSizeNormalConstr(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        TreeSizeApproxConstr(Integer.class, StatisticsType.INTEGER_MAX, StatisticsType.KEY_BEFORE_DATA),
        MotzkinTransformationsNormalConstr(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        MotzkinTransformationsApproxConstr(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        MotzkinCoefficientsNormalConstr(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        MotzkinCoefficientsApproxConstr(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ConstraintsSolvingTime(Long.class, StatisticsType.LONG_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        ConstraintsConstructionTime(Long.class, StatisticsType.LONG_ADDITION, StatisticsType.KEY_BEFORE_DATA),
        SatStatus(String.class, object -> object2 -> (String)object + "; " + (String)object2, StatisticsType.KEY_BEFORE_DATA);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private InvariantSynthesisStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mClazz = clazz;
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(this.name()).apply(object);
        }
    }
}

